/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.workspace;

import com.intellij.notification.Notification;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.cidr.cpp.CMakeBundle;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeEnvironmentStateTask;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\rJ\u0006\u0010\u001c\u001a\u00020\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\"\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeEnvironmentStateTaskQueue;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "disposable", "Lcom/intellij/openapi/Disposable;", "queue", "Lcom/intellij/openapi/progress/BackgroundTaskQueue;", "skipNextTask", "", "getSkipNextTask", "()Z", "setSkipNextTask", "(Z)V", "notification", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/notification/Notification;", "getNotification", "()Ljava/util/concurrent/atomic/AtomicReference;", "setNotification", "(Ljava/util/concurrent/atomic/AtomicReference;)V", "scheduleTask", "", "isFullCheck", "cancelAll", "intellij.cmake"})
public final class CMakeEnvironmentStateTaskQueue {
    @NotNull
    private final Project project;
    @Nullable
    private Disposable disposable;
    @NotNull
    private final BackgroundTaskQueue queue;
    private boolean skipNextTask;
    @NotNull
    private AtomicReference<Notification> notification;

    public CMakeEnvironmentStateTaskQueue(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.queue = new BackgroundTaskQueue(this.project, CMakeBundle.message("cmake.environment.state.checker.progress", new Object[0]));
        this.notification = new AtomicReference();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final boolean getSkipNextTask() {
        return this.skipNextTask;
    }

    public final synchronized void setSkipNextTask(boolean bl) {
        this.skipNextTask = bl;
    }

    @NotNull
    public final AtomicReference<Notification> getNotification() {
        return this.notification;
    }

    public final void setNotification(@NotNull AtomicReference<Notification> atomicReference) {
        Intrinsics.checkNotNullParameter(atomicReference, (String)"<set-?>");
        this.notification = atomicReference;
    }

    public final synchronized void scheduleTask(boolean isFullCheck) {
        if (ApplicationManager.getApplication().isUnitTestMode() || !Registry.Companion.is("cmake.enable.environment.state.checker", false)) {
            return;
        }
        if (this.skipNextTask) {
            this.skipNextTask = false;
            return;
        }
        if (this.notification.get() != null) {
            return;
        }
        CMakeWorkspace workspace = CMakeWorkspace.Companion.getInstance(this.project);
        if (this.disposable == null) {
            this.disposable = Disposer.newDisposable((Disposable)workspace, (String)"parent disposable for all CMakeEnvironmentStateTask");
        }
        Disposable disposable = this.disposable;
        Intrinsics.checkNotNull((Object)disposable);
        CMakeEnvironmentStateTask task2 = new CMakeEnvironmentStateTask(this.project, disposable, workspace, isFullCheck);
        this.queue.run((Task.Backgroundable)task2);
    }

    public static /* synthetic */ void scheduleTask$default(CMakeEnvironmentStateTaskQueue cMakeEnvironmentStateTaskQueue, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        cMakeEnvironmentStateTaskQueue.scheduleTask(bl);
    }

    public final synchronized void cancelAll() {
        if (this.disposable != null) {
            Disposable disposable = this.disposable;
            Intrinsics.checkNotNull((Object)disposable);
            Disposer.dispose((Disposable)disposable);
        }
        this.disposable = null;
    }
}

