/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.workspace;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Alarm;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.XcodeUtil;
import com.jetbrains.cidr.cpp.CMakeBundle;
import com.jetbrains.cidr.cpp.cmake.model.CMakeEnvironmentState;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModel;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModelConfigurationData;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeEnvironmentStateChecker;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeEnvironmentStateTaskQueue;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProfileInfo;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceReloadTask;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0006'()*+,B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ#\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0011\u0010\u001c\u001a\r\u0012\t\u0012\u00070\u0011\u00a2\u0006\u0002\b\u001e0\u001dH\u0002J.\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\r\u0010 \u001a\t\u0018\u00010\u0011\u00a2\u0006\u0002\b\u001e2\r\u0010\u000f\u001a\t\u0018\u00010\u0011\u00a2\u0006\u0002\b\u001eH\u0002J\u001d\u0010!\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u000b\u0010 \u001a\u00070\u0011\u00a2\u0006\u0002\b\u001eH\u0002J\u0015\u0010\"\u001a\u00020\u00162\u000b\u0010#\u001a\u00070\u0011\u00a2\u0006\u0002\b\u001eH\u0002J\"\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010&\u001a\u00020\tH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeEnvironmentStateTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "workspace", "Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace;", "isFullCheck", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace;Z)V", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "cancellationDisposable", "xcodeSelectPath", "Lcom/intellij/openapi/util/Ref;", "", "run", "", "indicator", "checkProfile", "Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeEnvironmentStateTask$CheckResult;", "environment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "environmentState", "Lcom/jetbrains/cidr/cpp/cmake/model/CMakeEnvironmentState;", "checkCompilers", "compilers", "", "Lcom/intellij/openapi/util/NlsSafe;", "checkXcode", "osxRoot", "checkOsxRoot", "checkXcodeSelectPath", "oldPath", "showReloadNotification", "checkResult", "isLongDelay", "CheckResult", "OK", "CompilerNotFound", "OsxRootNotFound", "XcodeSelectChanged", "Companion", "intellij.cmake"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nCMakeEnvironmentStateChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CMakeEnvironmentStateChecker.kt\ncom/jetbrains/cidr/cpp/cmake/workspace/CMakeEnvironmentStateTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,368:1\n1#2:369\n30#3,2:370\n*S KotlinDebug\n*F\n+ 1 CMakeEnvironmentStateChecker.kt\ncom/jetbrains/cidr/cpp/cmake/workspace/CMakeEnvironmentStateTask\n*L\n330#1:370,2\n*E\n"})
public final class CMakeEnvironmentStateTask
extends Task.Backgroundable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CMakeWorkspace workspace;
    private final boolean isFullCheck;
    @Nullable
    private ProgressIndicator progressIndicator;
    @NotNull
    private final Disposable cancellationDisposable;
    @Nullable
    private Ref<String> xcodeSelectPath;
    @NotNull
    public static final String NOTIFICATION_GROUP = "cmake-environment-state-notifications";

    public CMakeEnvironmentStateTask(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull CMakeWorkspace workspace, boolean isFullCheck) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)((Object)workspace), (String)"workspace");
        super(project, CMakeBundle.message("cmake.environment.state.checker.progress", new Object[0]));
        this.workspace = workspace;
        this.isFullCheck = isFullCheck;
        Disposable disposable = Disposer.newDisposable((Disposable)parentDisposable, (String)"CMakeEnvironmentStateTask");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.cancellationDisposable = disposable;
    }

    public /* synthetic */ CMakeEnvironmentStateTask(Project project, Disposable disposable, CMakeWorkspace cMakeWorkspace, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        this(project, disposable, cMakeWorkspace, bl);
    }

    public void run(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        try {
            Disposer.register((Disposable)this.cancellationDisposable, () -> CMakeEnvironmentStateTask.run$lambda$0(indicator));
        }
        catch (IncorrectOperationException ex) {
            return;
        }
        this.progressIndicator = indicator;
        indicator.checkCanceled();
        CMakeEnvironmentStateChecker.Companion.getLOG$intellij_cmake().debug("Checking environment state...");
        CMakeModel cMakeModel = this.workspace.getModel();
        if (cMakeModel == null) {
            return;
        }
        CMakeModel model = cMakeModel;
        Collection<CMakeProfileInfo> profileInfos = this.workspace.getProfileInfos();
        for (CMakeModelConfigurationData configurationData : model.getConfigurationData()) {
            CMakeEnvironmentState environmentState;
            CPPEnvironment environment;
            CMakeProfileInfo profileInfo;
            Object v1;
            String profileName;
            block6: {
                if (configurationData.getEnvironmentState() == null) continue;
                profileName = configurationData.getConfigName();
                Iterable iterable = profileInfos;
                for (Object t : iterable) {
                    CMakeProfileInfo it = (CMakeProfileInfo)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getProfile().getName(), (Object)profileName)) continue;
                    v1 = t;
                    break block6;
                }
                v1 = null;
            }
            if ((CMakeProfileInfo)v1 == null || profileInfo.getEnvironmentAndCMakeProblems().hasProblems()) continue;
            Intrinsics.checkNotNull((Object)profileInfo.getEnvironment());
            CheckResult checkResult = this.checkProfile(environment, environmentState);
            if (!Intrinsics.areEqual((Object)checkResult, (Object)OK.INSTANCE)) {
                CMakeEnvironmentStateChecker.Companion.getLOG$intellij_cmake().info("Environment change detected for profile " + profileName + ": " + checkResult);
                this.showReloadNotification(checkResult, this.workspace, this.isFullCheck);
                return;
            }
            indicator.checkCanceled();
        }
    }

    @NotNull
    public final CheckResult checkProfile(@NotNull CPPEnvironment environment, @NotNull CMakeEnvironmentState environmentState) {
        CheckResult xcodeCheck;
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)environmentState, (String)"environmentState");
        CheckResult compilerCheck = this.checkCompilers(environment, environmentState.getCompilers());
        if (!Intrinsics.areEqual((Object)compilerCheck, (Object)OK.INSTANCE)) {
            return compilerCheck;
        }
        ProgressIndicator progressIndicator = this.progressIndicator;
        if (progressIndicator != null) {
            progressIndicator.checkCanceled();
        }
        if (environmentState.isXcode() && environment.getHostMachine().getOS() == OS.macOS && !Intrinsics.areEqual((Object)(xcodeCheck = this.checkXcode(environment, environmentState.getOsxRoot(), environmentState.getXcodeSelectPath())), (Object)OK.INSTANCE)) {
            return xcodeCheck;
        }
        return OK.INSTANCE;
    }

    private final CheckResult checkCompilers(CPPEnvironment environment, List<String> compilers) {
        if (environment.getHostMachine().isRemote()) {
            return OK.INSTANCE;
        }
        Set uniqueCompilers = CollectionsKt.toSet((Iterable)compilers);
        for (String compiler : uniqueCompilers) {
            Path path;
            Intrinsics.checkNotNullExpressionValue((Object)environment.getHostMachine().getPath(compiler, new String[0]), (String)"getPath(...)");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.notExists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return new CompilerNotFound(compiler);
            }
            ProgressIndicator progressIndicator = this.progressIndicator;
            if (progressIndicator == null) continue;
            progressIndicator.checkCanceled();
        }
        return OK.INSTANCE;
    }

    private final CheckResult checkXcode(CPPEnvironment environment, String osxRoot, String xcodeSelectPath) {
        CheckResult xcodeSelectCheck;
        CheckResult osxRootCheck;
        if (osxRoot != null && !Intrinsics.areEqual((Object)(osxRootCheck = this.checkOsxRoot(environment, osxRoot)), (Object)OK.INSTANCE)) {
            return osxRootCheck;
        }
        ProgressIndicator progressIndicator = this.progressIndicator;
        if (progressIndicator != null) {
            progressIndicator.checkCanceled();
        }
        if (xcodeSelectPath != null && !Intrinsics.areEqual((Object)(xcodeSelectCheck = this.checkXcodeSelectPath(xcodeSelectPath)), (Object)OK.INSTANCE)) {
            return xcodeSelectCheck;
        }
        return OK.INSTANCE;
    }

    private final CheckResult checkOsxRoot(CPPEnvironment environment, String osxRoot) {
        Path path;
        Path path2 = environment.getHostMachine().getPath(osxRoot, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getPath(...)");
        Path path3 = path = path2;
        LinkOption[] linkOptionArray = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
        if (Files.notExists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return new OsxRootNotFound(osxRoot);
        }
        return OK.INSTANCE;
    }

    private final CheckResult checkXcodeSelectPath(String oldPath) {
        String newPath;
        if (!this.isFullCheck) {
            return OK.INSTANCE;
        }
        if (this.xcodeSelectPath == null) {
            File file = XcodeUtil.getXcodeSelect();
            this.xcodeSelectPath = new Ref((Object)(file != null ? file.getPath() : null));
            ProgressIndicator progressIndicator = this.progressIndicator;
            if (progressIndicator != null) {
                progressIndicator.checkCanceled();
            }
        }
        Ref<String> ref = this.xcodeSelectPath;
        String string = newPath = ref != null ? (String)ref.get() : null;
        if (newPath != null && !Intrinsics.areEqual((Object)newPath, (Object)oldPath)) {
            return new XcodeSelectChanged(oldPath, newPath);
        }
        return OK.INSTANCE;
    }

    private final void showReloadNotification(CheckResult checkResult, CMakeWorkspace workspace, boolean isLongDelay) {
        new Alarm(Alarm.ThreadToUse.SWING_THREAD, this.cancellationDisposable).addRequest(() -> CMakeEnvironmentStateTask.showReloadNotification$lambda$0(checkResult, this, workspace), isLongDelay ? 5000 : 1000);
    }

    static /* synthetic */ void showReloadNotification$default(CMakeEnvironmentStateTask cMakeEnvironmentStateTask, CheckResult checkResult, CMakeWorkspace cMakeWorkspace, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        cMakeEnvironmentStateTask.showReloadNotification(checkResult, cMakeWorkspace, bl);
    }

    private static final void run$lambda$0(ProgressIndicator $indicator) {
        if ($indicator.isRunning()) {
            $indicator.cancel();
        }
    }

    private static final void showReloadNotification$lambda$0(CheckResult $checkResult, CMakeEnvironmentStateTask this$0, CMakeWorkspace $workspace) {
        String string;
        String string2 = CMakeBundle.message("cmake.environment.state.checker.reload.notification.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String title = string2;
        CheckResult checkResult = $checkResult;
        if (Intrinsics.areEqual((Object)checkResult, (Object)OK.INSTANCE)) {
            return;
        }
        if (checkResult instanceof CompilerNotFound) {
            var7_5 = new Object[]{((CompilerNotFound)$checkResult).getCompiler()};
            string = CMakeBundle.message("cmake.environment.state.checker.compiler.not.found", var7_5);
        } else if (checkResult instanceof OsxRootNotFound) {
            var7_5 = new Object[]{((OsxRootNotFound)$checkResult).getOsxRoot()};
            string = CMakeBundle.message("cmake.environment.state.checker.osx.root.not.found", var7_5);
        } else if (checkResult instanceof XcodeSelectChanged) {
            string = CMakeBundle.message("cmake.environment.state.checker.xcode.select.changed", new Object[0]);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String string3 = string;
        Intrinsics.checkNotNull((Object)string3);
        String checkDescription = string3;
        String content = CMakeBundle.message("cmake.environment.state.checker.reload.notification.body", new Object[0]) + " " + checkDescription;
        NotificationAction notificationAction = NotificationAction.createExpiring((String)CMakeBundle.message("cmake.environment.state.checker.reload.notification.action", new Object[0]), (arg_0, arg_1) -> CMakeEnvironmentStateTask.showReloadNotification$lambda$0$1((arg_0, arg_1) -> CMakeEnvironmentStateTask.showReloadNotification$lambda$0$0($workspace, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"createExpiring(...)");
        NotificationAction action2 = notificationAction;
        Notification notification = NotificationGroupManager.getInstance().getNotificationGroup(NOTIFICATION_GROUP).createNotification(title, content, NotificationType.WARNING).addAction((AnAction)action2);
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"addAction(...)");
        Notification notification2 = notification;
        Project project = this$0.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<CMakeEnvironmentStateTaskQueue> serviceClass$iv = CMakeEnvironmentStateTaskQueue.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        CMakeEnvironmentStateTaskQueue queueService = (CMakeEnvironmentStateTaskQueue)object;
        if (!queueService.getNotification().compareAndSet(null, notification2)) {
            return;
        }
        try {
            Disposer.register((Disposable)this$0.cancellationDisposable, () -> CMakeEnvironmentStateTask.showReloadNotification$lambda$0$2(notification2));
        }
        catch (IncorrectOperationException ex) {
            return;
        }
        if (!notification2.isExpired()) {
            notification2.notify($workspace.getProject());
        }
        notification2.whenExpired(() -> CMakeEnvironmentStateTask.showReloadNotification$lambda$0$3(queueService, this$0));
    }

    private static final Unit showReloadNotification$lambda$0$0(CMakeWorkspace $workspace, AnActionEvent anActionEvent, Notification notification) {
        $workspace.scheduleReload(CMakeWorkspaceReloadTask.Companion.clearCache().withExplicit(true));
        return Unit.INSTANCE;
    }

    private static final void showReloadNotification$lambda$0$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void showReloadNotification$lambda$0$2(Notification $notification) {
        $notification.expire();
    }

    private static final void showReloadNotification$lambda$0$3(CMakeEnvironmentStateTaskQueue $queueService, CMakeEnvironmentStateTask this$0) {
        $queueService.getNotification().set(null);
        Disposer.dispose((Disposable)this$0.cancellationDisposable);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001\u0082\u0001\u0004\u0002\u0003\u0004\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeEnvironmentStateTask$CheckResult;", "", "Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeEnvironmentStateTask$CompilerNotFound;", "Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeEnvironmentStateTask$OK;", "Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeEnvironmentStateTask$OsxRootNotFound;", "Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeEnvironmentStateTask$XcodeSelectChanged;", "intellij.cmake"})
    public static sealed interface CheckResult
    permits CompilerNotFound, OK, OsxRootNotFound, XcodeSelectChanged {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeEnvironmentStateTask$Companion;", "", "<init>", "()V", "NOTIFICATION_GROUP", "", "intellij.cmake"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0014\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\t\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\u0018\u0010\n\u001a\u00020\u00002\r\b\u0002\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeEnvironmentStateTask$CompilerNotFound;", "Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeEnvironmentStateTask$CheckResult;", "compiler", "", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Ljava/lang/String;)V", "getCompiler", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.cmake"})
    public static final class CompilerNotFound
    implements CheckResult {
        @NotNull
        private final String compiler;

        public CompilerNotFound(@NotNull String compiler) {
            Intrinsics.checkNotNullParameter((Object)compiler, (String)"compiler");
            this.compiler = compiler;
        }

        @NotNull
        public final String getCompiler() {
            return this.compiler;
        }

        @NotNull
        public final String component1() {
            return this.compiler;
        }

        @NotNull
        public final CompilerNotFound copy(@NotNull String compiler) {
            Intrinsics.checkNotNullParameter((Object)compiler, (String)"compiler");
            return new CompilerNotFound(compiler);
        }

        public static /* synthetic */ CompilerNotFound copy$default(CompilerNotFound compilerNotFound, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = compilerNotFound.compiler;
            }
            return compilerNotFound.copy(string);
        }

        @NotNull
        public String toString() {
            return "CompilerNotFound(compiler=" + this.compiler + ")";
        }

        public int hashCode() {
            return this.compiler.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CompilerNotFound)) {
                return false;
            }
            CompilerNotFound compilerNotFound = (CompilerNotFound)other;
            return Intrinsics.areEqual((Object)this.compiler, (Object)compilerNotFound.compiler);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeEnvironmentStateTask$OK;", "Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeEnvironmentStateTask$CheckResult;", "<init>", "()V", "intellij.cmake"})
    public static final class OK
    implements CheckResult {
        @NotNull
        public static final OK INSTANCE = new OK();

        private OK() {
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0014\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\t\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\u0018\u0010\n\u001a\u00020\u00002\r\b\u0002\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeEnvironmentStateTask$OsxRootNotFound;", "Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeEnvironmentStateTask$CheckResult;", "osxRoot", "", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Ljava/lang/String;)V", "getOsxRoot", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.cmake"})
    public static final class OsxRootNotFound
    implements CheckResult {
        @NotNull
        private final String osxRoot;

        public OsxRootNotFound(@NotNull String osxRoot) {
            Intrinsics.checkNotNullParameter((Object)osxRoot, (String)"osxRoot");
            this.osxRoot = osxRoot;
        }

        @NotNull
        public final String getOsxRoot() {
            return this.osxRoot;
        }

        @NotNull
        public final String component1() {
            return this.osxRoot;
        }

        @NotNull
        public final OsxRootNotFound copy(@NotNull String osxRoot) {
            Intrinsics.checkNotNullParameter((Object)osxRoot, (String)"osxRoot");
            return new OsxRootNotFound(osxRoot);
        }

        public static /* synthetic */ OsxRootNotFound copy$default(OsxRootNotFound osxRootNotFound, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = osxRootNotFound.osxRoot;
            }
            return osxRootNotFound.copy(string);
        }

        @NotNull
        public String toString() {
            return "OsxRootNotFound(osxRoot=" + this.osxRoot + ")";
        }

        public int hashCode() {
            return this.osxRoot.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OsxRootNotFound)) {
                return false;
            }
            OsxRootNotFound osxRootNotFound = (OsxRootNotFound)other;
            return Intrinsics.areEqual((Object)this.osxRoot, (Object)osxRootNotFound.osxRoot);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u000b\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000b\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\u000e\u0010\f\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J'\u0010\r\u001a\u00020\u00002\r\b\u0002\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\r\b\u0002\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeEnvironmentStateTask$XcodeSelectChanged;", "Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeEnvironmentStateTask$CheckResult;", "oldPath", "", "Lcom/intellij/openapi/util/NlsSafe;", "newPath", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getOldPath", "()Ljava/lang/String;", "getNewPath", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.cmake"})
    public static final class XcodeSelectChanged
    implements CheckResult {
        @NotNull
        private final String oldPath;
        @NotNull
        private final String newPath;

        public XcodeSelectChanged(@NotNull String oldPath, @NotNull String newPath) {
            Intrinsics.checkNotNullParameter((Object)oldPath, (String)"oldPath");
            Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
            this.oldPath = oldPath;
            this.newPath = newPath;
        }

        @NotNull
        public final String getOldPath() {
            return this.oldPath;
        }

        @NotNull
        public final String getNewPath() {
            return this.newPath;
        }

        @NotNull
        public final String component1() {
            return this.oldPath;
        }

        @NotNull
        public final String component2() {
            return this.newPath;
        }

        @NotNull
        public final XcodeSelectChanged copy(@NotNull String oldPath, @NotNull String newPath) {
            Intrinsics.checkNotNullParameter((Object)oldPath, (String)"oldPath");
            Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
            return new XcodeSelectChanged(oldPath, newPath);
        }

        public static /* synthetic */ XcodeSelectChanged copy$default(XcodeSelectChanged xcodeSelectChanged, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = xcodeSelectChanged.oldPath;
            }
            if ((n & 2) != 0) {
                string2 = xcodeSelectChanged.newPath;
            }
            return xcodeSelectChanged.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "XcodeSelectChanged(oldPath=" + this.oldPath + ", newPath=" + this.newPath + ")";
        }

        public int hashCode() {
            int result2 = this.oldPath.hashCode();
            result2 = result2 * 31 + this.newPath.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof XcodeSelectChanged)) {
                return false;
            }
            XcodeSelectChanged xcodeSelectChanged = (XcodeSelectChanged)other;
            if (!Intrinsics.areEqual((Object)this.oldPath, (Object)xcodeSelectChanged.oldPath)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.newPath, (Object)xcodeSelectChanged.newPath);
        }
    }
}

