/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.settings;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.GroupedComboBoxRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.system.OS;
import com.intellij.util.ui.UiScopeKt;
import com.jetbrains.cidr.coroutines.PreemptiveCoroutineScope;
import com.jetbrains.cidr.cpp.CMakeBundle;
import com.jetbrains.cidr.cpp.cmake.CMakeSettings;
import com.jetbrains.cidr.cpp.cmake.execution.CMakeCapabilities;
import com.jetbrains.cidr.cpp.cmake.execution.CMakeExecutableToolKt;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorType;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorUtils;
import com.jetbrains.cidr.cpp.cmake.settings.CMakeGeneratorComboBox;
import com.jetbrains.cidr.cpp.cmake.settings.CMakeGeneratorComboBoxKt;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.toolchains.CMakeExecutableTool;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.execution.CidrRunProcessUtil;
import com.jetbrains.cidr.toolchains.EnvironmentProblems;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\t\u0018\u0000 A2\b\u0012\u0004\u0012\u00020\u00020\u0001:\b:;<=>?@AB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010(\u001a\u00020)2\u000b\u0010*\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0014H\u0007J\u0015\u0010+\u001a\u00020)2\u000b\u0010\u001a\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0014H\u0003J\b\u0010,\u001a\u00020\u001dH\u0002J\u0014\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u00010\u0007H\u0002J\u0014\u00100\u001a\u00020)2\n\b\u0002\u00101\u001a\u0004\u0018\u00010\u0007H\u0002J\u001a\u00102\u001a\u0004\u0018\u0001032\b\u00101\u001a\u0004\u0018\u00010\u0007H\u0082@\u00a2\u0006\u0002\u00104J\b\u00105\u001a\u000203H\u0002J\u0010\u00106\u001a\u00020)2\u0006\u00107\u001a\u000203H\u0007J\u000e\u00108\u001a\b\u0012\u0004\u0012\u00020\u000209H\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R0\u0010\u0015\u001a\u00070\u0007\u00a2\u0006\u0002\b\u00142\u000b\u0010\u0013\u001a\u00070\u0007\u00a2\u0006\u0002\b\u00148\u0007@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R(\u0010\u001a\u001a\u00070\u0007\u00a2\u0006\u0002\b\u00142\u000b\u0010\u0013\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001f\"\u0004\b#\u0010!R\u000e\u0010$\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010&\u001a\u00070\u0007\u00a2\u0006\u0002\b'X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox;", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$Item;", "project", "Lcom/intellij/openapi/project/Project;", "toolchainNameProperty", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/observable/properties/ObservableProperty;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getToolchainNameProperty", "()Lcom/intellij/openapi/observable/properties/ObservableProperty;", "updatingCoroutineScope", "Lcom/jetbrains/cidr/coroutines/PreemptiveCoroutineScope;", "generator", "getGenerator", "()Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$Item;", "value", "Lcom/intellij/openapi/util/NlsSafe;", "defaultGeneratorName", "getDefaultGeneratorName", "()Ljava/lang/String;", "setDefaultGeneratorName", "(Ljava/lang/String;)V", "customGeneratorName", "getCustomGeneratorName", "shouldShowSpinner", "", "getShouldShowSpinner", "()Z", "setShouldShowSpinner", "(Z)V", "isLoading", "setLoading", "lastEmptyGenerator", "firstPredefinedGenerator", "separatorText", "Lorg/jetbrains/annotations/Nls;", "setGeneratorName", "", "generatorName", "selectCustomGenerator", "hasCustomGeneratorItem", "findPredefinedGenerator", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$GeneratorItem;", "name", "updateGeneratorList", "toolchainName", "getLongCMakeGenerators", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$GenerationGetResult;", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getApproximateCMakeGenerators", "setGeneratorItems", "generationGetResult", "getGenerators", "", "Item", "Customizable", "GeneratorItem", "DefaultGeneratorItem", "CustomGeneratorItem", "NoGeneratorItem", "GenerationGetResult", "Companion", "intellij.cmake"})
@SourceDebugExtension(value={"SMAP\nCMakeGeneratorComboBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CMakeGeneratorComboBox.kt\ncom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,559:1\n1563#2:560\n1634#2,3:561\n1563#2:564\n1634#2,2:565\n1636#2:568\n1056#2:569\n808#2,11:570\n808#2,11:581\n1#3:567\n*S KotlinDebug\n*F\n+ 1 CMakeGeneratorComboBox.kt\ncom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox\n*L\n359#1:560\n359#1:561,3\n360#1:564\n360#1:565,2\n360#1:568\n361#1:569\n406#1:570,11\n417#1:581,11\n*E\n"})
public final class CMakeGeneratorComboBox
extends ComboBox<Item> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ObservableProperty<String> toolchainNameProperty;
    @NotNull
    private final PreemptiveCoroutineScope updatingCoroutineScope;
    @NotNull
    private String defaultGeneratorName;
    @NotNull
    private String customGeneratorName;
    private boolean shouldShowSpinner;
    private boolean isLoading;
    @NotNull
    private Item lastEmptyGenerator;
    @Nullable
    private Item firstPredefinedGenerator;
    @NotNull
    private String separatorText;
    @NotNull
    private static final List<CMakeGeneratorType> WIN_GENERATORS;
    @NotNull
    private static final List<CMakeGeneratorType> UNIX_GENERATORS;
    @NotNull
    private static final List<CMakeGeneratorType> MAC_GENERATORS;

    public CMakeGeneratorComboBox(@NotNull Project project, @NotNull ObservableProperty<String> toolchainNameProperty) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(toolchainNameProperty, (String)"toolchainNameProperty");
        this.project = project;
        this.toolchainNameProperty = toolchainNameProperty;
        this.updatingCoroutineScope = new PreemptiveCoroutineScope("CMakeGeneratorComboBox.updatingCoroutineScope", CMakeWorkspace.Companion.getInstance((Project)this.project).coroutineScope);
        this.defaultGeneratorName = "";
        this.customGeneratorName = "";
        this.shouldShowSpinner = true;
        this.lastEmptyGenerator = DefaultGeneratorItem.INSTANCE;
        String string = CMakeBundle.message("cmake.generator.loading.generators", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.separatorText = string;
        this.putClientProperty(AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, true);
        List defaultItems = new ArrayList();
        defaultItems.add(DefaultGeneratorItem.INSTANCE);
        defaultItems.add(NoGeneratorItem.INSTANCE);
        this.isLoading = true;
        this.setModel((ComboBoxModel)new CollectionComboBoxModel<Item>((List<Item>)defaultItems){

            public void setSelectedItem(Object item) {
                if (item == DefaultGeneratorItem.INSTANCE) {
                    lastEmptyGenerator = DefaultGeneratorItem.INSTANCE;
                } else if (item == NoGeneratorItem.INSTANCE) {
                    lastEmptyGenerator = NoGeneratorItem.INSTANCE;
                }
                super.setSelectedItem(item);
            }
        });
        this.renderer = (ListCellRenderer)new GroupedComboBoxRenderer<Item>(){

            public ListSeparator separatorFor(Item value) {
                String string = StringUtil.shortenTextWithEllipsis((String)separatorText, (int)80, (int)3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
                String shortenText = string;
                return this.isLoading() && Intrinsics.areEqual(this.getModel().getElementAt(0), (Object)value) ? new ListSeparator(shortenText, (Icon)AnimatedIcon.Default.INSTANCE) : (!this.isLoading() && Intrinsics.areEqual((Object)value, (Object)firstPredefinedGenerator) ? new ListSeparator(shortenText) : null);
            }

            public String getText(Item item) {
                Object object = item;
                if (object == null || (object = object.toString()) == null) {
                    object = "";
                }
                return object;
            }

            public void customize(SimpleColoredComponent item, Item value, int index, boolean isSelected, boolean cellHasFocus) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                if (value instanceof Customizable) {
                    ((Customizable)((Object)value)).customize(item, this);
                } else {
                    super.customize(item, (Object)value, index, isSelected, cellHasFocus);
                }
            }
        };
        this.setSwingPopup(false);
        UiScopeKt.launchOnShow$default((Component)((Component)((Object)this)), (String)"CMakeGeneratorComboBox.launchOnShow", null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ CMakeGeneratorComboBox this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        CMakeGeneratorComboBox.updateGeneratorList$default(this.this$0, null, 1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        this.toolchainNameProperty.afterChange(arg_0 -> CMakeGeneratorComboBox._init_$lambda$0(this, arg_0));
        CMakeGeneratorComboBox.updateGeneratorList$default(this, null, 1, null);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ObservableProperty<String> getToolchainNameProperty() {
        return this.toolchainNameProperty;
    }

    @NotNull
    public final Item getGenerator() {
        Object object = this.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(...)");
        return (Item)object;
    }

    @RequiresEdt
    @NotNull
    public final String getDefaultGeneratorName() {
        return this.defaultGeneratorName;
    }

    @RequiresEdt
    public final void setDefaultGeneratorName(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.defaultGeneratorName = value;
        this.repaint();
    }

    @NotNull
    public final String getCustomGeneratorName() {
        return this.customGeneratorName;
    }

    public final boolean getShouldShowSpinner() {
        return this.shouldShowSpinner;
    }

    public final void setShouldShowSpinner(boolean bl) {
        this.shouldShowSpinner = bl;
    }

    public final boolean isLoading() {
        return this.isLoading;
    }

    public final void setLoading(boolean bl) {
        this.isLoading = bl;
    }

    @RequiresEdt
    public final void setGeneratorName(@NotNull String generatorName) {
        Intrinsics.checkNotNullParameter((Object)generatorName, (String)"generatorName");
        if (StringsKt.isBlank((CharSequence)generatorName)) {
            this.setSelectedItem(this.lastEmptyGenerator);
            return;
        }
        GeneratorItem predefined = this.findPredefinedGenerator(generatorName);
        if (predefined != null) {
            this.setSelectedItem(predefined);
            return;
        }
        this.selectCustomGenerator(generatorName);
    }

    @RequiresEdt
    private final void selectCustomGenerator(String customGeneratorName) {
        this.customGeneratorName = customGeneratorName;
        if (this.hasCustomGeneratorItem()) {
            this.repaint();
        } else {
            ComboBoxModel comboBoxModel = this.getModel();
            Intrinsics.checkNotNull((Object)comboBoxModel, (String)"null cannot be cast to non-null type com.intellij.ui.CollectionComboBoxModel<com.jetbrains.cidr.cpp.cmake.settings.CMakeGeneratorComboBox.Item>");
            ((CollectionComboBoxModel)comboBoxModel).add(0, (Object)CustomGeneratorItem.INSTANCE);
        }
        this.setSelectedItem(CustomGeneratorItem.INSTANCE);
    }

    private final boolean hasCustomGeneratorItem() {
        int n = this.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            Item item = (Item)this.getModel().getElementAt(i);
            if (!(item instanceof CustomGeneratorItem)) continue;
            return true;
        }
        return false;
    }

    private final GeneratorItem findPredefinedGenerator(String name) {
        if (name == null) {
            return null;
        }
        int n = this.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            Item item = (Item)this.getModel().getElementAt(i);
            if (!(item instanceof GeneratorItem) || !Intrinsics.areEqual((Object)((GeneratorItem)item).getGeneratorName(), (Object)name)) continue;
            return (GeneratorItem)item;
        }
        return null;
    }

    private final void updateGeneratorList(String toolchainName) {
        PreemptiveCoroutineScope.launchCancelling$default((PreemptiveCoroutineScope)this.updatingCoroutineScope, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, toolchainName, null){
            Object L$0;
            int label;
            final /* synthetic */ CMakeGeneratorComboBox this$0;
            final /* synthetic */ String $toolchainName;
            {
                this.this$0 = $receiver;
                this.$toolchainName = $toolchainName;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = CMakeGeneratorComboBox.access$getLongCMakeGenerators(this.this$0, this.$toolchainName, (Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if ((v1 = (GenerationGetResult)v0) == null) {
                            v1 = CMakeGeneratorComboBox.access$getApproximateCMakeGenerators(this.this$0);
                        }
                        getResult = v1;
                        v2 = CoroutinesKt.getUI((Dispatchers)Dispatchers.INSTANCE);
                        v3 = ModalityState.any();
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"any(...)");
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)getResult);
                        this.label = 2;
                        v4 = BuildersKt.withContext((CoroutineContext)v2.plus(ModalityKt.asContextElement((ModalityState)v3)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, getResult, null){
                            int label;
                            final /* synthetic */ CMakeGeneratorComboBox this$0;
                            final /* synthetic */ GenerationGetResult $getResult;
                            {
                                this.this$0 = $receiver;
                                this.$getResult = $getResult;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.this$0.setGeneratorItems(this.$getResult);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v4 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl29
                    }
                    case 2: {
                        getResult = (GenerationGetResult)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl29:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    static /* synthetic */ void updateGeneratorList$default(CMakeGeneratorComboBox cMakeGeneratorComboBox, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = (String)cMakeGeneratorComboBox.toolchainNameProperty.get();
        }
        cMakeGeneratorComboBox.updateGeneratorList(string);
    }

    /*
     * Unable to fully structure code
     */
    private final Object getLongCMakeGenerators(String toolchainName, Continuation<? super GenerationGetResult> $completion) {
        if (!($completion instanceof getLongCMakeGenerators.1)) ** GOTO lbl-1000
        var23_3 = $completion;
        if ((var23_3.label & -2147483648) != 0) {
            var23_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ CMakeGeneratorComboBox this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return CMakeGeneratorComboBox.access$getLongCMakeGenerators(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var24_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                toolchain = CPPToolchains.getInstance().getToolchainByNameOrDefault(toolchainName);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)toolchainName);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)toolchain);
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super CMakeCapabilities>, Object>(this, toolchain, null){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    int label;
                    final /* synthetic */ CMakeGeneratorComboBox this$0;
                    final /* synthetic */ CPPToolchains.Toolchain $toolchain;
                    {
                        this.this$0 = $receiver;
                        this.$toolchain = $toolchain;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                CPPEnvironment cppEnvironment = CPPToolchains.createCPPEnvironment((Project)this.this$0.getProject(), (CPPToolchains.Toolchain)this.$toolchain, (EnvironmentProblems)new EnvironmentProblems(), (boolean)false);
                                CPPEnvironment cPPEnvironment = cppEnvironment;
                                if (cPPEnvironment == null || (cPPEnvironment = cPPEnvironment.getCMake()) == null) {
                                    return null;
                                }
                                CPPEnvironment executableTool = cPPEnvironment;
                                java.time.Duration readVersionFallbackTimeout = CidrRunProcessUtil.getReadVersionTimeout((OS)cppEnvironment.getHostMachine().getOS());
                                Intrinsics.checkNotNull((Object)readVersionFallbackTimeout);
                                java.time.Duration duration = readVersionFallbackTimeout;
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)cppEnvironment);
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)executableTool);
                                this.L$2 = SpillingKt.nullOutSpilledVariable((Object)readVersionFallbackTimeout);
                                this.label = 1;
                                Object object2 = TimeoutKt.withTimeoutOrNull-KLykuaI((long)Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)duration.getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)duration.getNano(), (DurationUnit)DurationUnit.NANOSECONDS)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super CMakeCapabilities>, Object>((CMakeExecutableTool)executableTool, null){
                                    int label;
                                    final /* synthetic */ CMakeExecutableTool $executableTool;
                                    {
                                        this.$executableTool = $executableTool;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                this.label = 1;
                                                Object object2 = CMakeExecutableToolKt.safeGetCMakeCapabilities(this.$executableTool, (Continuation<? super CMakeCapabilities>)((Continuation)this));
                                                Object object3 = object2;
                                                if (object2 != object) return (CMakeCapabilities)object3;
                                                return object;
                                            }
                                            case 1: {
                                                Object object3;
                                                try {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    object3 = $result;
                                                    return (CMakeCapabilities)object3;
                                                }
                                                catch (ExecutionException e) {
                                                    CMakeGeneratorComboBoxKt.access$getLOG$p().info("Failed to get CMake capabilities", (Throwable)e);
                                                    return null;
                                                }
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super CMakeCapabilities> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                java.time.Duration readVersionFallbackTimeout = (java.time.Duration)this.L$2;
                                CMakeExecutableTool executableTool = (CMakeExecutableTool)this.L$1;
                                CPPEnvironment cppEnvironment = (CPPEnvironment)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super CMakeCapabilities> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var24_5) {
                    return var24_5;
                }
                ** GOTO lbl25
            }
            case 1: {
                toolchain = (CPPToolchains.Toolchain)$continuation.L$1;
                toolchainName = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                v1 = (CMakeCapabilities)v0;
                if (v1 == null) {
                    return null;
                }
                cMakeCapabilities = v1;
                items = new ArrayList<E>();
                knownGenerators = CMakeGeneratorType.Companion.allKnownGenerators();
                var8_10 = cMakeCapabilities.getGenerators();
                $i$f$map = false;
                var10_13 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var15_18 = (CMakeCapabilities.Generator)item$iv$iv;
                    var21_20 = destination$iv$iv;
                    $i$a$-map-CMakeGeneratorComboBox$getLongCMakeGenerators$generators$1 = false;
                    var21_20.add(new GeneratorItem(CMakeGeneratorType.Companion.fromGeneratorSpec(it.getName())));
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (GeneratorItem)item$iv$iv;
                    var21_20 = destination$iv$iv;
                    $i$a$-map-CMakeGeneratorComboBox$getLongCMakeGenerators$generators$2 = false;
                    var17_21 = Boxing.boxInt((int)knownGenerators.indexOf(generatorItem.getGenerator()));
                    var18_22 = ((Number)var17_21).intValue();
                    var19_23 = generatorItem;
                    $i$a$-takeIf-CMakeGeneratorComboBox$getLongCMakeGenerators$generators$2$1 = false;
                    v2 = Boxing.boxBoolean((boolean)(it >= 0)) != false ? var17_21 : null;
                    var21_20.add(TuplesKt.to((Object)var19_23, (Object)Boxing.boxInt((int)(v2 != null ? v2.intValue() : knownGenerators.size()))));
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$sortedBy = false;
                generators = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Pair it = (Pair)a;
                        boolean bl = false;
                        Comparable comparable = (Integer)it.getSecond();
                        it = (Pair)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getSecond()));
                    }
                });
                for (Pair generator : generators) {
                    items.add(generator.getFirst());
                }
                this.firstPredefinedGenerator = (Item)CollectionsKt.first((List)items);
                v3 = CMakeBundle.message("cmake.generator.loaded", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"message(...)");
                return new GenerationGetResult(v3, items);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final GenerationGetResult getApproximateCMakeGenerators() {
        CMakeGeneratorComboBoxKt.access$getLOG$p().warn("Using approximate CMake generator list");
        List items = new ArrayList();
        List<CMakeGeneratorType> generators = SystemInfo.isWindows ? WIN_GENERATORS : (SystemInfo.isMac ? MAC_GENERATORS : UNIX_GENERATORS);
        for (CMakeGeneratorType generator : generators) {
            GeneratorItem item = new GeneratorItem(generator);
            items.add(item);
        }
        this.firstPredefinedGenerator = (Item)CollectionsKt.first((List)items);
        String string = CMakeBundle.message("cmake.generator.loaded.approximate", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return new GenerationGetResult(string, items);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public final void setGeneratorItems(@NotNull GenerationGetResult generationGetResult) {
        Intrinsics.checkNotNullParameter((Object)generationGetResult, (String)"generationGetResult");
        Object currentSelection = this.getSelectedItem();
        this.separatorText = generationGetResult.getSeparatorName();
        this.isLoading = false;
        Object object = new Item[]{DefaultGeneratorItem.INSTANCE, NoGeneratorItem.INSTANCE};
        List newItems = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])object), (Iterable)generationGetResult.getItems());
        ComboBoxModel comboBoxModel = this.getModel();
        Intrinsics.checkNotNull((Object)comboBoxModel, (String)"null cannot be cast to non-null type com.intellij.ui.CollectionComboBoxModel<@[FlexibleNullability] com.jetbrains.cidr.cpp.cmake.settings.CMakeGeneratorComboBox.Item?>");
        ((CollectionComboBoxModel)comboBoxModel).replaceAll(newItems);
        object = currentSelection;
        if (object instanceof GeneratorItem) {
            Collection<Object> collection;
            block10: {
                Iterator $this$filterIsInstanceTo$iv$iv;
                void $this$filterIsInstance$iv;
                Iterable iterable = generationGetResult.getItems();
                boolean $i$f$filterIsInstance22 = false;
                void var8_11 = $this$filterIsInstance$iv;
                Collection<Object> destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                Iterator iterator = $this$filterIsInstanceTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv = iterator.next();
                    if (!(element$iv$iv instanceof GeneratorItem)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                Iterable $i$f$filterIsInstance22 = (List)destination$iv$iv2;
                for (Collection<Object> destination$iv$iv2 : $i$f$filterIsInstance22) {
                    GeneratorItem it = (GeneratorItem)((Object)destination$iv$iv2);
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getGeneratorName(), (Object)((GeneratorItem)currentSelection).getGeneratorName())) continue;
                    collection = destination$iv$iv2;
                    break block10;
                }
                collection = null;
            }
            GeneratorItem matchingGenerator = (GeneratorItem)((Object)collection);
            if (matchingGenerator != null) {
                this.setSelectedItem(matchingGenerator);
            } else {
                this.selectCustomGenerator(((GeneratorItem)currentSelection).getGeneratorName());
            }
        } else if (object instanceof CustomGeneratorItem) {
            Object v2;
            block11: {
                Iterable $this$filterIsInstance$iv = generationGetResult.getItems();
                boolean $i$f$filterIsInstance = false;
                Iterable $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof GeneratorItem)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable iterable = (List)destination$iv$iv;
                for (Object t : iterable) {
                    GeneratorItem it = (GeneratorItem)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getGeneratorName(), (Object)this.customGeneratorName)) continue;
                    v2 = t;
                    break block11;
                }
                v2 = null;
            }
            GeneratorItem matchingGenerator = v2;
            if (matchingGenerator != null) {
                this.setSelectedItem(matchingGenerator);
            }
        }
    }

    @TestOnly
    @NotNull
    public final List<Item> getGenerators() {
        ComboBoxModel comboBoxModel = this.getModel();
        Intrinsics.checkNotNull((Object)comboBoxModel, (String)"null cannot be cast to non-null type com.intellij.ui.CollectionComboBoxModel<@[FlexibleNullability] com.jetbrains.cidr.cpp.cmake.settings.CMakeGeneratorComboBox.Item?>");
        List list2 = ((CollectionComboBoxModel)comboBoxModel).getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems(...)");
        return list2;
    }

    private static final Unit _init_$lambda$0(CMakeGeneratorComboBox this$0, String it) {
        this$0.updateGeneratorList(it);
        return Unit.INSTANCE;
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final String changeGenerator(@NotNull String options, @NotNull String newGenerator) {
        return Companion.changeGenerator(options, newGenerator);
    }

    public static final /* synthetic */ Object access$getLongCMakeGenerators(CMakeGeneratorComboBox $this, String toolchainName, Continuation $completion) {
        return $this.getLongCMakeGenerators(toolchainName, (Continuation<? super GenerationGetResult>)$completion);
    }

    public static final /* synthetic */ GenerationGetResult access$getApproximateCMakeGenerators(CMakeGeneratorComboBox $this) {
        return $this.getApproximateCMakeGenerators();
    }

    static {
        Object[] objectArray = new CMakeGeneratorType[]{CMakeGeneratorType.NINJA.INSTANCE, CMakeGeneratorType.NINJA_MULTI.INSTANCE, CMakeGeneratorType.UNIX_MAKEFILES.INSTANCE, CMakeGeneratorType.BORLAND_MAKEFILES.INSTANCE, CMakeGeneratorType.NMAKE_MAKEFILES.INSTANCE, CMakeGeneratorType.NMAKE_MAKEFILES_JOM.INSTANCE, CMakeGeneratorType.MSYS_MAKEFILES.INSTANCE, CMakeGeneratorType.MINGW_MAKEFILES.INSTANCE, CMakeGeneratorType.WATCOM_MAKEFILES.INSTANCE, CMakeGeneratorType.VS14.INSTANCE, CMakeGeneratorType.VS15.INSTANCE, CMakeGeneratorType.VS16.INSTANCE, CMakeGeneratorType.VS17.INSTANCE, CMakeGeneratorType.GREEN_HILLS_MULTI.INSTANCE};
        WIN_GENERATORS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new CMakeGeneratorType[]{CMakeGeneratorType.NINJA.INSTANCE, CMakeGeneratorType.NINJA_MULTI.INSTANCE, CMakeGeneratorType.UNIX_MAKEFILES.INSTANCE, CMakeGeneratorType.WATCOM_MAKEFILES.INSTANCE, CMakeGeneratorType.GREEN_HILLS_MULTI.INSTANCE};
        UNIX_GENERATORS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new CMakeGeneratorType[]{CMakeGeneratorType.NINJA.INSTANCE, CMakeGeneratorType.NINJA_MULTI.INSTANCE, CMakeGeneratorType.UNIX_MAKEFILES.INSTANCE, CMakeGeneratorType.XCODE.INSTANCE};
        MAC_GENERATORS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0007J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u001a\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0002J\"\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\nH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$Companion;", "", "<init>", "()V", "WIN_GENERATORS", "", "Lcom/jetbrains/cidr/cpp/cmake/model/CMakeGeneratorType;", "UNIX_GENERATORS", "MAC_GENERATORS", "changeGenerator", "", "options", "newGenerator", "addGenerator", "new", "removeGenerator", "old", "replaceGenerator", "createGeneratorReplacementRegex", "Lkotlin/text/Regex;", "generator", "intellij.cmake"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final String changeGenerator(@NotNull String options, @NotNull String newGenerator) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter((Object)newGenerator, (String)"newGenerator");
            List<String> optionsList = CMakeSettings.Companion.getOptionsList(options);
            boolean hasUserGenerator = CMakeGeneratorUtils.hasUserSpecifiedGenerator(optionsList);
            String userGenerator = CMakeGeneratorUtils.getUserSpecifiedGenerator(optionsList);
            return !hasUserGenerator && StringsKt.isBlank((CharSequence)newGenerator) ? options : (!hasUserGenerator && !StringsKt.isBlank((CharSequence)newGenerator) ? this.addGenerator(options, newGenerator) : (hasUserGenerator && StringsKt.isBlank((CharSequence)newGenerator) ? this.removeGenerator(options, userGenerator) : this.replaceGenerator(options, userGenerator, newGenerator)));
        }

        private final String addGenerator(String options, String string) {
            ParametersList parameters2 = new ParametersList();
            parameters2.add("-G");
            parameters2.add(string);
            return parameters2.getParametersString() + " " + options;
        }

        private final String removeGenerator(String options, String old) {
            Regex regex = this.createGeneratorReplacementRegex(old);
            MatchResult matchResult = (MatchResult)SequencesKt.lastOrNull((Sequence)Regex.findAll$default((Regex)regex, (CharSequence)options, (int)0, (int)2, null));
            if (matchResult == null) {
                return options;
            }
            MatchResult match = matchResult;
            String string = options;
            int n = 0;
            int n2 = match.getRange().getFirst();
            String string2 = string.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String beforeMatch = string2;
            String string3 = options;
            n2 = match.getRange().getLast() + 1;
            String string4 = string3.substring(n2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            String afterMatch = string4;
            if (StringsKt.isBlank((CharSequence)beforeMatch)) {
                string3 = options;
                n2 = match.getRange().getLast() + 1;
                String string5 = string3.substring(n2);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                return ((Object)StringsKt.trimStart((CharSequence)string5)).toString();
            }
            if (StringsKt.isBlank((CharSequence)afterMatch)) {
                string3 = options;
                n2 = 0;
                int n3 = match.getRange().getFirst();
                String string6 = string3.substring(n2, n3);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                return ((Object)StringsKt.trimEnd((CharSequence)string6)).toString();
            }
            IntRange replaceRange = match.getRange();
            if (StringsKt.endsWith$default((String)beforeMatch, (String)" ", (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)afterMatch, (String)" ", (boolean)false, (int)2, null)) {
                replaceRange = new IntRange(replaceRange.getFirst(), replaceRange.getLast() + 1);
            }
            String string7 = options;
            CharSequence charSequence = "";
            return ((Object)StringsKt.replaceRange((CharSequence)string7, (IntRange)replaceRange, (CharSequence)charSequence)).toString();
        }

        private final String replaceGenerator(String options, String old, String string) {
            Regex regex = this.createGeneratorReplacementRegex(old);
            ParametersList parameters2 = new ParametersList();
            parameters2.add("-G");
            parameters2.add(string);
            MatchResult matchResult = (MatchResult)SequencesKt.lastOrNull((Sequence)Regex.findAll$default((Regex)regex, (CharSequence)options, (int)0, (int)2, null));
            if (matchResult == null) {
                return options;
            }
            MatchResult match = matchResult;
            StringBuilder sb = new StringBuilder(options.length());
            sb.append(options, 0, match.getRange().getFirst());
            sb.append(parameters2.getParametersString());
            sb.append(options, match.getRange().getLast() + 1, options.length());
            String string2 = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string2;
        }

        private final Regex createGeneratorReplacementRegex(String generator) {
            String quotes = "`'\"";
            String openingQuotes = "\u201e\u00ab" + quotes;
            String closingQuotes = "\u201c\u00bb" + quotes;
            String string = generator;
            if (string == null) {
                string = "";
            }
            String generatorRegex = "-G\\s*[" + openingQuotes + "]?\\Q" + string + "\\E[" + closingQuotes + "]?";
            return new Regex(generatorRegex);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$CustomGeneratorItem;", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$Item;", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$Customizable;", "<init>", "()V", "customize", "", "component", "Lcom/intellij/ui/SimpleColoredComponent;", "comboBox", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox;", "toString", "", "intellij.cmake"})
    public static final class CustomGeneratorItem
    implements Item,
    Customizable {
        @NotNull
        public static final CustomGeneratorItem INSTANCE = new CustomGeneratorItem();

        private CustomGeneratorItem() {
        }

        @Override
        public void customize(@NotNull SimpleColoredComponent component, @NotNull CMakeGeneratorComboBox comboBox) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter((Object)((Object)comboBox), (String)"comboBox");
            String customGeneratorName = comboBox.getCustomGeneratorName();
            component.append(CMakeBundle.message("cmake.generator.custom.label", new Object[0]));
            if (!StringsKt.isBlank((CharSequence)customGeneratorName)) {
                component.append(" ");
                component.append(customGeneratorName, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        }

        @NotNull
        public String toString() {
            String string = CMakeBundle.message("cmake.generator.custom.label", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$Customizable;", "", "customize", "", "component", "Lcom/intellij/ui/SimpleColoredComponent;", "comboBox", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox;", "intellij.cmake"})
    private static interface Customizable {
        public void customize(@NotNull SimpleColoredComponent var1, @NotNull CMakeGeneratorComboBox var2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$DefaultGeneratorItem;", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$Item;", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$Customizable;", "<init>", "()V", "UNKNOWN", "", "customize", "", "component", "Lcom/intellij/ui/SimpleColoredComponent;", "comboBox", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox;", "toString", "intellij.cmake"})
    public static final class DefaultGeneratorItem
    implements Item,
    Customizable {
        @NotNull
        public static final DefaultGeneratorItem INSTANCE = new DefaultGeneratorItem();
        @NotNull
        public static final String UNKNOWN = "__CIDR_UNKNOWN_GENERATOR__";

        private DefaultGeneratorItem() {
        }

        @Override
        public void customize(@NotNull SimpleColoredComponent component, @NotNull CMakeGeneratorComboBox comboBox) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter((Object)((Object)comboBox), (String)"comboBox");
            String defaultGeneratorName = comboBox.getDefaultGeneratorName();
            component.append(CMakeBundle.message("cmake.generator.default.label", new Object[0]));
            if (Intrinsics.areEqual((Object)defaultGeneratorName, (Object)UNKNOWN)) {
                return;
            }
            if (!StringsKt.isBlank((CharSequence)defaultGeneratorName)) {
                component.append("  ");
                component.append(defaultGeneratorName, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            } else if (comboBox.getShouldShowSpinner()) {
                component.setIconOnTheRight(true);
                component.setIcon((Icon)AnimatedIcon.Default.INSTANCE);
            }
        }

        @NotNull
        public String toString() {
            String string = CMakeBundle.message("cmake.generator.default.label", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\"\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u000e\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J(\u0010\u0010\u001a\u00020\u00002\r\b\u0002\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$GenerationGetResult;", "", "separatorName", "", "Lorg/jetbrains/annotations/Nls;", "items", "", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$Item;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getSeparatorName", "()Ljava/lang/String;", "getItems", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.cmake"})
    public static final class GenerationGetResult {
        @NotNull
        private final String separatorName;
        @NotNull
        private final List<Item> items;

        public GenerationGetResult(@NotNull String separatorName, @NotNull List<? extends Item> items) {
            Intrinsics.checkNotNullParameter((Object)separatorName, (String)"separatorName");
            Intrinsics.checkNotNullParameter(items, (String)"items");
            this.separatorName = separatorName;
            this.items = items;
        }

        @NotNull
        public final String getSeparatorName() {
            return this.separatorName;
        }

        @NotNull
        public final List<Item> getItems() {
            return this.items;
        }

        @NotNull
        public final String component1() {
            return this.separatorName;
        }

        @NotNull
        public final List<Item> component2() {
            return this.items;
        }

        @NotNull
        public final GenerationGetResult copy(@NotNull String separatorName, @NotNull List<? extends Item> items) {
            Intrinsics.checkNotNullParameter((Object)separatorName, (String)"separatorName");
            Intrinsics.checkNotNullParameter(items, (String)"items");
            return new GenerationGetResult(separatorName, items);
        }

        public static /* synthetic */ GenerationGetResult copy$default(GenerationGetResult generationGetResult, String string, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                string = generationGetResult.separatorName;
            }
            if ((n & 2) != 0) {
                list2 = generationGetResult.items;
            }
            return generationGetResult.copy(string, list2);
        }

        @NotNull
        public String toString() {
            return "GenerationGetResult(separatorName=" + this.separatorName + ", items=" + this.items + ")";
        }

        public int hashCode() {
            int result2 = this.separatorName.hashCode();
            result2 = result2 * 31 + ((Object)this.items).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GenerationGetResult)) {
                return false;
            }
            GenerationGetResult generationGetResult = (GenerationGetResult)other;
            if (!Intrinsics.areEqual((Object)this.separatorName, (Object)generationGetResult.separatorName)) {
                return false;
            }
            return Intrinsics.areEqual(this.items, generationGetResult.items);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\n\u001a\u00070\t\u00a2\u0006\u0002\b\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$GeneratorItem;", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$Item;", "generator", "Lcom/jetbrains/cidr/cpp/cmake/model/CMakeGeneratorType;", "<init>", "(Lcom/jetbrains/cidr/cpp/cmake/model/CMakeGeneratorType;)V", "getGenerator", "()Lcom/jetbrains/cidr/cpp/cmake/model/CMakeGeneratorType;", "toString", "", "generatorName", "Lcom/intellij/openapi/util/NlsSafe;", "getGeneratorName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "intellij.cmake"})
    public static final class GeneratorItem
    implements Item {
        @NotNull
        private final CMakeGeneratorType generator;

        public GeneratorItem(@NotNull CMakeGeneratorType generator) {
            Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
            this.generator = generator;
        }

        @NotNull
        public final CMakeGeneratorType getGenerator() {
            return this.generator;
        }

        @NotNull
        public String toString() {
            return this.generator.getName();
        }

        @NotNull
        public final String getGeneratorName() {
            return this.generator.getName();
        }

        @NotNull
        public final CMakeGeneratorType component1() {
            return this.generator;
        }

        @NotNull
        public final GeneratorItem copy(@NotNull CMakeGeneratorType generator) {
            Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
            return new GeneratorItem(generator);
        }

        public static /* synthetic */ GeneratorItem copy$default(GeneratorItem generatorItem, CMakeGeneratorType cMakeGeneratorType, int n, Object object) {
            if ((n & 1) != 0) {
                cMakeGeneratorType = generatorItem.generator;
            }
            return generatorItem.copy(cMakeGeneratorType);
        }

        public int hashCode() {
            return this.generator.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GeneratorItem)) {
                return false;
            }
            GeneratorItem generatorItem = (GeneratorItem)other;
            return Intrinsics.areEqual((Object)this.generator, (Object)generatorItem.generator);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001\u0082\u0001\u0004\u0002\u0003\u0004\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$Item;", "", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$CustomGeneratorItem;", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$DefaultGeneratorItem;", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$GeneratorItem;", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$NoGeneratorItem;", "intellij.cmake"})
    public static sealed interface Item
    permits CustomGeneratorItem, DefaultGeneratorItem, GeneratorItem, NoGeneratorItem {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$NoGeneratorItem;", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$Item;", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox$Customizable;", "<init>", "()V", "customize", "", "component", "Lcom/intellij/ui/SimpleColoredComponent;", "comboBox", "Lcom/jetbrains/cidr/cpp/cmake/settings/CMakeGeneratorComboBox;", "intellij.cmake"})
    public static final class NoGeneratorItem
    implements Item,
    Customizable {
        @NotNull
        public static final NoGeneratorItem INSTANCE = new NoGeneratorItem();

        private NoGeneratorItem() {
        }

        @Override
        public void customize(@NotNull SimpleColoredComponent component, @NotNull CMakeGeneratorComboBox comboBox) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter((Object)((Object)comboBox), (String)"comboBox");
            component.append(CMakeBundle.message("cmake.generator.none.label", new Object[0]));
            component.append("  ");
            component.append(CMakeBundle.message("cmake.generator.none.description", new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }
}

