/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.presets;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.EnvironmentUtil;
import com.jetbrains.cidr.cpp.cmake.presets.CircularReferenceInMacroException;
import com.jetbrains.cidr.cpp.cmake.presets.ExpansionPolicy;
import com.jetbrains.cidr.cpp.cmake.presets.MacroString;
import com.jetbrains.cidr.cpp.cmake.presets.Preset;
import java.nio.file.FileSystems;
import java.util.ArrayDeque;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u00062\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0016J\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u00062\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0016J\u0016\u0010\f\u001a\u0004\u0018\u00010\u00062\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/presets/TrivialExpansionPolicy;", "Lcom/jetbrains/cidr/cpp/cmake/presets/ExpansionPolicy;", "<init>", "()V", "macrosUnderExpansion", "Ljava/util/ArrayDeque;", "", "expandEnvironmentVariable", "variable", "preset", "Lcom/jetbrains/cidr/cpp/cmake/presets/Preset;", "expandSourceDirMacro", "expandSourceParentDirMacro", "intellij.cmake"})
@SourceDebugExtension(value={"SMAP\nExpansionPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpansionPolicy.kt\ncom/jetbrains/cidr/cpp/cmake/presets/TrivialExpansionPolicy\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,56:1\n13#2:57\n*S KotlinDebug\n*F\n+ 1 ExpansionPolicy.kt\ncom/jetbrains/cidr/cpp/cmake/presets/TrivialExpansionPolicy\n*L\n27#1:57\n*E\n"})
public class TrivialExpansionPolicy
implements ExpansionPolicy {
    @NotNull
    private final ArrayDeque<String> macrosUnderExpansion = new ArrayDeque();

    @Override
    @Nullable
    public String expandEnvironmentVariable(@NotNull String variable, @NotNull Preset<?> preset) {
        Object expansion;
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter(preset, (String)"preset");
        if (this.macrosUnderExpansion.contains(variable)) {
            throw new CircularReferenceInMacroException(preset, variable, CollectionsKt.toList((Iterable)this.macrosUnderExpansion));
        }
        this.macrosUnderExpansion.push(variable);
        Object object = preset.getEnvironment().get(variable);
        if ((object == null || (object = ((MacroString)object).expand(this)) == null) && (object = EnvironmentUtil.getValue((String)variable)) == null) {
            object = expansion = "";
        }
        if (!Intrinsics.areEqual((Object)variable, (Object)this.macrosUnderExpansion.peek())) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(TrivialExpansionPolicy.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Macro expansion stack inconsistency, expected <" + variable + "> got <" + this.macrosUnderExpansion.peek() + ">");
        }
        this.macrosUnderExpansion.pop();
        return expansion;
    }

    @Override
    @Nullable
    public String expandSourceDirMacro(@NotNull Preset<?> preset) {
        Intrinsics.checkNotNullParameter(preset, (String)"preset");
        return ((Object)preset.getSchema().getProjectPath$intellij_cmake()).toString();
    }

    @Override
    @Nullable
    public String expandSourceParentDirMacro(@NotNull Preset<?> preset) {
        Intrinsics.checkNotNullParameter(preset, (String)"preset");
        return preset.getSchema().getProjectPath$intellij_cmake() + FileSystems.getDefault().getSeparator() + "..";
    }
}

