/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.presets;

import com.google.gson.JsonParseException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.cidr.cpp.cmake.presets.BuildPreset;
import com.jetbrains.cidr.cpp.cmake.presets.ConfigurePreset;
import com.jetbrains.cidr.cpp.cmake.presets.FileParsingException;
import com.jetbrains.cidr.cpp.cmake.presets.FilePresetContent;
import com.jetbrains.cidr.cpp.cmake.presets.GenericPresetException;
import com.jetbrains.cidr.cpp.cmake.presets.NoPresetFilesException;
import com.jetbrains.cidr.cpp.cmake.presets.ParseKt;
import com.jetbrains.cidr.cpp.cmake.presets.PresetContent;
import com.jetbrains.cidr.cpp.cmake.presets.UnknownToolsetException;
import com.jetbrains.cidr.cpp.cmake.presets.parser.gson.GsonSchemaParser;
import com.jetbrains.cidr.cpp.cmake.presets.parser.kotlin.KxSerializationSchemaParser;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0002J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0005H\u0002J\b\u0010!\u001a\u00020\u0000H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001d\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001f0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001d\u00a8\u0006#"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/presets/Schema;", "", "projectPath", "Ljava/nio/file/Path;", "presetFiles", "", "<init>", "(Ljava/nio/file/Path;Ljava/util/List;)V", "getProjectPath$intellij_cmake", "()Ljava/nio/file/Path;", "getPresetFiles$intellij_cmake", "()Ljava/util/List;", "timestamps", "Ljava/nio/file/attribute/FileTime;", "apply", "", "content", "Lcom/jetbrains/cidr/cpp/cmake/presets/PresetContent;", "isUpToDate", "", "project", "Lcom/intellij/openapi/project/Project;", "files", "getProjectPresetFilesTimestamps", "configurePresetsMap", "", "", "Lcom/jetbrains/cidr/cpp/cmake/presets/ConfigurePreset;", "getConfigurePresetsMap", "()Ljava/util/Map;", "buildPresetsMap", "Lcom/jetbrains/cidr/cpp/cmake/presets/BuildPreset;", "getBuildPresetsMap", "postProcess", "Companion", "intellij.cmake"})
@SourceDebugExtension(value={"SMAP\nSchema.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Schema.kt\ncom/jetbrains/cidr/cpp/cmake/presets/Schema\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1869#2,2:130\n1869#2,2:132\n1869#2,2:134\n*S KotlinDebug\n*F\n+ 1 Schema.kt\ncom/jetbrains/cidr/cpp/cmake/presets/Schema\n*L\n104#1:130,2\n118#1:132,2\n122#1:134,2\n*E\n"})
public final class Schema {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path projectPath;
    @NotNull
    private final List<Path> presetFiles;
    @NotNull
    private final List<FileTime> timestamps;
    @NotNull
    private final Map<String, ConfigurePreset<?>> configurePresetsMap;
    @NotNull
    private final Map<String, BuildPreset> buildPresetsMap;

    private Schema(Path projectPath, List<? extends Path> presetFiles) {
        this.projectPath = projectPath;
        this.presetFiles = presetFiles;
        this.timestamps = Schema.Companion.getFilesTimestamps(this.presetFiles);
        this.configurePresetsMap = new LinkedHashMap();
        this.buildPresetsMap = new LinkedHashMap();
    }

    @NotNull
    public final Path getProjectPath$intellij_cmake() {
        return this.projectPath;
    }

    @NotNull
    public final List<Path> getPresetFiles$intellij_cmake() {
        return this.presetFiles;
    }

    private final void apply(PresetContent content) throws FileParsingException {
        block8: {
            try {
                if (Registry.Companion.is("cmake.presets.use.new.parser")) {
                    try {
                        Schema schema = KxSerializationSchemaParser.Companion.parse(content, this);
                        break block8;
                    }
                    catch (SerializationException ex) {
                        throw new FileParsingException(content.getFile(), (Exception)((Object)ex));
                    }
                }
                try {
                    GsonSchemaParser.Companion.parse(this, content);
                }
                catch (JsonParseException ex) {
                    throw new FileParsingException(content.getFile(), (Exception)((Object)ex));
                }
            }
            catch (UnknownToolsetException ex) {
                throw new FileParsingException(content.getFile(), ex);
            }
            catch (GenericPresetException ex) {
                throw new FileParsingException(content.getFile(), ex);
            }
        }
    }

    public final boolean isUpToDate(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return Intrinsics.areEqual((Object)CMakeWorkspace.Companion.getInstance(project).getProjectPath(), (Object)this.projectPath) && Intrinsics.areEqual(this.timestamps, this.getProjectPresetFilesTimestamps());
    }

    private final void apply(List<? extends Path> files) throws FileParsingException {
        Iterable $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path file = (Path)element$iv;
            boolean bl = false;
            FilePresetContent content = new FilePresetContent(file);
            this.apply(content);
        }
    }

    private final List<FileTime> getProjectPresetFilesTimestamps() {
        return Schema.Companion.getFilesTimestamps(Schema.Companion.getPresetFiles(this.projectPath));
    }

    @NotNull
    public final Map<String, ConfigurePreset<?>> getConfigurePresetsMap() {
        return this.configurePresetsMap;
    }

    @NotNull
    public final Map<String, BuildPreset> getBuildPresetsMap() {
        return this.buildPresetsMap;
    }

    private final Schema postProcess() {
        Iterable $this$forEach$iv = this.configurePresetsMap.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConfigurePreset configurePreset = (ConfigurePreset)element$iv;
            boolean bl = false;
            configurePreset.setSchema(this);
        }
        $this$forEach$iv = this.buildPresetsMap.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BuildPreset buildPreset = (BuildPreset)element$iv;
            boolean bl = false;
            buildPreset.setSchema(this);
        }
        return this;
    }

    @JvmStatic
    @NotNull
    public static final List<Path> getPresetFiles(@NotNull Path projectPath) {
        return Companion.getPresetFiles(projectPath);
    }

    public /* synthetic */ Schema(Path projectPath, List presetFiles, DefaultConstructorMarker $constructor_marker) {
        this(projectPath, presetFiles);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0007J\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u0012\u001a\u00020\nH\u0007\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/presets/Schema$Companion;", "", "<init>", "()V", "loadForProject", "Lcom/jetbrains/cidr/cpp/cmake/presets/Schema;", "project", "Lcom/intellij/openapi/project/Project;", "loadFrom", "path", "Ljava/nio/file/Path;", "presetContentList", "", "Lcom/jetbrains/cidr/cpp/cmake/presets/PresetContent;", "getFilesTimestamps", "Ljava/nio/file/attribute/FileTime;", "files", "getPresetFiles", "projectPath", "intellij.cmake"})
    @SourceDebugExtension(value={"SMAP\nSchema.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Schema.kt\ncom/jetbrains/cidr/cpp/cmake/presets/Schema$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n1617#2,9:130\n1869#2:139\n1870#2:141\n1626#2:142\n1#3:140\n*S KotlinDebug\n*F\n+ 1 Schema.kt\ncom/jetbrains/cidr/cpp/cmake/presets/Schema$Companion\n*L\n59#1:130,9\n59#1:139\n59#1:141\n59#1:142\n59#1:140\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Schema loadForProject(@NotNull Project project) throws NoPresetFilesException, FileParsingException {
            Path path;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            try {
                path = CMakeWorkspace.Companion.getInstance(project).getProjectPath();
            }
            catch (CidrWorkspace.NullFallbackProjectPathException ex) {
                throw new NoPresetFilesException();
            }
            Path projectPath = path;
            List<Path> allFiles = this.getPresetFiles(projectPath);
            if (allFiles.isEmpty()) {
                throw new NoPresetFilesException();
            }
            Schema schema = new Schema(projectPath, allFiles, null);
            schema.apply(allFiles);
            return schema.postProcess();
        }

        @TestOnly
        @NotNull
        public final Schema loadFrom(@NotNull Path path, @NotNull List<? extends PresetContent> presetContentList) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(presetContentList, (String)"presetContentList");
            Schema schema = new Schema(path, CollectionsKt.emptyList(), null);
            for (PresetContent presetContent : presetContentList) {
                schema.apply(presetContent);
            }
            return schema.postProcess();
        }

        /*
         * WARNING - void declaration
         */
        private final List<FileTime> getFilesTimestamps(List<? extends Path> files) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = files;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                FileTime fileTime;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Path it = (Path)element$iv$iv;
                boolean bl2 = false;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    LinkOption[] linkOptionArray2 = new LinkOption[]{};
                    FileTime fileTime2 = Files.getLastModifiedTime(it, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length));
                    fileTime = fileTime2;
                    Intrinsics.checkNotNullExpressionValue((Object)fileTime2, (String)"getLastModifiedTime(...)");
                } else {
                    fileTime = null;
                }
                if (fileTime == null) continue;
                FileTime it$iv$iv = fileTime;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        }

        @JvmStatic
        @NotNull
        public final List<Path> getPresetFiles(@NotNull Path projectPath) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            return CollectionsKt.plus((Collection)ParseKt.getProjectPresetsFiles(projectPath), (Iterable)ParseKt.getProjectUserPresetsFiles(projectPath));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

