/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.presets;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.MultiSelectionListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.cpp.CMakeBundle;
import com.jetbrains.cidr.cpp.cmake.CMakeSettings;
import com.jetbrains.cidr.cpp.cmake.presets.BuildPreset;
import com.jetbrains.cidr.cpp.cmake.presets.CMakePresetLoader;
import com.jetbrains.cidr.cpp.cmake.presets.FileParsingException;
import com.jetbrains.cidr.cpp.cmake.presets.InvalidPresetException;
import com.jetbrains.cidr.cpp.cmake.presets.NoPresetFilesException;
import com.jetbrains.cidr.cpp.cmake.presets.NotificationsKt;
import com.jetbrains.cidr.cpp.cmake.presets.Preset;
import com.jetbrains.cidr.cpp.cmake.presets.Schema;
import com.jetbrains.cidr.cpp.cmake.presets.problems.PresetProblem;
import com.jetbrains.cidr.cpp.cmake.presets.problems.PresetProblemReportingService;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J$\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/presets/LoadPresetsAndShowPopupTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "project", "Lcom/intellij/openapi/project/Project;", "workspace", "Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace;)V", "getWorkspace", "()Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace;", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "showErrorNotification", "message", "", "addShowProblemsAction", "", "Companion", "PresetsListPopupStep", "intellij.cmake"})
@SourceDebugExtension(value={"SMAP\nLoadPresetsAndShowPopupTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoadPresetsAndShowPopupTask.kt\ncom/jetbrains/cidr/cpp/cmake/presets/LoadPresetsAndShowPopupTask\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,134:1\n30#2,2:135\n30#2,2:137\n30#2,2:175\n30#2,2:177\n827#3:139\n855#3,2:140\n1563#3:142\n1634#3,3:143\n827#3:146\n855#3,2:147\n1617#3,9:149\n1869#3:158\n1870#3:160\n1626#3:161\n1617#3,9:162\n1869#3:171\n1870#3:173\n1626#3:174\n827#3:179\n855#3,2:180\n1563#3:182\n1634#3,3:183\n774#3:186\n865#3,2:187\n1869#3,2:189\n1563#3:191\n1634#3,3:192\n1563#3:195\n1634#3,3:196\n827#3:199\n855#3,2:200\n1#4:159\n1#4:172\n13#5:202\n*S KotlinDebug\n*F\n+ 1 LoadPresetsAndShowPopupTask.kt\ncom/jetbrains/cidr/cpp/cmake/presets/LoadPresetsAndShowPopupTask\n*L\n37#1:135,2\n43#1:137,2\n79#1:175,2\n97#1:177,2\n52#1:139\n52#1:140,2\n52#1:142\n52#1:143,3\n56#1:146\n56#1:147,2\n56#1:149,9\n56#1:158\n56#1:160\n56#1:161\n75#1:162,9\n75#1:171\n75#1:173\n75#1:174\n85#1:179\n85#1:180,2\n85#1:182\n85#1:183,3\n86#1:186\n86#1:187,2\n87#1:189,2\n91#1:191\n91#1:192,3\n92#1:195\n92#1:196,3\n94#1:199\n94#1:200,2\n56#1:159\n75#1:172\n28#1:202\n*E\n"})
public final class LoadPresetsAndShowPopupTask
extends Task.Backgroundable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CMakeWorkspace workspace;
    @NotNull
    private static final Logger LOG;

    public LoadPresetsAndShowPopupTask(@NotNull Project project, @NotNull CMakeWorkspace workspace) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)workspace), (String)"workspace");
        super(project, CMakeBundle.message("progress.title.loading.cmake.presets", new Object[0]), false);
        this.workspace = workspace;
    }

    @NotNull
    public final CMakeWorkspace getWorkspace() {
        return this.workspace;
    }

    /*
     * WARNING - void declaration
     */
    public void run(@NotNull ProgressIndicator indicator) {
        Iterable $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object it;
        void $this$filterNotTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object it2;
        void $this$filterNotTo$iv$iv2;
        Object $this$service$iv;
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        ActionsKt.invokeAndWaitIfNeeded$default(null, LoadPresetsAndShowPopupTask::run$lambda$0, (int)1, null);
        try {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<CMakePresetLoader> serviceClass$iv = CMakePresetLoader.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            $this$service$iv = ((CMakePresetLoader)object).loadProjectSchema();
        }
        catch (Exception e) {
            Exception serviceClass$iv = e;
            if (serviceClass$iv instanceof NoPresetFilesException) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Object[] objectArray = new Object[]{this.workspace.getProjectPath()};
                String string = CMakeBundle.message("notification.presets.files.not.found", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                LoadPresetsAndShowPopupTask.showErrorNotification$default(this, project, string, false, 4, null);
            } else if (serviceClass$iv instanceof FileParsingException) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                ComponentManager $this$service$iv2 = (ComponentManager)project;
                boolean $i$f$service22 = false;
                Class<PresetProblemReportingService> serviceClass$iv2 = PresetProblemReportingService.class;
                Object object = $this$service$iv2.getService(serviceClass$iv2);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv2, serviceClass$iv2);
                }
                PresetProblemReportingService presetProblemReportingService = (PresetProblemReportingService)object;
                FileParsingException fileParsingException = (FileParsingException)e;
                Project project2 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                presetProblemReportingService.setProblems(CollectionsKt.listOf((Object)fileParsingException.asProblem(project2)));
                Project project3 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                Object[] $i$f$service22 = new Object[]{((FileParsingException)e).getFile().getFileName()};
                String string = CMakeBundle.message("notification.content.has.issues.cannot.be.read", $i$f$service22);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.showErrorNotification(project3, string, true);
            } else {
                LOG.warn("Preset schema cannot be read because of ", (Throwable)e);
            }
            return;
        }
        Object schema = $this$service$iv;
        Iterable $this$filterNot$iv = (Iterable)ActionsKt.runReadAction(() -> LoadPresetsAndShowPopupTask.run$lambda$1(this));
        boolean $i$f$filterNot = false;
        Iterable $this$service$iv2 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv2) {
            it2 = (CMakeSettings.Profile)element$iv$iv;
            boolean bl = false;
            if (((CMakeSettings.Profile)it2).getFromPreset()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv2 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it2 = (CMakeSettings.Profile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((CMakeSettings.Profile)it2).getName());
        }
        List profileNames = (List)destination$iv$iv;
        List problems = new ArrayList();
        Iterable $this$filterNot$iv2 = ((Schema)schema).getBuildPresetsMap().values();
        boolean $i$f$filterNot2 = false;
        Iterable $i$f$mapTo22 = $this$filterNot$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo2 = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (BuildPreset)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)((Preset)it).getHidden(), (Object)true)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterNot$iv2 = (List)destination$iv$iv2;
        boolean $i$f$mapNotNull2 = false;
        $this$filterNotTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            Pair pair;
            block18: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = it.next();
                boolean bl = false;
                BuildPreset it3 = (BuildPreset)element$iv$iv;
                boolean bl2 = false;
                try {
                    Pair presetToProfile = TuplesKt.to((Object)it3, (Object)Preset.toCMakeProfile$default(it3, null, 1, null));
                    if (!profileNames.contains(((CMakeSettings.Profile)presetToProfile.getSecond()).getName())) {
                        pair = presetToProfile;
                        break block18;
                    }
                    Project project = this.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    Path path = it3.getFile();
                    Object[] objectArray = new Object[]{it3.getName()};
                    String string = CMakeBundle.message("preset.cannot.be.imported.cmake.profile.same.name", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    problems.add(new PresetProblem(project, path, string, (Preset)it3));
                }
                catch (InvalidPresetException e) {
                    Project project = this.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    problems.add(e.asProblem(project));
                }
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List profilesFromPresets = (List)destination$iv$iv2;
        if (!((Collection)problems).isEmpty()) {
            void $this$mapNotNullTo$iv$iv2;
            void $this$mapNotNull$iv2;
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            String string = CMakeBundle.message("notification.title.failed.to.load.cmake.presets", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Object[] $i$f$mapNotNull2 = new Object[2];
            $i$f$mapNotNull2[0] = problems.size();
            $this$mapNotNullTo$iv$iv = problems;
            int n = 1;
            Object[] objectArray = $i$f$mapNotNull2;
            String string2 = "notification.preset.cannot.be.loaded";
            String string3 = string;
            collection = project;
            boolean $i$f$mapNotNull3 = false;
            void $i$f$mapNotNullTo2 = $this$mapNotNull$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo3 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv$iv$iv2.iterator();
            while (iterator.hasNext()) {
                Preset<?> it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                PresetProblem it4 = (PresetProblem)element$iv$iv;
                boolean bl3 = false;
                if (it4.getPreset() == null) continue;
                boolean bl4 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            List list2 = (List)destination$iv$iv3;
            objectArray[n] = CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)", ", null, null, (int)0, null, LoadPresetsAndShowPopupTask::run$lambda$7, (int)30, null);
            String string4 = CMakeBundle.message(string2, $i$f$mapNotNull2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            Project project4 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
            NotificationsKt.showPresetNotification((Project)collection, string3, string4, NotificationType.WARNING, CollectionsKt.listOf((Object)NotificationsKt.getShowProblemsAction(project4)));
        }
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        $this$service$iv2 = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<PresetProblemReportingService> serviceClass$iv = PresetProblemReportingService.class;
        Object object = $this$service$iv2.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv2, serviceClass$iv);
        }
        ((PresetProblemReportingService)object).setProblems(problems);
        ActionsKt.invokeLater$default(null, () -> LoadPresetsAndShowPopupTask.run$lambda$8(profilesFromPresets, this, problems), (int)1, null);
    }

    private final void showErrorNotification(Project project, @NlsContexts.NotificationContent String message, boolean addShowProblemsAction) {
        String string = CMakeBundle.message("notification.title.failed.to.load.cmake.presets", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        NotificationsKt.showPresetNotification(project, string, message, NotificationType.ERROR, addShowProblemsAction ? CollectionsKt.listOf((Object)NotificationsKt.getShowProblemsAction(project)) : CollectionsKt.emptyList());
    }

    static /* synthetic */ void showErrorNotification$default(LoadPresetsAndShowPopupTask loadPresetsAndShowPopupTask, Project project, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        loadPresetsAndShowPopupTask.showErrorNotification(project, string, bl);
    }

    private static final Unit run$lambda$0() {
        FileDocumentManager.getInstance().saveAllDocuments();
        return Unit.INSTANCE;
    }

    private static final List run$lambda$1(LoadPresetsAndShowPopupTask this$0) {
        return this$0.workspace.getSettings().getProfiles();
    }

    private static final CharSequence run$lambda$7(Preset it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = StringUtil.wrapWithDoubleQuote((String)it.getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wrapWithDoubleQuote(...)");
        return string;
    }

    private static final Unit run$lambda$8(List $profilesFromPresets, LoadPresetsAndShowPopupTask this$0, List $problems) {
        ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new PresetsListPopupStep($profilesFromPresets, (Function1<? super List<Pair<BuildPreset, CMakeSettings.Profile>>, Unit>)((Function1)arg_0 -> LoadPresetsAndShowPopupTask.run$lambda$8$0(this$0, $problems, arg_0))));
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createListPopup(...)");
        ListPopup popup = listPopup;
        popup.showCenteredInCurrentWindow(this$0.getProject());
        return Unit.INSTANCE;
    }

    private static final Unit run$lambda$8$0(LoadPresetsAndShowPopupTask this$0, List $problems, List selectedProfiles) {
        Intrinsics.checkNotNullParameter((Object)selectedProfiles, (String)"selectedProfiles");
        ActionsKt.runWriteAction(() -> LoadPresetsAndShowPopupTask.run$lambda$8$0$0(this$0, selectedProfiles, $problems));
        Project project = this$0.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<PresetProblemReportingService> serviceClass$iv = PresetProblemReportingService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((PresetProblemReportingService)object).setProblems($problems);
        Project project2 = this$0.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        String string = CMakeBundle.message("notification.title.cmake.presets", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Object[] objectArray = new Object[]{selectedProfiles.size()};
        String string2 = CMakeBundle.message("notification.loaded.n.presets", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        NotificationsKt.showPresetNotification$default(project2, string, string2, NotificationType.INFORMATION, null, 16, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit run$lambda$8$0$0(LoadPresetsAndShowPopupTask this$0, List $selectedProfiles, List $problems) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Object element$iv2;
        Object element$iv$iv;
        Iterator $this$filterTo$iv$iv;
        Object object;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv3;
        void $this$map$iv;
        CMakeSettings.Profile it;
        void $this$filterNotTo$iv$iv2;
        Iterable $this$filterNot$iv2 = this$0.workspace.getSettings().getProfiles();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv2;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv2 : $this$filterNotTo$iv$iv2) {
            it = (CMakeSettings.Profile)element$iv$iv2;
            boolean bl = false;
            if (it.getFromPreset()) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        $this$filterNot$iv2 = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv2 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
            it = (CMakeSettings.Profile)item$iv$iv2;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.getName());
        }
        List currentProfileNames = (List)destination$iv$iv;
        Iterable $this$filter$iv = $selectedProfiles;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        item$iv$iv2 = $this$filterTo$iv$iv.iterator();
        while (item$iv$iv2.hasNext()) {
            element$iv$iv = item$iv$iv2.next();
            Pair it2 = (Pair)element$iv$iv;
            boolean bl = false;
            if (!currentProfileNames.contains(((CMakeSettings.Profile)it2.getSecond()).getName())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List conflicts = (List)destination$iv$iv2;
        Iterable $this$forEach$iv = conflicts;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            Pair it3 = (Pair)element$iv2;
            boolean bl = false;
            Project project = this$0.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Path path = ((BuildPreset)it3.getFirst()).getFile();
            element$iv$iv = new Object[]{((CMakeSettings.Profile)it3.getSecond()).getName()};
            String string = CMakeBundle.message("preset.cannot.be.imported.cmake.profile.same.name", (Object[])element$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            $problems.add(new PresetProblem(project, path, string, (Preset)it3.getFirst()));
        }
        Iterable $this$map$iv2 = CollectionsKt.minus((Iterable)$selectedProfiles, (Iterable)conflicts);
        boolean $i$f$map2 = false;
        element$iv2 = $this$map$iv2;
        Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv2) {
            void it4;
            Pair bl = (Pair)item$iv$iv3;
            object = destination$iv$iv3;
            boolean bl2 = false;
            object.add((CMakeSettings.Profile)it4.getSecond());
        }
        List profilesToLoad = (List)destination$iv$iv3;
        Iterable $this$map$iv3 = profilesToLoad;
        boolean $i$f$map3 = false;
        destination$iv$iv3 = $this$map$iv3;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv4 : $this$mapTo$iv$iv) {
            void it5;
            CMakeSettings.Profile bl2 = (CMakeSettings.Profile)item$iv$iv4;
            object = destination$iv$iv4;
            boolean bl = false;
            object.add(it5.getName());
        }
        List profilesToLoadNames = (List)destination$iv$iv4;
        $this$map$iv3 = this$0.workspace.getSettings().getProfiles();
        object = this$0.workspace.getSettings();
        boolean $i$f$filterNot2 = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterNotTo2 = false;
        for (Object element$iv$iv3 : $this$filterNotTo$iv$iv) {
            CMakeSettings.Profile it6 = (CMakeSettings.Profile)element$iv$iv3;
            boolean bl = false;
            if (profilesToLoadNames.contains(it6.getName())) continue;
            destination$iv$iv4.add(element$iv$iv3);
        }
        ((CMakeSettings)object).setProfiles(CollectionsKt.plus((Collection)((List)destination$iv$iv4), (Iterable)profilesToLoad));
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LoadPresetsAndShowPopupTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/presets/LoadPresetsAndShowPopupTask$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.cmake"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001BG\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0006\u0012$\u0010\u0007\u001a \u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0006\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ0\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001c\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0016R/\u0010\u0007\u001a \u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0006\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/presets/LoadPresetsAndShowPopupTask$PresetsListPopupStep;", "Lcom/intellij/openapi/ui/popup/MultiSelectionListPopupStep;", "Lkotlin/Pair;", "Lcom/jetbrains/cidr/cpp/cmake/presets/BuildPreset;", "Lcom/jetbrains/cidr/cpp/cmake/CMakeSettings$Profile;", "profiles", "", "block", "Lkotlin/Function1;", "", "<init>", "(Ljava/util/List;Lkotlin/jvm/functions/Function1;)V", "getBlock", "()Lkotlin/jvm/functions/Function1;", "onChosen", "Lcom/intellij/openapi/ui/popup/PopupStep;", "selectedValues", "finalChoice", "", "getTextFor", "", "value", "intellij.cmake"})
    private static final class PresetsListPopupStep
    extends MultiSelectionListPopupStep<Pair<? extends BuildPreset, ? extends CMakeSettings.Profile>> {
        @NotNull
        private final Function1<List<Pair<BuildPreset, CMakeSettings.Profile>>, Unit> block;

        public PresetsListPopupStep(@NotNull List<Pair<BuildPreset, CMakeSettings.Profile>> profiles, @NotNull Function1<? super List<Pair<BuildPreset, CMakeSettings.Profile>>, Unit> block) {
            Intrinsics.checkNotNullParameter(profiles, (String)"profiles");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            super(CMakeBundle.message("popup.title.select.presets", new Object[0]), profiles);
            this.block = block;
        }

        @NotNull
        public final Function1<List<Pair<BuildPreset, CMakeSettings.Profile>>, Unit> getBlock() {
            return this.block;
        }

        @Nullable
        public PopupStep<?> onChosen(@NotNull List<Pair<BuildPreset, CMakeSettings.Profile>> selectedValues, boolean finalChoice) {
            Intrinsics.checkNotNullParameter(selectedValues, (String)"selectedValues");
            if (finalChoice) {
                this.block.invoke(selectedValues);
            }
            return MultiSelectionListPopupStep.FINAL_CHOICE;
        }

        @NotNull
        public String getTextFor(@NotNull Pair<BuildPreset, CMakeSettings.Profile> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return ((CMakeSettings.Profile)value.getSecond()).getName();
        }
    }
}

