/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.cpp.cmake.CMakeException;
import com.jetbrains.cidr.cpp.cmake.model.CMakeCacheFileParser;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorType;
import com.jetbrains.cidr.cpp.cmake.model.CMakeVariable;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeCacheFile {
    @NonNls
    public static final String DEFAULT_PROJECT_NAME = "Project";
    @NlsSafe
    public static final String CONFIGURATION_TYPES = "CMAKE_CONFIGURATION_TYPES";
    @NlsSafe
    public static final String CUDA_HOST_COMPILER = "CMAKE_CUDA_HOST_COMPILER";
    private final Map<@NlsSafe String, CMakeVariable> myVariables;

    public CMakeCacheFile(@NotNull File cmakeCacheFile, @NotNull String encoding) throws CMakeException {
        if (cmakeCacheFile == null) {
            CMakeCacheFile.$$$reportNull$$$0(0);
        }
        if (encoding == null) {
            CMakeCacheFile.$$$reportNull$$$0(1);
        }
        this(new CMakeCacheFileParser().parseUnique(cmakeCacheFile, encoding));
    }

    public CMakeCacheFile(@NotNull Path cmakeCacheFile, @NotNull String encoding) throws CMakeException {
        if (cmakeCacheFile == null) {
            CMakeCacheFile.$$$reportNull$$$0(2);
        }
        if (encoding == null) {
            CMakeCacheFile.$$$reportNull$$$0(3);
        }
        this(new CMakeCacheFileParser().parseUnique(cmakeCacheFile, encoding));
    }

    CMakeCacheFile(@NotNull Map<String, CMakeVariable> variables) {
        if (variables == null) {
            CMakeCacheFile.$$$reportNull$$$0(4);
        }
        this.myVariables = Collections.unmodifiableMap(variables);
    }

    @NotNull
    public Collection<CMakeVariable> getVariables() {
        Collection<CMakeVariable> collection = this.myVariables.values();
        if (collection == null) {
            CMakeCacheFile.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @Nullable
    public CMakeVariable getVariable(@NotNull String key) {
        if (key == null) {
            CMakeCacheFile.$$$reportNull$$$0(6);
        }
        return this.myVariables.get(key);
    }

    @Nullable
    public String getVariableValue(@NlsSafe @NotNull String name) {
        CMakeVariable var;
        if (name == null) {
            CMakeCacheFile.$$$reportNull$$$0(7);
        }
        return (var = this.getVariable(name)) == null ? null : var.getValue();
    }

    @Nullable
    public List<String> getVariableListValue(@NotNull String name) {
        String value;
        if (name == null) {
            CMakeCacheFile.$$$reportNull$$$0(8);
        }
        return (value = this.getVariableValue(name)) == null ? null : CMakeCacheFileParser.parseListValue(value);
    }

    @NotNull
    public CMakeGeneratorType getGeneratorType() {
        CMakeGeneratorType cMakeGeneratorType = CMakeGeneratorType.fromGeneratorSpec(this.getVariableValue("CMAKE_GENERATOR"));
        if (cMakeGeneratorType == null) {
            CMakeCacheFile.$$$reportNull$$$0(9);
        }
        return cMakeGeneratorType;
    }

    @Nullable
    public String getProjectName() {
        return this.getVariableValue("CMAKE_PROJECT_NAME");
    }

    @NotNull
    public String getProjectNameValueOrDefault() {
        String result2 = this.getProjectName();
        String string = StringUtil.isEmptyOrSpaces((String)result2) ? DEFAULT_PROJECT_NAME : result2;
        if (string == null) {
            CMakeCacheFile.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    public List<String> getConfigurationTypesValue() {
        return this.getVariableListValue(CONFIGURATION_TYPES);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmakeCacheFile";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeCacheFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeCacheFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariables";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratorType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectNameValueOrDefault";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getVariable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getVariableValue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getVariableListValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 9, 10 -> new IllegalStateException(string);
        };
    }
}

