/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FileCollectionFactory;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.cpp.CMakeBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.model.CMakeApiProfileGenerationResult;
import com.jetbrains.cidr.cpp.cmake.model.CMakeCompiler;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfigurationSettings;
import com.jetbrains.cidr.cpp.cmake.model.CMakeFileSettings;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorCommonInfo;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorType;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorUtils;
import com.jetbrains.cidr.cpp.cmake.model.CMakeProfileGenerationResult;
import com.jetbrains.cidr.cpp.cmake.model.CMakeProfileTargetInfo;
import com.jetbrains.cidr.cpp.cmake.model.CMakeVariable;
import com.jetbrains.cidr.cpp.cmake.model.api.CMakeApiException;
import com.jetbrains.cidr.cpp.cmake.model.api.CMakeApiFailLogger;
import com.jetbrains.cidr.cpp.cmake.model.api.CMakeApiJsonUtils;
import com.jetbrains.cidr.cpp.cmake.model.api.model.CacheV2;
import com.jetbrains.cidr.cpp.cmake.model.api.model.FileSet;
import com.jetbrains.cidr.cpp.cmake.model.api.model.FileV1;
import com.jetbrains.cidr.cpp.cmake.model.api.model.FilesV1;
import com.jetbrains.cidr.cpp.toolchains.CPPCompilerSwitchesUtil;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSpecificSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.NVCCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CMakeApiTargetReader {
    private static final Logger LOG = Logger.getInstance(CMakeApiTargetReader.class);
    @NotNull
    private final Context myContext;
    @NotNull
    private final CMakeApiProfileGenerationResult myResult;
    @NotNull
    private final CMakeApiFailLogger myLogger;
    private static final Regex EVAL_FILE_EXTENSION = new Regex(":[0-9]+:EVAL$");
    private static final int MAX_DEPTH = 100;

    CMakeApiTargetReader(Context context) {
        this.myContext = context;
        this.myResult = context.result;
        this.myLogger = context.logger;
    }

    @NotNull
    private static @NotNull List<@NotNull CMakeGeneratorUtils.CudaTargetInfo> getCudaInfoForCurrentTarget(@NotNull JsonObject target, @NotNull CPPEnvironment environment, @NotNull File topLevelSourceDir, @NotNull Map<File, CMakeGeneratorUtils.CudaTargetInfo> cudaInfo) {
        if (target == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(1);
        }
        if (topLevelSourceDir == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(2);
        }
        if (cudaInfo == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(3);
        }
        ArrayList<CMakeGeneratorUtils.CudaTargetInfo> targetInfo = new ArrayList<CMakeGeneratorUtils.CudaTargetInfo>();
        JsonArray sourcesArray = target.getAsJsonArray("sources");
        if (sourcesArray == null || sourcesArray.isEmpty()) {
            ArrayList<CMakeGeneratorUtils.CudaTargetInfo> arrayList = targetInfo;
            if (arrayList == null) {
                CMakeApiTargetReader.$$$reportNull$$$0(4);
            }
            return arrayList;
        }
        for (JsonElement sourceElem : sourcesArray) {
            String sourcePath;
            File sourceFileDir;
            CMakeGeneratorUtils.CudaTargetInfo info;
            JsonElement pathElm;
            JsonObject currentTargetObj = sourceElem.getAsJsonObject();
            if (currentTargetObj == null || (pathElm = currentTargetObj.get("path")) == null || (info = cudaInfo.get(sourceFileDir = CMakeGeneratorUtils.toLocalFile(environment, topLevelSourceDir, sourcePath = pathElm.getAsString()).getParentFile())) == null) continue;
            targetInfo.add(info);
        }
        ArrayList<CMakeGeneratorUtils.CudaTargetInfo> arrayList = targetInfo;
        if (arrayList == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private Collection<String> findTargetCMakePath(@NotNull JsonObject target) throws CMakeApiException {
        JsonElement traceElm;
        if (target == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(6);
        }
        int traceNum = (traceElm = target.get("backtrace")) == null ? 0 : traceElm.getAsInt();
        JsonObject traceGraph = CMakeApiJsonUtils.getJsonObject(target, "backtraceGraph", this.myLogger);
        JsonArray traceNodes = CMakeApiJsonUtils.getJsonArray(traceGraph, "nodes", this.myLogger);
        if (traceNodes.isEmpty()) {
            this.myLogger.fail(CMakeBundle.message("cmake.api.no.backtrace", new Object[0]));
            List<String> list2 = Collections.singletonList("");
            if (list2 == null) {
                CMakeApiTargetReader.$$$reportNull$$$0(7);
            }
            return list2;
        }
        ArrayList<Pair> result2 = new ArrayList<Pair>();
        JsonObject traceNode = traceNodes.get(traceNum).getAsJsonObject();
        int depth = 0;
        while (true) {
            JsonElement parentNum;
            if (traceNode == null || traceNode.get("file") == null) {
                this.myLogger.fail(CMakeBundle.message("cmake.api.cant.find.the.trace.node", new Object[0]));
                break;
            }
            int fileIdx = traceNode.get("file").getAsInt();
            String path = CMakeApiJsonUtils.getJsonArray(traceGraph, "files", this.myLogger).get(fileIdx).getAsString();
            path = EVAL_FILE_EXTENSION.replace((CharSequence)path, "");
            FileV1 fileV1 = this.myContext.cmakeFiles.getInputs().get(path);
            if (!(fileV1 != null && fileV1.isCMake() || traceNode.get("line") == null)) {
                result2.add(Pair.create((Object)path, (Object)traceNode.get("line").getAsInt()));
            }
            if ((parentNum = traceNode.get("parent")) == null) break;
            traceNode = traceNodes.get(parentNum.getAsInt()).getAsJsonObject();
            if (depth >= 100) {
                this.myLogger.fail(CMakeBundle.message("cmake.api.backtrace.limit.reached", 100));
                result2.add(Pair.create((Object)"", null));
                break;
            }
            ++depth;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("CMake path for target " + CMakeApiProfileGenerationResult.getName(target) + "\n" + result2.stream().map(pair -> (String)pair.getFirst() + ":" + String.valueOf(pair.getSecond())).collect(Collectors.joining("\n")));
        }
        if (result2.isEmpty()) {
            result2.add(Pair.create((Object)"", null));
        }
        Collection collection = result2.stream().map(pair -> (String)pair.getFirst()).collect(Collectors.toSet());
        if (collection == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(8);
        }
        return collection;
    }

    CMakeProfileTargetInfo loadTargetInfo(@NotNull JsonObject target) throws CMakeApiException {
        if (target == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(9);
        }
        String buildType = this.myContext.buildType;
        CMakeConfiguration.Generator generator = this.myContext.generator;
        File topLevelSourceDir = this.myContext.topLevelSourceDir;
        File topLevelBuildDir = this.myContext.topLevelBuildDir;
        CacheV2 cmakeCache = this.myContext.cmakeCache;
        Map<OCLanguageKind, CMakeApiProfileGenerationResult.CompilerInfo> compilers = this.myContext.compilers;
        CMakeGeneratorCommonInfo commonInfo = this.myContext.commonInfo;
        Map<File, CMakeGeneratorUtils.CudaTargetInfo> cudaInfo = this.myContext.cudaInfo;
        Map<String, CPPEnvironment.ExecutablePathResult> resolvedExecutableCache = this.myContext.resolvedExecutableCache;
        CPPEnvironment environment = this.myContext.environment;
        CidrCompilerSwitches.Format flagsFormat = CPPCompilerSwitchesUtil.getFlagsFormat((CPPEnvironment)environment);
        String targetName = CMakeApiProfileGenerationResult.getName(target);
        String targetType = target.get("type").getAsString();
        Collection<String> filePaths = this.findTargetCMakePath(target);
        if (filePaths.isEmpty()) {
            throw new IllegalStateException("findTargetCMakePath can't return empty list");
        }
        File lastFile = null;
        for (String path : filePaths) {
            if (path.isBlank()) {
                path = "CMakeLists.txt";
            }
            if (!(lastFile = CMakeGeneratorUtils.toLocalFile(environment, topLevelSourceDir, path)).exists()) {
                CPPLog.LOG.warn("No CMakeLists.txt file at: " + lastFile.getPath());
            }
            commonInfo.addDependencyFile(lastFile);
        }
        String relativeBuildDir = CMakeApiJsonUtils.getJsonObject(target, "paths", this.myLogger).get("build").getAsString();
        File buildDir = CMakeGeneratorUtils.toLocalFile(environment, topLevelBuildDir, relativeBuildDir);
        if (!buildDir.exists()) {
            this.myLogger.fail(CMakeBundle.message("cmake.api.no.build.dir.at", buildDir.getPath()));
        }
        HashMap<OCLanguageKind, CMakeConfigurationSettings> commonLangSettings = new HashMap<OCLanguageKind, CMakeConfigurationSettings>();
        List<CompileGroup> compileGroups = this.readCompileGroups(target, compilers, flagsFormat, commonLangSettings, buildDir, generator, cmakeCache, resolvedExecutableCache);
        List<FileSet> fileSets = CMakeApiTargetReader.readFileSets(target);
        Map sourceMap = FileCollectionFactory.createCanonicalFileMap();
        List<CMakeGeneratorUtils.CudaTargetInfo> cudaTargetInfo = CMakeApiTargetReader.getCudaInfoForCurrentTarget(target, environment, topLevelSourceDir, cudaInfo);
        for (CMakeGeneratorUtils.CudaTargetInfo targetInfo : cudaTargetInfo) {
            this.myResult.addCudaCmakeTargets(targetInfo, commonLangSettings, sourceMap);
        }
        HashMap<OCLanguageKind, OCLanguageKind> predef2GenKinds = new HashMap<OCLanguageKind, OCLanguageKind>();
        List sources = CMakeApiJsonUtils.getJsonArray(target, "sources", this.myLogger).asList();
        List<Integer> sourceGroupToCompileGroupIndex = CMakeApiTargetReader.buildSourceGroupToCompileGroupIndex(target, sources);
        for (JsonElement srcElm : sources) {
            int index;
            CompileGroup group;
            JsonObject src = srcElm.getAsJsonObject();
            if (AdvancedSettings.getBoolean((String)"cmake.exclude.generated.project.files") && CMakeApiProfileGenerationResult.getBool(src, "isGenerated")) continue;
            String path = src.get("path").getAsString();
            File srcFile = CMakeGeneratorUtils.toLocalFile(environment, topLevelSourceDir, path);
            commonInfo.addSourceFile(srcFile);
            JsonElement cgElm = src.get("compileGroupIndex");
            int cgIdx = CMakeApiTargetReader.getCompileGroupIndex(cgElm, src, sources, sourceGroupToCompileGroupIndex);
            if (cgIdx < 0 || compileGroups.size() <= cgIdx || (group = compileGroups.get(cgIdx)) == null) continue;
            boolean isModule = false;
            JsonElement fileSetIndex = src.get("fileSetIndex");
            if (fileSetIndex != null && fileSets.get(index = fileSetIndex.getAsInt()).getType() == FileSet.FileSetType.CXX_MODULES) {
                isModule = true;
            }
            OCLanguageKind effectiveLangKind = CMakeProfileGenerationResult.getEffectiveLanguageKind(srcFile.getName(), group.languageKind, predef2GenKinds);
            CMakeFileSettings settings = new CMakeFileSettings(effectiveLangKind, null, group.leadFlags, group.flags, group.defines, isModule);
            sourceMap.put(srcFile, settings);
        }
        CMakeProfileTargetInfo info = new CMakeProfileTargetInfo(environment, lastFile, this.myResult.parameters.getGenerationDir(), buildDir, targetName, CMakeConfiguration.TargetType.fromString(targetType), generator, buildType, buildDir);
        info.productFile = this.readTargetProductFile(target, topLevelBuildDir, environment, info.targetName);
        if (info.productFile == null && info.targetType != CMakeConfiguration.TargetType.UTILITY) {
            this.myResult.reportNoProductFile(info);
        }
        CMakeProfileGenerationResult.adjustLanguageSettingsMap(commonLangSettings, predef2GenKinds);
        info.perLanguageSettings = commonLangSettings;
        info.linkerFlags = CMakeApiTargetReader.readTargetLinkerFlags(target, flagsFormat);
        info.sources = sourceMap;
        if (AdvancedSettings.getBoolean((String)"cmake.group.targets.by.folder.property")) {
            info.folder = CMakeApiTargetReader.readFolder(target);
        }
        return info;
    }

    @Nullable
    private static String readFolder(@NotNull JsonObject target) throws CMakeApiException {
        JsonObject folderObject;
        if (target == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(10);
        }
        if ((folderObject = CMakeApiJsonUtils.getOptionalJsonObject(target, "folder")) == null) {
            return null;
        }
        return folderObject.get("name").getAsString();
    }

    private static int getCompileGroupIndex(@Nullable JsonElement cgElm, @NotNull JsonObject src, @NotNull List<JsonElement> sources, @NotNull List<Integer> sourceGroupToCompileGroupIndex) {
        int sourceGroupIndex;
        String pathAttribute;
        if (src == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(11);
        }
        if (sources == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(12);
        }
        if (sourceGroupToCompileGroupIndex == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(13);
        }
        if (cgElm != null) {
            return cgElm.getAsInt();
        }
        if (Registry.is((String)"cmake.find.matching.compile.group.if.not.set") && OCFileTypeHelpers.isKnownFileType((String)(pathAttribute = src.get("path").getAsString())) && (sourceGroupIndex = src.get("sourceGroupIndex").getAsInt()) < sources.size()) {
            return sourceGroupToCompileGroupIndex.get(sourceGroupIndex);
        }
        return -1;
    }

    private static List<Integer> buildSourceGroupToCompileGroupIndex(@NotNull JsonObject target, @NotNull List<JsonElement> sources) {
        JsonElement srcGrsElm;
        if (target == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(14);
        }
        if (sources == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(15);
        }
        if ((srcGrsElm = target.get("sourceGroups")) == null) {
            return Collections.emptyList();
        }
        JsonArray sourceGroupsArray = srcGrsElm.getAsJsonArray();
        ArrayList<Integer> result2 = new ArrayList<Integer>(Collections.nCopies(sourceGroupsArray.size(), -1));
        for (int i = 0; i < sourceGroupsArray.size(); ++i) {
            JsonObject sourceGroup = sourceGroupsArray.get(i).getAsJsonObject();
            Set indexes = ContainerUtil.map2Set((Collection)sourceGroup.get("sourceIndexes").getAsJsonArray().asList(), JsonElement::getAsInt);
            for (Integer source : indexes) {
                JsonElement cgElmLookup = sources.get(source).getAsJsonObject().get("compileGroupIndex");
                if (cgElmLookup == null) continue;
                result2.set(i, cgElmLookup.getAsInt());
            }
        }
        return result2;
    }

    private static List<FileSet> readFileSets(JsonObject target) {
        ArrayList<FileSet> fileSets = new ArrayList<FileSet>();
        JsonElement fileSetsElement = target.get("fileSets");
        if (fileSetsElement == null) {
            return fileSets;
        }
        for (JsonElement fileSetElm : fileSetsElement.getAsJsonArray()) {
            FileSet.FileSetType fileSetType;
            JsonObject fileSet = fileSetElm.getAsJsonObject();
            String type = fileSet.get("type").getAsString();
            try {
                fileSetType = FileSet.FileSetType.valueOf(type);
            }
            catch (IllegalArgumentException ex) {
                CPPLog.LOG.debug("Unknown file set type: " + type);
                fileSetType = FileSet.FileSetType.UNKNOWN;
            }
            fileSets.add(new FileSet(fileSetType));
        }
        return fileSets;
    }

    @NotNull
    private List<CompileGroup> readCompileGroups(@NotNull JsonObject target, @NotNull Map<OCLanguageKind, CMakeApiProfileGenerationResult.CompilerInfo> compilers, @NotNull CidrCompilerSwitches.Format flagsFormat, @NotNull Map<OCLanguageKind, CMakeConfigurationSettings> settingsMap, @NotNull File buildWorkingDir, @NotNull CMakeConfiguration.Generator generator, @NotNull CacheV2 cmakeCache, @NotNull Map<String, CPPEnvironment.ExecutablePathResult> resolvedExecutableCache) throws CMakeApiException {
        CMakeApiProfileGenerationResult.CompilerInfo compilerInfo;
        OCLanguageKind kind;
        if (target == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(16);
        }
        if (compilers == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(17);
        }
        if (flagsFormat == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(18);
        }
        if (settingsMap == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(19);
        }
        if (buildWorkingDir == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(20);
        }
        if (generator == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(21);
        }
        if (cmakeCache == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(22);
        }
        if (resolvedExecutableCache == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(23);
        }
        ArrayList<CompileGroup> compileGroups = new ArrayList<CompileGroup>();
        JsonElement cgsElm = target.get("compileGroups");
        if (cgsElm == null) {
            ArrayList<CompileGroup> arrayList = compileGroups;
            if (arrayList == null) {
                CMakeApiTargetReader.$$$reportNull$$$0(24);
            }
            return arrayList;
        }
        for (JsonElement cgElm : cgsElm.getAsJsonArray()) {
            JsonObject compileGroup = cgElm.getAsJsonObject();
            String string = compileGroup.get("language").getAsString();
            kind = CMakeProfileGenerationResult.toLanguageKind(string);
            if (kind == null) {
                compileGroups.add(null);
                continue;
            }
            compilerInfo = this.getCompilerInfo(compilers, kind);
            OCCompilerKind compilerKind = compilerInfo.compiler.getCompilerKind();
            ArrayList<String> flagFragments = CMakeApiTargetReader.getFlagFragments(flagsFormat, generator, string, compileGroup, compilerInfo, compilerKind, cmakeCache, this.myContext.environment.getHostMachine().getOS() == OS.macOS);
            ArrayList<String> defineFragments = new ArrayList<String>();
            JsonElement definesElm = compileGroup.get("defines");
            if (definesElm != null) {
                for (Object defElm : definesElm.getAsJsonArray()) {
                    String define = defElm.getAsJsonObject().get("define").getAsString();
                    defineFragments.add(define);
                }
            }
            compileGroups.add(new CompileGroup(kind, compilerKind, Collections.emptyList(), flagFragments, defineFragments));
        }
        HashMap<OCLanguageKind, List<String>> langToCommonFlags = new HashMap<OCLanguageKind, List<String>>();
        HashMap<OCLanguageKind, List<String>> langToCommonDefines = new HashMap<OCLanguageKind, List<String>>();
        for (CompileGroup compileGroup : compileGroups) {
            if (compileGroup == null) continue;
            kind = compileGroup.languageKind;
            CMakeApiTargetReader.updateCommon(langToCommonFlags, kind, compileGroup.flagFragments);
            CMakeApiTargetReader.updateCommon(langToCommonDefines, kind, compileGroup.defineFragments);
        }
        for (CompileGroup compileGroup : compileGroups) {
            if (compileGroup == null) continue;
            kind = compileGroup.languageKind;
            compilerInfo = this.getCompilerInfo(compilers, kind);
            CMakeApiTargetReader.processUnique(langToCommonFlags, kind, compileGroup.flagFragments, frag -> group.flags.addAll(CMakeApiTargetReader.readCompilerFlags(frag, flagsFormat, compilerInfo.compiler)));
            CompilerSpecificSwitchBuilder defFlagBuilder = CMakeApiTargetReader.createSwitchBuilder(compileGroup.compilerKind);
            CMakeApiTargetReader.processUnique(langToCommonDefines, kind, compileGroup.defineFragments, frag -> defFlagBuilder.withMacro(frag));
            List groupDefines = defFlagBuilder.buildRaw();
            compileGroup.defines.addAll(groupDefines);
        }
        for (Map.Entry entry : langToCommonFlags.entrySet()) {
            boolean hasCCBinFlag;
            kind = (OCLanguageKind)entry.getKey();
            compilerInfo = this.getCompilerInfo(compilers, kind);
            List commonFlagFrags = (List)entry.getValue();
            ArrayList<@NlsSafe String> commonFlags = new ArrayList<String>();
            for (String frag2 : commonFlagFrags) {
                commonFlags.addAll(CMakeApiTargetReader.readCompilerFlags(frag2, flagsFormat, compilerInfo.compiler));
            }
            boolean bl = hasCCBinFlag = NVCCCompiler.getCCBinOption(commonFlags) != null;
            if (kind.isCuda() && !hasCCBinFlag && !StringUtil.isEmptyOrSpaces((String)this.myResult.getCudaHostCompiler())) {
                commonFlags.add(NVCCCompiler.getHostCompilerFlag((String)this.myResult.getCudaHostCompiler()));
            }
            CompilerSpecificSwitchBuilder defineBuilder = CMakeApiTargetReader.createSwitchBuilder(this.getCompilerInfo(compilers, (OCLanguageKind)kind).compiler.getCompilerKind());
            List commonDefineFrags = (List)langToCommonDefines.get(kind);
            for (String define : commonDefineFrags) {
                defineBuilder.withMacro(define);
            }
            List commonDefines = defineBuilder.buildRaw();
            Pair<String, String> result2 = CMakeProfileGenerationResult.resolveToExecutableOrGetFromCache(compilerInfo.path, buildWorkingDir, this.myResult.parameters.getEnvironment(), resolvedExecutableCache);
            String errorMessage = (String)result2.first;
            if (errorMessage != null) {
                List list2 = (List)this.myLogger.fail(errorMessage);
                if (list2 == null) {
                    CMakeApiTargetReader.$$$reportNull$$$0(25);
                }
                return list2;
            }
            String effectiveCompilerPath = (String)result2.second;
            settingsMap.put(kind, new CMakeConfigurationSettings(compilerInfo.compiler, new File(effectiveCompilerPath), commonFlags, commonDefines));
        }
        ArrayList<CompileGroup> arrayList = compileGroups;
        if (arrayList == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    @NotNull
    private static ArrayList<String> getFlagFragments(@NotNull CidrCompilerSwitches.Format flagsFormat, @NotNull CMakeConfiguration.Generator generatorConfiguration, @NotNull String langID, @NotNull JsonObject compileGroup, @NotNull CMakeApiProfileGenerationResult.CompilerInfo compilerInfo, @NotNull OCCompilerKind compilerKind, @NotNull CacheV2 cmakeCache, boolean isMacOS) {
        JsonElement frameworksElm;
        String searchPath;
        boolean isSystem;
        JsonElement includesElm;
        CMakeVariable osxSysrootVariable;
        if (flagsFormat == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(27);
        }
        if (generatorConfiguration == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(28);
        }
        if (langID == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(29);
        }
        if (compileGroup == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(30);
        }
        if (compilerInfo == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(31);
        }
        if (compilerKind == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(32);
        }
        if (cmakeCache == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(33);
        }
        CompilerSpecificSwitchBuilder sysrootFlagBuilder = CMakeApiTargetReader.createSwitchBuilder(compilerKind);
        JsonObject sysrootObj = compileGroup.getAsJsonObject("sysroot");
        if (sysrootObj != null) {
            String sysroot = sysrootObj.get("path").getAsString();
            sysrootFlagBuilder.withSysroot(sysroot);
        } else if (generatorConfiguration.generatorSpec.getGeneratorType() == CMakeGeneratorType.XCODE.INSTANCE && (osxSysrootVariable = cmakeCache.getVariables().get("CMAKE_OSX_SYSROOT")) != null && osxSysrootVariable.getValue() != null) {
            sysrootFlagBuilder.withSysroot(osxSysrootVariable.getValue());
        }
        CompilerSpecificSwitchBuilder targetFlagBuilder = CMakeApiTargetReader.createSwitchBuilder(compilerKind);
        if (compilerInfo.target != null && !compilerInfo.target.isEmpty()) {
            targetFlagBuilder.withTarget(compilerInfo.target);
        }
        CompilerSpecificSwitchBuilder incFlagBuilder = CMakeApiTargetReader.createSwitchBuilder(compilerKind);
        if (!CMakeGeneratorType.isVS(generatorConfiguration.generatorSpec.getGeneratorType())) {
            incFlagBuilder.withPosixSearchPathFlags();
        }
        if ((includesElm = compileGroup.get("includes")) != null) {
            HashSet<String> addedFrameworkDirs = new HashSet<String>(compilerInfo.implicitFrameworkDirs);
            for (JsonElement incElm : includesElm.getAsJsonArray()) {
                JsonObject include = incElm.getAsJsonObject();
                isSystem = CMakeApiProfileGenerationResult.getBool(include, "isSystem");
                String pathString = include.get("path").getAsString();
                if (isMacOS && pathString.endsWith(".framework")) {
                    Path incFile = Path.of(pathString, new String[0]);
                    if (!Files.isDirectory(incFile, new LinkOption[0]) || !addedFrameworkDirs.add(searchPath = incFile.getParent().toAbsolutePath().toString())) continue;
                    incFlagBuilder = isSystem ? incFlagBuilder.withSystemFrameworkSearchPath(searchPath) : incFlagBuilder.withFrameworkSearchPath(searchPath);
                    continue;
                }
                incFlagBuilder = isSystem ? incFlagBuilder.withSystemIncludePath(pathString) : incFlagBuilder.withIncludePath(pathString);
            }
        }
        if ((frameworksElm = compileGroup.get("frameworks")) != null) {
            for (JsonElement frameworkElm : frameworksElm.getAsJsonArray()) {
                JsonObject framework = frameworkElm.getAsJsonObject();
                isSystem = CMakeApiProfileGenerationResult.getBool(framework, "isSystem");
                String path = framework.get("path").getAsString();
                File frameworkFile = new File(path);
                searchPath = frameworkFile.getParent();
                incFlagBuilder = isSystem ? incFlagBuilder.withSystemFrameworkSearchPath(searchPath) : incFlagBuilder.withFrameworkSearchPath(searchPath);
            }
        }
        ArrayList<String> flagFragments = new ArrayList<String>();
        String argVariableName = "CMAKE_<LANG>_COMPILER_ARG1".replace("<LANG>", langID);
        CMakeVariable argVariable = cmakeCache.getVariables().get(argVariableName);
        if (argVariable != null && argVariable.getValue() != null) {
            flagFragments.add(argVariable.getValue());
        }
        flagFragments.addAll(incFlagBuilder.build().getList(flagsFormat));
        flagFragments.add(sysrootFlagBuilder.build().getCommandLineString(flagsFormat));
        flagFragments.add(targetFlagBuilder.build().getCommandLineString(flagsFormat));
        JsonElement ccfElm = compileGroup.get("compileCommandFragments");
        if (ccfElm != null) {
            JsonArray compileCodeFrags = ccfElm.getAsJsonArray();
            for (JsonElement frag : compileCodeFrags) {
                String fragText = frag.getAsJsonObject().get("fragment").getAsString();
                flagFragments.add(fragText);
            }
        }
        ArrayList<String> arrayList = flagFragments;
        if (arrayList == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    @NotNull
    private static List<String> readCompilerFlags(@NotNull String flagStr, @NotNull CidrCompilerSwitches.Format flagsFormat, @NotNull CMakeCompiler compiler) {
        if (flagStr == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(35);
        }
        if (flagsFormat == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(36);
        }
        if (compiler == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(37);
        }
        List flags = CidrSwitchBuilder.parseArgs((String)flagStr, (CidrCompilerSwitches.Format)flagsFormat);
        ArrayList mutableFlags = new ArrayList(flags);
        List list2 = compiler.getCompilerKind().fixPchSwitches(mutableFlags);
        if (list2 == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(38);
        }
        return list2;
    }

    @NotNull
    private CMakeApiProfileGenerationResult.CompilerInfo getCompilerInfo(@NotNull Map<OCLanguageKind, CMakeApiProfileGenerationResult.CompilerInfo> compilers, @NotNull OCLanguageKind kind) throws CMakeApiException {
        CMakeApiProfileGenerationResult.CompilerInfo compilerInfo;
        if (compilers == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(39);
        }
        if (kind == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(40);
        }
        if ((compilerInfo = compilers.get(kind)) == null) {
            this.myLogger.fail(CMakeBundle.message("cmake.api.no.compiler.found.for", kind));
        }
        CMakeApiProfileGenerationResult.CompilerInfo compilerInfo2 = compilerInfo;
        if (compilerInfo2 == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(41);
        }
        return compilerInfo2;
    }

    @NotNull
    private static CompilerSpecificSwitchBuilder createSwitchBuilder(@NotNull OCCompilerKind compilerKind) {
        if (compilerKind == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(42);
        }
        CompilerSpecificSwitchBuilder compilerSpecificSwitchBuilder = compilerKind.getSwitchBuilder(new CidrSwitchBuilder());
        if (compilerSpecificSwitchBuilder == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(43);
        }
        return compilerSpecificSwitchBuilder;
    }

    private static void processUnique(@NotNull Map<OCLanguageKind, List<String>> commonSettings, @NotNull OCLanguageKind kind, @NotNull List<String> fragments, @NotNull Consumer<String> c) {
        if (commonSettings == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(44);
        }
        if (kind == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(45);
        }
        if (fragments == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(46);
        }
        if (c == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(47);
        }
        List<String> commonFrags = commonSettings.get(kind);
        for (String frag : fragments) {
            if (commonFrags.contains(frag)) continue;
            c.accept(frag);
        }
    }

    private static void updateCommon(Map<OCLanguageKind, List<String>> langToCommonFlags, OCLanguageKind kind, List<String> groupFragments) {
        List<String> commonFlags = langToCommonFlags.get(kind);
        if (commonFlags == null) {
            commonFlags = new ArrayList<String>(groupFragments);
            langToCommonFlags.put(kind, commonFlags);
        } else {
            commonFlags.retainAll(groupFragments);
        }
    }

    @NotNull
    private static List<String> readTargetLinkerFlags(@NotNull JsonObject target, CidrCompilerSwitches.Format flagsFormat) {
        JsonElement linkElm;
        if (target == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(48);
        }
        if ((linkElm = target.get("link")) == null) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                CMakeApiTargetReader.$$$reportNull$$$0(49);
            }
            return list2;
        }
        JsonElement fragmentsElm = linkElm.getAsJsonObject().get("commandFragments");
        if (fragmentsElm == null) {
            List<String> list3 = Collections.emptyList();
            if (list3 == null) {
                CMakeApiTargetReader.$$$reportNull$$$0(50);
            }
            return list3;
        }
        ArrayList<String> allFlags = new ArrayList<String>();
        JsonArray fragments = (JsonArray)fragmentsElm;
        for (JsonElement fragment : fragments) {
            String flagsText = fragment.getAsJsonObject().get("fragment").getAsString();
            List flags = CidrSwitchBuilder.parseArgs((String)flagsText, (CidrCompilerSwitches.Format)flagsFormat);
            allFlags.addAll(flags);
        }
        ArrayList<String> arrayList = allFlags;
        if (arrayList == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(51);
        }
        return arrayList;
    }

    @Nullable
    private File readTargetProductFile(@NotNull JsonObject target, @NotNull File topLevelBuildDir, @NotNull CPPEnvironment environment, @NotNull String targetName) {
        boolean emulateNotFound;
        if (target == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(52);
        }
        if (topLevelBuildDir == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(53);
        }
        if (environment == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(54);
        }
        if (targetName == null) {
            CMakeApiTargetReader.$$$reportNull$$$0(55);
        }
        if (emulateNotFound = this.myResult.myGenerator.shouldEmulateProductNotFoundForTargetAndProfile((Pair<String, String>)Pair.create((Object)targetName, (Object)this.myResult.parameters.getProfileName()))) {
            return null;
        }
        JsonArray artifacts = target.getAsJsonArray("artifacts");
        if (artifacts != null && !artifacts.isEmpty()) {
            String path = artifacts.get(0).getAsJsonObject().get("path").getAsString();
            return CMakeGeneratorUtils.toLocalFile(environment, topLevelBuildDir, path);
        }
        return CMakeGeneratorUtils.toLocalFile(environment, topLevelBuildDir, targetName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 8, 24, 25, 26, 34, 38, 41, 43, 49, 50, 51 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelSourceDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cudaInfo";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 24: 
            case 25: 
            case 26: 
            case 34: 
            case 38: 
            case 41: 
            case 43: 
            case 49: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeApiTargetReader";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceGroupToCompileGroupIndex";
                break;
            }
            case 17: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilers";
                break;
            }
            case 18: 
            case 27: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flagsFormat";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsMap";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildWorkingDir";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 22: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmakeCache";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedExecutableCache";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatorConfiguration";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "langID";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compileGroup";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerInfo";
                break;
            }
            case 32: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerKind";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flagStr";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiler";
                break;
            }
            case 40: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelBuildDir";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeApiTargetReader";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCudaInfoForCurrentTarget";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findTargetCMakePath";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "readCompileGroups";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlagFragments";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "readCompilerFlags";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerInfo";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createSwitchBuilder";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "readTargetLinkerFlags";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCudaInfoForCurrentTarget";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 24: 
            case 25: 
            case 26: 
            case 34: 
            case 38: 
            case 41: 
            case 43: 
            case 49: 
            case 50: 
            case 51: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findTargetCMakePath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadTargetInfo";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readFolder";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCompileGroupIndex";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "buildSourceGroupToCompileGroupIndex";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "readCompileGroups";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getFlagFragments";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "readCompilerFlags";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerInfo";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createSwitchBuilder";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "processUnique";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "readTargetLinkerFlags";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "readTargetProductFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7, 8, 24, 25, 26, 34, 38, 41, 43, 49, 50, 51 -> new IllegalStateException(string);
        };
    }

    record Context(@NotNull CMakeApiProfileGenerationResult result, @NotNull CMakeApiFailLogger logger, @NotNull CPPEnvironment environment, @NotNull String buildType, @NotNull CMakeConfiguration.Generator generator, @NotNull File topLevelSourceDir, @NotNull File topLevelBuildDir, @NotNull CacheV2 cmakeCache, @NotNull FilesV1 cmakeFiles, @NotNull Map<OCLanguageKind, CMakeApiProfileGenerationResult.CompilerInfo> compilers, @NotNull CMakeGeneratorCommonInfo commonInfo, @NotNull Map<File, CMakeGeneratorUtils.CudaTargetInfo> cudaInfo, @NotNull Map<String, CPPEnvironment.ExecutablePathResult> resolvedExecutableCache) {
        @NotNull
        private final CMakeApiProfileGenerationResult result;
        @NotNull
        private final CMakeApiFailLogger logger;
        @NotNull
        private final CPPEnvironment environment;
        @NotNull
        private final String buildType;
        @NotNull
        private final CMakeConfiguration.Generator generator;
        @NotNull
        private final File topLevelSourceDir;
        @NotNull
        private final File topLevelBuildDir;
        @NotNull
        private final CacheV2 cmakeCache;
        @NotNull
        private final FilesV1 cmakeFiles;
        @NotNull
        private final Map<OCLanguageKind, CMakeApiProfileGenerationResult.CompilerInfo> compilers;
        @NotNull
        private final CMakeGeneratorCommonInfo commonInfo;
        @NotNull
        private final Map<File, CMakeGeneratorUtils.CudaTargetInfo> cudaInfo;
        @NotNull
        private final Map<String, CPPEnvironment.ExecutablePathResult> resolvedExecutableCache;

        Context(@NotNull CMakeApiProfileGenerationResult result2, @NotNull CMakeApiFailLogger logger, @NotNull CPPEnvironment environment, @NotNull String buildType, @NotNull CMakeConfiguration.Generator generator, @NotNull File topLevelSourceDir, @NotNull File topLevelBuildDir, @NotNull CacheV2 cmakeCache, @NotNull FilesV1 cmakeFiles, @NotNull Map<OCLanguageKind, CMakeApiProfileGenerationResult.CompilerInfo> compilers, @NotNull CMakeGeneratorCommonInfo commonInfo, @NotNull Map<File, CMakeGeneratorUtils.CudaTargetInfo> cudaInfo, @NotNull Map<String, CPPEnvironment.ExecutablePathResult> resolvedExecutableCache) {
            if (result2 == null) {
                Context.$$$reportNull$$$0(0);
            }
            if (logger == null) {
                Context.$$$reportNull$$$0(1);
            }
            if (environment == null) {
                Context.$$$reportNull$$$0(2);
            }
            if (buildType == null) {
                Context.$$$reportNull$$$0(3);
            }
            if (generator == null) {
                Context.$$$reportNull$$$0(4);
            }
            if (topLevelSourceDir == null) {
                Context.$$$reportNull$$$0(5);
            }
            if (topLevelBuildDir == null) {
                Context.$$$reportNull$$$0(6);
            }
            if (cmakeCache == null) {
                Context.$$$reportNull$$$0(7);
            }
            if (cmakeFiles == null) {
                Context.$$$reportNull$$$0(8);
            }
            if (compilers == null) {
                Context.$$$reportNull$$$0(9);
            }
            if (commonInfo == null) {
                Context.$$$reportNull$$$0(10);
            }
            if (cudaInfo == null) {
                Context.$$$reportNull$$$0(11);
            }
            if (resolvedExecutableCache == null) {
                Context.$$$reportNull$$$0(12);
            }
        }

        @NotNull
        public CMakeApiProfileGenerationResult result() {
            CMakeApiProfileGenerationResult cMakeApiProfileGenerationResult = this.result;
            if (cMakeApiProfileGenerationResult == null) {
                Context.$$$reportNull$$$0(13);
            }
            return cMakeApiProfileGenerationResult;
        }

        @NotNull
        public CMakeApiFailLogger logger() {
            CMakeApiFailLogger cMakeApiFailLogger = this.logger;
            if (cMakeApiFailLogger == null) {
                Context.$$$reportNull$$$0(14);
            }
            return cMakeApiFailLogger;
        }

        @NotNull
        public CPPEnvironment environment() {
            CPPEnvironment cPPEnvironment = this.environment;
            if (cPPEnvironment == null) {
                Context.$$$reportNull$$$0(15);
            }
            return cPPEnvironment;
        }

        @NotNull
        public String buildType() {
            String string = this.buildType;
            if (string == null) {
                Context.$$$reportNull$$$0(16);
            }
            return string;
        }

        @NotNull
        public CMakeConfiguration.Generator generator() {
            CMakeConfiguration.Generator generator = this.generator;
            if (generator == null) {
                Context.$$$reportNull$$$0(17);
            }
            return generator;
        }

        @NotNull
        public File topLevelSourceDir() {
            File file = this.topLevelSourceDir;
            if (file == null) {
                Context.$$$reportNull$$$0(18);
            }
            return file;
        }

        @NotNull
        public File topLevelBuildDir() {
            File file = this.topLevelBuildDir;
            if (file == null) {
                Context.$$$reportNull$$$0(19);
            }
            return file;
        }

        @NotNull
        public CacheV2 cmakeCache() {
            CacheV2 cacheV2 = this.cmakeCache;
            if (cacheV2 == null) {
                Context.$$$reportNull$$$0(20);
            }
            return cacheV2;
        }

        @NotNull
        public FilesV1 cmakeFiles() {
            FilesV1 filesV1 = this.cmakeFiles;
            if (filesV1 == null) {
                Context.$$$reportNull$$$0(21);
            }
            return filesV1;
        }

        @NotNull
        public Map<OCLanguageKind, CMakeApiProfileGenerationResult.CompilerInfo> compilers() {
            Map<OCLanguageKind, CMakeApiProfileGenerationResult.CompilerInfo> map = this.compilers;
            if (map == null) {
                Context.$$$reportNull$$$0(22);
            }
            return map;
        }

        @NotNull
        public CMakeGeneratorCommonInfo commonInfo() {
            CMakeGeneratorCommonInfo cMakeGeneratorCommonInfo = this.commonInfo;
            if (cMakeGeneratorCommonInfo == null) {
                Context.$$$reportNull$$$0(23);
            }
            return cMakeGeneratorCommonInfo;
        }

        @NotNull
        public Map<File, CMakeGeneratorUtils.CudaTargetInfo> cudaInfo() {
            Map<File, CMakeGeneratorUtils.CudaTargetInfo> map = this.cudaInfo;
            if (map == null) {
                Context.$$$reportNull$$$0(24);
            }
            return map;
        }

        @NotNull
        public Map<String, CPPEnvironment.ExecutablePathResult> resolvedExecutableCache() {
            Map<String, CPPEnvironment.ExecutablePathResult> map = this.resolvedExecutableCache;
            if (map == null) {
                Context.$$$reportNull$$$0(25);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logger";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildType";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "generator";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topLevelSourceDir";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topLevelBuildDir";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cmakeCache";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cmakeFiles";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "compilers";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commonInfo";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cudaInfo";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolvedExecutableCache";
                    break;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeApiTargetReader$Context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeApiTargetReader$Context";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "result";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "logger";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "environment";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildType";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generator";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "topLevelSourceDir";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "topLevelBuildDir";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "cmakeCache";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "cmakeFiles";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compilers";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "commonInfo";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[1] = "cudaInfo";
                    break;
                }
                case 25: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolvedExecutableCache";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25 -> new IllegalStateException(string);
            };
        }
    }

    private static final class CompileGroup {
        @NotNull
        final OCLanguageKind languageKind;
        @NotNull
        final OCCompilerKind compilerKind;
        @NotNull
        final List<String> leadFlags;
        @NotNull
        final List<String> flagFragments;
        @NotNull
        final List<String> flags;
        @NotNull
        final List<String> defineFragments;
        @NotNull
        final List<String> defines;

        CompileGroup(@NotNull OCLanguageKind kind, @NotNull OCCompilerKind compilerKind, @NotNull List<String> leadFlags, @NotNull List<String> flagFragments, @NotNull List<String> defineFragments) {
            if (kind == null) {
                CompileGroup.$$$reportNull$$$0(0);
            }
            if (compilerKind == null) {
                CompileGroup.$$$reportNull$$$0(1);
            }
            if (leadFlags == null) {
                CompileGroup.$$$reportNull$$$0(2);
            }
            if (flagFragments == null) {
                CompileGroup.$$$reportNull$$$0(3);
            }
            if (defineFragments == null) {
                CompileGroup.$$$reportNull$$$0(4);
            }
            this.flags = new ArrayList<String>();
            this.defines = new ArrayList<String>();
            this.languageKind = kind;
            this.compilerKind = compilerKind;
            this.leadFlags = leadFlags;
            this.flagFragments = flagFragments;
            this.defineFragments = defineFragments;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "kind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "compilerKind";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "leadFlags";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "flagFragments";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "defineFragments";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeApiTargetReader$CompileGroup";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

