/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.console;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.console.CMakeConsoleMessageType;
import com.jetbrains.cidr.cpp.cmake.console.ErrorMatcher;
import com.jetbrains.cidr.cpp.cmake.console.VersionErrorResultItem;
import com.jetbrains.cidr.cpp.cmake.model.CMakeMessage;
import com.jetbrains.cidr.execution.DimmableFilter;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cmake.psi.util.CMakePsiUtils;
import com.jetbrains.cmake.psi.util.CMakeVersionRange;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CMakeOutputFilter
implements Filter,
ErrorMatcher,
DumbAware,
DimmableFilter {
    @NonNls
    private static final String CMAKE_ERROR = "CMake Error";
    @NonNls
    private static final String CMAKE_WARNING = "CMake Warning";
    private static final Pattern MESSAGE_PATTERN = Pattern.compile("CMake ((?:Error|Warning)( \\(dev\\))?)(?: (?:in|at) (.+?)(?::(\\d+)( \\(.+\\))?)?)?:");
    private static final Pattern LOCATION_PATTERN = Pattern.compile("(.+?):(\\d+):?");
    private static final Pattern LOW_VERSION_PATTERN = Pattern.compile("Compatibility with CMake < (?<version>[0-9]+(\\.[0-9]+)*) is not supported by CMake >= [0-9]+(\\.[0-9]+)*.");
    private static final Pattern HIGH_VERSION_PATTERN = Pattern.compile("CMake [0-9]+(\\.[0-9]+)* or higher is required.[ \t]*You are running version (?<version>[0-9]+(\\.[0-9]+)*)");
    @Nullable
    private final Project myProject;
    @NotNull
    private final CidrToolEnvironment myEnvironment;
    @Nullable
    private final Path myBaseDir;
    @NotNull
    private final ArrayList<CMakeMessage> myCollectedMessages = new ArrayList();
    @NotNull
    private final EditorColorsScheme myColorsScheme;
    private boolean myDimHighlighting;
    private volatile boolean isFinished;
    private final StringBuilder myBuffer = new StringBuilder();
    private boolean isParseError = false;
    private boolean isGeneralError = false;
    private final List<CharSequence> parseErrorLines = new ArrayList<CharSequence>();
    private Matcher currentMatcher = null;

    public CMakeOutputFilter(@Nullable Project project, @Nullable CidrToolEnvironment env, @Nullable Path baseDir) {
        this.myProject = project;
        this.myEnvironment = env == null ? new CidrToolEnvironment() : env;
        this.myBaseDir = baseDir;
        this.myColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
    }

    public void dimHighlighting() {
        this.myDimHighlighting = true;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String eachLine, int entireLength) {
        if (eachLine == null) {
            CMakeOutputFilter.$$$reportNull$$$0(0);
        }
        CPPLog.LOG.assertTrue(!this.isFinished, (Object)"finish has been already called");
        int offset = entireLength - eachLine.length();
        SmartList links = new SmartList();
        if (this.match(eachLine, offset, (List<Filter.ResultItem>)links) && !this.myDimHighlighting) {
            TextAttributes errorAttr = this.myColorsScheme.getAttributes(ConsoleViewContentType.ERROR_OUTPUT_KEY);
            links.add(new Filter.ResultItem(this, offset, entireLength, null, errorAttr, null){

                public int getHighlighterLayer() {
                    return 5000;
                }
            });
        }
        return links.isEmpty() ? null : new Filter.Result((List)links);
    }

    private boolean match(CharSequence eachLine, int offset, List<Filter.ResultItem> links) {
        Matcher m;
        eachLine = StringUtil.trimTrailing((CharSequence)eachLine);
        if (this.currentMatcher != null) {
            if (eachLine.isEmpty()) {
                this.myBuffer.append('\n');
                return true;
            }
            if (StringUtil.startsWith((CharSequence)eachLine, (CharSequence)"  ")) {
                int length = this.myBuffer.length();
                if (length > 0 && !Character.isWhitespace(this.myBuffer.charAt(length - 1))) {
                    this.myBuffer.append(' ');
                }
                this.myBuffer.append(eachLine.subSequence("  ".length(), eachLine.length()));
                CMakeVersionRange version = CMakeOutputFilter.tryParseCMakeRunningVersionError(eachLine);
                if (version != null) {
                    Pair<File, Integer> loc = this.toFileAndLine(this.currentMatcher.group(3), this.currentMatcher.group(4));
                    Filter.ResultItem res = this.createQuickFixForCMakeVersion(offset, offset + eachLine.length(), (File)loc.first, (Integer)loc.second - 1, version);
                    if (res != null) {
                        links.add(res);
                    }
                }
                return true;
            }
            this.flushMessage(this.currentMatcher, this.myBuffer);
            this.currentMatcher = null;
            this.myBuffer.setLength(0);
        } else if (this.isParseError) {
            if (this.parseErrorLines.size() < 2) {
                this.parseErrorLines.add(eachLine);
                return true;
            }
            this.flushParsingError(this.parseErrorLines);
            this.parseErrorLines.clear();
            this.isParseError = false;
        }
        boolean startsWithError = StringUtil.startsWith((CharSequence)eachLine, (CharSequence)CMAKE_ERROR);
        Matcher matcher = m = startsWithError || StringUtil.startsWith((CharSequence)eachLine, (CharSequence)CMAKE_WARNING) ? MESSAGE_PATTERN.matcher(eachLine) : null;
        if (m != null && m.matches()) {
            if (this.isGeneralError) {
                this.flushGeneralMessage(this.myBuffer);
            }
            this.isGeneralError = false;
            this.currentMatcher = m;
            this.addErrorHyperlink(m, offset, links);
            return true;
        }
        if (startsWithError && StringUtil.startsWith((CharSequence)eachLine, (CharSequence)"CMake Error:")) {
            if (this.isGeneralError) {
                this.flushGeneralMessage(this.myBuffer);
            }
            this.isGeneralError = false;
            if (eachLine.equals("CMake Error: Error in cmake code at")) {
                this.isParseError = true;
            } else {
                this.myBuffer.append(eachLine.subSequence("CMake Error:".length(), eachLine.length())).append("\n");
                this.isGeneralError = true;
            }
            return true;
        }
        if (this.isGeneralError) {
            if (!StringUtil.startsWith((CharSequence)eachLine, (CharSequence)"-- ") && !StringUtil.equalsTrimWhitespaces((CharSequence)eachLine, (CharSequence)"")) {
                this.myBuffer.append(eachLine).append("\n");
                return true;
            }
            this.flushGeneralMessage(this.myBuffer);
            this.isGeneralError = false;
        }
        return false;
    }

    @Nullable
    protected Filter.ResultItem createQuickFixForCMakeVersion(int startOffset, int endOffset, @NotNull File file, @NotNull Integer line, @NotNull CMakeVersionRange requiredVersion) {
        if (file == null) {
            CMakeOutputFilter.$$$reportNull$$$0(1);
        }
        if (line == null) {
            CMakeOutputFilter.$$$reportNull$$$0(2);
        }
        if (requiredVersion == null) {
            CMakeOutputFilter.$$$reportNull$$$0(3);
        }
        return VersionErrorResultItem.create(startOffset, endOffset, this.myProject, file, line, requiredVersion);
    }

    @Override
    public boolean isPotentialMatch(@NotNull CharSequence multilineFragment) {
        if (multilineFragment == null) {
            CMakeOutputFilter.$$$reportNull$$$0(4);
        }
        return StringUtil.contains((CharSequence)multilineFragment, (CharSequence)CMAKE_ERROR) || StringUtil.contains((CharSequence)multilineFragment, (CharSequence)CMAKE_WARNING);
    }

    @Override
    @Nullable
    public CMakeConsoleMessageType match(@NotNull CharSequence line) {
        if (line == null) {
            CMakeOutputFilter.$$$reportNull$$$0(5);
        }
        return CMakeOutputFilter.getMessageType(line);
    }

    @Nullable
    public static CMakeConsoleMessageType getMessageType(@NotNull CharSequence line) {
        Matcher m;
        if (line == null) {
            CMakeOutputFilter.$$$reportNull$$$0(6);
        }
        if ((m = MESSAGE_PATTERN.matcher(line = StringUtil.trimTrailing((CharSequence)line))).matches()) {
            return m.group(1).equals("Error") ? CMakeConsoleMessageType.ERROR : CMakeConsoleMessageType.WARNING;
        }
        if (StringUtil.startsWith((CharSequence)line, (CharSequence)"CMake Error:")) {
            return CMakeConsoleMessageType.ERROR;
        }
        return null;
    }

    private void addErrorHyperlink(@NotNull Matcher m, int offset, @NotNull List<? super Filter.ResultItem> results) {
        HyperlinkInfo info;
        if (m == null) {
            CMakeOutputFilter.$$$reportNull$$$0(7);
        }
        if (results == null) {
            CMakeOutputFilter.$$$reportNull$$$0(8);
        }
        Pair<File, Integer> fileAndLine = this.toFileAndLine(m.group(3), m.group(4));
        if (fileAndLine.first != null && (info = this.createHyperlinkInfo((File)fileAndLine.first, (Integer)fileAndLine.second)) != null) {
            results.add((Filter.ResultItem)new Filter.ResultItem(offset + m.start(3), offset + Math.max(m.end(3), m.end(4)), info, this.myDimHighlighting));
        }
    }

    @Nullable
    protected HyperlinkInfo createHyperlinkInfo(@NotNull File file, @Nullable Integer line) {
        if (file == null) {
            CMakeOutputFilter.$$$reportNull$$$0(9);
        }
        VirtualFile vFile2 = VfsUtil.findFileByIoFile((File)file, (boolean)false);
        return this.myProject == null || vFile2 == null ? null : new OpenFileHyperlinkInfo(this.myProject, vFile2, line == null ? 0 : line - 1, 0);
    }

    @TestOnly
    @NotNull
    public List<CMakeMessage> finishAndGetMessages() {
        CPPLog.LOG.assertTrue(!this.isFinished, (Object)"finishAndGetMessages() has been already called.\nThis might happen when something tries to write to CMake console, after generation/build has finished");
        this.isFinished = true;
        if (this.currentMatcher != null) {
            this.flushMessage(this.currentMatcher, this.myBuffer);
        }
        if (this.isParseError) {
            this.flushParsingError(this.parseErrorLines);
        }
        if (this.isGeneralError) {
            this.flushGeneralMessage(this.myBuffer);
        }
        List<CMakeMessage> list2 = Collections.unmodifiableList(this.myCollectedMessages);
        if (list2 == null) {
            CMakeOutputFilter.$$$reportNull$$$0(10);
        }
        return list2;
    }

    private static CMakeVersionRange tryParseCMakeRunningVersionError(CharSequence message) {
        Matcher m1 = LOW_VERSION_PATTERN.matcher(message);
        if (m1.find()) {
            return new CMakeVersionRange(CMakePsiUtils.toSimpleCMakeVersion((String)m1.group("version")), Collections.emptyList());
        }
        Matcher m2 = HIGH_VERSION_PATTERN.matcher(message);
        if (m2.find()) {
            return new CMakeVersionRange(Collections.emptyList(), CMakePsiUtils.toSimpleCMakeVersion((String)m2.group("version")));
        }
        return null;
    }

    private void flushGeneralMessage(StringBuilder text) {
        this.myCollectedMessages.add(this.createMessage(CMakeMessage.MessageLevel.ERROR, null, null, text));
    }

    private void flushParsingError(List<CharSequence> parseErrorLines) {
        Matcher m = LOCATION_PATTERN.matcher(parseErrorLines.get(0));
        String fileText = null;
        String lineText = null;
        StringBuilder text = new StringBuilder();
        if (m.matches()) {
            fileText = m.group(1);
            lineText = m.group(2);
        } else {
            text.append(parseErrorLines.get(0)).append(' ');
        }
        text.append(parseErrorLines.get(1));
        this.myCollectedMessages.add(this.createMessage(CMakeMessage.MessageLevel.FATAL_ERROR, fileText, lineText, text));
    }

    private void flushMessage(@NotNull Matcher matcher, @NotNull StringBuilder text) {
        if (matcher == null) {
            CMakeOutputFilter.$$$reportNull$$$0(11);
        }
        if (text == null) {
            CMakeOutputFilter.$$$reportNull$$$0(12);
        }
        String levelText = matcher.group(1);
        String dev = matcher.group(2);
        String fileText = matcher.group(3);
        String lineText = matcher.group(4);
        CMakeMessage.MessageLevel level = levelText.equals("Error") ? CMakeMessage.MessageLevel.ERROR : (dev == null ? CMakeMessage.MessageLevel.WARNING : CMakeMessage.MessageLevel.AUTHOR_WARNING);
        this.myCollectedMessages.add(this.createMessage(level, fileText, lineText, text));
    }

    private CMakeMessage createMessage(@NotNull CMakeMessage.MessageLevel level, @Nullable String fileText, @Nullable String lineText, @NotNull StringBuilder text) {
        if (level == null) {
            CMakeOutputFilter.$$$reportNull$$$0(13);
        }
        if (text == null) {
            CMakeOutputFilter.$$$reportNull$$$0(14);
        }
        Pair<File, Integer> fileAndLine = this.toFileAndLine(fileText, lineText);
        CMakeMessage result2 = new CMakeMessage(level, (File)fileAndLine.first, (Integer)fileAndLine.second, text.toString().trim());
        text.setLength(0);
        return result2;
    }

    @NotNull
    private Pair<File, Integer> toFileAndLine(@Nullable String fileText, @Nullable String lineText) {
        Integer line = null;
        try {
            line = lineText == null ? null : Integer.valueOf(Integer.parseInt(lineText));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Pair pair = Pair.create(fileText == null || this.myBaseDir == null ? null : new File(this.myEnvironment.toLocalPath(this.myBaseDir.toFile(), fileText)), (Object)line);
        if (pair == null) {
            CMakeOutputFilter.$$$reportNull$$$0(15);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eachLine";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredVersion";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multilineFragment";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/console/CMakeOutputFilter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/console/CMakeOutputFilter";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "finishAndGetMessages";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "toFileAndLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyFilter";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createQuickFixForCMakeVersion";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isPotentialMatch";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMessageType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addErrorHyperlink";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createHyperlinkInfo";
                break;
            }
            case 10: 
            case 15: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "flushMessage";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 15 -> new IllegalStateException(string);
        };
    }
}

