/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.actions.newFile.base;

import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.EditorTextField;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.cpp.cmake.actions.newFile.base.NewFileTarget;
import java.awt.Dimension;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 \u0019*\u0010\b\u0000\u0010\u0001*\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00022\u00020\u0004:\u0001\u0019B!\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00018\u0000\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\r\u001a\u00020\u000eH\u0014J\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00028\u0000H\u0007\u00a2\u0006\u0002\u0010\u0011J\u001f\u0010\u0012\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0007\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0015J\u001f\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0013\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00028\u0000H\u0003\u00a2\u0006\u0002\u0010\u0011R\u0012\u0010\u0007\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/actions/newFile/base/PreviewTextFieldBase;", "T", "Lcom/jetbrains/cidr/cpp/cmake/actions/newFile/base/NewFileTarget;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/ui/EditorTextField;", "project", "Lcom/intellij/openapi/project/Project;", "target", "type", "Lcom/intellij/openapi/fileTypes/FileType;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/cidr/cpp/cmake/actions/newFile/base/NewFileTarget;Lcom/intellij/openapi/fileTypes/FileType;)V", "Lcom/jetbrains/cidr/cpp/cmake/actions/newFile/base/NewFileTarget;", "createEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "setTarget", "", "(Lcom/jetbrains/cidr/cpp/cmake/actions/newFile/base/NewFileTarget;)V", "updateWithTarget", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/cidr/cpp/cmake/actions/newFile/base/NewFileTarget;)V", "configureNewEditor", "(Lcom/jetbrains/cidr/cpp/cmake/actions/newFile/base/NewFileTarget;Lcom/intellij/openapi/editor/ex/EditorEx;)Lcom/intellij/openapi/editor/ex/EditorEx;", "initDocument", "Companion", "intellij.cmake"})
@SourceDebugExtension(value={"SMAP\nPreviewTextFieldBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreviewTextFieldBase.kt\ncom/jetbrains/cidr/cpp/cmake/actions/newFile/base/PreviewTextFieldBase\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,104:1\n13#2:105\n*S KotlinDebug\n*F\n+ 1 PreviewTextFieldBase.kt\ncom/jetbrains/cidr/cpp/cmake/actions/newFile/base/PreviewTextFieldBase\n*L\n101#1:105\n*E\n"})
public abstract class PreviewTextFieldBase<T extends NewFileTarget<? extends PsiElement>>
extends EditorTextField {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private T target;
    @NotNull
    private static final Logger LOG;

    public PreviewTextFieldBase(@NotNull Project project, @Nullable T target, @NotNull FileType type) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        super(null, project, type, true, false);
        this.target = target;
        this.setFont(EditorFontType.getGlobalPlainFont());
        this.setPreferredSize(new Dimension(JBUI.scale((int)500), JBUI.scale((int)130)));
        this.setMinimumSize(new Dimension(JBUI.scale((int)500), JBUI.scale((int)130)));
        this.setFocusable(false);
        this.setFocusTraversalPolicyProvider(false);
    }

    @NotNull
    protected EditorEx createEditor() {
        T myTarget = this.target;
        if (myTarget != null) {
            this.initDocument(myTarget);
        }
        EditorEx editorEx = super.createEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"createEditor(...)");
        return this.configureNewEditor(myTarget, editorEx);
    }

    @RequiresEdt
    public final void setTarget(@NotNull T target) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        this.target = target;
        this.initDocument(target);
        this.updateWithTarget(this.getEditor(), target);
    }

    private final void updateWithTarget(Editor editor, T target) {
        if (editor == null) {
            return;
        }
        Object t = target.getPsiElement();
        if (t == null) {
            return;
        }
        Object element = t;
        int startOffset = element.getTextOffset();
        editor.getCaretModel().moveToOffset(startOffset);
        ScrollingModel $this$updateWithTarget_u24lambda_u240 = editor.getScrollingModel();
        boolean bl = false;
        $this$updateWithTarget_u24lambda_u240.disableAnimation();
        $this$updateWithTarget_u24lambda_u240.scrollToCaret(ScrollType.CENTER);
        $this$updateWithTarget_u24lambda_u240.enableAnimation();
        MarkupModel $this$updateWithTarget_u24lambda_u241 = editor.getMarkupModel();
        boolean bl2 = false;
        $this$updateWithTarget_u24lambda_u241.removeAllHighlighters();
        TextRange range = element.getTextRange();
        $this$updateWithTarget_u24lambda_u241.addRangeHighlighter(EditorColors.SEARCH_RESULT_ATTRIBUTES, range.getStartOffset(), range.getEndOffset(), 5500, HighlighterTargetArea.EXACT_RANGE);
    }

    private final EditorEx configureNewEditor(T target, EditorEx editor) {
        EditorEx $this$configureNewEditor_u24lambda_u240 = editor;
        boolean bl = false;
        $this$configureNewEditor_u24lambda_u240.setBackgroundColor(EditorFragmentComponent.getBackgroundColor((Editor)((Editor)editor)));
        $this$configureNewEditor_u24lambda_u240.setVerticalScrollbarVisible(true);
        $this$configureNewEditor_u24lambda_u240.setHorizontalScrollbarVisible(true);
        if (target != null) {
            this.updateWithTarget((Editor)editor, target);
        }
        return editor;
    }

    @RequiresReadLock
    private final void initDocument(T target) {
        Object t = target.getPsiElement();
        PsiFile file = t != null ? t.getContainingFile() : null;
        LOG.assertTrue(file != null);
        if (file == null) {
            return;
        }
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return;
        }
        Document document2 = document;
        if (!Intrinsics.areEqual((Object)document2, (Object)this.getDocument())) {
            this.setDocument(document2);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PreviewTextFieldBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/actions/newFile/base/PreviewTextFieldBase$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.cmake"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

