/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.actions.newFile;

import com.intellij.core.CoreBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.jetbrains.cidr.cpp.CMakeBundle;
import com.jetbrains.cidr.cpp.cmake.actions.newFile.CMakeNewFileTargetSeekerKt;
import com.jetbrains.cidr.cpp.cmake.actions.newFile.base.NewFileTarget;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileCreationException;
import com.jetbrains.cmake.psi.CMakeCommand;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B@\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u000b\u0010\u000b\u001a\u00070\u0007\u00a2\u0006\u0002\b\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0006H\u0017J\u001e\u0010\u001b\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00062\u0006\u0010\u0003\u001a\u00020\u0002H\u0014J\b\u0010\u001f\u001a\u00020\nH\u0016J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0096\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0019\u0010\u000b\u001a\u00070\u0007\u00a2\u0006\u0002\b\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006$"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/actions/newFile/CMakeNewFileTarget;", "Lcom/jetbrains/cidr/cpp/cmake/actions/newFile/base/NewFileTarget;", "Lcom/jetbrains/cmake/psi/CMakeCommand;", "command", "Lcom/intellij/psi/SmartPsiElementPointer;", "targetNames", "", "", "name", "selectionPriority", "", "additionalInfo", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Lcom/intellij/psi/SmartPsiElementPointer;Ljava/util/List;Ljava/lang/String;ILjava/lang/String;)V", "getTargetNames", "()Ljava/util/List;", "getName", "()Ljava/lang/String;", "getSelectionPriority", "()I", "getAdditionalInfo", "psiPointer", "addFiles", "", "files", "Lcom/intellij/openapi/vfs/VirtualFile;", "writeFiles", "psiElement", "getPsiElement", "()Lcom/jetbrains/cmake/psi/CMakeCommand;", "hashCode", "equals", "", "other", "", "intellij.cmake"})
@SourceDebugExtension(value={"SMAP\nCMakeNewFileTarget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CMakeNewFileTarget.kt\ncom/jetbrains/cidr/cpp/cmake/actions/newFile/CMakeNewFileTarget\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1869#2:160\n1870#2:162\n1#3:161\n*S KotlinDebug\n*F\n+ 1 CMakeNewFileTarget.kt\ncom/jetbrains/cidr/cpp/cmake/actions/newFile/CMakeNewFileTarget\n*L\n62#1:160\n62#1:162\n*E\n"})
public class CMakeNewFileTarget
implements NewFileTarget<CMakeCommand> {
    @NotNull
    private final List<String> targetNames;
    @NotNull
    private final String name;
    private final int selectionPriority;
    @NotNull
    private final String additionalInfo;
    @NotNull
    private final SmartPsiElementPointer<CMakeCommand> psiPointer;

    public CMakeNewFileTarget(@NotNull SmartPsiElementPointer<CMakeCommand> command, @NotNull List<String> targetNames, @NotNull String name, int selectionPriority, @NotNull String additionalInfo) {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        Intrinsics.checkNotNullParameter(targetNames, (String)"targetNames");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)additionalInfo, (String)"additionalInfo");
        this.targetNames = targetNames;
        this.name = name;
        this.selectionPriority = selectionPriority;
        this.additionalInfo = additionalInfo;
        this.psiPointer = command;
    }

    @NotNull
    public final List<String> getTargetNames() {
        return this.targetNames;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public final int getSelectionPriority() {
        return this.selectionPriority;
    }

    @Override
    @NotNull
    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    @Override
    @RequiresWriteLock
    public void addFiles(@NotNull List<? extends VirtualFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        if (files.isEmpty()) {
            return;
        }
        VirtualFile virtualFile = this.psiPointer.getVirtualFile();
        virtualFile.refresh(false, false);
        if (!virtualFile.isWritable()) {
            Object[] objectArray = new Object[]{virtualFile.getPresentableUrl()};
            String string = CoreBundle.message((String)"cannot.modify.a.read.only.file", (Object[])objectArray);
            Object[] objectArray2 = new Object[]{virtualFile.getPresentableName()};
            String string2 = CMakeBundle.message("file.is.read.only.error.title", objectArray2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            throw new OCNewFileCreationException(string, string2);
        }
        CMakeCommand cMakeCommand = this.getPsiElement();
        if (cMakeCommand == null) {
            return;
        }
        CMakeCommand command = cMakeCommand;
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)command.getProject());
        Document document = psiDocumentManager.getDocument(command.getContainingFile());
        if (document != null && psiDocumentManager.isUncommited(document)) {
            psiDocumentManager.commitDocument(document);
        }
        this.writeFiles(files, command);
        if (document != null) {
            psiDocumentManager.commitDocument(document);
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
        }
    }

    protected void writeFiles(@NotNull List<? extends VirtualFile> files, @NotNull CMakeCommand command) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Iterable $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            block4: {
                VirtualFile file;
                block3: {
                    file = (VirtualFile)element$iv;
                    boolean bl = false;
                    object = command.getContainingFile();
                    if (object == null) break block3;
                    PsiFile it = object;
                    boolean bl2 = false;
                    String string = file.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    String string2 = CMakeNewFileTargetSeekerKt.extractRelativePath(it, string);
                    object = string2;
                    if (string2 != null) break block4;
                }
                String string = file.getPath();
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            }
            Object path = object;
            command.appendArgument((String)path, true);
        }
    }

    @Override
    @Nullable
    public CMakeCommand getPsiElement() {
        CMakeCommand cMakeCommand = (CMakeCommand)this.psiPointer.getElement();
        if (cMakeCommand == null) {
            return null;
        }
        CMakeCommand cmd = cMakeCommand;
        return cmd.isValid() ? cmd : null;
    }

    public int hashCode() {
        return this.psiPointer.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof CMakeNewFileTarget && Intrinsics.areEqual(((CMakeNewFileTarget)other).psiPointer, this.psiPointer);
    }
}

