/*
 * Decompiled with CFR 0.152.
 */
package org.rust.valgrind;

import com.intellij.cidr.profiling.CidrProfilingBundle;
import com.intellij.cidr.profiling.memory.MemoryProfileCompositeConsumer;
import com.intellij.cidr.profiling.memory.MemoryProfileConsoleViewWrapper;
import com.intellij.cidr.profiling.memory.MemoryProfileEnvironment;
import com.intellij.cidr.profiling.memory.MemoryProfileFileReader;
import com.intellij.cidr.profiling.memory.MemoryProfileStringAccumulator;
import com.intellij.cidr.profiling.memory.MemoryProfileTreeDataModel;
import com.intellij.cidr.profiling.memory.tree.MemoryProfileTree;
import com.intellij.cidr.profiling.memory.ui.MemoryProfileOutputPanel;
import com.intellij.cidr.profiling.valgrind.ValgrindCommandLineParametersBuilder;
import com.intellij.cidr.profiling.valgrind.ValgrindConfigurable;
import com.intellij.cidr.profiling.valgrind.ValgrindExecutor;
import com.intellij.cidr.profiling.valgrind.ValgrindHandler;
import com.intellij.cidr.profiling.valgrind.ValgrindOutputConsumer;
import com.intellij.cidr.profiling.valgrind.ValgrindSettings;
import com.intellij.cidr.profiling.valgrind.actions.EditValgrindSettingsAction;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.ExecutionSearchScopes;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.StatusText;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.runconfig.CargoCommandConfigurationExtension;
import org.rust.cargo.runconfig.ConfigurationExtensionContext;
import org.rust.cargo.runconfig.command.CargoCommandConfiguration;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.wsl.RsWslToolchain;
import org.rust.openapiext.UtilsKt;
import org.rust.valgrind.RsValgrindConfigurationExtension;
import org.rust.valgrind.RsValgrindConfigurationExtensionKt;
import org.rust.valgrind.ScopeService;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001,B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J(\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J(\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J(\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J(\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#H\u0002J9\u0010$\u001a\u00020\r\"\u0004\b\u0000\u0010%2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H%0'2\u0006\u0010(\u001a\u0002H%2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010)J3\u0010*\u001a\u0004\u0018\u0001H%\"\u0004\b\u0000\u0010%2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H%0'2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010+\u00a8\u0006-"}, d2={"Lorg/rust/valgrind/RsValgrindConfigurationExtension;", "Lorg/rust/cargo/runconfig/CargoCommandConfigurationExtension;", "<init>", "()V", "isApplicableFor", "", "configuration", "Lorg/rust/cargo/runconfig/command/CargoCommandConfiguration;", "isEnabledFor", "applicableConfiguration", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "patchCommandLine", "", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "cmdLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "context", "Lorg/rust/cargo/runconfig/ConfigurationExtensionContext;", "patchCommandLineState", "state", "Lcom/intellij/execution/configurations/CommandLineState;", "attachToProcess", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "configureUIListeners", "outputPanel", "Lcom/intellij/cidr/profiling/memory/ui/MemoryProfileOutputPanel;", "accumulator", "Lcom/intellij/cidr/profiling/memory/MemoryProfileStringAccumulator;", "project", "Lcom/intellij/openapi/project/Project;", "deleteFile", "file", "Ljava/io/File;", "putUserData", "T", "key", "Lcom/intellij/openapi/util/Key;", "value", "(Lcom/intellij/openapi/util/Key;Ljava/lang/Object;Lorg/rust/cargo/runconfig/command/CargoCommandConfiguration;Lorg/rust/cargo/runconfig/ConfigurationExtensionContext;)V", "getUserData", "(Lcom/intellij/openapi/util/Key;Lorg/rust/cargo/runconfig/command/CargoCommandConfiguration;Lorg/rust/cargo/runconfig/ConfigurationExtensionContext;)Ljava/lang/Object;", "Helper", "intellij.rustrover.valgrind"})
@SourceDebugExtension(value={"SMAP\nRsValgrindConfigurationExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsValgrindConfigurationExtension.kt\norg/rust/valgrind/RsValgrindConfigurationExtension\n+ 2 utils.kt\norg/rust/openapiext/UtilsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,247:1\n479#2,2:248\n30#3,2:250\n*S KotlinDebug\n*F\n+ 1 RsValgrindConfigurationExtension.kt\norg/rust/valgrind/RsValgrindConfigurationExtension\n*L\n79#1:248,2\n143#1:250,2\n*E\n"})
public final class RsValgrindConfigurationExtension
extends CargoCommandConfigurationExtension {
    public boolean isApplicableFor(@NotNull CargoCommandConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        return true;
    }

    public boolean isEnabledFor(@NotNull CargoCommandConfiguration applicableConfiguration, @Nullable RunnerSettings runnerSettings) {
        Intrinsics.checkNotNullParameter((Object)((Object)applicableConfiguration), (String)"applicableConfiguration");
        return Helper.INSTANCE.isEnabledFor(applicableConfiguration);
    }

    @Override
    public void patchCommandLine(@NotNull CargoCommandConfiguration configuration, @NotNull ExecutionEnvironment environment, @NotNull GeneralCommandLine cmdLine, @NotNull ConfigurationExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)cmdLine, (String)"cmdLine");
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        if (!RsValgrindConfigurationExtensionKt.access$getVALGRIND_RUNNER_IDS$p().contains(environment.getRunner().getRunnerId())) {
            return;
        }
        Object object = configuration.clean().getOk();
        if (object == null || (object = ((CargoCommandConfiguration.CleanConfiguration.Ok)object).getToolchain()) == null) {
            return;
        }
        Object toolchain2 = object;
        String string = cmdLine.getExePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExePath(...)");
        String programPath = ((RsToolchainBase)toolchain2).toLocalPath(string);
        if (!new File(programPath).exists()) {
            Object[] objectArray = new Object[]{programPath};
            throw new ExecutionException(RsBundle.INSTANCE.message("dialog.message.file.not.found", objectArray));
        }
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        String string2 = ValgrindSettings.getInstance().getValgrindPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValgrindPath(...)");
        String valgrindPath = ((RsToolchainBase)toolchain2).toLocalPath(string2);
        if (StringUtil.isEmpty((String)valgrindPath) || !new File(valgrindPath).exists()) {
            Project $this$showSettingsDialog$iv = project2;
            boolean $i$f$showSettingsDialog = false;
            ShowSettingsUtil.getInstance().showSettingsDialog($this$showSettingsDialog$iv, ValgrindConfigurable.class);
            return;
        }
        try {
            File file = FileUtil.createTempFile((String)"valgrind", null, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
            File outputFile = file;
            String string3 = outputFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAbsolutePath(...)");
            String outputFilePath = ((RsToolchainBase)toolchain2).toRemotePath(string3);
            cmdLine.setExePath(valgrindPath);
            ValgrindCommandLineParametersBuilder parametersBuilder = new ValgrindCommandLineParametersBuilder();
            List list = parametersBuilder.build(outputFilePath);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"build(...)");
            List valgrindParameters = list;
            valgrindParameters.add(programPath);
            String[] stringArray = ArrayUtil.toStringArray((Collection)valgrindParameters);
            cmdLine.getParametersList().prependAll(Arrays.copyOf(stringArray, stringArray.length));
            ((RsToolchainBase)toolchain2).patchCommandLine(cmdLine, false);
            this.putUserData(RsValgrindConfigurationExtensionKt.access$getOUTPUT_FILE_PATH_KEY$p(), outputFile, configuration, context);
        }
        catch (IOException e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    @Override
    public void patchCommandLineState(@NotNull CargoCommandConfiguration configuration, @NotNull ExecutionEnvironment environment, @NotNull CommandLineState state, @NotNull ConfigurationExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        if (!RsValgrindConfigurationExtensionKt.access$getVALGRIND_RUNNER_IDS$p().contains(environment.getRunner().getRunnerId())) {
            return;
        }
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        MemoryProfileTreeDataModel treeDataModel = new MemoryProfileTreeDataModel("Valgrind", project2);
        MemoryProfileOutputPanel outputPanel = new MemoryProfileOutputPanel(treeDataModel, (AnAction)new EditValgrindSettingsAction(), "ValgrindToolWindow.TreePopup", project2);
        this.putUserData(RsValgrindConfigurationExtensionKt.access$getDATA_MODEL_KEY$p(), treeDataModel, configuration, context);
        this.putUserData(RsValgrindConfigurationExtensionKt.access$getOUTPUT_PANEL_KEY$p(), outputPanel, configuration, context);
        ConsoleView consoleView = state.getConsoleBuilder().getConsole();
        Intrinsics.checkNotNullExpressionValue((Object)consoleView, (String)"getConsole(...)");
        ConsoleView console = consoleView;
        GlobalSearchScope globalSearchScope = ExecutionSearchScopes.executionScope((Project)environment.getProject(), (RunProfile)environment.getRunProfile());
        state.setConsoleBuilder((TextConsoleBuilder)new TextConsoleBuilderImpl(project2, console, outputPanel, globalSearchScope){
            final /* synthetic */ Project $project;
            final /* synthetic */ ConsoleView $console;
            final /* synthetic */ MemoryProfileOutputPanel $outputPanel;
            {
                this.$project = $project;
                this.$console = $console;
                this.$outputPanel = $outputPanel;
                super($project, $super_call_param$1);
            }

            public ConsoleView getConsole() {
                Icon icon = ValgrindExecutor.getExecutorInstance().getIcon();
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getIcon(...)");
                Icon icon2 = icon;
                return (ConsoleView)new MemoryProfileConsoleViewWrapper("Valgrind", this.$console, this.$outputPanel, this.$project, icon2);
            }
        });
    }

    @Override
    public void attachToProcess(@NotNull CargoCommandConfiguration configuration, @NotNull ProcessHandler handler, @NotNull ExecutionEnvironment environment, @NotNull ConfigurationExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        if (!RsValgrindConfigurationExtensionKt.access$getVALGRIND_RUNNER_IDS$p().contains(environment.getRunner().getRunnerId())) {
            return;
        }
        Object object = configuration.clean().getOk();
        if (object == null || (object = ((CargoCommandConfiguration.CleanConfiguration.Ok)object).getToolchain()) == null) {
            return;
        }
        Object toolchain2 = object;
        File file = (File)this.getUserData(RsValgrindConfigurationExtensionKt.access$getOUTPUT_FILE_PATH_KEY$p(), configuration, context);
        if (file == null) {
            return;
        }
        File outputFile = file;
        MemoryProfileTreeDataModel memoryProfileTreeDataModel = (MemoryProfileTreeDataModel)this.getUserData(RsValgrindConfigurationExtensionKt.access$getDATA_MODEL_KEY$p(), configuration, context);
        if (memoryProfileTreeDataModel == null) {
            return;
        }
        MemoryProfileTreeDataModel treeDataModel = memoryProfileTreeDataModel;
        MemoryProfileOutputPanel memoryProfileOutputPanel = (MemoryProfileOutputPanel)this.getUserData(RsValgrindConfigurationExtensionKt.access$getOUTPUT_PANEL_KEY$p(), configuration, context);
        if (memoryProfileOutputPanel == null) {
            return;
        }
        MemoryProfileOutputPanel outputPanel = memoryProfileOutputPanel;
        try {
            ValgrindHandler valgrindHandler = new ValgrindHandler(treeDataModel, new MemoryProfileEnvironment(new CidrToolEnvironment()));
            Project project = configuration.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ScopeService> serviceClass$iv = ScopeService.class;
            Object object2 = $this$service$iv.getService(serviceClass$iv);
            if (object2 == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ValgrindOutputConsumer outputFileConsumer = new ValgrindOutputConsumer(valgrindHandler, ((ScopeService)object2).getScope(), null);
            MemoryProfileStringAccumulator accumulator = new MemoryProfileStringAccumulator();
            MemoryProfileCompositeConsumer compositeConsumer = new MemoryProfileCompositeConsumer((Consumer)outputFileConsumer, (Consumer)accumulator);
            Consumer consumerReplacer = arg_0 -> RsValgrindConfigurationExtension.attachToProcess$lambda$0(compositeConsumer, (RsToolchainBase)toolchain2, arg_0);
            MemoryProfileFileReader fileReader = new MemoryProfileFileReader(outputFile, consumerReplacer, "Valgrind");
            handler.addProcessListener((ProcessListener)new ProcessAdapter(fileReader, compositeConsumer, this, outputFile){
                final /* synthetic */ MemoryProfileFileReader $fileReader;
                final /* synthetic */ MemoryProfileCompositeConsumer $compositeConsumer;
                final /* synthetic */ RsValgrindConfigurationExtension this$0;
                final /* synthetic */ File $outputFile;
                {
                    this.$fileReader = $fileReader;
                    this.$compositeConsumer = $compositeConsumer;
                    this.this$0 = $receiver;
                    this.$outputFile = $outputFile;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void processTerminated(ProcessEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    try {
                        this.$fileReader.stop();
                        Disposer.dispose((Disposable)((Disposable)this.$compositeConsumer));
                        RsValgrindConfigurationExtension.access$deleteFile(this.this$0, this.$outputFile);
                    }
                    finally {
                        this.$fileReader.close();
                    }
                }
            });
            Project project2 = configuration.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            this.configureUIListeners(outputPanel, handler, accumulator, project2);
        }
        catch (IOException e) {
            RsValgrindConfigurationExtensionKt.access$getLOG$p().warn("Exception during processListener setup: " + e);
        }
    }

    private final void configureUIListeners(MemoryProfileOutputPanel outputPanel, ProcessHandler handler, MemoryProfileStringAccumulator accumulator, Project project) {
        Application application = ApplicationManager.getApplication();
        Function1 expiredCondition = arg_0 -> RsValgrindConfigurationExtension.configureUIListeners$lambda$0(project, arg_0);
        MemoryProfileTree memoryProfileTree = outputPanel.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)memoryProfileTree, (String)"getTree(...)");
        MemoryProfileTree tree = memoryProfileTree;
        handler.addProcessListener((ProcessListener)new ProcessAdapter(application, (Function1<Object, Boolean>)expiredCondition, tree, outputPanel, accumulator){
            final /* synthetic */ Application $application;
            final /* synthetic */ Function1<Object, Boolean> $expiredCondition;
            final /* synthetic */ MemoryProfileTree $tree;
            final /* synthetic */ MemoryProfileOutputPanel $outputPanel;
            final /* synthetic */ MemoryProfileStringAccumulator $accumulator;
            {
                this.$application = $application;
                this.$expiredCondition = $expiredCondition;
                this.$tree = $tree;
                this.$outputPanel = $outputPanel;
                this.$accumulator = $accumulator;
            }

            public void startNotified(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$application.invokeLater(() -> configureUIListeners.1.startNotified$lambda$0(this.$tree), arg_0 -> configureUIListeners.1.startNotified$lambda$1(this.$expiredCondition, arg_0));
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$application.invokeLater(() -> configureUIListeners.1.processTerminated$lambda$2(this.$tree, this.$outputPanel, this.$accumulator), arg_0 -> configureUIListeners.1.processTerminated$lambda$3(this.$expiredCondition, arg_0));
            }

            private static final void startNotified$lambda$0(MemoryProfileTree $tree) {
                $tree.setPaintBusy(true);
                $tree.getEmptyText().setText(CidrProfilingBundle.message((String)"valgrind.progress", (Object[])new Object[0]));
            }

            private static final boolean startNotified$lambda$1(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }

            private static final void processTerminated$lambda$2(MemoryProfileTree $tree, MemoryProfileOutputPanel $outputPanel, MemoryProfileStringAccumulator $accumulator) {
                $tree.setPaintBusy(false);
                $tree.getEmptyText().setText(StatusText.getDefaultEmptyText());
                $outputPanel.setExportContent($accumulator.toString());
            }

            private static final boolean processTerminated$lambda$3(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }
        });
    }

    private final void deleteFile(File file) {
        if (!UtilsKt.isUnitTestMode() && !UtilsKt.isInternal()) {
            FileUtil.delete((File)file);
        }
    }

    private final <T> void putUserData(Key<T> key, T value, CargoCommandConfiguration configuration, ConfigurationExtensionContext context) {
        if (Intrinsics.areEqual((Object)configuration.getUserData(RsValgrindConfigurationExtensionKt.access$getSTORE_DATA_IN_RUN_CONFIGURATION$p()), (Object)true)) {
            configuration.putUserData(key, value);
        } else {
            context.putUserData(key, value);
        }
    }

    private final <T> T getUserData(Key<T> key, CargoCommandConfiguration configuration, ConfigurationExtensionContext context) {
        return (T)(Intrinsics.areEqual((Object)configuration.getUserData(RsValgrindConfigurationExtensionKt.access$getSTORE_DATA_IN_RUN_CONFIGURATION$p()), (Object)true) ? configuration.getUserData(key) : context.getUserData(key));
    }

    private static final void attachToProcess$lambda$0(MemoryProfileCompositeConsumer $compositeConsumer, RsToolchainBase $toolchain, String string) {
        Intrinsics.checkNotNull((Object)string);
        CharSequence charSequence = string;
        Regex regex = RsValgrindConfigurationExtensionKt.access$getTAG_RE$p();
        Function1 function1 = arg_0 -> RsValgrindConfigurationExtension.attachToProcess$lambda$0$0($toolchain, arg_0);
        String replaced = regex.replace(charSequence, function1);
        $compositeConsumer.consume(replaced);
    }

    private static final CharSequence attachToProcess$lambda$0$0(RsToolchainBase $toolchain, MatchResult it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        MatchResult.Destructured destructured = it2.getDestructured();
        String tag = (String)destructured.getMatch().getGroupValues().get(1);
        String value = (String)destructured.getMatch().getGroupValues().get(2);
        return "<" + tag + ">" + $toolchain.toLocalPath(value) + "</" + tag + ">";
    }

    private static final boolean configureUIListeners$lambda$0(Project $project, Object object) {
        return !$project.isOpen() || $project.isDisposed();
    }

    public static final /* synthetic */ void access$deleteFile(RsValgrindConfigurationExtension $this, File file) {
        $this.deleteFile(file);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/valgrind/RsValgrindConfigurationExtension$Helper;", "", "<init>", "()V", "isEnabledFor", "", "configuration", "Lorg/rust/cargo/runconfig/command/CargoCommandConfiguration;", "intellij.rustrover.valgrind"})
    public static final class Helper {
        @NotNull
        public static final Helper INSTANCE = new Helper();

        private Helper() {
        }

        public final boolean isEnabledFor(@NotNull CargoCommandConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
            CargoCommandConfiguration.CleanConfiguration.Ok ok = configuration.clean().getOk();
            RsToolchainBase toolchain2 = ok != null ? ok.getToolchain() : null;
            return SystemInfo.isLinux || SystemInfo.isMac || SystemInfo.isWindows && toolchain2 instanceof RsWslToolchain;
        }
    }
}

