/*
 * Decompiled with CFR 0.152.
 */
package org.rust.util;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.QueueProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsTask;
import org.rust.RsTaskWithEmptyProgress;
import org.rust.openapiext.DelayedBackgroundableProcessIndicator;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u001e2\u00020\u0001:\u0004\u001b\u001c\u001d\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u0006\u0010\u0019\u001a\u00020\u0010J\b\u0010\u001a\u001a\u00020\u0010H\u0002R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lorg/rust/util/RsBackgroundTaskQueue;", "", "<init>", "()V", "processor", "Lcom/intellij/util/concurrency/QueueProcessor;", "Lorg/rust/util/RsBackgroundTaskQueue$ContinuableRunnable;", "kotlin.jvm.PlatformType", "isDisposed", "", "cancelableTasks", "", "Lorg/rust/util/RsBackgroundTaskQueue$BackgroundableTaskData;", "isEmpty", "()Z", "run", "", "task", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "runTaskInCurrentThread", "cancelTasks", "taskType", "Lorg/rust/RsTask$TaskType;", "onFinish", "data", "dispose", "cancelAll", "ContinuableRunnable", "QueueConsumer", "BackgroundableTaskData", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsBackgroundTaskQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsBackgroundTaskQueue.kt\norg/rust/util/RsBackgroundTaskQueue\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,189:1\n13#2:190\n*S KotlinDebug\n*F\n+ 1 RsBackgroundTaskQueue.kt\norg/rust/util/RsBackgroundTaskQueue\n*L\n186#1:190\n*E\n"})
public final class RsBackgroundTaskQueue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final QueueProcessor<ContinuableRunnable> processor = new QueueProcessor((BiConsumer)new QueueConsumer(), true, QueueProcessor.ThreadToUse.AWT, arg_0 -> RsBackgroundTaskQueue.processor$lambda$0(this, arg_0));
    private volatile boolean isDisposed;
    @NotNull
    private final List<BackgroundableTaskData> cancelableTasks = new ArrayList();
    @NotNull
    private static final Logger LOG;

    public final boolean isEmpty() {
        return this.processor.isEmpty();
    }

    public final synchronized void run(@NotNull Task.Backgroundable task2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        if (UtilsKt.isUnitTestMode() && task2 instanceof RsTask && ((RsTask)task2).getRunSyncInUnitTests()) {
            this.runTaskInCurrentThread(task2);
        } else {
            LOG.debug("Scheduling task " + task2);
            if (task2 instanceof RsTask) {
                this.cancelTasks(((RsTask)task2).getTaskType());
            }
            BackgroundableTaskData data2 = new BackgroundableTaskData(task2, (Function1<? super BackgroundableTaskData, Unit>)((Function1)new Function1<BackgroundableTaskData, Unit>((Object)this){

                public final void invoke(BackgroundableTaskData p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    RsBackgroundTaskQueue.access$onFinish((RsBackgroundTaskQueue)this.receiver, p0);
                }
            }));
            ((Collection)this.cancelableTasks).add(data2);
            this.processor.add((Object)data2);
        }
    }

    private final void runTaskInCurrentThread(Task.Backgroundable task2) {
        if (!UtilsKt.isUnitTestMode()) {
            throw new IllegalStateException("Check failed.");
        }
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNull((Object)progressManager, (String)"null cannot be cast to non-null type com.intellij.openapi.progress.impl.ProgressManagerImpl");
        ProgressManagerImpl pm = (ProgressManagerImpl)progressManager;
        pm.runProcessWithProgressInCurrentThread((Task)task2, (ProgressIndicator)new EmptyProgressIndicator(), ModalityState.nonModal());
    }

    public final synchronized void cancelTasks(@NotNull RsTask.TaskType taskType) {
        Intrinsics.checkNotNullParameter((Object)((Object)taskType), (String)"taskType");
        this.cancelableTasks.removeIf(arg_0 -> RsBackgroundTaskQueue.cancelTasks$lambda$1(arg_0 -> RsBackgroundTaskQueue.cancelTasks$lambda$0(taskType, arg_0), arg_0));
    }

    private final synchronized void onFinish(BackgroundableTaskData data2) {
        this.cancelableTasks.remove(data2);
    }

    public final void dispose() {
        this.isDisposed = true;
        this.processor.clear();
        this.cancelAll();
    }

    private final synchronized void cancelAll() {
        for (BackgroundableTaskData task2 : this.cancelableTasks) {
            task2.cancel();
        }
        this.cancelableTasks.clear();
    }

    private static final boolean processor$lambda$0(RsBackgroundTaskQueue this$0, Object it2) {
        return this$0.isDisposed;
    }

    private static final boolean cancelTasks$lambda$0(RsTask.TaskType $taskType, BackgroundableTaskData data2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (data2.getTask() instanceof RsTask && $taskType.canCancelOther(((RsTask)data2.getTask()).getTaskType())) {
            data2.cancel();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean cancelTasks$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$onFinish(RsBackgroundTaskQueue $this, BackgroundableTaskData data2) {
        $this.onFinish(data2);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RsBackgroundTaskQueue.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/rust/util/RsBackgroundTaskQueue$BackgroundableTaskData;", "Lorg/rust/util/RsBackgroundTaskQueue$ContinuableRunnable;", "task", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "onFinish", "Lkotlin/Function1;", "", "<init>", "(Lcom/intellij/openapi/progress/Task$Backgroundable;Lkotlin/jvm/functions/Function1;)V", "getTask", "()Lcom/intellij/openapi/progress/Task$Backgroundable;", "getOnFinish", "()Lkotlin/jvm/functions/Function1;", "state", "Lorg/rust/util/RsBackgroundTaskQueue$BackgroundableTaskData$State;", "run", "continuation", "Ljava/lang/Runnable;", "cancel", "State", "intellij.rustrover.core"})
    private static final class BackgroundableTaskData
    implements ContinuableRunnable {
        @NotNull
        private final Task.Backgroundable task;
        @NotNull
        private final Function1<BackgroundableTaskData, Unit> onFinish;
        @NotNull
        private State state;

        public BackgroundableTaskData(@NotNull Task.Backgroundable task2, @NotNull Function1<? super BackgroundableTaskData, Unit> onFinish) {
            Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
            Intrinsics.checkNotNullParameter(onFinish, (String)"onFinish");
            this.task = task2;
            this.onFinish = onFinish;
            this.state = State.Pending.INSTANCE;
        }

        @NotNull
        public final Task.Backgroundable getTask() {
            return this.task;
        }

        @NotNull
        public final Function1<BackgroundableTaskData, Unit> getOnFinish() {
            return this.onFinish;
        }

        @Override
        public synchronized void run(@NotNull Runnable continuation) {
            Intrinsics.checkNotNullParameter((Object)continuation, (String)"continuation");
            UtilsKt.checkIsDispatchThread();
            State state = this.state;
            if (Intrinsics.areEqual((Object)state, (Object)State.CanceledContinued.INSTANCE)) {
                return;
            }
            if (Intrinsics.areEqual((Object)state, (Object)State.Canceled.INSTANCE)) {
                continuation.run();
                return;
            }
            if (state instanceof State.Running) {
                throw new IllegalStateException("Trying to re-run already running task".toString());
            }
            if (this.task instanceof RsTask && ((RsTask)this.task).getWaitForSmartMode()) {
                Project project = ((Task)this.task).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (DumbService.Companion.isDumb(project)) {
                    if (!(!(this.state instanceof State.WaitForSmartMode))) {
                        throw new IllegalStateException("Check failed.");
                    }
                    this.state = new State.WaitForSmartMode(continuation);
                    Project project2 = ((Task)this.task).getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                    DumbService.Companion.getInstance(project2).runWhenSmart(() -> BackgroundableTaskData.run$lambda$0(this, continuation));
                    return;
                }
            }
            StandardProgressIndicator indicator = UtilsKt.isHeadlessEnvironment() || this.task instanceof RsTaskWithEmptyProgress ? (StandardProgressIndicator)new EmptyProgressIndicator() : (this.task instanceof RsTask && ((RsTask)this.task).getProgressBarShowDelay() > 0 ? (StandardProgressIndicator)new DelayedBackgroundableProcessIndicator(this.task, ((RsTask)this.task).getProgressBarShowDelay()) : (StandardProgressIndicator)new BackgroundableProcessIndicator(this.task));
            this.state = new State.Running((ProgressIndicator)indicator);
            ProgressManager progressManager = ProgressManager.getInstance();
            Intrinsics.checkNotNull((Object)progressManager, (String)"null cannot be cast to non-null type com.intellij.openapi.progress.impl.ProgressManagerImpl");
            ProgressManagerImpl pm = (ProgressManagerImpl)progressManager;
            pm.runProcessWithProgressAsynchronously(this.task, (ProgressIndicator)indicator, () -> BackgroundableTaskData.run$lambda$1(this, continuation), ModalityState.nonModal());
        }

        public final synchronized void cancel() {
            State state = this.state;
            if (Intrinsics.areEqual((Object)state, (Object)State.Pending.INSTANCE)) {
                this.state = State.Canceled.INSTANCE;
            } else if (state instanceof State.Running) {
                ((State.Running)state).getIndicator().cancel();
            } else if (state instanceof State.WaitForSmartMode) {
                this.state = State.CanceledContinued.INSTANCE;
                ((State.WaitForSmartMode)state).getContinuation().run();
            } else if (!Intrinsics.areEqual((Object)state, (Object)State.Canceled.INSTANCE) && !Intrinsics.areEqual((Object)state, (Object)State.CanceledContinued.INSTANCE)) {
                throw new NoWhenBranchMatchedException();
            }
        }

        private static final void run$lambda$0(BackgroundableTaskData this$0, Runnable $continuation) {
            this$0.run($continuation);
        }

        private static final void run$lambda$1(BackgroundableTaskData this$0, Runnable $continuation) {
            this$0.onFinish.invoke((Object)this$0);
            $continuation.run();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0005\u0004\u0005\u0006\u0007\bB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0005\t\n\u000b\f\r\u00a8\u0006\u000e"}, d2={"Lorg/rust/util/RsBackgroundTaskQueue$BackgroundableTaskData$State;", "", "<init>", "()V", "Pending", "WaitForSmartMode", "Canceled", "CanceledContinued", "Running", "Lorg/rust/util/RsBackgroundTaskQueue$BackgroundableTaskData$State$Canceled;", "Lorg/rust/util/RsBackgroundTaskQueue$BackgroundableTaskData$State$CanceledContinued;", "Lorg/rust/util/RsBackgroundTaskQueue$BackgroundableTaskData$State$Pending;", "Lorg/rust/util/RsBackgroundTaskQueue$BackgroundableTaskData$State$Running;", "Lorg/rust/util/RsBackgroundTaskQueue$BackgroundableTaskData$State$WaitForSmartMode;", "intellij.rustrover.core"})
        private static abstract sealed class State {
            private State() {
            }

            public /* synthetic */ State(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/rust/util/RsBackgroundTaskQueue$BackgroundableTaskData$State$Canceled;", "Lorg/rust/util/RsBackgroundTaskQueue$BackgroundableTaskData$State;", "<init>", "()V", "intellij.rustrover.core"})
            public static final class Canceled
            extends State {
                @NotNull
                public static final Canceled INSTANCE = new Canceled();

                private Canceled() {
                    super(null);
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/rust/util/RsBackgroundTaskQueue$BackgroundableTaskData$State$CanceledContinued;", "Lorg/rust/util/RsBackgroundTaskQueue$BackgroundableTaskData$State;", "<init>", "()V", "intellij.rustrover.core"})
            public static final class CanceledContinued
            extends State {
                @NotNull
                public static final CanceledContinued INSTANCE = new CanceledContinued();

                private CanceledContinued() {
                    super(null);
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/rust/util/RsBackgroundTaskQueue$BackgroundableTaskData$State$Pending;", "Lorg/rust/util/RsBackgroundTaskQueue$BackgroundableTaskData$State;", "<init>", "()V", "intellij.rustrover.core"})
            public static final class Pending
            extends State {
                @NotNull
                public static final Pending INSTANCE = new Pending();

                private Pending() {
                    super(null);
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/rust/util/RsBackgroundTaskQueue$BackgroundableTaskData$State$Running;", "Lorg/rust/util/RsBackgroundTaskQueue$BackgroundableTaskData$State;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "<init>", "(Lcom/intellij/openapi/progress/ProgressIndicator;)V", "getIndicator", "()Lcom/intellij/openapi/progress/ProgressIndicator;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
            public static final class Running
            extends State {
                @NotNull
                private final ProgressIndicator indicator;

                public Running(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    super(null);
                    this.indicator = indicator;
                }

                @NotNull
                public final ProgressIndicator getIndicator() {
                    return this.indicator;
                }

                @NotNull
                public final ProgressIndicator component1() {
                    return this.indicator;
                }

                @NotNull
                public final Running copy(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    return new Running(indicator);
                }

                public static /* synthetic */ Running copy$default(Running running, ProgressIndicator progressIndicator, int n, Object object) {
                    if ((n & 1) != 0) {
                        progressIndicator = running.indicator;
                    }
                    return running.copy(progressIndicator);
                }

                @NotNull
                public String toString() {
                    return "Running(indicator=" + this.indicator + ")";
                }

                public int hashCode() {
                    return this.indicator.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Running)) {
                        return false;
                    }
                    Running running = (Running)other;
                    return Intrinsics.areEqual((Object)this.indicator, (Object)running.indicator);
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/rust/util/RsBackgroundTaskQueue$BackgroundableTaskData$State$WaitForSmartMode;", "Lorg/rust/util/RsBackgroundTaskQueue$BackgroundableTaskData$State;", "continuation", "Ljava/lang/Runnable;", "<init>", "(Ljava/lang/Runnable;)V", "getContinuation", "()Ljava/lang/Runnable;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
            public static final class WaitForSmartMode
            extends State {
                @NotNull
                private final Runnable continuation;

                public WaitForSmartMode(@NotNull Runnable continuation) {
                    Intrinsics.checkNotNullParameter((Object)continuation, (String)"continuation");
                    super(null);
                    this.continuation = continuation;
                }

                @NotNull
                public final Runnable getContinuation() {
                    return this.continuation;
                }

                @NotNull
                public final Runnable component1() {
                    return this.continuation;
                }

                @NotNull
                public final WaitForSmartMode copy(@NotNull Runnable continuation) {
                    Intrinsics.checkNotNullParameter((Object)continuation, (String)"continuation");
                    return new WaitForSmartMode(continuation);
                }

                public static /* synthetic */ WaitForSmartMode copy$default(WaitForSmartMode waitForSmartMode, Runnable runnable, int n, Object object) {
                    if ((n & 1) != 0) {
                        runnable = waitForSmartMode.continuation;
                    }
                    return waitForSmartMode.copy(runnable);
                }

                @NotNull
                public String toString() {
                    return "WaitForSmartMode(continuation=" + this.continuation + ")";
                }

                public int hashCode() {
                    return this.continuation.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof WaitForSmartMode)) {
                        return false;
                    }
                    WaitForSmartMode waitForSmartMode = (WaitForSmartMode)other;
                    return Intrinsics.areEqual((Object)this.continuation, (Object)waitForSmartMode.continuation);
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/rust/util/RsBackgroundTaskQueue$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lorg/rust/util/RsBackgroundTaskQueue$ContinuableRunnable;", "", "run", "", "continuation", "Ljava/lang/Runnable;", "intellij.rustrover.core"})
    private static interface ContinuableRunnable {
        public void run(@NotNull Runnable var1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0003H\u0016\u00a8\u0006\n"}, d2={"Lorg/rust/util/RsBackgroundTaskQueue$QueueConsumer;", "Ljava/util/function/BiConsumer;", "Lorg/rust/util/RsBackgroundTaskQueue$ContinuableRunnable;", "Ljava/lang/Runnable;", "<init>", "()V", "accept", "", "t", "u", "intellij.rustrover.core"})
    private static final class QueueConsumer
    implements BiConsumer<ContinuableRunnable, Runnable> {
        @Override
        public void accept(@NotNull ContinuableRunnable t, @NotNull Runnable u) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            Intrinsics.checkNotNullParameter((Object)u, (String)"u");
            t.run(u);
        }
    }
}

