/*
 * Decompiled with CFR 0.152.
 */
package org.rust.toml.resolve;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.rust.toml.UtilKt;
import org.rust.toml.resolve.CargoTomlNameResolutionKt;
import org.toml.lang.psi.TomlElement;
import org.toml.lang.psi.TomlFile;
import org.toml.lang.psi.TomlLiteral;
import org.toml.lang.psi.ext.TomlLiteralKind;
import org.toml.lang.psi.ext.TomlLiteralKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/rust/toml/resolve/CargoTomlFeatureDependencyReference;", "Lcom/intellij/psi/PsiPolyVariantReferenceBase;", "Lorg/toml/lang/psi/TomlLiteral;", "element", "<init>", "(Lorg/toml/lang/psi/TomlLiteral;)V", "multiResolve", "", "Lcom/intellij/psi/ResolveResult;", "incompleteCode", "", "(Z)[Lcom/intellij/psi/ResolveResult;", "handleElementRename", "Lcom/intellij/psi/PsiElement;", "newElementName", "", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCargoTomlFeatureDependencyReferenceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CargoTomlFeatureDependencyReferenceProvider.kt\norg/rust/toml/resolve/CargoTomlFeatureDependencyReference\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
final class CargoTomlFeatureDependencyReference
extends PsiPolyVariantReferenceBase<TomlLiteral> {
    public CargoTomlFeatureDependencyReference(@NotNull TomlLiteral element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element);
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray;
        PsiElement psiElement2 = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElement(...)");
        TomlLiteral element = (TomlLiteral)psiElement2;
        TomlLiteralKind tomlLiteralKind = TomlLiteralKt.getKind((TomlLiteral)element);
        Object object = tomlLiteralKind instanceof TomlLiteralKind.String ? (TomlLiteralKind.String)tomlLiteralKind : null;
        if (object == null || (object = object.getValue()) == null) {
            Intrinsics.checkNotNullExpressionValue((Object)ResolveResult.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ResolveResult.EMPTY_ARRAY;
        }
        Object literalValue = object;
        if (StringsKt.contains$default((CharSequence)((CharSequence)literalValue), (CharSequence)"/", (boolean)false, (int)2, null)) {
            Object object2 = new String[]{"/"};
            Object it2 = object2 = StringsKt.split$default((CharSequence)((CharSequence)literalValue), (String[])object2, (boolean)false, (int)2, (int)2, null);
            boolean bl = false;
            Object object3 = it2.size() == 2 ? object2 : null;
            if (object3 == null) {
                Intrinsics.checkNotNullExpressionValue((Object)ResolveResult.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return ResolveResult.EMPTY_ARRAY;
            }
            Object object4 = object3;
            String firstSegment = (String)object4.get(0);
            String featureName = (String)object4.get(1);
            String depName = StringsKt.removeSuffix((String)firstSegment, (CharSequence)"?");
            TomlFile tomlFile = UtilKt.findDependencyTomlFile((TomlElement)element, depName);
            if (tomlFile == null) {
                Intrinsics.checkNotNullExpressionValue((Object)ResolveResult.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return ResolveResult.EMPTY_ARRAY;
            }
            TomlFile depToml = tomlFile;
            resolveResultArray = CargoTomlNameResolutionKt.resolveFeature$default(depToml, featureName, false, 2, null);
        } else {
            boolean depOnly = StringsKt.startsWith$default((String)literalValue, (String)"dep:", (boolean)false, (int)2, null);
            PsiFile psiFile = element.getContainingFile();
            TomlFile tomlFile = psiFile instanceof TomlFile ? (TomlFile)psiFile : null;
            if (tomlFile == null) {
                Intrinsics.checkNotNullExpressionValue((Object)ResolveResult.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return ResolveResult.EMPTY_ARRAY;
            }
            TomlFile tomlFile2 = tomlFile;
            resolveResultArray = CargoTomlNameResolutionKt.resolveFeature(tomlFile2, StringsKt.removePrefix((String)literalValue, (CharSequence)"dep:"), depOnly);
        }
        return resolveResultArray;
    }

    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) {
        TextRange textRange;
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        TextRange textRange2 = this.getRangeInElement();
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"getRangeInElement(...)");
        TextRange valueRange = textRange2;
        String string = valueRange.substring(((TomlLiteral)this.getElement()).getNode().getText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String unescapedLiteralValue = string;
        int separatorIndex = StringsKt.indexOf$default((CharSequence)unescapedLiteralValue, (String)"/", (int)0, (boolean)false, (int)6, null);
        if (separatorIndex != -1) {
            textRange = new TextRange(valueRange.getStartOffset() + separatorIndex + 1, valueRange.getEndOffset());
        } else {
            TextRange textRange3 = this.getRangeInElement();
            Intrinsics.checkNotNull((Object)textRange3);
            textRange = textRange3;
        }
        TextRange range = textRange;
        ElementManipulator elementManipulator = ElementManipulators.getManipulator((PsiElement)this.getElement());
        Intrinsics.checkNotNull((Object)elementManipulator);
        PsiElement psiElement2 = elementManipulator.handleContentChange(this.myElement, range, newElementName);
        Intrinsics.checkNotNull((Object)psiElement2);
        return psiElement2;
    }
}

