/*
 * Decompiled with CFR 0.152.
 */
package org.rust.toml.jsonSchema;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.light.legacy.JsonSchemaObjectReadingUtils;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.toml.UtilKt;
import org.rust.toml.jsonSchema.RsJsonSchemaComplianceChecker;
import org.rust.toml.jsonSchema.RsTomlJsonPsiWalker;
import org.rust.toml.jsonSchema.TomlJsonSchemaBasedInspectionKt;
import org.rust.toml.jsonSchema.UtilsKt;
import org.toml.lang.psi.TomlArrayTable;
import org.toml.lang.psi.TomlFile;
import org.toml.lang.psi.TomlValue;
import org.toml.lang.psi.TomlVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/rust/toml/jsonSchema/TomlJsonSchemaBasedInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "intellij.rustrover.core"})
public final class TomlJsonSchemaBasedInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (!UtilKt.tomlPluginIsAbiCompatible()) {
            PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"buildVisitor(...)");
            return psiElementVisitor;
        }
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile file = psiFile;
        JsonSchemaService service = JsonSchemaService.Impl.get((Project)file.getProject());
        JsonComplianceCheckerOptions options = new JsonComplianceCheckerOptions(false);
        JsonSchemaObject jsonSchemaObject = service.getSchemaObject(file);
        if (jsonSchemaObject == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        JsonSchemaObject schema = jsonSchemaObject;
        return (PsiElementVisitor)new TomlVisitor(schema, holder, session2, options){
            final /* synthetic */ JsonSchemaObject $schema;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ LocalInspectionToolSession $session;
            final /* synthetic */ JsonComplianceCheckerOptions $options;
            {
                this.$schema = $schema;
                this.$holder = $holder;
                this.$session = $session;
                this.$options = $options;
            }

            public void visitValue(TomlValue element) {
                String format;
                JsonSchemaObject formatSchema;
                Object v3;
                Object[] objectArray;
                block4: {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    JsonLikePsiWalker jsonLikePsiWalker = JsonLikePsiWalker.getWalker((PsiElement)((PsiElement)element), (JsonSchemaObject)this.$schema);
                    if (jsonLikePsiWalker == null) {
                        return;
                    }
                    JsonLikePsiWalker walker = jsonLikePsiWalker;
                    JsonPointerPosition jsonPointerPosition = walker.findPosition((PsiElement)element, true);
                    if (jsonPointerPosition == null) {
                        return;
                    }
                    JsonPointerPosition position = jsonPointerPosition;
                    Collection collection = new JsonSchemaResolver(element.getProject(), this.$schema, position).resolve();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"resolve(...)");
                    Collection schemas = collection;
                    objectArray = (Object[])schemas;
                    for (T t : objectArray) {
                        JsonSchemaObject it2 = (JsonSchemaObject)t;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it2);
                        if (!(UtilsKt.guessJsonObjectType(it2) == UtilsKt.correspondingJsonSchemaType(element))) continue;
                        v3 = t;
                        break block4;
                    }
                    v3 = null;
                }
                JsonSchemaObject jsonSchemaObject = formatSchema = (JsonSchemaObject)v3;
                String string = format = jsonSchemaObject != null ? jsonSchemaObject.getFormat() : null;
                if (formatSchema != null && format != null && !TomlJsonSchemaBasedInspectionKt.access$hasCorrectFormat(element, format)) {
                    objectArray = new Object[]{format};
                    this.$holder.registerProblem((PsiElement)element, RsBundle.INSTANCE.message("inspection.message.invalid.json.schema.format", objectArray), new LocalQuickFix[0]);
                }
            }

            public void visitFile(PsiFile psiFile) {
                Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
                if (psiFile instanceof TomlFile) {
                    JsonLikePsiWalker jsonLikePsiWalker = JsonLikePsiWalker.getWalker((PsiElement)((PsiElement)psiFile), (JsonSchemaObject)this.$schema);
                    RsTomlJsonPsiWalker rsTomlJsonPsiWalker = jsonLikePsiWalker instanceof RsTomlJsonPsiWalker ? (RsTomlJsonPsiWalker)jsonLikePsiWalker : null;
                    if (rsTomlJsonPsiWalker == null) {
                        return;
                    }
                    RsTomlJsonPsiWalker walker = rsTomlJsonPsiWalker;
                    new RsJsonSchemaComplianceChecker(this.$schema, this.$holder, walker, this.$session, this.$options).checkRoot((TomlFile)psiFile);
                }
            }

            public void visitArrayTable(TomlArrayTable element) {
                boolean shouldHighlight;
                boolean bl;
                Collection<E> schemas;
                block8: {
                    Collection<E> collection;
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    JsonLikePsiWalker jsonLikePsiWalker = JsonLikePsiWalker.getWalker((PsiElement)((PsiElement)element), (JsonSchemaObject)this.$schema);
                    if (jsonLikePsiWalker == null) {
                        return;
                    }
                    JsonLikePsiWalker walker = jsonLikePsiWalker;
                    JsonPointerPosition jsonPointerPosition = walker.findPosition((PsiElement)element, true);
                    if (jsonPointerPosition == null) {
                        return;
                    }
                    JsonPointerPosition position = jsonPointerPosition;
                    Collection<E> it2 = collection = new JsonSchemaResolver(element.getProject(), this.$schema, position).resolve();
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it2);
                    Collection<E> collection2 = !it2.isEmpty() ? collection : null;
                    if (collection2 == null) {
                        return;
                    }
                    schemas = collection2;
                    Iterable $this$any$iv = schemas;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            JsonSchemaObject it3 = (JsonSchemaObject)element$iv;
                            boolean bl3 = false;
                            if (!(it3.getType() == JsonSchemaType._object)) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                boolean bl4 = shouldHighlight = !bl;
                if (shouldHighlight) {
                    String string = JsonSchemaObjectReadingUtils.getTypeDescription((JsonSchemaObject)((JsonSchemaObject)CollectionsKt.first((Iterable)schemas)), (boolean)true);
                    if (string == null) {
                        string = "";
                    }
                    String type = string;
                    Object[] objectArray = new Object[]{type};
                    this.$holder.registerProblem((PsiElement)element.getHeader(), RsBundle.INSTANCE.message("inspection.message.json.schema.invalid.type.map", objectArray), new LocalQuickFix[0]);
                }
            }
        };
    }
}

