/*
 * Decompiled with CFR 0.152.
 */
package org.rust.toml.jsonSchema;

import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaDocumentationProvider;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.light.legacy.JsonSchemaObjectReadingUtils;
import com.jetbrains.jsonSchema.impl.light.nodes.JsonSchemaObjectBackedByJacksonBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.toml.completion.ArrayTableInsertHandler;
import org.rust.toml.jsonSchema.RsTomlJsonSchemaCompletionProviderKt;
import org.rust.toml.jsonSchema.UtilsKt;
import org.toml.lang.psi.TomlKeyValue;
import org.toml.lang.psi.TomlLiteral;
import org.toml.lang.psi.TomlTableHeader;
import org.toml.lang.psi.TomlValue;
import org.toml.lang.psi.ext.TomlLiteralKind;
import org.toml.lang.psi.ext.TomlLiteralKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0002\u000b\fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lorg/rust/toml/jsonSchema/RsTomlJsonSchemaCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "fillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "Worker", "Companion", "intellij.rustrover.core"})
public final class RsTomlJsonSchemaCompletionProvider
extends CompletionContributor
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final double LOW_PRIORITY = -1000.0;

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        PsiElement psiElement2 = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getPosition(...)");
        PsiElement position = psiElement2;
        JsonSchemaService jsonSchemaService = JsonSchemaService.Impl.get((Project)position.getProject());
        JsonSchemaObject jsonSchemaObject = jsonSchemaService.getSchemaObject(parameters.getOriginalFile());
        if (jsonSchemaObject != null) {
            PsiElement psiElement3 = parameters.getOriginalPosition();
            if (psiElement3 == null) {
                PsiElement psiElement4 = parameters.getPosition();
                psiElement3 = psiElement4;
                Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"getPosition(...)");
            }
            PsiElement completionPosition = psiElement3;
            PsiElement psiElement5 = parameters.getPosition();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement5, (String)"getPosition(...)");
            Worker worker = new Worker(jsonSchemaObject, psiElement5, completionPosition, (Consumer<LookupElement>)((Consumer)result2));
            worker.work();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/rust/toml/jsonSchema/RsTomlJsonSchemaCompletionProvider$Companion;", "", "<init>", "()V", "LOW_PRIORITY", "", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0014\u001a\u00020\u0015J2\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\r2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u001a\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00032\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\"\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u00032\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0018\u0010$\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0013H\u0002J\u0018\u0010&\u001a\b\u0012\u0004\u0012\u00020\t0'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J\f\u0010*\u001a\u00020\t*\u00020+H\u0002J\u0017\u0010,\u001a\u00070-\u00a2\u0006\u0002\b.2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006/"}, d2={"Lorg/rust/toml/jsonSchema/RsTomlJsonSchemaCompletionProvider$Worker;", "", "rootSchema", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaObject;", "position", "Lcom/intellij/psi/PsiElement;", "originalPosition", "resultConsumer", "Lcom/intellij/util/Consumer;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "<init>", "(Lcom/jetbrains/jsonSchema/impl/JsonSchemaObject;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/util/Consumer;)V", "variants", "", "walker", "Lcom/jetbrains/jsonSchema/extension/JsonLikePsiWalker;", "project", "Lcom/intellij/openapi/project/Project;", "isInHeader", "", "work", "", "addAllPropertyVariants", "schema", "adapter", "Lcom/jetbrains/jsonSchema/extension/adapters/JsonPropertyAdapter;", "knownNames", "", "propertyValue", "Lorg/toml/lang/psi/TomlValue;", "addPropertyNameSchemaVariants", "addPropertyVariant", "key", "jsonSchemaObject", "isInsideStringLiteral", "()Z", "suggestValues", "isSurelyValue", "suggestValuesByType", "", "type", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaType;", "toLowPriorityElement", "Lcom/intellij/codeInsight/lookup/LookupElementBuilder;", "getIconForType", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nRsTomlJsonSchemaCompletionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsTomlJsonSchemaCompletionProvider.kt\norg/rust/toml/jsonSchema/RsTomlJsonSchemaCompletionProvider$Worker\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,284:1\n66#2,2:285\n66#2,2:287\n1#3:289\n1563#4:290\n1634#4,3:291\n*S KotlinDebug\n*F\n+ 1 RsTomlJsonSchemaCompletionProvider.kt\norg/rust/toml/jsonSchema/RsTomlJsonSchemaCompletionProvider$Worker\n*L\n62#1:285,2\n71#1:287,2\n195#1:290\n195#1:291,3\n*E\n"})
    private static final class Worker {
        @NotNull
        private final JsonSchemaObject rootSchema;
        @NotNull
        private final PsiElement position;
        @NotNull
        private final PsiElement originalPosition;
        @NotNull
        private final Consumer<LookupElement> resultConsumer;
        @NotNull
        private final Set<LookupElement> variants;
        @Nullable
        private final JsonLikePsiWalker walker;
        @NotNull
        private final Project project;
        private final boolean isInHeader;

        public Worker(@NotNull JsonSchemaObject rootSchema, @NotNull PsiElement position, @NotNull PsiElement originalPosition, @NotNull Consumer<LookupElement> resultConsumer) {
            Intrinsics.checkNotNullParameter((Object)rootSchema, (String)"rootSchema");
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)originalPosition, (String)"originalPosition");
            Intrinsics.checkNotNullParameter(resultConsumer, (String)"resultConsumer");
            this.rootSchema = rootSchema;
            this.position = position;
            this.originalPosition = originalPosition;
            this.resultConsumer = resultConsumer;
            this.variants = new LinkedHashSet();
            this.walker = JsonLikePsiWalker.getWalker((PsiElement)this.position, (JsonSchemaObject)this.rootSchema);
            Project project = this.originalPosition.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            this.project = project;
            PsiElement $this$parentOfType_u24default$iv = this.originalPosition;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            this.isInHeader = PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, TomlTableHeader.class, (boolean)true) != null;
        }

        public final void work() {
            JsonLikePsiWalker jsonLikePsiWalker = this.walker;
            if (jsonLikePsiWalker == null || (jsonLikePsiWalker = jsonLikePsiWalker.findElementToCheck(this.position)) == null) {
                return;
            }
            JsonLikePsiWalker checkable = jsonLikePsiWalker;
            boolean isPropertyAllowed = RsTomlJsonSchemaCompletionProviderKt.access$isPropertyAllowed((PsiElement)checkable);
            ThreeState isName = this.walker.isName((PsiElement)checkable);
            JsonPointerPosition pointerPosition = this.walker.findPosition((PsiElement)checkable, isName == ThreeState.NO);
            if (pointerPosition == null || pointerPosition.isEmpty() && isName == ThreeState.NO) {
                return;
            }
            PsiElement $this$parentOfType_u24default$iv = this.position;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            TomlKeyValue parent2 = (TomlKeyValue)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, TomlKeyValue.class, (boolean)true);
            TomlValue propertyValue = parent2 != null && Intrinsics.areEqual((Object)parent2.getKey(), (Object)checkable.getParent()) ? parent2.getValue() : null;
            Collection collection = new JsonSchemaResolver(this.project, this.rootSchema, pointerPosition).resolve();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"resolve(...)");
            Collection schemas = collection;
            HashSet knownNames = new HashSet();
            for (JsonSchemaObject schema : schemas) {
                if (isName != ThreeState.NO && isPropertyAllowed) {
                    JsonPropertyAdapter adapter = this.walker.getParentPropertyAdapter((PsiElement)checkable);
                    Intrinsics.checkNotNull((Object)schema);
                    this.addAllPropertyVariants(schema, adapter, knownNames, propertyValue);
                    this.addPropertyNameSchemaVariants(schema, propertyValue);
                }
                if (isName == ThreeState.YES) continue;
                Intrinsics.checkNotNull((Object)schema);
                this.suggestValues(schema, isName == ThreeState.NO);
            }
            for (LookupElement variant : this.variants) {
                this.resultConsumer.consume((Object)variant);
            }
        }

        private final void addAllPropertyVariants(JsonSchemaObject schema, JsonPropertyAdapter adapter, Set<String> knownNames, TomlValue propertyValue) {
            StreamEx variants = (StreamEx)StreamEx.of((Iterator)schema.getPropertyNames()).filter(arg_0 -> Worker.addAllPropertyVariants$lambda$1(arg_0 -> Worker.addAllPropertyVariants$lambda$0(schema, knownNames, adapter, arg_0), arg_0));
            Iterator iterator2 = variants.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"iterator(...)");
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Collection resolvedSchemas;
                JsonSchemaObject jsonSchemaObject;
                String variant = (String)iterator3.next();
                Intrinsics.checkNotNull((Object)variant);
                knownNames.add(variant);
                if (schema.getPropertyByName(variant) == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)new JsonSchemaResolver(this.project, jsonSchemaObject, new JsonPointerPosition()).resolve(), (String)"resolve(...)");
                if (this.isInHeader) {
                    JsonSchemaObject headerValidSchema;
                    Object v1;
                    block3: {
                        Iterable iterable = resolvedSchemas;
                        for (Object t : iterable) {
                            JsonSchemaObject it2 = (JsonSchemaObject)t;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)it2);
                            if (!RsTomlJsonSchemaCompletionProviderKt.access$isCompound(it2, this.project)) continue;
                            v1 = t;
                            break block3;
                        }
                        v1 = null;
                    }
                    if ((JsonSchemaObject)v1 == null) continue;
                    this.addPropertyVariant(variant, headerValidSchema, propertyValue);
                    continue;
                }
                JsonSchemaObject jsonSchemaObject2 = (JsonSchemaObject)CollectionsKt.firstOrNull((Iterable)resolvedSchemas);
                if (jsonSchemaObject2 == null) continue;
                this.addPropertyVariant(variant, jsonSchemaObject2, propertyValue);
            }
        }

        private final void addPropertyNameSchemaVariants(JsonSchemaObject schema, TomlValue propertyValue) {
            Collection collection = new JsonSchemaResolver(this.project, schema, new JsonPointerPosition()).resolve();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"resolve(...)");
            JsonSchemaObject jsonSchemaObject = (JsonSchemaObject)CollectionsKt.firstOrNull((Iterable)collection);
            if (jsonSchemaObject == null) {
                return;
            }
            JsonSchemaObject resolvedSchema = jsonSchemaObject;
            Object object = resolvedSchema.getPropertyNamesSchema();
            if (object == null || (object = object.getEnum()) == null) {
                return;
            }
            Object anEnum = object;
            Iterator iterator2 = anEnum.iterator();
            while (iterator2.hasNext()) {
                Object variant = iterator2.next();
                if (!(variant instanceof String)) continue;
                this.addPropertyVariant(StringsKt.replace$default((String)((String)variant), (String)"\"", (String)"", (boolean)false, (int)4, null), schema, propertyValue);
            }
        }

        private final void addPropertyVariant(String key, JsonSchemaObject jsonSchemaObject, TomlValue propertyValue) {
            Object object;
            String string = JsonSchemaObjectReadingUtils.getTypeDescription((JsonSchemaObject)jsonSchemaObject, (boolean)true);
            if (string == null) {
                string = "";
            }
            String typeDescription = string;
            JsonSchemaType type = UtilsKt.guessJsonObjectType(jsonSchemaObject);
            LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)key).withTypeText(typeDescription).withIcon(this.getIconForType(type));
            Worker worker = this;
            boolean bl = false;
            if (this.isInHeader) {
                object = type == JsonSchemaType._array ? it.withInsertHandler((InsertHandler)new ArrayTableInsertHandler()) : it;
            } else {
                Intrinsics.checkNotNull((Object)it);
                object = RsTomlJsonSchemaCompletionProviderKt.access$withTypeAwareInsertHandler((LookupElementBuilder)it, propertyValue, jsonSchemaObject, this.originalPosition);
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"let(...)");
            LookupElement lookupElement = worker.toLowPriorityElement((LookupElementBuilder)object);
            this.variants.add(lookupElement);
        }

        private final boolean isInsideStringLiteral() {
            PsiElement psiElement2 = this.position.getParent();
            TomlLiteral tomlLiteral = psiElement2 instanceof TomlLiteral ? (TomlLiteral)psiElement2 : null;
            return (tomlLiteral != null ? TomlLiteralKt.getKind((TomlLiteral)tomlLiteral) : null) instanceof TomlLiteralKind.String;
        }

        /*
         * WARNING - void declaration
         */
        private final void suggestValues(JsonSchemaObject schema, boolean isSurelyValue) {
            List enumVariants = schema.getEnum();
            if (enumVariants != null) {
                String description = JsonSchemaDocumentationProvider.getBestDocumentation((boolean)false, (JsonSchemaObject)schema);
                for (Object o : enumVariants) {
                    void $this$suggestValues_u24lambda_u240;
                    if (this.isInsideStringLiteral() && !(o instanceof String)) continue;
                    String string = this.isInsideStringLiteral() ? StringUtil.unquoteString((String)o.toString()) : o.toString();
                    Intrinsics.checkNotNull((Object)string);
                    String variant = string;
                    LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)variant);
                    Set<LookupElement> set = this.variants;
                    boolean bl = false;
                    Object object = description != null ? $this$suggestValues_u24lambda_u240.withTailText(" " + description, true) : $this$suggestValues_u24lambda_u240;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
                    set.add((LookupElement)object);
                }
            } else if (isSurelyValue && !this.isInsideStringLiteral()) {
                this.variants.addAll((Collection<LookupElement>)this.suggestValuesByType(UtilsKt.guessJsonObjectType(schema)));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final List<LookupElement> suggestValuesByType(JsonSchemaType type) {
            List list;
            JsonSchemaType jsonSchemaType = type;
            if ((jsonSchemaType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonSchemaType.ordinal()]) == 1) {
                void $this$mapTo$iv$iv;
                Object[] objectArray = new String[]{"true", "false"};
                Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(LookupElementBuilder.create((String)it2));
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        private final LookupElement toLowPriorityElement(LookupElementBuilder $this$toLowPriorityElement) {
            LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)$this$toLowPriorityElement), (double)-1000.0);
            Intrinsics.checkNotNullExpressionValue((Object)lookupElement, (String)"withPriority(...)");
            return lookupElement;
        }

        private final Icon getIconForType(JsonSchemaType type) {
            JsonSchemaType jsonSchemaType = type;
            Icon icon = switch (jsonSchemaType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonSchemaType.ordinal()]) {
                case 2 -> AllIcons.Json.Object;
                case 3 -> AllIcons.Json.Array;
                default -> IconManager.Companion.getInstance().getPlatformIcon(PlatformIcons.Property);
            };
            Intrinsics.checkNotNull((Object)icon);
            return icon;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final boolean addAllPropertyVariants$lambda$0(JsonSchemaObject $schema, Set $knownNames, JsonPropertyAdapter $adapter, String name2) {
            JsonNode jsonNode;
            JsonNode jsonNode2;
            JsonSchemaObject jsonSchemaObject = $schema.getPropertyByName(name2);
            JsonSchemaObjectBackedByJacksonBase jsonSchemaObjectBackedByJacksonBase = jsonSchemaObject instanceof JsonSchemaObjectBackedByJacksonBase ? (JsonSchemaObjectBackedByJacksonBase)jsonSchemaObject : null;
            boolean isHidden = Boolean.parseBoolean(jsonSchemaObjectBackedByJacksonBase != null && (jsonSchemaObject = jsonSchemaObjectBackedByJacksonBase.getRawSchemaNode()) != null && (jsonNode2 = jsonSchemaObject.get("x-taplo")) != null && (jsonNode = jsonNode2.get("hidden")) != null ? jsonNode.toPrettyString() : null);
            if (!isHidden) {
                if (!$knownNames.contains(name2)) return true;
            }
            JsonPropertyAdapter jsonPropertyAdapter = $adapter;
            if (!Intrinsics.areEqual((Object)name2, (Object)(jsonPropertyAdapter != null ? jsonPropertyAdapter.getName() : null))) return false;
            return true;
        }

        private static final boolean addAllPropertyVariants$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[JsonSchemaType.values().length];
                try {
                    nArray[JsonSchemaType._boolean.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonSchemaType._object.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonSchemaType._array.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

