/*
 * Decompiled with CFR 0.152.
 */
package org.rust.toml.jsonSchema;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaAnnotatorChecker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.MatchResult;
import com.jetbrains.jsonSchema.impl.tree.JsonSchemaNodeExpansionRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.toml.jsonSchema.HighlightingData;
import org.rust.toml.jsonSchema.RsJsonSchemaComplianceCheckerKt;
import org.rust.toml.jsonSchema.RsTomlJsonPsiWalker;
import org.rust.toml.jsonSchema.adapters.RsTomlFileJsonObjectAdapter;
import org.toml.lang.psi.TomlFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/rust/toml/jsonSchema/RsJsonSchemaComplianceChecker;", "", "rootSchema", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaObject;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "walker", "Lorg/rust/toml/jsonSchema/RsTomlJsonPsiWalker;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "options", "Lcom/jetbrains/jsonSchema/impl/JsonComplianceCheckerOptions;", "<init>", "(Lcom/jetbrains/jsonSchema/impl/JsonSchemaObject;Lcom/intellij/codeInspection/ProblemsHolder;Lorg/rust/toml/jsonSchema/RsTomlJsonPsiWalker;Lcom/intellij/codeInspection/LocalInspectionToolSession;Lcom/jetbrains/jsonSchema/impl/JsonComplianceCheckerOptions;)V", "checkRoot", "", "tomlFile", "Lorg/toml/lang/psi/TomlFile;", "showHighlightings", "highlightings", "", "Lorg/rust/toml/jsonSchema/HighlightingData;", "registerError", "data", "range", "Lcom/intellij/openapi/util/TextRange;", "checkIfAlreadyProcessed", "", "property", "Lcom/intellij/psi/PsiElement;", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsJsonSchemaComplianceChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsJsonSchemaComplianceChecker.kt\norg/rust/toml/jsonSchema/RsJsonSchemaComplianceChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1#2:160\n*E\n"})
public final class RsJsonSchemaComplianceChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsonSchemaObject rootSchema;
    @NotNull
    private final ProblemsHolder holder;
    @NotNull
    private final RsTomlJsonPsiWalker walker;
    @NotNull
    private final LocalInspectionToolSession session;
    @NotNull
    private final JsonComplianceCheckerOptions options;
    @NotNull
    private static final Key<Set<PsiElement>> ANNOTATED_PROPERTIES;

    public RsJsonSchemaComplianceChecker(@NotNull JsonSchemaObject rootSchema, @NotNull ProblemsHolder holder, @NotNull RsTomlJsonPsiWalker walker, @NotNull LocalInspectionToolSession session2, @NotNull JsonComplianceCheckerOptions options) {
        Intrinsics.checkNotNullParameter((Object)rootSchema, (String)"rootSchema");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)walker, (String)"walker");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.rootSchema = rootSchema;
        this.holder = holder;
        this.walker = walker;
        this.session = session2;
        this.options = options;
    }

    public final void checkRoot(@NotNull TomlFile tomlFile) {
        List list;
        Intrinsics.checkNotNullParameter((Object)tomlFile, (String)"tomlFile");
        Project project = tomlFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        MatchResult matchResult = new JsonSchemaResolver(project2, this.rootSchema, new JsonPointerPosition(), new JsonSchemaNodeExpansionRequest(null, true)).detailedResolve();
        JsonSchemaAnnotatorChecker jsonSchemaAnnotatorChecker = JsonSchemaAnnotatorChecker.checkByMatchResult((Project)project2, (JsonValueAdapter)new RsTomlFileJsonObjectAdapter(tomlFile), (MatchResult)matchResult, (JsonComplianceCheckerOptions)this.options);
        if (jsonSchemaAnnotatorChecker == null || (list = RsJsonSchemaComplianceCheckerKt.access$collectHighlightingData(jsonSchemaAnnotatorChecker, tomlFile, this.walker)) == null) {
            return;
        }
        List errors = list;
        this.showHighlightings(errors);
    }

    private final void showHighlightings(List<HighlightingData> highlightings) {
        List ranges = new ArrayList();
        List entries2 = new ArrayList();
        for (HighlightingData entry2 : highlightings) {
            TextRange range;
            Intrinsics.checkNotNullExpressionValue((Object)this.walker.adjustErrorHighlightingRange(entry2.getElement()), (String)"adjustErrorHighlightingRange(...)");
            boolean processed = false;
            int n = ((Collection)ranges).size();
            for (int i2 = 0; i2 < n; ++i2) {
                TextRange currRange = (TextRange)ranges.get(i2);
                if (!currRange.intersects(range)) continue;
                ranges.set(i2, new TextRange(Math.min(currRange.getStartOffset(), range.getStartOffset()), Math.max(currRange.getEndOffset(), range.getEndOffset())));
                ((List)entries2.get(i2)).add(entry2);
                processed = true;
                break;
            }
            if (processed) continue;
            ranges.add(range);
            entries2.add(new SmartList((Object)entry2));
        }
        for (List entryList : entries2) {
            Comparable comparable;
            Iterator iterator2 = ((Iterable)entryList).iterator();
            if (!iterator2.hasNext()) {
                comparable = null;
            } else {
                HighlightingData it2 = (HighlightingData)iterator2.next();
                boolean bl = false;
                Comparable comparable2 = Integer.valueOf(it2.getJsonError().getPriority().ordinal());
                while (iterator2.hasNext()) {
                    HighlightingData it3 = (HighlightingData)iterator2.next();
                    $i$a$-minOfOrNull-RsJsonSchemaComplianceChecker$showHighlightings$min$1 = false;
                    Comparable comparable3 = Integer.valueOf(it3.getJsonError().getPriority().ordinal());
                    if (comparable2.compareTo(comparable3) <= 0) continue;
                    comparable2 = comparable3;
                }
                comparable = comparable2;
            }
            Integer n = (Integer)comparable;
            int min = n != null ? n : Integer.MAX_VALUE;
            for (HighlightingData data2 : entryList) {
                if (data2.getJsonError().getPriority().ordinal() > min) continue;
                TextRange textRange = this.walker.adjustErrorHighlightingRange(data2.getElement());
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"adjustErrorHighlightingRange(...)");
                TextRange range = textRange;
                TextRange textRange2 = range.shiftLeft(data2.getElement().getTextRange().getStartOffset());
                Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"shiftLeft(...)");
                range = textRange2;
                this.registerError(data2, range);
            }
        }
    }

    private final void registerError(HighlightingData data2, TextRange range) {
        if (this.checkIfAlreadyProcessed(data2.getElement())) {
            return;
        }
        String value = data2.getMessage();
        LocalQuickFix[] localQuickFixArray = data2.getJsonError().createFixes(this.walker.getSyntaxAdapter(this.holder.getProject()));
        Intrinsics.checkNotNullExpressionValue((Object)localQuickFixArray, (String)"createFixes(...)");
        LocalQuickFix[] fix = localQuickFixArray;
        PsiElement element = range.isEmpty() ? (PsiElement)data2.getElement().getContainingFile() : data2.getElement();
        if (fix.length == 0) {
            this.holder.registerProblem(element, value, data2.getSeverity(), range, new LocalQuickFix[0]);
        } else {
            this.holder.registerProblem(element, value, data2.getSeverity(), range, Arrays.copyOf(fix, fix.length));
        }
    }

    private final boolean checkIfAlreadyProcessed(PsiElement property) {
        Set data2;
        Set set = (Set)this.session.getUserData(ANNOTATED_PROPERTIES);
        if (set == null) {
            ConcurrentHashMap.KeySetView keySetView;
            ConcurrentHashMap.KeySetView $this$checkIfAlreadyProcessed_u24lambda_u240 = keySetView = ConcurrentHashMap.newKeySet();
            boolean bl = false;
            this.session.putUserData(ANNOTATED_PROPERTIES, $this$checkIfAlreadyProcessed_u24lambda_u240);
            set = keySetView;
        }
        if ((data2 = set).contains(property)) {
            return true;
        }
        data2.add(property);
        return false;
    }

    static {
        Key key = Key.create((String)"org.rust.toml.jsonSchema.ANNOTATED_PROPERTIES");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        ANNOTATED_PROPERTIES = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R-\u0010\u0004\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0007 \b*\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/rust/toml/jsonSchema/RsJsonSchemaComplianceChecker$Companion;", "", "<init>", "()V", "ANNOTATED_PROPERTIES", "Lcom/intellij/openapi/util/Key;", "", "Lcom/intellij/psi/PsiElement;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

