/*
 * Decompiled with CFR 0.152.
 */
package org.rust.toml.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.toml.UtilKt;
import org.rust.toml.intentions.RsTomlElementBaseIntentionAction;
import org.toml.lang.psi.TomlInlineTable;
import org.toml.lang.psi.TomlKeySegment;
import org.toml.lang.psi.TomlKeyValue;
import org.toml.lang.psi.TomlTable;
import org.toml.lang.psi.TomlTableHeader;
import org.toml.lang.psi.TomlValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\"\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/rust/toml/intentions/SimplifyDependencySpecificationIntention;", "Lorg/rust/toml/intentions/RsTomlElementBaseIntentionAction;", "Lorg/rust/toml/intentions/SimplifyDependencySpecificationIntention$Context;", "<init>", "()V", "getText", "", "getFamilyName", "findApplicableContextInternal", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "ctx", "Context", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nSimplifyDependencySpecificationIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimplifyDependencySpecificationIntention.kt\norg/rust/toml/intentions/SimplifyDependencySpecificationIntention\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,46:1\n80#2:47\n183#3,2:48\n*S KotlinDebug\n*F\n+ 1 SimplifyDependencySpecificationIntention.kt\norg/rust/toml/intentions/SimplifyDependencySpecificationIntention\n*L\n28#1:47\n29#1:48,2\n*E\n"})
public final class SimplifyDependencySpecificationIntention
extends RsTomlElementBaseIntentionAction<Context> {
    @NotNull
    public String getText() {
        return RsBundle.INSTANCE.message("intention.name.simplify.dependency.specification", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected Context findApplicableContextInternal(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        Object v3;
        block5: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiFile psiFile = element.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            if (!UtilKt.isCargoToml(psiFile)) {
                return null;
            }
            PsiElement $this$parentsOfType_u24default$iv = element;
            boolean withSelf$iv = true;
            boolean $i$f$parentsOfType = false;
            $this$parentsOfType_u24default$iv = PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType_u24default$iv, TomlKeyValue.class, (boolean)withSelf$iv);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TomlKeyValue it2 = (TomlKeyValue)element$iv;
                boolean bl = false;
                PsiElement psiElement2 = it2.getParent();
                TomlTable tomlTable = psiElement2 instanceof TomlTable ? (TomlTable)psiElement2 : null;
                boolean bl2 = tomlTable != null && (tomlTable = tomlTable.getHeader()) != null ? UtilKt.isDependencyListHeader((TomlTableHeader)tomlTable) : false;
                if (!bl2) continue;
                v3 = element$iv;
                break block5;
            }
            v3 = null;
        }
        TomlKeyValue tomlKeyValue = v3;
        if (tomlKeyValue == null) {
            return null;
        }
        TomlKeyValue dependency = tomlKeyValue;
        TomlValue tomlValue = dependency.getValue();
        TomlInlineTable tomlInlineTable = tomlValue instanceof TomlInlineTable ? (TomlInlineTable)tomlValue : null;
        if (tomlInlineTable == null) {
            return null;
        }
        TomlInlineTable dependencyValue = tomlInlineTable;
        Object object = CollectionsKt.singleOrNull((List)dependencyValue.getEntries());
        TomlKeyValue it3 = (TomlKeyValue)object;
        boolean bl = false;
        Object object2 = it3;
        tomlValue = (TomlKeyValue)(Intrinsics.areEqual(object2 != null && (object2 = object2.getKey()) != null && (object2 = object2.getSegments()) != null && (object2 = (TomlKeySegment)CollectionsKt.singleOrNull((List)object2)) != null ? object2.getText() : null, (Object)"version") ? object : null);
        if (tomlValue == null || (object = tomlValue.getValue()) == null) {
            return null;
        }
        Object version = object;
        return new Context(dependencyValue, (TomlValue)version);
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        PsiElement psiElement2 = ctx.getValue().replace(ctx.getVersion().copy());
        if (psiElement2 == null) {
            return;
        }
        int offset = PsiElementKt.getEndOffset(psiElement2);
        editor2.getCaretModel().moveToOffset(offset);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/rust/toml/intentions/SimplifyDependencySpecificationIntention$Context;", "", "value", "Lorg/toml/lang/psi/TomlInlineTable;", "version", "Lorg/toml/lang/psi/TomlValue;", "<init>", "(Lorg/toml/lang/psi/TomlInlineTable;Lorg/toml/lang/psi/TomlValue;)V", "getValue", "()Lorg/toml/lang/psi/TomlInlineTable;", "getVersion", "()Lorg/toml/lang/psi/TomlValue;", "intellij.rustrover.core"})
    public static final class Context {
        @NotNull
        private final TomlInlineTable value;
        @NotNull
        private final TomlValue version;

        public Context(@NotNull TomlInlineTable value, @NotNull TomlValue version) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            this.value = value;
            this.version = version;
        }

        @NotNull
        public final TomlInlineTable getValue() {
            return this.value;
        }

        @NotNull
        public final TomlValue getVersion() {
            return this.version;
        }
    }
}

