/*
 * Decompiled with CFR 0.152.
 */
package org.rust.toml.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.toml.UtilKt;
import org.rust.toml.intentions.RsTomlElementBaseIntentionAction;
import org.toml.lang.psi.TomlKeyValue;
import org.toml.lang.psi.TomlLiteral;
import org.toml.lang.psi.TomlPsiFactory;
import org.toml.lang.psi.TomlTable;
import org.toml.lang.psi.TomlValue;
import org.toml.lang.psi.ext.TomlLiteralKind;
import org.toml.lang.psi.ext.TomlLiteralKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\"\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/rust/toml/intentions/ExpandDependencySpecificationIntention;", "Lorg/rust/toml/intentions/RsTomlElementBaseIntentionAction;", "Lorg/toml/lang/psi/TomlKeyValue;", "<init>", "()V", "getText", "", "getFamilyName", "findApplicableContextInternal", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "ctx", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nExpandDependencySpecificationIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpandDependencySpecificationIntention.kt\norg/rust/toml/intentions/ExpandDependencySpecificationIntention\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,48:1\n66#2,2:49\n*S KotlinDebug\n*F\n+ 1 ExpandDependencySpecificationIntention.kt\norg/rust/toml/intentions/ExpandDependencySpecificationIntention\n*L\n30#1:49,2\n*E\n"})
public final class ExpandDependencySpecificationIntention
extends RsTomlElementBaseIntentionAction<TomlKeyValue> {
    @NotNull
    public String getText() {
        return RsBundle.INSTANCE.message("intention.name.expand.dependency.specification", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    @Nullable
    protected TomlKeyValue findApplicableContextInternal(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        if (!UtilKt.isCargoToml(psiFile)) {
            return null;
        }
        PsiElement $this$parentOfType_u24default$iv = element;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        TomlKeyValue tomlKeyValue = (TomlKeyValue)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, TomlKeyValue.class, (boolean)true);
        if (tomlKeyValue == null) {
            return null;
        }
        TomlKeyValue keyValue = tomlKeyValue;
        PsiElement psiElement2 = keyValue.getParent();
        TomlTable tomlTable = psiElement2 instanceof TomlTable ? (TomlTable)psiElement2 : null;
        if (tomlTable == null) {
            return null;
        }
        TomlTable table = tomlTable;
        if (!UtilKt.isDependencyListHeader(table.getHeader())) {
            return null;
        }
        TomlValue value = keyValue.getValue();
        if (!(value instanceof TomlLiteral) || !(TomlLiteralKt.getKind((TomlLiteral)((TomlLiteral)value)) instanceof TomlLiteralKind.String)) {
            return null;
        }
        return keyValue;
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull TomlKeyValue ctx) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        String crateName = ctx.getKey().getText();
        Object object = ctx.getValue();
        if (object == null || (object = object.getText()) == null) {
            object = "\"\"";
        }
        Object crateVersion = object;
        TomlKeyValue newKeyValue = new TomlPsiFactory(project, false, 2, null).createKeyValue(crateName + " = { version = " + (String)crateVersion + " }");
        PsiElement psiElement2 = ctx.replace((PsiElement)newKeyValue);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"replace(...)");
        int newKeyValueOffset = PsiElementKt.getEndOffset(psiElement2);
        editor2.getCaretModel().moveToOffset(newKeyValueOffset);
    }
}

