/*
 * Decompiled with CFR 0.152.
 */
package org.rust.toml.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.toml.UtilKt;
import org.toml.lang.psi.TomlInlineTable;
import org.toml.lang.psi.TomlKey;
import org.toml.lang.psi.TomlKeySegment;
import org.toml.lang.psi.TomlKeyValue;
import org.toml.lang.psi.TomlTable;
import org.toml.lang.psi.TomlValue;
import org.toml.lang.psi.TomlVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u001a\b\u0004\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e0\fH\u0086\b\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u000f"}, d2={"Lorg/rust/toml/inspections/TomlInspectionsUtil;", "", "<init>", "()V", "createKeyStringValueVisitor", "Lorg/toml/lang/psi/TomlVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "key", "", "parentTable", "valueHandler", "Lkotlin/Function2;", "Lorg/toml/lang/psi/TomlValue;", "", "intellij.rustrover.core"})
public final class TomlInspectionsUtil {
    @NotNull
    public static final TomlInspectionsUtil INSTANCE = new TomlInspectionsUtil();

    private TomlInspectionsUtil() {
    }

    @NotNull
    public final TomlVisitor createKeyStringValueVisitor(@NotNull ProblemsHolder holder, @NotNull String key, @NotNull String parentTable, @NotNull Function2<? super TomlValue, ? super String, Unit> valueHandler) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)parentTable, (String)"parentTable");
        Intrinsics.checkNotNullParameter(valueHandler, (String)"valueHandler");
        boolean $i$f$createKeyStringValueVisitor = false;
        return new TomlVisitor(key, parentTable, holder, valueHandler){
            final /* synthetic */ String $key;
            final /* synthetic */ String $parentTable;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ Function2<TomlValue, String, Unit> $valueHandler;
            {
                this.$key = $key;
                this.$parentTable = $parentTable;
                this.$holder = $holder;
                this.$valueHandler = $valueHandler;
            }

            public void visitKeyValue(TomlKeyValue element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                TomlValue tomlValue = element.getValue();
                if (tomlValue == null) {
                    return;
                }
                TomlValue psiValue = tomlValue;
                if (psiValue instanceof TomlInlineTable) {
                    return;
                }
                if (!Intrinsics.areEqual((Object)UtilKt.getStringValue(element.getKey()), (Object)this.$key)) {
                    return;
                }
                PsiElement psiElement2 = element.getParent();
                TomlTable tomlTable = psiElement2 instanceof TomlTable ? (TomlTable)psiElement2 : null;
                if (tomlTable == null) {
                    return;
                }
                TomlTable parent2 = tomlTable;
                TomlKey tomlKey = parent2.getHeader().getKey();
                List<E> list = tomlKey != null ? tomlKey.getSegments() : null;
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                List<E> tableNames = list;
                TomlKeySegment tomlKeySegment = (TomlKeySegment)CollectionsKt.singleOrNull((List)tableNames);
                if (!(tomlKeySegment != null ? tomlKeySegment.textMatches((CharSequence)this.$parentTable) : false)) {
                    return;
                }
                String stringValue = UtilKt.getStringValue(psiValue);
                if (stringValue == null) {
                    this.$holder.registerProblem((PsiElement)psiValue, RsBundle.INSTANCE.message("inspection.toml.string.literal.expected", new Object[0]), new LocalQuickFix[0]);
                } else {
                    this.$valueHandler.invoke((Object)psiValue, (Object)stringValue);
                }
            }
        };
    }
}

