/*
 * Decompiled with CFR 0.152.
 */
package org.rust.toml.inspections;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.ide.search.RsWithMacrosProjectScope;
import org.rust.lang.core.psi.RsFile;
import org.rust.openapiext.UtilsKt;
import org.rust.toml.CrateExtKt;
import org.toml.lang.psi.TomlFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/rust/toml/inspections/PackageSearchScope;", "Lorg/rust/ide/search/RsWithMacrosProjectScope;", "tomlFile", "Lorg/toml/lang/psi/TomlFile;", "<init>", "(Lorg/toml/lang/psi/TomlFile;)V", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "contains", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.rustrover.core"})
final class PackageSearchScope
extends RsWithMacrosProjectScope {
    @NotNull
    private final TomlFile tomlFile;
    @NotNull
    private final Project project;

    public PackageSearchScope(@NotNull TomlFile tomlFile) {
        Intrinsics.checkNotNullParameter((Object)tomlFile, (String)"tomlFile");
        Project project = tomlFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        super(project);
        this.tomlFile = tomlFile;
        Project project2 = this.tomlFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        this.project = project2;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!super.contains(file)) {
            return false;
        }
        PsiFile psiFile = UtilsKt.toPsiFile(file, this.project);
        RsFile rsFile = psiFile instanceof RsFile ? (RsFile)psiFile : null;
        if (rsFile == null) {
            return false;
        }
        RsFile rsPsiFile = rsFile;
        if (rsPsiFile.getCrate().getOrigin() != PackageOrigin.WORKSPACE) {
            return false;
        }
        TomlFile tomlFile = CrateExtKt.getTomlFile(rsPsiFile.getCrate());
        if (tomlFile == null) {
            return false;
        }
        TomlFile owningCargo = tomlFile;
        return Intrinsics.areEqual((Object)this.tomlFile, (Object)owningCargo) && rsPsiFile.getCrateRoot() != null;
    }
}

