/*
 * Decompiled with CFR 0.152.
 */
package org.rust.toml.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.project.workspace.MissingCargoFeaturesUtil;
import org.rust.cargo.project.workspace.PackageFeature;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.ide.fixes.EnableCargoFeaturesFix;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\u0004\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ/\u0010\u000e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\rJ/\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u0011JC\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lorg/rust/toml/inspections/MissingFeaturesInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "checkCargoTomlFile", "checkRsFile", "Lorg/rust/lang/core/psi/RsFile;", "(Lorg/rust/lang/core/psi/RsFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "createProblemDescriptors", "missingFeatures", "", "Lorg/rust/cargo/project/workspace/PackageFeature;", "cargoProject", "Lorg/rust/cargo/project/model/CargoProject;", "(Ljava/util/Set;Lcom/intellij/codeInspection/InspectionManager;Lcom/intellij/psi/PsiFile;ZLorg/rust/cargo/project/model/CargoProject;)[Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nMissingFeaturesInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MissingFeaturesInspection.kt\norg/rust/toml/inspections/MissingFeaturesInspection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public final class MissingFeaturesInspection
extends LocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        return file instanceof RsFile ? this.checkRsFile((RsFile)file, manager, isOnTheFly) : (Intrinsics.areEqual((Object)file.getName(), (Object)"Cargo.toml") ? this.checkCargoTomlFile(file, manager, isOnTheFly) : null);
    }

    private final ProblemDescriptor[] checkCargoTomlFile(PsiFile file, InspectionManager manager, boolean isOnTheFly) {
        CargoWorkspace.Package package_;
        CargoProject cargoProject;
        block5: {
            block4: {
                VirtualFile virtualFile;
                CargoWorkspace.Package package_2;
                CargoProject cargoProject2 = RsElementKt.findCargoProject((PsiFileSystemItem)file);
                if (cargoProject2 == null) {
                    return null;
                }
                cargoProject = cargoProject2;
                package_ = RsElementKt.findCargoPackage((PsiFileSystemItem)file);
                if (package_ == null) break block4;
                CargoWorkspace.Package it2 = package_2 = package_;
                boolean bl = false;
                package_ = Intrinsics.areEqual((Object)it2.getContentRootPath(), (virtualFile = file.getVirtualFile()) != null && (virtualFile = virtualFile.getParent()) != null ? UtilsKt.getPathAsPath(virtualFile) : null) ? package_2 : null;
                if (package_ != null) break block5;
            }
            return null;
        }
        CargoWorkspace.Package pkg = package_;
        Set<PackageFeature> missingFeatures = MissingCargoFeaturesUtil.INSTANCE.collectMissingFeaturesForPackage(pkg);
        return this.createProblemDescriptors(missingFeatures, manager, file, isOnTheFly, cargoProject);
    }

    private final ProblemDescriptor[] checkRsFile(RsFile file, InspectionManager manager, boolean isOnTheFly) {
        CargoProject cargoProject = RsElementKt.findCargoProject((PsiFileSystemItem)file);
        if (cargoProject == null) {
            return null;
        }
        CargoProject cargoProject2 = cargoProject;
        CargoWorkspace.Target target = RsElementKt.getContainingCargoTarget(file);
        if (target == null) {
            return null;
        }
        CargoWorkspace.Target target2 = target;
        if (target2.getPkg().getOrigin() != PackageOrigin.WORKSPACE) {
            return null;
        }
        Set<PackageFeature> missingFeatures = MissingCargoFeaturesUtil.INSTANCE.collectMissingFeatureForTarget(target2);
        return this.createProblemDescriptors(missingFeatures, manager, (PsiFile)file, isOnTheFly, cargoProject2);
    }

    private final ProblemDescriptor[] createProblemDescriptors(Set<PackageFeature> missingFeatures, InspectionManager manager, PsiFile file, boolean isOnTheFly, CargoProject cargoProject) {
        ProblemDescriptor[] problemDescriptorArray;
        if (missingFeatures.isEmpty()) {
            ProblemDescriptor[] problemDescriptorArray2 = ProblemDescriptor.EMPTY_ARRAY;
            Intrinsics.checkNotNull((Object)problemDescriptorArray2);
            problemDescriptorArray = problemDescriptorArray2;
        } else {
            ProblemDescriptor[] problemDescriptorArray3 = new ProblemDescriptor[1];
            Object[] objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)missingFeatures, null, null, null, (int)0, null, null, (int)63, null)};
            String string = RsBundle.INSTANCE.message("inspection.message.missing.features", objectArray);
            objectArray = new EnableCargoFeaturesFix[]{new EnableCargoFeaturesFix(cargoProject, missingFeatures)};
            problemDescriptorArray3[0] = manager.createProblemDescriptor((PsiElement)file, string, isOnTheFly, (LocalQuickFix[])objectArray, ProblemHighlightType.WARNING);
            problemDescriptorArray = problemDescriptorArray3;
        }
        return problemDescriptorArray;
    }
}

