/*
 * Decompiled with CFR 0.152.
 */
package org.rust.toml.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.stdext.RsResult;
import org.rust.toml.UtilKt;
import org.rust.toml.crates.local.CargoRegistryCrate;
import org.rust.toml.crates.local.CratesLocalIndexService;
import org.rust.toml.inspections.CargoDependencyCrateVisitor;
import org.rust.toml.inspections.CargoTomlInspectionToolBase;
import org.rust.toml.inspections.DependencyCrate;
import org.toml.lang.psi.TomlValue;
import org.toml.lang.psi.TomlVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/rust/toml/inspections/CrateNotFoundInspection;", "Lorg/rust/toml/inspections/CargoTomlInspectionToolBase;", "<init>", "()V", "requiresLocalCrateIndex", "", "getRequiresLocalCrateIndex", "()Z", "buildCargoTomlVisitor", "Lorg/toml/lang/psi/TomlVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "intellij.rustrover.core"})
public final class CrateNotFoundInspection
extends CargoTomlInspectionToolBase {
    private final boolean requiresLocalCrateIndex;

    public CrateNotFoundInspection() {
        this.requiresLocalCrateIndex = true;
    }

    @Override
    public boolean getRequiresLocalCrateIndex() {
        return this.requiresLocalCrateIndex;
    }

    @Override
    @NotNull
    public TomlVisitor buildCargoTomlVisitor(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new CargoDependencyCrateVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitDependency(DependencyCrate dependency) {
                boolean dependencyFound;
                boolean isWorkspace;
                Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
                if (dependency.isForeign()) {
                    return;
                }
                String crateName = dependency.getCrateName();
                Object object = dependency.getProperties().get("workspace");
                boolean bl = object != null && (object = UtilKt.asBoolean((TomlValue)object)) != null ? (Boolean)object : (isWorkspace = false);
                if (isWorkspace) {
                    return;
                }
                RsResult<CargoRegistryCrate, CratesLocalIndexService.Error> $this$unwrapOrElse$iv = CratesLocalIndexService.Companion.getInstance().getCrate(crateName);
                boolean $i$f$unwrapOrElse = false;
                RsResult<CargoRegistryCrate, CratesLocalIndexService.Error> rsResult = $this$unwrapOrElse$iv;
                if (!(rsResult instanceof RsResult.Ok)) {
                    if (rsResult instanceof RsResult.Err) {
                        CratesLocalIndexService.Error it2 = (CratesLocalIndexService.Error)((RsResult.Err)$this$unwrapOrElse$iv).getErr();
                        boolean bl2 = false;
                        return;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                boolean bl3 = dependencyFound = ((RsResult.Ok)$this$unwrapOrElse$iv).getOk() != null;
                if (!dependencyFound) {
                    Object[] objectArray = new Object[]{crateName};
                    this.$holder.registerProblem((PsiElement)dependency.getCrateNameElement(), RsBundle.INSTANCE.message("inspection.message.crate.not.found", objectArray), new LocalQuickFix[0]);
                }
            }
        };
    }
}

