/*
 * Decompiled with CFR 0.152.
 */
package org.rust.toml.inspections;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.openapiext.UtilsKt;
import org.rust.toml.UtilKt;
import org.rust.toml.inspections.CrateUsageFinder;
import org.rust.toml.inspections.PackageSearchScope;
import org.rust.toml.jsonSchema.RsTomlJsonPositionStep;
import org.rust.toml.jsonSchema.RsTomlJsonPsiWalker;
import org.rust.toml.psi.PropertiesManipulatorsKt;
import org.rust.toml.psi.TablesKt;
import org.rust.toml.psi.TomlPropertyValue;
import org.toml.lang.psi.TomlArray;
import org.toml.lang.psi.TomlFile;
import org.toml.lang.psi.TomlKeyValue;
import org.toml.lang.psi.TomlValue;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a \u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0002\u001a&\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a(\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0014\u0010\u0012\u001a\u00020\u0001*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a8\u0006\u0015"}, d2={"isCrateUsedInFeatures", "", "tomlFile", "Lorg/toml/lang/psi/TomlFile;", "crateName", "", "isCrateUsedInCode", "crateAccessName", "crateNormName", "isWorkspaceDependencyUsedInMembers", "project", "Lcom/intellij/openapi/project/Project;", "members", "", "findPackageName", "dependenciesOwnerName", "workspace", "Lorg/rust/cargo/project/workspace/CargoWorkspace;", "isSelfPath", "Ljava/nio/file/Path;", "selfPath", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCargoUnusedDependencyInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CargoUnusedDependencyInspection.kt\norg/rust/toml/inspections/CargoUnusedDependencyInspectionKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,286:1\n1761#2,2:287\n1761#2,3:289\n1763#2:292\n37#3,2:293\n*S KotlinDebug\n*F\n+ 1 CargoUnusedDependencyInspection.kt\norg/rust/toml/inspections/CargoUnusedDependencyInspectionKt\n*L\n169#1:287,2\n171#1:289,3\n169#1:292\n218#1:293,2\n*E\n"})
public final class CargoUnusedDependencyInspectionKt {
    private static final boolean isCrateUsedInFeatures(TomlFile tomlFile, String crateName) {
        boolean bl;
        block10: {
            String[] stringArray = new String[]{"features"};
            TomlPropertyValue tomlPropertyValue = PropertiesManipulatorsKt.findPropertyValue(tomlFile, stringArray);
            TomlPropertyValue.ObjectValue objectValue = tomlPropertyValue instanceof TomlPropertyValue.ObjectValue ? (TomlPropertyValue.ObjectValue)tomlPropertyValue : null;
            if (objectValue == null) {
                return false;
            }
            TomlPropertyValue.ObjectValue featuresHolder = objectValue;
            Iterable $this$any$iv = featuresHolder.getProperties();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block9: {
                        TomlKeyValue feature = (TomlKeyValue)element$iv;
                        boolean bl3 = false;
                        TomlValue tomlValue = feature.getValue();
                        if ((tomlValue instanceof TomlArray ? (TomlArray)tomlValue : null) == null) {
                            bl2 = false;
                        } else {
                            TomlArray deps;
                            deps = deps;
                            Iterable $this$any$iv2 = deps.getElements();
                            boolean $i$f$any2 = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv2) {
                                    String string;
                                    String string2;
                                    String[] stringArray2;
                                    List list;
                                    TomlValue it2 = (TomlValue)element$iv2;
                                    boolean bl4 = false;
                                    String string3 = UtilKt.getStringValue(it2);
                                    String string4 = string3 != null && (list = StringsKt.split$default((CharSequence)string3, (String[])(stringArray2 = new String[]{"/"}), (boolean)false, (int)0, (int)6, null)) != null && (string2 = (String)CollectionsKt.firstOrNull((List)list)) != null && (string = StringsKt.removePrefix((String)string2, (CharSequence)"dep:")) != null ? StringsKt.removeSuffix((String)string, (CharSequence)"?") : null;
                                    if (!Intrinsics.areEqual(string4, (Object)crateName)) continue;
                                    bl2 = true;
                                    break block9;
                                }
                                bl2 = false;
                            }
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean isCrateUsedInCode(TomlFile tomlFile, String crateAccessName, String crateNormName) {
        CrateUsageFinder crateUsageFinder = new CrateUsageFinder(crateNormName);
        PsiSearchHelper.getInstance((Project)tomlFile.getProject()).processElementsWithWord((TextOccurenceProcessor)crateUsageFinder, (SearchScope)new PackageSearchScope(tomlFile), crateAccessName, (short)((short)(2 | 1) | 4), true, true);
        return crateUsageFinder.getCrateFound();
    }

    private static final boolean isWorkspaceDependencyUsedInMembers(Project project, List<TomlFile> members, String crateName) {
        Ref.BooleanRef workspaceDependencyUsed = new Ref.BooleanRef();
        Collection $this$toTypedArray$iv = members;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        PsiSearchHelper.getInstance((Project)project).processElementsWithWord(new TextOccurenceProcessor(workspaceDependencyUsed){
            final /* synthetic */ Ref.BooleanRef $workspaceDependencyUsed;
            {
                this.$workspaceDependencyUsed = $workspaceDependencyUsed;
            }

            public boolean execute(PsiElement element, int offsetInElement) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (offsetInElement != 0) {
                    return true;
                }
                List<RsTomlJsonPositionStep> steps = RsTomlJsonPsiWalker.INSTANCE.findSteps(element, false);
                Object object = CollectionsKt.getOrNull(steps, (int)1);
                RsTomlJsonPositionStep.Property property = object instanceof RsTomlJsonPositionStep.Property ? (RsTomlJsonPositionStep.Property)object : null;
                if (Intrinsics.areEqual((Object)(property != null ? property.getName() : null), (Object)"workspace")) {
                    return true;
                }
                RsTomlJsonPositionStep rsTomlJsonPositionStep = (RsTomlJsonPositionStep)CollectionsKt.firstOrNull(steps);
                if (rsTomlJsonPositionStep != null) {
                    RsTomlJsonPositionStep.Property property2;
                    object = rsTomlJsonPositionStep;
                    Ref.BooleanRef booleanRef = this.$workspaceDependencyUsed;
                    Object it2 = object;
                    boolean bl = false;
                    RsTomlJsonPositionStep.Property property3 = property2 = it2 instanceof RsTomlJsonPositionStep.Property ? (RsTomlJsonPositionStep.Property)it2 : null;
                    if (TablesKt.isCargoDependenciesName(property3 != null ? property3.getName() : null)) {
                        booleanRef.element = true;
                        return false;
                    }
                }
                return true;
            }
        }, (SearchScope)new LocalSearchScope((PsiElement[])thisCollection$iv.toArray(new TomlFile[0])), crateName, (short)1, true, false);
        return workspaceDependencyUsed.element;
    }

    private static final String findPackageName(TomlFile tomlFile, String dependenciesOwnerName, String crateName, CargoWorkspace workspace) {
        Object object;
        block10: {
            block11: {
                block8: {
                    block9: {
                        TomlFile workspaceCargo;
                        PsiFile psiFile;
                        boolean isFromWorkspace;
                        String[] stringArray = new String[]{dependenciesOwnerName, crateName, "workspace"};
                        boolean bl = isFromWorkspace = PropertiesManipulatorsKt.findPropertyValue(tomlFile, stringArray) != null;
                        if (!isFromWorkspace) break block8;
                        String[] stringArray2 = VirtualFileManager.getInstance().findFileByNioPath(workspace.getManifestPath());
                        if (stringArray2 != null) {
                            Project project = tomlFile.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                            v2 = UtilsKt.toPsiFile((VirtualFile)stringArray2, project);
                        } else {
                            v2 = psiFile = null;
                        }
                        if ((object = (workspaceCargo = psiFile instanceof TomlFile ? (TomlFile)psiFile : null)) == null || (object = PropertiesManipulatorsKt.findPropertyValue(object, stringArray2 = new String[]{"workspace", "dependencies", crateName, "package"})) == null) break block9;
                        Object it2 = object;
                        boolean bl2 = false;
                        TomlPropertyValue.SimpleValue simpleValue = it2 instanceof TomlPropertyValue.SimpleValue ? (TomlPropertyValue.SimpleValue)it2 : null;
                        String string = simpleValue != null && (simpleValue = simpleValue.getValue()) != null ? UtilKt.getStringValue((TomlValue)simpleValue) : null;
                        object = string;
                        if (string != null) break block10;
                    }
                    object = crateName;
                    break block10;
                }
                String[] stringArray = new String[]{dependenciesOwnerName, crateName, "package"};
                object = PropertiesManipulatorsKt.findPropertyValue(tomlFile, stringArray);
                if (object == null) break block11;
                Object it3 = object;
                boolean bl = false;
                TomlPropertyValue.SimpleValue simpleValue = it3 instanceof TomlPropertyValue.SimpleValue ? (TomlPropertyValue.SimpleValue)it3 : null;
                String string = simpleValue != null && (simpleValue = simpleValue.getValue()) != null ? UtilKt.getStringValue((TomlValue)simpleValue) : null;
                object = string;
                if (string != null) break block10;
            }
            object = crateName;
        }
        return object;
    }

    private static final boolean isSelfPath(Path $this$isSelfPath, Path selfPath) {
        boolean bl;
        if ($this$isSelfPath.isAbsolute()) {
            bl = Intrinsics.areEqual((Object)$this$isSelfPath, (Object)selfPath);
        } else {
            Path path = Paths.get(".", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            bl = Intrinsics.areEqual((Object)$this$isSelfPath, (Object)path);
        }
        return bl;
    }

    public static final /* synthetic */ boolean access$isSelfPath(Path $receiver, Path selfPath) {
        return CargoUnusedDependencyInspectionKt.isSelfPath($receiver, selfPath);
    }

    public static final /* synthetic */ boolean access$isCrateUsedInFeatures(TomlFile tomlFile, String crateName) {
        return CargoUnusedDependencyInspectionKt.isCrateUsedInFeatures(tomlFile, crateName);
    }

    public static final /* synthetic */ String access$findPackageName(TomlFile tomlFile, String dependenciesOwnerName, String crateName, CargoWorkspace workspace) {
        return CargoUnusedDependencyInspectionKt.findPackageName(tomlFile, dependenciesOwnerName, crateName, workspace);
    }

    public static final /* synthetic */ boolean access$isCrateUsedInCode(TomlFile tomlFile, String crateAccessName, String crateNormName) {
        return CargoUnusedDependencyInspectionKt.isCrateUsedInCode(tomlFile, crateAccessName, crateNormName);
    }

    public static final /* synthetic */ boolean access$isWorkspaceDependencyUsedInMembers(Project project, List members, String crateName) {
        return CargoUnusedDependencyInspectionKt.isWorkspaceDependencyUsedInMembers(project, members, crateName);
    }
}

