/*
 * Decompiled with CFR 0.152.
 */
package org.rust.toml.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.model.AttachCargoProjectAction;
import org.rust.cargo.project.model.CargoProjectsService;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.lang.core.crate.Crate;
import org.rust.lang.core.crate.CrateGraphServiceKt;
import org.rust.lang.core.crate.impl.CargoBasedCrate;
import org.rust.openapiext.UtilsKt;
import org.rust.toml.CrateExtKt;
import org.rust.toml.UtilKt;
import org.rust.toml.fixes.TomlRemoveElementFix;
import org.rust.toml.inspections.CargoTomlInspectionToolBase;
import org.rust.toml.inspections.CargoUnusedDependencyInspectionKt;
import org.rust.toml.psi.PropertiesManipulatorsKt;
import org.rust.toml.psi.TablesKt;
import org.rust.toml.psi.TomlPropertyValue;
import org.toml.lang.psi.TomlElement;
import org.toml.lang.psi.TomlFile;
import org.toml.lang.psi.TomlKeySegment;
import org.toml.lang.psi.TomlKeyValue;
import org.toml.lang.psi.TomlTableHeader;
import org.toml.lang.psi.TomlVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\b\u001a\u00020\t*\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/rust/toml/inspections/CargoUnusedDependencyInspection;", "Lorg/rust/toml/inspections/CargoTomlInspectionToolBase;", "<init>", "()V", "buildCargoTomlVisitor", "Lorg/toml/lang/psi/TomlVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "registerUnusedCrate", "", "element", "Lorg/toml/lang/psi/TomlElement;", "crateName", "", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCargoUnusedDependencyInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CargoUnusedDependencyInspection.kt\norg/rust/toml/inspections/CargoUnusedDependencyInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,286:1\n295#2,2:287\n*S KotlinDebug\n*F\n+ 1 CargoUnusedDependencyInspection.kt\norg/rust/toml/inspections/CargoUnusedDependencyInspection\n*L\n50#1:287,2\n*E\n"})
public final class CargoUnusedDependencyInspection
extends CargoTomlInspectionToolBase {
    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public TomlVisitor buildCargoTomlVisitor(@NotNull ProblemsHolder holder) {
        Object v2;
        block3: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            PsiFile psiFile = holder.getFile();
            TomlFile tomlFile = psiFile instanceof TomlFile ? (TomlFile)psiFile : null;
            if (tomlFile == null) {
                return null;
            }
            TomlFile cargoToml = tomlFile;
            Project project = holder.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Iterable iterable = CrateGraphServiceKt.getCrateGraph(project).getTopSortedCrates();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Crate it2 = (Crate)element$iv;
                boolean bl = false;
                if (!(it2 instanceof CargoBasedCrate && Intrinsics.areEqual((Object)CrateExtKt.getTomlFile(it2), (Object)cargoToml))) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        Crate crate = v2;
        if (crate == null) {
            return null;
        }
        Crate crate2 = crate;
        return new TomlVisitor(crate2, this, holder){
            final /* synthetic */ Crate $crate;
            final /* synthetic */ CargoUnusedDependencyInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$crate = $crate;
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitKeyValue(TomlKeyValue element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                TomlKeySegment tomlKeySegment = (TomlKeySegment)CollectionsKt.firstOrNull((List)element.getKey().getSegments());
                if (tomlKeySegment == null) {
                    return;
                }
                this.checkDep(tomlKeySegment);
            }

            public void visitKeySegment(TomlKeySegment element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement psiElement2 = element.getParent();
                if ((psiElement2 != null ? psiElement2.getParent() : null) instanceof TomlTableHeader) {
                    this.checkDep(element);
                }
            }

            private final void checkDep(TomlKeySegment keySegment) {
                boolean bl;
                Path depPath;
                Path path;
                Object object;
                PsiFile psiFile = keySegment.getContainingFile();
                TomlFile tomlFile = psiFile instanceof TomlFile ? (TomlFile)psiFile : null;
                if (tomlFile == null) {
                    return;
                }
                TomlFile tomlFile2 = tomlFile;
                String string = keySegment.getName();
                if (string == null) {
                    return;
                }
                String depName = string;
                Object object2 = CargoProjectsService.Companion.findCargoProject((PsiElement)tomlFile2);
                if (object2 == null || (object2 = object2.getWorkspace()) == null) {
                    return;
                }
                Object workspace = object2;
                String string2 = TablesKt.dependenciesOwnerName(keySegment);
                if (string2 == null) {
                    return;
                }
                String dependenciesOwnerName = string2;
                PsiElement $this$parentOfType_u24default$iv = (PsiElement)keySegment;
                boolean withSelf$iv = false;
                boolean $i$f$parentOfType = false;
                TomlKeyValue tomlKeyValue = (TomlKeyValue)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, TomlKeyValue.class, (boolean)true);
                if (tomlKeyValue != null) {
                    object = (PsiElement)tomlKeyValue;
                } else {
                    PsiElement $this$parentOfType_u24default$iv2 = (PsiElement)keySegment;
                    boolean withSelf$iv2 = false;
                    boolean $i$f$parentOfType2 = false;
                    TomlTableHeader tomlTableHeader = (TomlTableHeader)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv2, TomlTableHeader.class, (boolean)true);
                    object = tomlTableHeader != null ? tomlTableHeader.getParent() : null;
                }
                PsiElement psiElement2 = object;
                TomlElement tomlElement = psiElement2 instanceof TomlElement ? (TomlElement)psiElement2 : null;
                if (tomlElement == null) {
                    return;
                }
                TomlElement inspectionElement = tomlElement;
                String[] stringArray = new String[]{dependenciesOwnerName, depName, "path"};
                TomlPropertyValue tomlPropertyValue = PropertiesManipulatorsKt.findPropertyValue(tomlFile2, stringArray);
                if (tomlPropertyValue != null) {
                    TomlPropertyValue it2 = tomlPropertyValue;
                    boolean bl2 = false;
                    String string3 = UtilKt.getStringValue(((TomlPropertyValue.SimpleValue)it2).getValue());
                    if (string3 != null) {
                        String path2 = string3;
                        boolean bl3 = false;
                        Path path3 = Paths.get(path2, new String[0]);
                        path = path3;
                        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
                    } else {
                        path = null;
                    }
                } else {
                    path = null;
                }
                Path path4 = depPath = path;
                if (path4 != null) {
                    VirtualFile virtualFile = tomlFile2.getVirtualFile().getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
                    bl = CargoUnusedDependencyInspectionKt.access$isSelfPath(path4, UtilsKt.getPathAsPath(virtualFile));
                } else {
                    bl = false;
                }
                if (bl) {
                    return;
                }
                Project project = tomlFile2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                VirtualFile virtualFile = tomlFile2.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                if (!AttachCargoProjectAction.Companion.isCargoTomlAttached(project, virtualFile)) {
                    return;
                }
                if (Intrinsics.areEqual((Object)dependenciesOwnerName, (Object)"dev-dependencies") && this.$crate.getHasCyclicDevDependencies()) {
                    return;
                }
                if (TablesKt.isWorkspaceDependency(keySegment)) {
                    this.checkWorkspaceDependencyInspection((CargoWorkspace)workspace, inspectionElement, depName);
                } else {
                    this.checkPackageDependencyInspection((CargoWorkspace)workspace, tomlFile2, inspectionElement, depName, dependenciesOwnerName);
                }
            }

            private final void checkPackageDependencyInspection(CargoWorkspace workspace, TomlFile tomlFile, TomlElement element, String depName, String dependenciesOwnerName) {
                Object libName;
                Object crateName;
                if (CargoUnusedDependencyInspectionKt.access$isCrateUsedInFeatures(tomlFile, depName)) {
                    return;
                }
                String packageName = StringsKt.replace$default((String)CargoUnusedDependencyInspectionKt.access$findPackageName(tomlFile, dependenciesOwnerName, depName, workspace), (String)"-", (String)"_", (boolean)false, (int)4, null);
                Object object = CargoWorkspace.findPackageByName$default(workspace, packageName, null, 2, null);
                if (object == null || (object = object.getLibTarget()) == null || (object = object.getName()) == null || (object = StringsKt.replace$default((String)object, (String)"-", (String)"_", (boolean)false, (int)4, null)) == null) {
                    object = packageName;
                }
                Object object2 = crateName = Intrinsics.areEqual((Object)(libName = object), (Object)packageName) ? StringsKt.replace$default((String)depName, (String)"-", (String)"_", (boolean)false, (int)4, null) : libName;
                if (!CargoUnusedDependencyInspectionKt.access$isCrateUsedInCode(tomlFile, (String)crateName, (String)libName)) {
                    CargoUnusedDependencyInspection.access$registerUnusedCrate(this.this$0, this.$holder, element, depName);
                }
            }

            /*
             * WARNING - void declaration
             */
            private final void checkWorkspaceDependencyInspection(CargoWorkspace workspace, TomlElement element, String crateName) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                void $this$filterTo$iv$iv;
                Project project = element.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Project project2 = project;
                Iterable $this$filter$iv = workspace.getPackages();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    CargoWorkspace.Package pkg = (CargoWorkspace.Package)element$iv$iv;
                    boolean bl = false;
                    if (!(pkg.getOrigin() == PackageOrigin.WORKSPACE)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                $this$filterTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    TomlFile it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    CargoWorkspace.Package it2 = (CargoWorkspace.Package)element$iv$iv;
                    boolean bl2 = false;
                    if (UtilKt.getPackageCargoTomlFile(it2, project2) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List workspaceMembers = (List)destination$iv$iv;
                if (!CargoUnusedDependencyInspectionKt.access$isWorkspaceDependencyUsedInMembers(project2, workspaceMembers, crateName)) {
                    CargoUnusedDependencyInspection.access$registerUnusedCrate(this.this$0, this.$holder, element, crateName);
                }
            }
        };
    }

    private final void registerUnusedCrate(ProblemsHolder $this$registerUnusedCrate, TomlElement element, String crateName) {
        Object[] objectArray = new Object[]{crateName};
        String string = RsBundle.INSTANCE.message("inspection.message.unused.dependency", objectArray);
        objectArray = new LocalQuickFix[]{new TomlRemoveElementFix(element, RsBundle.INSTANCE.message("intention.fix.name.remove.unused.dependency", new Object[0]))};
        $this$registerUnusedCrate.registerProblem((PsiElement)element, string, ProblemHighlightType.LIKE_UNUSED_SYMBOL, (LocalQuickFix[])objectArray);
    }

    public static final /* synthetic */ void access$registerUnusedCrate(CargoUnusedDependencyInspection $this, ProblemsHolder $receiver, TomlElement element, String crateName) {
        $this.registerUnusedCrate($receiver, element, crateName);
    }
}

