/*
 * Decompiled with CFR 0.152.
 */
package org.rust.toml.inspections;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.toml.UtilKt;
import org.rust.toml.inspections.CargoDependencyCrateVisitorKt;
import org.rust.toml.inspections.DependencyCrate;
import org.rust.toml.inspections.DependencyTable;
import org.toml.lang.psi.TomlElement;
import org.toml.lang.psi.TomlInlineTable;
import org.toml.lang.psi.TomlKeySegment;
import org.toml.lang.psi.TomlKeyValue;
import org.toml.lang.psi.TomlKeyValueOwner;
import org.toml.lang.psi.TomlLiteral;
import org.toml.lang.psi.TomlTable;
import org.toml.lang.psi.TomlValue;
import org.toml.lang.psi.TomlVisitor;
import org.toml.lang.psi.ext.TomlLiteralKind;
import org.toml.lang.psi.ext.TomlLiteralKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/rust/toml/inspections/CargoDependencyCrateVisitor;", "Lorg/toml/lang/psi/TomlVisitor;", "<init>", "()V", "visitDependency", "", "dependency", "Lorg/rust/toml/inspections/DependencyCrate;", "visitKeyValue", "element", "Lorg/toml/lang/psi/TomlKeyValue;", "visitTable", "Lorg/toml/lang/psi/TomlTable;", "intellij.rustrover.core"})
public abstract class CargoDependencyCrateVisitor
extends TomlVisitor {
    public abstract void visitDependency(@NotNull DependencyCrate var1);

    public void visitKeyValue(@NotNull TomlKeyValue element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement2 = element.getParent();
        TomlTable tomlTable = psiElement2 instanceof TomlTable ? (TomlTable)psiElement2 : null;
        if (tomlTable == null) {
            return;
        }
        TomlTable table = tomlTable;
        DependencyTable dependencyTable = DependencyTable.Companion.fromTomlTable(table);
        if (dependencyTable == null) {
            return;
        }
        DependencyTable depTable = dependencyTable;
        if (!(depTable instanceof DependencyTable.General)) {
            return;
        }
        TomlKeySegment tomlKeySegment = (TomlKeySegment)CollectionsKt.firstOrNull((List)element.getKey().getSegments());
        if (tomlKeySegment == null) {
            return;
        }
        TomlKeySegment segment = tomlKeySegment;
        String string = segment.getName();
        if (string == null) {
            return;
        }
        String name2 = string;
        TomlValue tomlValue = element.getValue();
        if (tomlValue == null) {
            return;
        }
        TomlValue value = tomlValue;
        if (value instanceof TomlLiteral && TomlLiteralKt.getKind((TomlLiteral)((TomlLiteral)value)) instanceof TomlLiteralKind.String) {
            this.visitDependency(new DependencyCrate(name2, (TomlElement)segment, MapsKt.mapOf((Pair)TuplesKt.to((Object)"version", (Object)value)), name2));
        } else if (value instanceof TomlInlineTable) {
            Pair pair;
            TomlKeyValue pkg = CargoDependencyCrateVisitorKt.access$getPackageKeyValue((TomlKeyValueOwner)value);
            TomlKeyValue tomlKeyValue = pkg;
            if (tomlKeyValue != null) {
                TomlValue tomlValue2 = pkg.getValue();
                pair = TuplesKt.to((Object)tomlKeyValue.getValue(), (Object)(tomlValue2 != null ? UtilKt.getStringValue(tomlValue2) : null));
            } else {
                pair = TuplesKt.to((Object)segment, (Object)name2);
            }
            Pair pair2 = pair;
            TomlElement originalNameElement = (TomlElement)pair2.component1();
            String originalName = (String)pair2.component2();
            if (originalName != null && originalNameElement != null) {
                this.visitDependency(new DependencyCrate(originalName, originalNameElement, CargoDependencyCrateVisitorKt.access$collectProperties((TomlKeyValueOwner)value), name2));
            }
        }
    }

    public void visitTable(@NotNull TomlTable element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        DependencyTable dependencyTable = DependencyTable.Companion.fromTomlTable(element);
        if (dependencyTable == null) {
            return;
        }
        DependencyTable depTable = dependencyTable;
        if (!(depTable instanceof DependencyTable.Specific)) {
            return;
        }
        this.visitDependency(new DependencyCrate(((DependencyTable.Specific)depTable).getCrateName(), ((DependencyTable.Specific)depTable).getCrateNameElement(), CargoDependencyCrateVisitorKt.access$collectProperties((TomlKeyValueOwner)element), ((DependencyTable.Specific)depTable).getDependencyName()));
    }
}

