/*
 * Decompiled with CFR 0.152.
 */
package org.rust.toml.crates.local;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.storage.file.WindowCacheConfig;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.OrTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.SystemReader;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.RsTaskWithEmptyProgress;
import org.rust.openapiext.RsPathManager;
import org.rust.stdext.RsResult;
import org.rust.toml.crates.local.CargoCratesIoGitRegistryUpdater;
import org.rust.toml.crates.local.CargoRegistryCrate;
import org.rust.toml.crates.local.CargoRegistryCrateVersion;
import org.rust.toml.crates.local.CrateVersionInterner;
import org.rust.toml.crates.local.CratesLocalIndexService;
import org.rust.toml.crates.local.CratesLocalIndexServiceImpl;
import org.rust.toml.crates.local.CratesLocalIndexServiceImplKt;
import org.rust.toml.crates.local.CustomJGitConfigSystemReader;
import org.rust.toml.crates.local.RsCratesLocalIndexPersistenceState;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0080\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u001e\u0010\u0006\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0007\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\u0007\u0012!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\nH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J(\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0005H\u0002J\u0016\u0010#\u001a\u0004\u0018\u00010$*\u00020\u001e2\u0006\u0010%\u001a\u00020\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\r0\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/rust/toml/crates/local/CratesLocalIndexUpdateTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "Lorg/rust/RsTaskWithEmptyProgress;", "indexedCommitHashGetter", "Lkotlin/Function0;", "", "writeNewCrate", "Lkotlin/Function1;", "Lkotlin/Pair;", "Lorg/rust/toml/crates/local/CargoRegistryCrate;", "", "writeNewHeadHash", "onError", "Lorg/rust/toml/crates/local/CratesLocalIndexService$Error$InternalError;", "onFinish", "", "Lkotlin/ParameterName;", "name", "lastCargoRegistryUpdateSucceed", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "lastCargoRegistryUpdateResult", "Lorg/rust/stdext/RsResult;", "Ljava/nio/file/Path;", "run", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "onFinished", "readRegistryHeadCommitHash", "repository", "Lorg/eclipse/jgit/lib/Repository;", "readNewCrates", "", "newHeadHash", "prevHeadHash", "resolveTreeObject", "Lorg/eclipse/jgit/lib/ObjectId;", "hash", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCratesLocalIndexServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CratesLocalIndexServiceImpl.kt\norg/rust/toml/crates/local/CratesLocalIndexUpdateTask\n+ 2 RsResult.kt\norg/rust/stdext/RsResultKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,906:1\n60#2,4:907\n1563#3:911\n1634#3,3:912\n*S KotlinDebug\n*F\n+ 1 CratesLocalIndexServiceImpl.kt\norg/rust/toml/crates/local/CratesLocalIndexUpdateTask\n*L\n592#1:907,4\n714#1:911\n714#1:912,3\n*E\n"})
final class CratesLocalIndexUpdateTask
extends Task.Backgroundable
implements RsTaskWithEmptyProgress {
    @NotNull
    private final Function0<String> indexedCommitHashGetter;
    @NotNull
    private final Function1<Pair<String, CargoRegistryCrate>, Unit> writeNewCrate;
    @NotNull
    private final Function1<String, Unit> writeNewHeadHash;
    @NotNull
    private final Function1<CratesLocalIndexService.Error.InternalError, Unit> onError;
    @NotNull
    private final Function1<Boolean, Unit> onFinish;
    @NotNull
    private RsResult<? extends Path, ? extends CratesLocalIndexService.Error.InternalError> lastCargoRegistryUpdateResult;

    public CratesLocalIndexUpdateTask(@NotNull Function0<String> indexedCommitHashGetter, @NotNull Function1<? super Pair<String, CargoRegistryCrate>, Unit> writeNewCrate, @NotNull Function1<? super String, Unit> writeNewHeadHash, @NotNull Function1<? super CratesLocalIndexService.Error.InternalError, Unit> onError, @NotNull Function1<? super Boolean, Unit> onFinish) {
        Intrinsics.checkNotNullParameter(indexedCommitHashGetter, (String)"indexedCommitHashGetter");
        Intrinsics.checkNotNullParameter(writeNewCrate, (String)"writeNewCrate");
        Intrinsics.checkNotNullParameter(writeNewHeadHash, (String)"writeNewHeadHash");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        Intrinsics.checkNotNullParameter(onFinish, (String)"onFinish");
        super(null, RsBundle.INSTANCE.message("progress.title.loading.cargo.registry.index", new Object[0]), false);
        this.indexedCommitHashGetter = indexedCommitHashGetter;
        this.writeNewCrate = writeNewCrate;
        this.writeNewHeadHash = writeNewHeadHash;
        this.onError = onError;
        this.onFinish = onFinish;
        this.lastCargoRegistryUpdateResult = new RsResult.Err<CratesLocalIndexService.Error.InternalError.CargoCratesIoGitRegistryUpdateError>(CratesLocalIndexService.Error.InternalError.CargoCratesIoGitRegistryUpdateError.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull ProgressIndicator indicator) {
        Object repository;
        WindowCacheConfig $i$f$unwrapOrElse2;
        Path cargoRegistryIndexPath;
        Object object;
        block18: {
            block17: {
                File file;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                CratesLocalIndexServiceImplKt.access$getLOG$p().info("crates.io index loading started - updating Cargo Registry");
                File $this$run_u24lambda_u240 = file = RsPathManager.INSTANCE.pluginDirInSystem().resolve(".empty.gitconfig").toFile();
                boolean bl = false;
                $this$run_u24lambda_u240.getParentFile().mkdirs();
                $this$run_u24lambda_u240.createNewFile();
                File emptyGitConfig = file;
                Intrinsics.checkNotNull((Object)emptyGitConfig);
                SystemReader.setInstance((SystemReader)new CustomJGitConfigSystemReader(emptyGitConfig));
                this.lastCargoRegistryUpdateResult = CargoCratesIoGitRegistryUpdater.INSTANCE.updateCratesIoGitIndex(this.getProject(), CratesLocalIndexServiceImpl.Companion.getLocalIndexCargoHome());
                CratesLocalIndexServiceImplKt.access$getLOG$p().info("Cargo Registry update finished; succeed=" + this.lastCargoRegistryUpdateResult.isOk() + "; Now indexing...");
                Object $this$unwrapOrElse$iv = this.lastCargoRegistryUpdateResult;
                boolean $i$f$unwrapOrElse2 = false;
                object = $this$unwrapOrElse$iv;
                if (!(object instanceof RsResult.Ok)) {
                    if (object instanceof RsResult.Err) {
                        CratesLocalIndexService.Error.InternalError it2 = (CratesLocalIndexService.Error.InternalError)((RsResult.Err)$this$unwrapOrElse$iv).getErr();
                        boolean bl2 = false;
                        this.onError.invoke((Object)it2);
                        return;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                cargoRegistryIndexPath = (Path)((RsResult.Ok)$this$unwrapOrElse$iv).getOk();
                Path cargoRegistryIndexRefsPath = cargoRegistryIndexPath.resolve("refs");
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(cargoRegistryIndexPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block17;
                Intrinsics.checkNotNull((Object)cargoRegistryIndexRefsPath);
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (Files.exists(cargoRegistryIndexRefsPath, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) break block18;
            }
            this.onError.invoke((Object)new CratesLocalIndexService.Error.InternalError.NoCargoIndex(cargoRegistryIndexPath));
            return;
        }
        WindowCacheConfig $this$run_u24lambda_u242 = $i$f$unwrapOrElse2 = new WindowCacheConfig();
        boolean bl = false;
        $this$run_u24lambda_u242.setStreamFileThreshold(0x100000);
        $i$f$unwrapOrElse2.install();
        FileRepositoryBuilder builder = (FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(cargoRegistryIndexPath.toFile());
        try {
            String indexedCommitHash;
            repository = builder.build();
            try {
                indexedCommitHash = (String)this.indexedCommitHashGetter.invoke();
                Intrinsics.checkNotNull((Object)repository);
                String newHead = this.readRegistryHeadCommitHash((Repository)repository);
                if (newHead == null) {
                    CratesLocalIndexServiceImplKt.access$getLOG$p().warn("Failed to resolve remote branch in the cargo registry index repository");
                    return;
                }
                if (Intrinsics.areEqual((Object)newHead, (Object)indexedCommitHash)) {
                    CratesLocalIndexServiceImplKt.access$getLOG$p().info("Indexed commit hash " + indexedCommitHash + " is equal to new commit hash, no update needed");
                    return;
                }
                CratesLocalIndexServiceImplKt.access$getLOG$p().info("Loading crates.io index for a new commit hash " + newHead);
                indicator.checkCanceled();
                int updatedCount = this.readNewCrates(indicator, (Repository)repository, newHead, indexedCommitHash);
                indexedCommitHash = TuplesKt.to((Object)newHead, (Object)updatedCount);
            }
            finally {
                RepositoryCache.unregister((Repository)repository);
                repository.close();
            }
            repository = indexedCommitHash;
        }
        catch (RepositoryNotFoundException e) {
            CratesLocalIndexServiceImplKt.access$getLOG$p().warn((Throwable)e);
            this.onError.invoke((Object)new CratesLocalIndexService.Error.InternalError.NoCargoIndex(cargoRegistryIndexPath));
            return;
        }
        catch (IOException e) {
            CratesLocalIndexServiceImplKt.access$getLOG$p().warn((Throwable)e);
            this.onError.invoke((Object)new CratesLocalIndexService.Error.InternalError.RepoReadError(cargoRegistryIndexPath, e.toString()));
            return;
        }
        object = repository;
        String newHeadHash = (String)object.component1();
        int cratesUpdatedCount = ((Number)object.component2()).intValue();
        if (cratesUpdatedCount > 0) {
            ProgressManager.getInstance().executeNonCancelableSection(() -> CratesLocalIndexUpdateTask.run$lambda$3(this, newHeadHash));
        }
        ((RsCratesLocalIndexPersistenceState.MyState)RsCratesLocalIndexPersistenceState.Companion.getInstance().getState()).setLocalIndexUpdated(true);
        CratesLocalIndexServiceImplKt.access$getLOG$p().info("crates.io index loading finished for commit hash " + newHeadHash + ". " + cratesUpdatedCount + " crates updated");
    }

    public void onFinished() {
        this.onFinish.invoke((Object)this.lastCargoRegistryUpdateResult.isOk());
    }

    private final String readRegistryHeadCommitHash(Repository repository) throws IOException, RevisionSyntaxException {
        ObjectId objectId;
        ObjectId objectId2 = objectId = repository.resolve("origin/HEAD");
        return objectId2 != null ? objectId2.getName() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final int readNewCrates(ProgressIndicator indicator, Repository repository, String newHeadHash, String prevHeadHash) throws IOException {
        List list;
        TreeFilter treeFilter;
        block16: {
            CanonicalTreeParser canonicalTreeParser;
            ObjectReader reader = repository.newObjectReader();
            CanonicalTreeParser $this$readNewCrates_u24lambda_u240 = canonicalTreeParser = new CanonicalTreeParser();
            boolean bl = false;
            ObjectId objectId = this.resolveTreeObject(repository, newHeadHash);
            if (objectId == null) {
                CanonicalTreeParser $this$readNewCrates_u24lambda_u240_u240 = $this$readNewCrates_u24lambda_u240;
                boolean bl2 = false;
                CratesLocalIndexServiceImplKt.access$getLOG$p().error("Git revision `" + newHeadHash + "^{tree}` cannot be resolved to any object id");
                return 0;
            }
            ObjectId currentHeadTree = objectId;
            $this$readNewCrates_u24lambda_u240.reset(reader, (AnyObjectId)currentHeadTree);
            CanonicalTreeParser currentTreeIter = canonicalTreeParser;
            CratesLocalIndexUpdateTask $this$readNewCrates_u24lambda_u241 = this;
            boolean bl3 = false;
            ObjectId objectId2 = $this$readNewCrates_u24lambda_u241.resolveTreeObject(repository, prevHeadHash);
            if (objectId2 == null) {
                treeFilter = TreeFilter.ALL;
            } else {
                List list22;
                ObjectId prevHeadTree = objectId2;
                ObjectId $this$readNewCrates_u24lambda_u241_u240 = currentHeadTree = new CanonicalTreeParser();
                boolean list22 = false;
                $this$readNewCrates_u24lambda_u241_u240.reset(reader, (AnyObjectId)prevHeadTree);
                ObjectId prevTreeIter = currentHeadTree;
                Git git = new Git(repository);
                try {
                    list22 = git.diff().setNewTree((AbstractTreeIterator)currentTreeIter).setOldTree((AbstractTreeIterator)prevTreeIter).call();
                }
                catch (GitAPIException e) {
                    CratesLocalIndexServiceImplKt.access$getLOG$p().error("Failed to calculate diff due to Git API error: " + e.getMessage());
                    treeFilter = TreeFilter.ALL;
                    break block16;
                }
                List changes = list22;
                switch (changes.size()) {
                    case 0: {
                        treeFilter = TreeFilter.ALL;
                        break;
                    }
                    case 1: {
                        Intrinsics.checkNotNull((Object)changes);
                        treeFilter = (TreeFilter)PathFilter.create((String)((DiffEntry)CollectionsKt.single((List)changes)).getNewPath());
                        break;
                    }
                    default: {
                        void $this$mapTo$iv$iv;
                        Intrinsics.checkNotNull((Object)changes);
                        Iterable $this$map$iv = changes;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it2;
                            DiffEntry diffEntry = (DiffEntry)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl4 = false;
                            collection.add(PathFilter.create((String)it2.getNewPath()));
                        }
                        treeFilter = OrTreeFilter.create((Collection)((List)destination$iv$iv));
                    }
                }
            }
        }
        TreeFilter filter2 = treeFilter;
        RevTree revTree = new RevWalk(repository).parseCommit((AnyObjectId)ObjectId.fromString((String)newHeadHash)).getTree();
        ObjectMapper mapper = ExtensionsKt.registerKotlinModule((ObjectMapper)((ObjectMapper)new JsonMapper())).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        AutoCloseable autoCloseable = (AutoCloseable)new TreeWalk(repository);
        Throwable throwable = null;
        try {
            TreeWalk treeWalk = (TreeWalk)autoCloseable;
            boolean bl = false;
            treeWalk.addTree((AnyObjectId)revTree);
            treeWalk.setFilter(filter2);
            treeWalk.setRecursive(true);
            treeWalk.setPostOrderTraversal(false);
            List objectIds = new ArrayList();
            while (treeWalk.next()) {
                if (treeWalk.isSubtree()) continue;
                String path = treeWalk.getPathString();
                Intrinsics.checkNotNull((Object)path);
                if (StringsKt.startsWith$default((String)path, (String)".", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)path, (Object)"config.json")) continue;
                indicator.checkCanceled();
                ObjectId objectId = treeWalk.getObjectId(0);
                objectIds.add(TuplesKt.to((Object)objectId, (Object)treeWalk.getNameString()));
            }
            list = objectIds;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        List objectIds = list;
        return objectIds.stream().mapToInt(arg_0 -> CratesLocalIndexUpdateTask.readNewCrates$lambda$4(arg_0 -> CratesLocalIndexUpdateTask.readNewCrates$lambda$3(indicator, repository, this, mapper, arg_0), arg_0)).sum();
    }

    private final ObjectId resolveTreeObject(Repository $this$resolveTreeObject, String hash) throws IOException {
        ObjectId objectId;
        try {
            objectId = $this$resolveTreeObject.resolve(hash + "^{tree}");
        }
        catch (MissingObjectException e) {
            CratesLocalIndexServiceImplKt.access$getLOG$p().warn((Throwable)e);
            objectId = null;
        }
        return objectId;
    }

    private static final void run$lambda$3(CratesLocalIndexUpdateTask this$0, String $newHeadHash) {
        try {
            this$0.writeNewHeadHash.invoke((Object)$newHeadHash);
        }
        catch (IOException e) {
            CratesLocalIndexServiceImplKt.access$getLOG$p().warn((Throwable)e);
            this$0.onError.invoke((Object)new CratesLocalIndexService.Error.InternalError.PersistentHashMapWriteError(e.toString()));
        }
    }

    private static final int readNewCrates$lambda$3(ProgressIndicator $indicator, Repository $repository, CratesLocalIndexUpdateTask this$0, ObjectMapper $mapper, Pair pair) {
        ObjectId objectId = (ObjectId)pair.component1();
        String name2 = (String)pair.component2();
        $indicator.checkCanceled();
        List versions = new ArrayList();
        CrateVersionInterner interner = new CrateVersionInterner();
        ObjectLoader loader = $repository.open((AnyObjectId)objectId);
        ObjectStream objectStream = loader.openStream();
        Intrinsics.checkNotNullExpressionValue((Object)objectStream, (String)"openStream(...)");
        InputStream inputStream = (InputStream)objectStream;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(inputStream, charset);
        int n = 8192;
        BufferedReader fileReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
        TextStreamsKt.forEachLine((Reader)fileReader, arg_0 -> CratesLocalIndexUpdateTask.readNewCrates$lambda$3$0($mapper, interner, versions, name2, arg_0));
        this$0.writeNewCrate.invoke((Object)TuplesKt.to((Object)name2, (Object)new CargoRegistryCrate(versions)));
        return 1;
    }

    private static final Unit readNewCrates$lambda$3$0(ObjectMapper $mapper, CrateVersionInterner $interner, List $versions, String $name, String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (StringsKt.isBlank((CharSequence)line)) {
            return Unit.INSTANCE;
        }
        try {
            Intrinsics.checkNotNull((Object)$mapper);
            CargoRegistryCrateVersion version = CratesLocalIndexServiceImplKt.access$intern(CratesLocalIndexServiceImplKt.access$crateFromJson(line, $mapper), $interner);
            $versions.add(version);
        }
        catch (Exception e) {
            CratesLocalIndexServiceImplKt.access$getLOG$p().warn("Failed to parse JSON for crate " + $name + ", line " + line, (Throwable)e);
        }
        return Unit.INSTANCE;
    }

    private static final int readNewCrates$lambda$4(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }
}

