/*
 * Decompiled with CFR 0.152.
 */
package org.rust.toml.crates.local;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.openapiext.RsPathManager;
import org.rust.openapiext.UtilsKt;
import org.rust.stdext.PathKt;
import org.rust.stdext.RsResult;
import org.rust.toml.crates.local.CargoRegistryCrate;
import org.rust.toml.crates.local.CrateExternalizer;
import org.rust.toml.crates.local.CratesLocalIndexService;
import org.rust.toml.crates.local.CratesLocalIndexServiceImpl;
import org.rust.toml.crates.local.CratesLocalIndexServiceImplKt;
import org.rust.toml.crates.local.CratesLocalIndexUpdateTask;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B+\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u0004J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015J\u001c\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J.\u0010\u001c\u001a\u00020\u001d2\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00170\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\"J\u0006\u0010#\u001a\u00020\u0017R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/rust/toml/crates/local/CratesLocalIndexServiceImplInner;", "", "crates", "Lcom/intellij/util/io/PersistentHashMap;", "", "Lorg/rust/toml/crates/local/CargoRegistryCrate;", "indexedCommitHashFile", "Ljava/nio/file/Path;", "indexedCommitHash", "<init>", "(Lcom/intellij/util/io/PersistentHashMap;Ljava/nio/file/Path;Ljava/lang/String;)V", "value", "", "lastCargoRegistryUpdateSucceed", "getLastCargoRegistryUpdateSucceed", "()Z", "isClosedLock", "isClosed", "getCrate", "crateName", "getAllCrateNames", "", "writeNewCrate", "", "newCrate", "Lkotlin/Pair;", "writeNewHeadHash", "newHeadHash", "createUpdateTask", "Lorg/rust/toml/crates/local/CratesLocalIndexUpdateTask;", "onError", "Lkotlin/Function2;", "Lorg/rust/toml/crates/local/CratesLocalIndexService$Error$InternalError;", "onFinish", "Lkotlin/Function0;", "close", "Companion", "intellij.rustrover.core"})
final class CratesLocalIndexServiceImplInner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PersistentHashMap<String, CargoRegistryCrate> crates;
    @NotNull
    private final Path indexedCommitHashFile;
    @NotNull
    private String indexedCommitHash;
    private volatile boolean lastCargoRegistryUpdateSucceed;
    @NotNull
    private final Object isClosedLock;
    private boolean isClosed;

    public CratesLocalIndexServiceImplInner(@NotNull PersistentHashMap<String, CargoRegistryCrate> crates, @NotNull Path indexedCommitHashFile, @NotNull String indexedCommitHash) {
        Intrinsics.checkNotNullParameter(crates, (String)"crates");
        Intrinsics.checkNotNullParameter((Object)indexedCommitHashFile, (String)"indexedCommitHashFile");
        Intrinsics.checkNotNullParameter((Object)indexedCommitHash, (String)"indexedCommitHash");
        this.crates = crates;
        this.indexedCommitHashFile = indexedCommitHashFile;
        this.indexedCommitHash = indexedCommitHash;
        this.isClosedLock = new Object();
    }

    public final boolean getLastCargoRegistryUpdateSucceed() {
        return this.lastCargoRegistryUpdateSucceed;
    }

    @Nullable
    public final CargoRegistryCrate getCrate(@NotNull String crateName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)crateName, (String)"crateName");
        return (CargoRegistryCrate)this.crates.get((Object)crateName);
    }

    @NotNull
    public final List<String> getAllCrateNames() throws IOException {
        List crateNames = new ArrayList();
        this.crates.processKeys(arg_0 -> CratesLocalIndexServiceImplInner.getAllCrateNames$lambda$1(arg_0 -> CratesLocalIndexServiceImplInner.getAllCrateNames$lambda$0(crateNames, arg_0), arg_0));
        return crateNames;
    }

    private final void writeNewCrate(Pair<String, CargoRegistryCrate> newCrate) throws IOException {
        this.crates.put(newCrate.getFirst(), newCrate.getSecond());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeNewHeadHash(String newHeadHash) throws IOException {
        this.crates.force();
        Object object = this.isClosedLock;
        synchronized (object) {
            boolean bl = false;
            if (this.isClosed) {
                return;
            }
            CratesLocalIndexServiceImplInner.Companion.writeCommitHash(this.indexedCommitHashFile, newHeadHash);
            this.indexedCommitHash = newHeadHash;
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final CratesLocalIndexUpdateTask createUpdateTask(@NotNull Function2<? super CratesLocalIndexServiceImplInner, ? super CratesLocalIndexService.Error.InternalError, Unit> onError, @NotNull Function0<Unit> onFinish) {
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        Intrinsics.checkNotNullParameter(onFinish, (String)"onFinish");
        return new CratesLocalIndexUpdateTask((Function0<String>)((Function0)() -> CratesLocalIndexServiceImplInner.createUpdateTask$lambda$0(this)), (Function1<? super Pair<String, CargoRegistryCrate>, Unit>)((Function1)new Function1<Pair<? extends String, ? extends CargoRegistryCrate>, Unit>((Object)this){

            public final void invoke(Pair<String, CargoRegistryCrate> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                CratesLocalIndexServiceImplInner.access$writeNewCrate((CratesLocalIndexServiceImplInner)this.receiver, p0);
            }
        }), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Object)this){

            public final void invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                CratesLocalIndexServiceImplInner.access$writeNewHeadHash((CratesLocalIndexServiceImplInner)this.receiver, p0);
            }
        }), (Function1<? super CratesLocalIndexService.Error.InternalError, Unit>)((Function1)arg_0 -> CratesLocalIndexServiceImplInner.createUpdateTask$lambda$1(onError, this, arg_0)), (Function1<? super Boolean, Unit>)((Function1)arg_0 -> CratesLocalIndexServiceImplInner.createUpdateTask$lambda$2(this, onFinish, arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        Object object = this.isClosedLock;
        synchronized (object) {
            boolean bl = false;
            this.isClosed = true;
            Unit unit = Unit.INSTANCE;
        }
        CratesLocalIndexServiceImplInner.Companion.catchAndWarn((Function0<Unit>)((Function0)new Function0<Unit>(this.crates){

            public final void invoke() {
                ((PersistentHashMap)this.receiver).close();
            }
        }));
    }

    private static final boolean getAllCrateNames$lambda$0(List $crateNames, String name2) {
        Intrinsics.checkNotNull((Object)name2);
        return $crateNames.add(name2);
    }

    private static final boolean getAllCrateNames$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String createUpdateTask$lambda$0(CratesLocalIndexServiceImplInner this$0) {
        return this$0.indexedCommitHash;
    }

    private static final Unit createUpdateTask$lambda$1(Function2 $onError, CratesLocalIndexServiceImplInner this$0, CratesLocalIndexService.Error.InternalError it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        $onError.invoke((Object)this$0, (Object)it2);
        return Unit.INSTANCE;
    }

    private static final Unit createUpdateTask$lambda$2(CratesLocalIndexServiceImplInner this$0, Function0 $onFinish, boolean it2) {
        this$0.lastCargoRegistryUpdateSucceed = it2;
        $onFinish.invoke();
        return Unit.INSTANCE;
    }

    @JvmStatic
    private static final void catchAndWarn(Function0<Unit> runnable) {
        CratesLocalIndexServiceImplInner.Companion.catchAndWarn((Function0<Unit>)runnable);
    }

    public static final /* synthetic */ void access$writeNewCrate(CratesLocalIndexServiceImplInner $this, Pair newCrate) {
        $this.writeNewCrate((Pair<String, CargoRegistryCrate>)newCrate);
    }

    public static final /* synthetic */ void access$writeNewHeadHash(CratesLocalIndexServiceImplInner $this, String newHeadHash) {
        $this.writeNewHeadHash(newHeadHash);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0016\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013H\u0003\u00a8\u0006\u0014"}, d2={"Lorg/rust/toml/crates/local/CratesLocalIndexServiceImplInner$Companion;", "", "<init>", "()V", "tryCreate", "Lorg/rust/stdext/RsResult;", "Lorg/rust/toml/crates/local/CratesLocalIndexServiceImplInner;", "Lorg/rust/toml/crates/local/CratesLocalIndexService$Error$InternalError;", "baseCratesLocalRegistryDir", "Ljava/nio/file/Path;", "tryCreateRegistryDirFromCache", "", "readCommitHash", "", "indexedCommitHashFile", "writeCommitHash", "hash", "catchAndWarn", "runnable", "Lkotlin/Function0;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RsResult<CratesLocalIndexServiceImplInner, CratesLocalIndexService.Error.InternalError> tryCreate(@NotNull Path baseCratesLocalRegistryDir) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)baseCratesLocalRegistryDir, (String)"baseCratesLocalRegistryDir");
            if (!UtilsKt.isUnitTestMode()) {
                UtilsKt.checkIsBackgroundThread();
            }
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(baseCratesLocalRegistryDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                this.tryCreateRegistryDirFromCache(baseCratesLocalRegistryDir);
            }
            Path indexedCommitHashFile = baseCratesLocalRegistryDir.resolve("indexed-commit-hash");
            Ref.ObjectRef indexedCommitHash = new Ref.ObjectRef();
            Intrinsics.checkNotNull((Object)indexedCommitHashFile);
            indexedCommitHash.element = this.readCommitHash(indexedCommitHashFile);
            if (Intrinsics.areEqual((Object)indexedCommitHash.element, (Object)"<invalid>")) {
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (Files.exists(baseCratesLocalRegistryDir, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                    try {
                        PathKt.cleanDirectory(baseCratesLocalRegistryDir);
                    }
                    catch (IOException e) {
                        CratesLocalIndexServiceImplKt.access$getLOG$p().error("Cannot clean directory " + baseCratesLocalRegistryDir, (Throwable)e);
                    }
                }
            }
            Path cratesFilePath = baseCratesLocalRegistryDir.resolve("crates-local-index");
            try {
                object = IOUtil.openCleanOrResetBroken(() -> Companion.tryCreate$lambda$0(cratesFilePath), () -> Companion.tryCreate$lambda$1(baseCratesLocalRegistryDir, indexedCommitHash));
                Intrinsics.checkNotNull((Object)object);
                object = (PersistentHashMap)object;
            }
            catch (IOException e) {
                CratesLocalIndexServiceImplKt.access$getLOG$p().error("Cannot open or create PersistentHashMap in " + cratesFilePath, (Throwable)e);
                Intrinsics.checkNotNull((Object)cratesFilePath);
                return new RsResult.Err<CratesLocalIndexService.Error.InternalError.PersistentHashMapInitError>(new CratesLocalIndexService.Error.InternalError.PersistentHashMapInitError(cratesFilePath, e.toString()));
            }
            Object crates = object;
            CratesLocalIndexServiceImplInner inner = new CratesLocalIndexServiceImplInner((PersistentHashMap<String, CargoRegistryCrate>)crates, indexedCommitHashFile, (String)indexedCommitHash.element);
            return new RsResult.Ok<CratesLocalIndexServiceImplInner>(inner);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void tryCreateRegistryDirFromCache(Path baseCratesLocalRegistryDir) {
            try {
                baseCratesLocalRegistryDir.toFile().mkdirs();
                Path cratesLocalIndexZip = RsPathManager.INSTANCE.bundledCachesDir().resolve(CratesLocalIndexServiceImpl.Companion.getCratesLocalIndexZipName());
                Intrinsics.checkNotNull((Object)cratesLocalIndexZip);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(cratesLocalIndexZip, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    return;
                }
                ZipInputStream zipStream = new ZipInputStream(Files.newInputStream(cratesLocalIndexZip, new OpenOption[0]));
                Closeable closeable = zipStream;
                Throwable throwable = null;
                try {
                    ZipInputStream it2 = (ZipInputStream)closeable;
                    boolean bl = false;
                    while (it2.getNextEntry() != null) {
                        ZipEntry entry2;
                        File file = baseCratesLocalRegistryDir.resolve(entry2.getName()).toFile();
                        Closeable closeable2 = new FileOutputStream(file);
                        Throwable throwable2 = null;
                        try {
                            FileOutputStream outputStream = (FileOutputStream)closeable2;
                            boolean bl2 = false;
                            long l = ByteStreamsKt.copyTo$default((InputStream)zipStream, (OutputStream)outputStream, (int)0, (int)2, null);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                CratesLocalIndexServiceImplKt.access$getLOG$p().warn("Failed to copy registry cache to " + baseCratesLocalRegistryDir, (Throwable)e);
                try {
                    Path path = PathKt.cleanDirectory(baseCratesLocalRegistryDir);
                }
                catch (Exception exception) {
                    Unit unit = Unit.INSTANCE;
                }
            }
        }

        private final String readCommitHash(Path indexedCommitHashFile) {
            String string;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(indexedCommitHashFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                String string2;
                try {
                    string2 = Files.readString(indexedCommitHashFile);
                    Intrinsics.checkNotNull((Object)string2);
                }
                catch (IOException e) {
                    CratesLocalIndexServiceImplKt.access$getLOG$p().warn("Cannot read file " + indexedCommitHashFile, (Throwable)e);
                    string2 = "<invalid>";
                }
                string = string2;
            } else {
                string = "<invalid>";
            }
            return string;
        }

        private final void writeCommitHash(Path indexedCommitHashFile, String hash) throws IOException {
            Files.writeString(indexedCommitHashFile, (CharSequence)hash, new OpenOption[0]);
        }

        @JvmStatic
        private final void catchAndWarn(Function0<Unit> runnable) {
            try {
                runnable.invoke();
            }
            catch (IOException e) {
                CratesLocalIndexServiceImplKt.access$getLOG$p().warn((Throwable)e);
            }
            catch (Throwable t) {
                CratesLocalIndexServiceImplKt.access$getLOG$p().error(t);
            }
        }

        private static final PersistentHashMap tryCreate$lambda$0(Path $cratesFilePath) {
            return new PersistentHashMap($cratesFilePath, (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, (DataExternalizer)CrateExternalizer.INSTANCE, 4096, 4);
        }

        private static final void tryCreate$lambda$1(Path $baseCratesLocalRegistryDir, Ref.ObjectRef $indexedCommitHash) {
            PathKt.cleanDirectory($baseCratesLocalRegistryDir);
            $indexedCommitHash.element = "<invalid>";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

