/*
 * Decompiled with CFR 0.152.
 */
package org.rust.toml.crates.local;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Alarm;
import com.intellij.util.io.PathKt;
import com.intellij.util.ui.UIUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectsService;
import org.rust.openapiext.RsPathManager;
import org.rust.openapiext.UtilsKt;
import org.rust.stdext.RsResult;
import org.rust.toml.crates.local.CargoRegistryCrate;
import org.rust.toml.crates.local.CratesLocalIndexService;
import org.rust.toml.crates.local.CratesLocalIndexServiceImpl;
import org.rust.toml.crates.local.CratesLocalIndexServiceImplInner;
import org.rust.toml.crates.local.CratesLocalIndexServiceImplKt;
import org.rust.toml.crates.local.RsCratesLocalIndexPersistenceState;
import org.rust.toml.statistics.RsCratesLocalIndexCollector;
import org.rust.util.RsBackgroundTaskQueue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\t\u0018\u0000 <2\u00020\u00012\u00020\u0002:\u0002;<B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001e\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010\u0017\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0004\u0012\u00020\u001a0\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001e\u0010\u001d\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0004\u0012\u00020\u001a0\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\"\u0010\u001e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001f\u0012\u0004\u0012\u00020\u001a0\u00182\u0006\u0010 \u001a\u00020!H\u0016J8\u0010\"\u001a\u000e\u0012\u0004\u0012\u0002H#\u0012\u0004\u0012\u00020\u001a0\u0018\"\u0004\b\u0000\u0010#2\b\b\u0002\u0010$\u001a\u00020\u000e2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u0002H#0\u0014H\u0002J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u0006\u0010,\u001a\u00020\u0016J\b\u0010-\u001a\u00020\u0016H\u0002J\b\u0010.\u001a\u00020\u0016H\u0007J\u0010\u0010-\u001a\u00020\u00162\u0006\u0010/\u001a\u00020%H\u0002J\u0010\u00100\u001a\u00020\u000e2\u0006\u0010/\u001a\u00020%H\u0002J\u0010\u00101\u001a\u00020\u00162\u0006\u0010/\u001a\u00020%H\u0002J\u0010\u00102\u001a\u00020\u00162\u0006\u00103\u001a\u000204H\u0002J\b\u00105\u001a\u00020\u0016H\u0016J\u0018\u00106\u001a\u00020\u00162\u0006\u0010/\u001a\u00020%2\u0006\u00107\u001a\u00020'H\u0002J\u0018\u00108\u001a\u00020\u00162\u0006\u0010/\u001a\u00020%2\u0006\u00107\u001a\u00020'H\u0002J\b\u00109\u001a\u00020\u0016H\u0002J\b\u0010:\u001a\u00020\u0016H\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/rust/toml/crates/local/CratesLocalIndexServiceImpl;", "Lorg/rust/toml/crates/local/CratesLocalIndexService;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "queue", "Lorg/rust/util/RsBackgroundTaskQueue;", "alarm", "Lcom/intellij/util/Alarm;", "innerStateLock", "", "innerState", "Lorg/rust/toml/crates/local/CratesLocalIndexServiceImpl$InnerState;", "isUpdating", "", "()Z", "updateTaskCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "stateTransition", "action", "Lkotlin/Function1;", "loadAsync", "", "getCrate", "Lorg/rust/stdext/RsResult;", "Lorg/rust/toml/crates/local/CargoRegistryCrate;", "Lorg/rust/toml/crates/local/CratesLocalIndexService$Error;", "crateName", "", "getCrateUnreliably", "getAllCrateNamesUnreliably", "", "project", "Lcom/intellij/openapi/project/Project;", "handleErrors", "T", "unreliable", "Lorg/rust/toml/crates/local/CratesLocalIndexServiceImplInner;", "onPersistentHashMapError", "Lorg/rust/toml/crates/local/CratesLocalIndexService$Error$InternalError;", "lastInnerState", "Lorg/rust/toml/crates/local/CratesLocalIndexServiceImpl$InnerState$Loaded;", "e", "Ljava/io/IOException;", "updateOrRecoverIfNeeded", "updateIndexIfNeeded", "forceUpdateIndex", "inner", "needsUpdate", "doUpdateIndex", "scheduleUpdate", "delay", "", "dispose", "updateTaskFailed", "err", "transitToErrorState", "updateTaskFinished", "awaitLoadedAndUpdated", "InnerState", "Companion", "intellij.rustrover.core"})
public final class CratesLocalIndexServiceImpl
implements CratesLocalIndexService,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RsBackgroundTaskQueue queue = new RsBackgroundTaskQueue();
    @NotNull
    private final Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    @NotNull
    private final Object innerStateLock = new Object();
    @NotNull
    private volatile InnerState innerState = InnerState.Loading.INSTANCE;
    @NotNull
    private final AtomicInteger updateTaskCount = new AtomicInteger(0);
    @NotNull
    private static final String cratesLocalIndexZipName = "crates-local-index.zip";
    private static final int DEFAULT_UPDATE_INTERVAL_MIN = 60;
    private static final int MIN_UPDATE_INTERVAL_MIN = 1;
    @NotNull
    private static final String CORRUPTION_MARKER_NAME = "corruption.marker";

    public CratesLocalIndexServiceImpl() {
        this.loadAsync();
    }

    @Override
    public boolean isUpdating() {
        return this.updateTaskCount.get() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final InnerState stateTransition(Function1<? super InnerState, ? extends InnerState> action2) {
        InnerState innerState;
        Object object = this.innerStateLock;
        synchronized (object) {
            InnerState innerState2;
            InnerState newState;
            boolean bl = false;
            InnerState oldState = this.innerState;
            this.innerState = newState = (InnerState)action2.invoke((Object)oldState);
            if (!Intrinsics.areEqual((Object)newState, (Object)oldState)) {
                CratesLocalIndexServiceImplKt.access$getLOG$p().debug("CratesLocalIndexService state transition " + oldState + " -> " + newState);
                innerState2 = newState;
            } else {
                innerState2 = null;
            }
            innerState = innerState2;
        }
        return innerState;
    }

    private final void loadAsync() {
        CratesLocalIndexServiceImplKt.access$getLOG$p().debug("Loading CratesLocalIndexService");
        ApplicationManager.getApplication().executeOnPooledThread(() -> CratesLocalIndexServiceImpl.loadAsync$lambda$0(this));
    }

    @Override
    @NotNull
    public RsResult<CargoRegistryCrate, CratesLocalIndexService.Error> getCrate(@NotNull String crateName) {
        Intrinsics.checkNotNullParameter((Object)crateName, (String)"crateName");
        return CratesLocalIndexServiceImpl.handleErrors$default(this, false, arg_0 -> CratesLocalIndexServiceImpl.getCrate$lambda$0(crateName, arg_0), 1, null);
    }

    @Override
    @NotNull
    public RsResult<CargoRegistryCrate, CratesLocalIndexService.Error> getCrateUnreliably(@NotNull String crateName) {
        Intrinsics.checkNotNullParameter((Object)crateName, (String)"crateName");
        return this.handleErrors(true, arg_0 -> CratesLocalIndexServiceImpl.getCrateUnreliably$lambda$0(crateName, arg_0));
    }

    @Override
    @NotNull
    public RsResult<List<String>, CratesLocalIndexService.Error> getAllCrateNamesUnreliably(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!((RsCratesLocalIndexPersistenceState.MyState)RsCratesLocalIndexPersistenceState.Companion.getInstance().getState()).getLocalIndexUpdated()) {
            RsCratesLocalIndexCollector.INSTANCE.logPrebuiltLocalIndexAccessed(project);
        }
        return this.handleErrors(true, getAllCrateNamesUnreliably.1.INSTANCE);
    }

    private final <T> RsResult<T, CratesLocalIndexService.Error> handleErrors(boolean unreliable, Function1<? super CratesLocalIndexServiceImplInner, ? extends T> action2) {
        RsResult rsResult;
        if (this.isUpdating() && !unreliable) {
            return new RsResult.Err<CratesLocalIndexService.Error.Updating>(CratesLocalIndexService.Error.Updating.INSTANCE);
        }
        InnerState innerState = this.innerState;
        if (Intrinsics.areEqual((Object)innerState, (Object)InnerState.Loading.INSTANCE)) {
            rsResult = new RsResult.Err<CratesLocalIndexService.Error.NotYetLoaded>(CratesLocalIndexService.Error.NotYetLoaded.INSTANCE);
        } else if (innerState instanceof InnerState.Loaded) {
            if (((InnerState.Loaded)innerState).getInner().getLastCargoRegistryUpdateSucceed() || unreliable) {
                RsResult rsResult2;
                try {
                    rsResult2 = new RsResult.Ok<Object>(action2.invoke((Object)((InnerState.Loaded)innerState).getInner()));
                }
                catch (IOException e) {
                    rsResult2 = new RsResult.Err<CratesLocalIndexService.Error.InternalError>(this.onPersistentHashMapError((InnerState.Loaded)innerState, e));
                }
                rsResult = rsResult2;
            } else {
                rsResult = new RsResult.Err<CratesLocalIndexService.Error.InternalError.CargoCratesIoGitRegistryUpdateError>(CratesLocalIndexService.Error.InternalError.CargoCratesIoGitRegistryUpdateError.INSTANCE);
            }
        } else if (innerState instanceof InnerState.Err) {
            rsResult = new RsResult.Err<CratesLocalIndexService.Error.InternalError>(((InnerState.Err)innerState).getErr());
        } else if (innerState instanceof InnerState.Disposed) {
            rsResult = new RsResult.Err<CratesLocalIndexService.Error.Disposed>(CratesLocalIndexService.Error.Disposed.INSTANCE);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return rsResult;
    }

    static /* synthetic */ RsResult handleErrors$default(CratesLocalIndexServiceImpl cratesLocalIndexServiceImpl, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return cratesLocalIndexServiceImpl.handleErrors(bl, function1);
    }

    private final CratesLocalIndexService.Error.InternalError onPersistentHashMapError(InnerState.Loaded lastInnerState, IOException e) {
        CratesLocalIndexService.Error.InternalError.PersistentHashMapReadError err = new CratesLocalIndexService.Error.InternalError.PersistentHashMapReadError(e.toString());
        this.transitToErrorState(lastInnerState.getInner(), err);
        CratesLocalIndexServiceImplKt.access$getLOG$p().warn((Throwable)e);
        return err;
    }

    public final void updateOrRecoverIfNeeded() {
        InnerState newState = this.stateTransition((Function1<? super InnerState, ? extends InnerState>)((Function1)CratesLocalIndexServiceImpl::updateOrRecoverIfNeeded$lambda$0));
        if (newState != null) {
            this.loadAsync();
        } else {
            this.updateIndexIfNeeded();
        }
    }

    private final void updateIndexIfNeeded() {
        InnerState innerState = this.innerState;
        if (!(innerState instanceof InnerState.Loaded)) {
            return;
        }
        this.updateIndexIfNeeded(((InnerState.Loaded)innerState).getInner());
    }

    @TestOnly
    public final void forceUpdateIndex() {
        InnerState innerState = this.innerState;
        if (!(innerState instanceof InnerState.Loaded)) {
            return;
        }
        this.doUpdateIndex(((InnerState.Loaded)innerState).getInner());
    }

    private final void updateIndexIfNeeded(CratesLocalIndexServiceImplInner inner) {
        if (!this.needsUpdate(inner)) {
            return;
        }
        this.doUpdateIndex(inner);
    }

    private final boolean needsUpdate(CratesLocalIndexServiceImplInner inner) {
        return (Boolean)ActionsKt.runReadAction(() -> CratesLocalIndexServiceImpl.needsUpdate$lambda$0(inner, this));
    }

    private final void doUpdateIndex(CratesLocalIndexServiceImplInner inner) {
        this.updateTaskCount.incrementAndGet();
        this.alarm.cancelAllRequests();
        this.queue.run(inner.createUpdateTask((Function2<? super CratesLocalIndexServiceImplInner, ? super CratesLocalIndexService.Error.InternalError, Unit>)((Function2)new Function2<CratesLocalIndexServiceImplInner, CratesLocalIndexService.Error.InternalError, Unit>((Object)this){

            public final void invoke(CratesLocalIndexServiceImplInner p0, CratesLocalIndexService.Error.InternalError p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                CratesLocalIndexServiceImpl.access$updateTaskFailed((CratesLocalIndexServiceImpl)this.receiver, p0, p1);
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                CratesLocalIndexServiceImpl.access$updateTaskFinished((CratesLocalIndexServiceImpl)this.receiver);
            }
        })));
    }

    private final void scheduleUpdate(int delay) {
        if (this.alarm.isEmpty() && !UtilsKt.isUnitTestMode()) {
            this.alarm.addRequest(this::updateOrRecoverIfNeeded, delay, true);
            CratesLocalIndexServiceImplKt.access$getLOG$p().info("crates.io index update is scheduled in " + delay + " ms");
        }
    }

    public void dispose() {
        this.queue.dispose();
        this.stateTransition((Function1<? super InnerState, ? extends InnerState>)((Function1)CratesLocalIndexServiceImpl::dispose$lambda$0));
    }

    private final void updateTaskFailed(CratesLocalIndexServiceImplInner inner, CratesLocalIndexService.Error.InternalError err) {
        this.transitToErrorState(inner, err);
    }

    private final void transitToErrorState(CratesLocalIndexServiceImplInner inner, CratesLocalIndexService.Error.InternalError err) {
        this.stateTransition((Function1<? super InnerState, ? extends InnerState>)((Function1)arg_0 -> CratesLocalIndexServiceImpl.transitToErrorState$lambda$0(inner, err, arg_0)));
    }

    private final void updateTaskFinished() {
        ActionsKt.runWriteAction(() -> CratesLocalIndexServiceImpl.updateTaskFinished$lambda$0(this));
        CratesLocalIndexServiceImplKt.access$reHighlightOpenedProjects("CratesLocalIndexServiceImpl.updateTaskFinished");
        this.scheduleUpdate(CratesLocalIndexServiceImpl.Companion.getUpdateIntervalMillis());
    }

    @TestOnly
    public final void awaitLoadedAndUpdated() {
        while (this.innerState instanceof InnerState.Loading || this.isUpdating()) {
            Thread.sleep(10L);
            UIUtil.dispatchAllInvocationEvents();
        }
    }

    private static final void loadAsync$lambda$0(CratesLocalIndexServiceImpl this$0) {
        InnerState newState;
        try {
            Companion.resetIndexIfNeeded();
        }
        catch (IOException e) {
            CratesLocalIndexServiceImplKt.access$getLOG$p().error((Throwable)e);
        }
        RsResult<CratesLocalIndexServiceImplInner, CratesLocalIndexService.Error.InternalError> inner = CratesLocalIndexServiceImplInner.Companion.tryCreate(Companion.getBaseCratesLocalIndexDir());
        InnerState innerState = newState = this$0.stateTransition((Function1<? super InnerState, ? extends InnerState>)((Function1)arg_0 -> CratesLocalIndexServiceImpl.loadAsync$lambda$0$0(inner, arg_0)));
        if (innerState instanceof InnerState.Loaded) {
            this$0.updateIndexIfNeeded(((InnerState.Loaded)newState).getInner());
        } else if (Intrinsics.areEqual((Object)innerState, (Object)InnerState.Disposed.INSTANCE)) {
            CratesLocalIndexServiceImplInner cratesLocalIndexServiceImplInner = inner.ok();
            if (cratesLocalIndexServiceImplInner != null) {
                cratesLocalIndexServiceImplInner.close();
            }
        }
        CratesLocalIndexServiceImplKt.access$getLOG$p().debug("Loading CratesLocalIndexService finished");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final InnerState loadAsync$lambda$0$0(RsResult $inner, InnerState oldState) {
        InnerState innerState;
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        InnerState innerState2 = oldState;
        if (Intrinsics.areEqual((Object)innerState2, (Object)InnerState.Loading.INSTANCE)) {
            RsResult rsResult = $inner;
            if (rsResult instanceof RsResult.Ok) {
                innerState = new InnerState.Loaded((CratesLocalIndexServiceImplInner)((RsResult.Ok)$inner).getOk());
                return innerState;
            } else {
                if (!(rsResult instanceof RsResult.Err)) throw new NoWhenBranchMatchedException();
                innerState = new InnerState.Err((CratesLocalIndexService.Error.InternalError)((RsResult.Err)$inner).getErr());
            }
            return innerState;
        } else {
            if (innerState2 instanceof InnerState.Loaded || innerState2 instanceof InnerState.Err) {
                throw new IllegalStateException("unreachable".toString());
            }
            if (!Intrinsics.areEqual((Object)innerState2, (Object)InnerState.Disposed.INSTANCE)) throw new NoWhenBranchMatchedException();
            innerState = InnerState.Disposed.INSTANCE;
        }
        return innerState;
    }

    private static final CargoRegistryCrate getCrate$lambda$0(String $crateName, CratesLocalIndexServiceImplInner it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2.getCrate($crateName);
    }

    private static final CargoRegistryCrate getCrateUnreliably$lambda$0(String $crateName, CratesLocalIndexServiceImplInner it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2.getCrate($crateName);
    }

    private static final InnerState updateOrRecoverIfNeeded$lambda$0(InnerState oldState) {
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        return oldState instanceof InnerState.Err ? (InnerState)InnerState.Loading.INSTANCE : oldState;
    }

    private static final boolean needsUpdate$lambda$0(CratesLocalIndexServiceImplInner $inner, CratesLocalIndexServiceImpl this$0) {
        if (!CratesLocalIndexServiceImpl.Companion.getHasOpenRustProject()) {
            return false;
        }
        if (!$inner.getLastCargoRegistryUpdateSucceed() && !this$0.isUpdating()) {
            return true;
        }
        long lastUpdate = PropertiesComponent.getInstance().getLong("CRATES_IO_INDEX_LAST_UPDATE", 0L);
        long sinceLastUpdate = System.currentTimeMillis() - lastUpdate;
        if (sinceLastUpdate < (long)CratesLocalIndexServiceImpl.Companion.getUpdateIntervalMillis()) {
            if (this$0.alarm.isEmpty()) {
                this$0.scheduleUpdate(CratesLocalIndexServiceImpl.Companion.getUpdateIntervalMillis() - (int)sinceLastUpdate);
            }
            return false;
        }
        return true;
    }

    private static final InnerState dispose$lambda$0(InnerState oldState) {
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        if (oldState instanceof InnerState.Loaded) {
            ((InnerState.Loaded)oldState).getInner().close();
        }
        return InnerState.Disposed.INSTANCE;
    }

    private static final InnerState transitToErrorState$lambda$0(CratesLocalIndexServiceImplInner $inner, CratesLocalIndexService.Error.InternalError $err, InnerState oldState) {
        InnerState innerState;
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        if (oldState instanceof InnerState.Loaded && Intrinsics.areEqual((Object)((InnerState.Loaded)oldState).getInner(), (Object)$inner)) {
            $inner.close();
            innerState = new InnerState.Err($err);
        } else {
            innerState = oldState;
        }
        return innerState;
    }

    private static final Unit updateTaskFinished$lambda$0(CratesLocalIndexServiceImpl this$0) {
        this$0.updateTaskCount.decrementAndGet();
        PropertiesComponent.getInstance().setValue("CRATES_IO_INDEX_LAST_UPDATE", String.valueOf(System.currentTimeMillis()));
        return Unit.INSTANCE;
    }

    @JvmStatic
    public static final void invalidateCaches() throws IOException {
        Companion.invalidateCaches();
    }

    public static final /* synthetic */ void access$updateTaskFailed(CratesLocalIndexServiceImpl $this, CratesLocalIndexServiceImplInner inner, CratesLocalIndexService.Error.InternalError err) {
        $this.updateTaskFailed(inner, err);
    }

    public static final /* synthetic */ void access$updateTaskFinished(CratesLocalIndexServiceImpl $this) {
        $this.updateTaskFinished();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0014\u001a\u00020\u0015H\u0007J\u0006\u0010\u0016\u001a\u00020\u0015R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\rX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lorg/rust/toml/crates/local/CratesLocalIndexServiceImpl$Companion;", "", "<init>", "()V", "baseCratesLocalIndexDir", "Ljava/nio/file/Path;", "getBaseCratesLocalIndexDir", "()Ljava/nio/file/Path;", "corruptionMarkerFile", "getCorruptionMarkerFile", "localIndexCargoHome", "getLocalIndexCargoHome", "cratesLocalIndexZipName", "", "getCratesLocalIndexZipName", "()Ljava/lang/String;", "DEFAULT_UPDATE_INTERVAL_MIN", "", "MIN_UPDATE_INTERVAL_MIN", "CORRUPTION_MARKER_NAME", "invalidateCaches", "", "resetIndexIfNeeded", "hasOpenRustProject", "", "getHasOpenRustProject", "()Z", "updateIntervalMillis", "getUpdateIntervalMillis", "()I", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nCratesLocalIndexServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CratesLocalIndexServiceImpl.kt\norg/rust/toml/crates/local/CratesLocalIndexServiceImpl$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,906:1\n12970#2,2:907\n*S KotlinDebug\n*F\n+ 1 CratesLocalIndexServiceImpl.kt\norg/rust/toml/crates/local/CratesLocalIndexServiceImpl$Companion\n*L\n365#1:907,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Path getBaseCratesLocalIndexDir() {
            Path path = RsPathManager.INSTANCE.pluginDirInSystem().resolve("crates-local-index");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return path;
        }

        private final Path getCorruptionMarkerFile() {
            Path path = this.getBaseCratesLocalIndexDir().resolve(CratesLocalIndexServiceImpl.CORRUPTION_MARKER_NAME);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return path;
        }

        @NotNull
        public final Path getLocalIndexCargoHome() {
            Path path = RsPathManager.INSTANCE.pluginDirInSystem().resolve("crates-local-index-cargo-home");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return path;
        }

        @NotNull
        public final String getCratesLocalIndexZipName() {
            return cratesLocalIndexZipName;
        }

        @JvmStatic
        public final void invalidateCaches() throws IOException {
            Path path;
            Path $this$invalidateCaches_u24lambda_u240 = path = this.getCorruptionMarkerFile();
            boolean bl = false;
            Path path2 = $this$invalidateCaches_u24lambda_u240.getParent();
            if (path2 != null) {
                PathKt.createDirectories((Path)path2);
            }
            Files.createFile($this$invalidateCaches_u24lambda_u240, new FileAttribute[0]);
        }

        public final void resetIndexIfNeeded() throws IOException {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(this.getCorruptionMarkerFile(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                org.rust.stdext.PathKt.cleanDirectory(this.getBaseCratesLocalIndexDir());
            }
        }

        private final boolean getHasOpenRustProject() {
            boolean bl;
            block1: {
                Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
                Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
                Object[] $this$any$iv = projectArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    Project it2 = (Project)element$iv;
                    boolean bl2 = false;
                    CargoProjectsService cargoProjectsService = (CargoProjectsService)it2.getServiceIfCreated(CargoProjectsService.class);
                    Collection<CargoProject> collection = cargoProjectsService != null ? cargoProjectsService.getAllProjects() : null;
                    if (!(!(collection == null || collection.isEmpty()))) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        private final int getUpdateIntervalMillis() {
            int intervalMin = Math.max(1, Registry.Companion.intValue("org.rust.crates.local.index.update.interval", 60));
            long intervalMillis = TimeUnit.MINUTES.toMillis(intervalMin);
            return intervalMillis > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)intervalMillis;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0004\u0004\u0005\u0006\u0007B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0004\b\t\n\u000b\u00a8\u0006\f"}, d2={"Lorg/rust/toml/crates/local/CratesLocalIndexServiceImpl$InnerState;", "", "<init>", "()V", "Loading", "Loaded", "Err", "Disposed", "Lorg/rust/toml/crates/local/CratesLocalIndexServiceImpl$InnerState$Disposed;", "Lorg/rust/toml/crates/local/CratesLocalIndexServiceImpl$InnerState$Err;", "Lorg/rust/toml/crates/local/CratesLocalIndexServiceImpl$InnerState$Loaded;", "Lorg/rust/toml/crates/local/CratesLocalIndexServiceImpl$InnerState$Loading;", "intellij.rustrover.core"})
    private static abstract sealed class InnerState {
        private InnerState() {
        }

        public /* synthetic */ InnerState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/rust/toml/crates/local/CratesLocalIndexServiceImpl$InnerState$Disposed;", "Lorg/rust/toml/crates/local/CratesLocalIndexServiceImpl$InnerState;", "<init>", "()V", "toString", "", "intellij.rustrover.core"})
        public static final class Disposed
        extends InnerState {
            @NotNull
            public static final Disposed INSTANCE = new Disposed();

            private Disposed() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "InnerState.Disposed";
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/rust/toml/crates/local/CratesLocalIndexServiceImpl$InnerState$Err;", "Lorg/rust/toml/crates/local/CratesLocalIndexServiceImpl$InnerState;", "err", "Lorg/rust/toml/crates/local/CratesLocalIndexService$Error$InternalError;", "<init>", "(Lorg/rust/toml/crates/local/CratesLocalIndexService$Error$InternalError;)V", "getErr", "()Lorg/rust/toml/crates/local/CratesLocalIndexService$Error$InternalError;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class Err
        extends InnerState {
            @NotNull
            private final CratesLocalIndexService.Error.InternalError err;

            public Err(@NotNull CratesLocalIndexService.Error.InternalError err) {
                Intrinsics.checkNotNullParameter((Object)err, (String)"err");
                super(null);
                this.err = err;
            }

            @NotNull
            public final CratesLocalIndexService.Error.InternalError getErr() {
                return this.err;
            }

            @NotNull
            public final CratesLocalIndexService.Error.InternalError component1() {
                return this.err;
            }

            @NotNull
            public final Err copy(@NotNull CratesLocalIndexService.Error.InternalError err) {
                Intrinsics.checkNotNullParameter((Object)err, (String)"err");
                return new Err(err);
            }

            public static /* synthetic */ Err copy$default(Err err, CratesLocalIndexService.Error.InternalError internalError, int n, Object object) {
                if ((n & 1) != 0) {
                    internalError = err.err;
                }
                return err.copy(internalError);
            }

            @NotNull
            public String toString() {
                return "Err(err=" + this.err + ")";
            }

            public int hashCode() {
                return this.err.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Err)) {
                    return false;
                }
                Err err = (Err)other;
                return Intrinsics.areEqual((Object)this.err, (Object)err.err);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/rust/toml/crates/local/CratesLocalIndexServiceImpl$InnerState$Loaded;", "Lorg/rust/toml/crates/local/CratesLocalIndexServiceImpl$InnerState;", "inner", "Lorg/rust/toml/crates/local/CratesLocalIndexServiceImplInner;", "<init>", "(Lorg/rust/toml/crates/local/CratesLocalIndexServiceImplInner;)V", "getInner", "()Lorg/rust/toml/crates/local/CratesLocalIndexServiceImplInner;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.rustrover.core"})
        public static final class Loaded
        extends InnerState {
            @NotNull
            private final CratesLocalIndexServiceImplInner inner;

            public Loaded(@NotNull CratesLocalIndexServiceImplInner inner) {
                Intrinsics.checkNotNullParameter((Object)inner, (String)"inner");
                super(null);
                this.inner = inner;
            }

            @NotNull
            public final CratesLocalIndexServiceImplInner getInner() {
                return this.inner;
            }

            @NotNull
            public final CratesLocalIndexServiceImplInner component1() {
                return this.inner;
            }

            @NotNull
            public final Loaded copy(@NotNull CratesLocalIndexServiceImplInner inner) {
                Intrinsics.checkNotNullParameter((Object)inner, (String)"inner");
                return new Loaded(inner);
            }

            public static /* synthetic */ Loaded copy$default(Loaded loaded, CratesLocalIndexServiceImplInner cratesLocalIndexServiceImplInner, int n, Object object) {
                if ((n & 1) != 0) {
                    cratesLocalIndexServiceImplInner = loaded.inner;
                }
                return loaded.copy(cratesLocalIndexServiceImplInner);
            }

            @NotNull
            public String toString() {
                return "Loaded(inner=" + this.inner + ")";
            }

            public int hashCode() {
                return this.inner.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Loaded)) {
                    return false;
                }
                Loaded loaded = (Loaded)other;
                return Intrinsics.areEqual((Object)this.inner, (Object)loaded.inner);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/rust/toml/crates/local/CratesLocalIndexServiceImpl$InnerState$Loading;", "Lorg/rust/toml/crates/local/CratesLocalIndexServiceImpl$InnerState;", "<init>", "()V", "toString", "", "intellij.rustrover.core"})
        public static final class Loading
        extends InnerState {
            @NotNull
            public static final Loading INSTANCE = new Loading();

            private Loading() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "InnerState.Loading";
            }
        }
    }
}

