/*
 * Decompiled with CFR 0.152.
 */
package org.rust.toml.crates.local;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.toolchain.BacktraceMode;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.tools.Cargo;
import org.rust.cargo.toolchain.tools.CargoKt;
import org.rust.cargo.toolchain.tools.RustcKt;
import org.rust.openapiext.CommandLineExtKt;
import org.rust.openapiext.RsPathManager;
import org.rust.stdext.RsResult;
import org.rust.toml.crates.local.CargoCratesIoGitRegistryUpdaterKt;
import org.rust.toml.crates.local.CratesLocalIndexService;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\rJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rH\u0002J2\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f*\u00020\u00162\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/rust/toml/crates/local/CargoCratesIoGitRegistryUpdater;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "UPDATE_PROJECT_DIR_NAME", "", "UPDATE_PROJECT_FILES", "", "Lorg/rust/toml/crates/local/CargoCratesIoGitRegistryUpdater$FileTemplate;", "updateCratesIoGitIndex", "Lorg/rust/stdext/RsResult;", "Ljava/nio/file/Path;", "Lorg/rust/toml/crates/local/CratesLocalIndexService$Error$InternalError;", "project", "Lcom/intellij/openapi/project/Project;", "cargoHomeDir", "createUpdateProjectIfNeeded", "", "projectPath", "triggerCratesIoGitIndexUpdate", "Lorg/rust/cargo/toolchain/RsToolchainBase;", "FileTemplate", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCargoCratesIoGitRegistryUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CargoCratesIoGitRegistryUpdater.kt\norg/rust/toml/crates/local/CargoCratesIoGitRegistryUpdater\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,139:1\n13#2:140\n*S KotlinDebug\n*F\n+ 1 CargoCratesIoGitRegistryUpdater.kt\norg/rust/toml/crates/local/CargoCratesIoGitRegistryUpdater\n*L\n31#1:140\n*E\n"})
public final class CargoCratesIoGitRegistryUpdater {
    @NotNull
    public static final CargoCratesIoGitRegistryUpdater INSTANCE = new CargoCratesIoGitRegistryUpdater();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String UPDATE_PROJECT_DIR_NAME = "crate_index_update_project_1";
    @NotNull
    private static final List<FileTemplate> UPDATE_PROJECT_FILES;

    private CargoCratesIoGitRegistryUpdater() {
    }

    @NotNull
    public final RsResult<Path, CratesLocalIndexService.Error.InternalError> updateCratesIoGitIndex(@Nullable Project project, @NotNull Path cargoHomeDir) {
        Intrinsics.checkNotNullParameter((Object)cargoHomeDir, (String)"cargoHomeDir");
        Path projectPath = RsPathManager.INSTANCE.pluginDirInSystem().resolve(UPDATE_PROJECT_DIR_NAME);
        Intrinsics.checkNotNull((Object)projectPath);
        boolean projectCreated = this.createUpdateProjectIfNeeded(projectPath);
        if (!projectCreated) {
            return new RsResult.Err<CratesLocalIndexService.Error.InternalError.CargoCratesIoGitRegistryUpdateError>(CratesLocalIndexService.Error.InternalError.CargoCratesIoGitRegistryUpdateError.INSTANCE);
        }
        RsToolchainBase rsToolchainBase = RsToolchainBase.Companion.suggest(projectPath);
        if (rsToolchainBase == null) {
            return new RsResult.Err<CratesLocalIndexService.Error.InternalError.CargoCratesIoGitRegistryUpdateError>(CratesLocalIndexService.Error.InternalError.CargoCratesIoGitRegistryUpdateError.INSTANCE);
        }
        RsToolchainBase toolchain2 = rsToolchainBase;
        return this.triggerCratesIoGitIndexUpdate(toolchain2, project, cargoHomeDir, projectPath);
    }

    private final boolean createUpdateProjectIfNeeded(Path projectPath) {
        boolean bl;
        try {
            for (FileTemplate fileTemplate : UPDATE_PROJECT_FILES) {
                String path = fileTemplate.component1();
                String text = fileTemplate.component2();
                Path projectFilePath = projectPath.resolve(path);
                Intrinsics.checkNotNull((Object)projectFilePath);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.exists(projectFilePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                PathKt.write$default((Path)projectFilePath, (CharSequence)text, null, (boolean)false, (int)6, null);
            }
            bl = true;
        }
        catch (IOException e) {
            LOG.error("Failed to create update project at " + projectPath, (Throwable)e);
            bl = false;
        }
        return bl;
    }

    private final RsResult<Path, CratesLocalIndexService.Error.InternalError> triggerCratesIoGitIndexUpdate(RsToolchainBase $this$triggerCratesIoGitIndexUpdate, Project project, Path cargoHomeDir, Path projectPath) {
        Cargo cargo = CargoKt.cargo($this$triggerCratesIoGitIndexUpdate);
        Object[] objectArray = new Pair[2];
        objectArray[0] = TuplesKt.to((Object)"CARGO_REGISTRIES_CRATES_IO_PROTOCOL", (Object)"git");
        Path path = Files.createDirectories(cargoHomeDir, new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createDirectories(...)");
        objectArray[1] = TuplesKt.to((Object)"CARGO_HOME", (Object)((Object)path.toAbsolutePath()).toString());
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.create((Map)MapsKt.mapOf((Pair[])objectArray), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"create(...)");
        EnvironmentVariablesData envs = environmentVariablesData;
        objectArray = new String[]{"update", "--dry-run"};
        RsResult result2 = CommandLineExtKt.execute$default(RsToolchainBase.createGeneralCommandLine$default($this$triggerCratesIoGitIndexUpdate, project, cargo.getExecutable(), projectPath, null, BacktraceMode.FULL, envs, CollectionsKt.listOf((Object[])objectArray), false, false, false, null, 1536, null), null, null, 3, null);
        if (result2 instanceof RsResult.Err) {
            LOG.warn("Failed to update crates.io index", (Throwable)((RsResult.Err)result2).getErr());
        }
        return result2.isOk() ? (RsResult)new RsResult.Ok<Path>(CargoCratesIoGitRegistryUpdaterKt.access$cargoRegistryIndexPath(RustcKt.rustc($this$triggerCratesIoGitIndexUpdate).queryVersion(project, projectPath))) : (RsResult)new RsResult.Err<CratesLocalIndexService.Error.InternalError.CargoCratesIoGitRegistryUpdateError>(CratesLocalIndexService.Error.InternalError.CargoCratesIoGitRegistryUpdateError.INSTANCE);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CargoCratesIoGitRegistryUpdater.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Object[] objectArray = new FileTemplate[]{new FileTemplate("Cargo.toml", "[package]\nname = \"crate_index_update_project\"\nversion = \"0.1.0\"\nedition = \"2015\"\n\n[dependencies]\nserde = \"1.0\""), new FileTemplate("src/lib.rs", "")};
        UPDATE_PROJECT_FILES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/rust/toml/crates/local/CargoCratesIoGitRegistryUpdater$FileTemplate;", "", "path", "", "text", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "getText", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rustrover.core"})
    private static final class FileTemplate {
        @NotNull
        private final String path;
        @NotNull
        private final String text;

        public FileTemplate(@NotNull String path, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.path = path;
            this.text = text;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final String component2() {
            return this.text;
        }

        @NotNull
        public final FileTemplate copy(@NotNull String path, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return new FileTemplate(path, text);
        }

        public static /* synthetic */ FileTemplate copy$default(FileTemplate fileTemplate, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = fileTemplate.path;
            }
            if ((n & 2) != 0) {
                string2 = fileTemplate.text;
            }
            return fileTemplate.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "FileTemplate(path=" + this.path + ", text=" + this.text + ")";
        }

        public int hashCode() {
            int result2 = this.path.hashCode();
            result2 = result2 * 31 + this.text.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileTemplate)) {
                return false;
            }
            FileTemplate fileTemplate = (FileTemplate)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)fileTemplate.path)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.text, (Object)fileTemplate.text);
        }
    }
}

