/*
 * Decompiled with CFR 0.152.
 */
package org.rust.toml.crates;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.rust.toml.crates.CratesStatistics;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00078VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/rust/toml/crates/CratesStatisticsImpl;", "Lorg/rust/toml/crates/CratesStatistics;", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "popularCrates", "", "", "Lorg/rust/toml/crates/CratesStatistics$PopularCrate;", "getPopularCrates", "()Ljava/util/Map;", "popularCrates$delegate", "Lkotlin/Lazy;", "loadCsv", "Lkotlin/sequences/Sequence;", "", "path", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCratesStatisticsImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CratesStatisticsImpl.kt\norg/rust/toml/crates/CratesStatisticsImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,39:1\n13#2:40\n*S KotlinDebug\n*F\n+ 1 CratesStatisticsImpl.kt\norg/rust/toml/crates/CratesStatisticsImpl\n*L\n13#1:40\n*E\n"})
public final class CratesStatisticsImpl
implements CratesStatistics {
    @NotNull
    private final Logger LOG;
    @NotNull
    private final Lazy popularCrates$delegate;

    public CratesStatisticsImpl() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CratesStatisticsImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
        this.popularCrates$delegate = LazyKt.lazy(() -> CratesStatisticsImpl.popularCrates_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public Map<String, CratesStatistics.PopularCrate> getPopularCrates() {
        Lazy lazy = this.popularCrates$delegate;
        return (Map)lazy.getValue();
    }

    private final Sequence<List<String>> loadCsv(String path) {
        InputStream statisticsFileAsStream = this.getClass().getClassLoader().getResourceAsStream(path);
        if (statisticsFileAsStream == null) {
            this.LOG.error("Can't find `" + path + "` file in resources");
            return SequencesKt.emptySequence();
        }
        Stream<String> statistics = new BufferedReader(new InputStreamReader(statisticsFileAsStream, StandardCharsets.UTF_8)).lines();
        Intrinsics.checkNotNull(statistics);
        return SequencesKt.map((Sequence)StreamsKt.asSequence(statistics), CratesStatisticsImpl::loadCsv$lambda$0);
    }

    private static final Map popularCrates_delegate$lambda$0(CratesStatisticsImpl this$0) {
        return MapsKt.toMap((Sequence)SequencesKt.map(this$0.loadCsv("statistics/crates.csv"), CratesStatisticsImpl::popularCrates_delegate$lambda$0$0));
    }

    private static final Pair popularCrates_delegate$lambda$0$0(List columns) {
        Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
        return TuplesKt.to(columns.get(1), (Object)new CratesStatistics.PopularCrate((String)columns.get(1), Long.parseLong((String)columns.get(5)), (String)columns.get(6)));
    }

    private static final List loadCsv$lambda$0(String it2) {
        return StringUtil.splitHonorQuotes((String)it2, (char)',');
    }
}

