/*
 * Decompiled with CFR 0.152.
 */
package org.rust.toml;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.project.workspace.FeatureState;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.ide.experiments.RsExperiments;
import org.rust.ide.icons.RsIcons;
import org.rust.ide.lineMarkers.RsLineMarkerInfoUtils;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.toml.CargoFeatureLineMarkerProviderKt;
import org.rust.toml.CargoTomlPsiPattern;
import org.rust.toml.OpenSettingsAction;
import org.rust.toml.UtilKt;
import org.toml.lang.psi.TomlElementTypes;
import org.toml.lang.psi.TomlFile;
import org.toml.lang.psi.TomlKeySegment;
import org.toml.lang.psi.TomlKeyValue;
import org.toml.lang.psi.TomlTable;
import org.toml.lang.psi.TomlTableHeader;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J*\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0012\u0010\f\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u00050\rH\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0018\u0010\u0011\u001a\u00020\u000f*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lorg/rust/toml/TomlCargoFeatureLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/LineMarkerProvider;", "<init>", "()V", "getLineMarkerInfo", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "element", "Lcom/intellij/psi/PsiElement;", "collectSlowLineMarkers", "", "elements", "", "result", "", "isDependencyName", "", "(Lcom/intellij/psi/PsiElement;)Z", "isFeatureKey", "Lorg/toml/lang/psi/TomlKeySegment;", "(Lorg/toml/lang/psi/TomlKeySegment;)Z", "genSettingsLineMarkerInfo", "header", "Lorg/toml/lang/psi/TomlTableHeader;", "intellij.rustrover.core"})
public final class TomlCargoFeatureLineMarkerProvider
implements LineMarkerProvider {
    @Nullable
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements2, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        if (!UtilKt.tomlPluginIsAbiCompatible()) {
            return;
        }
        PsiElement psiElement2 = (PsiElement)CollectionsKt.firstOrNull(elements2);
        if (psiElement2 == null) {
            return;
        }
        PsiElement firstElement = psiElement2;
        PsiFile psiFile = firstElement.getContainingFile();
        TomlFile tomlFile = psiFile instanceof TomlFile ? (TomlFile)psiFile : null;
        if (tomlFile == null) {
            return;
        }
        TomlFile file = tomlFile;
        if (!StringsKt.equals((String)file.getName(), (String)"Cargo.toml", (boolean)true)) {
            return;
        }
        CargoWorkspace.Package package_ = RsElementKt.findCargoPackage((PsiFileSystemItem)file);
        if (package_ == null) {
            return;
        }
        CargoWorkspace.Package cargoPackage = package_;
        Map<String, FeatureState> features = cargoPackage.getFeatureState();
        for (PsiElement psiElement3 : elements2) {
            TomlTableHeader header;
            PsiElement parent2 = psiElement3.getParent();
            if (parent2 instanceof TomlKeySegment) {
                String featureName;
                boolean isFeatureKey = this.isFeatureKey((TomlKeySegment)parent2);
                if (!isFeatureKey && !this.isDependencyName(parent2) || ((TomlKeySegment)parent2).getName() == null || !isFeatureKey && !features.containsKey(featureName)) continue;
                Collection<LineMarkerInfo<?>> collection = result2;
                PsiElement psiElement4 = ((TomlKeySegment)parent2).getFirstChild();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"getFirstChild(...)");
                collection.add(CargoFeatureLineMarkerProviderKt.access$genFeatureLineMarkerInfo(psiElement4, featureName, features.get(featureName), cargoPackage));
            }
            if (!RsExperiments.INSTANCE.getCARGO_FEATURES_SETTINGS_GUTTER().asBoolean() || !Intrinsics.areEqual((Object)PsiElementExtensionsKt.getElementType(psiElement3), (Object)TomlElementTypes.L_BRACKET) || cargoPackage.getOrigin() != PackageOrigin.WORKSPACE) continue;
            TomlTableHeader tomlTableHeader = parent2 instanceof TomlTableHeader ? (TomlTableHeader)parent2 : null;
            if (tomlTableHeader == null || !UtilKt.isFeatureListHeader(header = tomlTableHeader)) continue;
            result2.add(this.genSettingsLineMarkerInfo(header));
        }
    }

    private final boolean isDependencyName(PsiElement $this$isDependencyName) {
        return CargoTomlPsiPattern.INSTANCE.getOnDependencyKey().accepts((Object)$this$isDependencyName) || CargoTomlPsiPattern.INSTANCE.getOnSpecificDependencyHeaderKey().accepts((Object)$this$isDependencyName);
    }

    private final boolean isFeatureKey(TomlKeySegment $this$isFeatureKey) {
        PsiElement psiElement2 = $this$isFeatureKey.getParent();
        PsiElement psiElement3 = psiElement2 != null ? psiElement2.getParent() : null;
        TomlKeyValue tomlKeyValue = psiElement3 instanceof TomlKeyValue ? (TomlKeyValue)psiElement3 : null;
        if (tomlKeyValue == null) {
            return false;
        }
        TomlKeyValue keyValue = tomlKeyValue;
        PsiElement psiElement4 = keyValue.getParent();
        TomlTable tomlTable = psiElement4 instanceof TomlTable ? (TomlTable)psiElement4 : null;
        if (tomlTable == null) {
            return false;
        }
        TomlTable table = tomlTable;
        return UtilKt.isFeatureListHeader(table.getHeader());
    }

    private final LineMarkerInfo<PsiElement> genSettingsLineMarkerInfo(TomlTableHeader header) {
        PsiElement anchor = header.getFirstChild();
        Intrinsics.checkNotNull((Object)anchor);
        TextRange textRange = anchor.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        return RsLineMarkerInfoUtils.INSTANCE.create(anchor, textRange, RsIcons.INSTANCE.getFEATURES_SETTINGS(), (GutterIconNavigationHandler<PsiElement>)((GutterIconNavigationHandler)OpenSettingsAction.INSTANCE), GutterIconRenderer.Alignment.RIGHT, (Function0<String>)((Function0)TomlCargoFeatureLineMarkerProvider::genSettingsLineMarkerInfo$lambda$0));
    }

    private static final String genSettingsLineMarkerInfo$lambda$0() {
        return RsBundle.INSTANCE.message("gutter.rust.configure.features", new Object[0]);
    }
}

