/*
 * Decompiled with CFR 0.152.
 */
package org.rust.toml;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.cargo.project.model.CargoProjectsService;
import org.rust.cargo.project.workspace.FeatureState;
import org.rust.cargo.project.workspace.PackageFeature;
import org.rust.ide.statistics.RsCfgSwitcherUsageCollector;
import org.rust.openapiext.UtilsKt;
import org.rust.toml.CargoFeatureLineMarkerProviderKt;
import org.rust.toml.Context;
import org.toml.lang.psi.TomlFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/rust/toml/ToggleFeatureAction;", "Lcom/intellij/codeInsight/daemon/GutterIconNavigationHandler;", "Lcom/intellij/psi/PsiElement;", "featureName", "", "<init>", "(Ljava/lang/String;)V", "navigate", "", "e", "Ljava/awt/event/MouseEvent;", "element", "intellij.rustrover.core"})
final class ToggleFeatureAction
implements GutterIconNavigationHandler<PsiElement> {
    @NotNull
    private final String featureName;

    public ToggleFeatureAction(@NotNull String featureName) {
        Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
        this.featureName = featureName;
    }

    public void navigate(@NotNull MouseEvent e, @NotNull PsiElement element) {
        boolean isDocUnsaved;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Context context = CargoFeatureLineMarkerProviderKt.access$getContext(element);
        if (context == null) {
            return;
        }
        Context context2 = context;
        FeatureState oldState = context2.getCargoPackage().getFeatureState().getOrDefault(this.featureName, FeatureState.Disabled);
        FeatureState newState = oldState.not();
        PsiFile file = element.getContainingFile();
        Intrinsics.checkNotNull((Object)file);
        RsCfgSwitcherUsageCollector.INSTANCE.logCargoFeatureToggled(newState, file);
        TomlFile tomlFile = file instanceof TomlFile ? (TomlFile)file : null;
        Document tomlDoc = tomlFile != null ? UtilsKt.getDocument((PsiFile)tomlFile) : null;
        boolean bl = isDocUnsaved = tomlDoc != null && FileDocumentManager.getInstance().isDocumentUnsaved(tomlDoc);
        if (isDocUnsaved) {
            ActionsKt.runWriteAction(ToggleFeatureAction::navigate$lambda$0);
            CargoProjectsService.refreshAllProjects$default(context2.getCargoProjectsService(), false, 1, null);
        }
        context2.getCargoProjectsService().modifyFeatures(context2.getCargoProject(), SetsKt.setOf((Object)new PackageFeature(context2.getCargoPackage(), this.featureName)), newState);
    }

    private static final Unit navigate$lambda$0() {
        UtilsKt.saveAllDocuments$default(false, 1, null);
        return Unit.INSTANCE;
    }
}

