/*
 * Decompiled with CFR 0.152.
 */
package org.rust.stdext;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\u001a3\u0010\u0007\u001a\u0004\u0018\u0001H\u0004\"\u0004\b\u0000\u0010\u0004*\u00020\b2\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u0001H\u00040\nH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000b\u001a\n\u0010\f\u001a\u00020\r*\u00020\u000e\u001a\f\u0010\u000f\u001a\u0004\u0018\u00010\r*\u00020\u000e\u001a\u0014\u0010\u0010\u001a\u0004\u0018\u00010\r*\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000e\u001a\u0019\u0010\u0012\u001a\u0004\u0018\u00010\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0014H\u0082\b\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\r\u001a\u0010\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0018*\u00020\r\u001a\n\u0010\u0019\u001a\u00020\u000e*\u00020\u000e\u001a\u0011\u0010\u001a\u001a\u00020\u000e*\u00070\u000e\u00a2\u0006\u0002\b\u001bH\u0007\u001a\u000e\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\n\u0010\u001f\u001a\u00020\u0016*\u00020 \"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u0004*\u0002H\u00048\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006!"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "exhaustive", "T", "getExhaustive", "(Ljava/lang/Object;)Ljava/lang/Object;", "applyWithSymlink", "Lcom/intellij/openapi/vfs/VirtualFile;", "f", "Lkotlin/Function1;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "toPath", "Ljava/nio/file/Path;", "", "toPathOrNull", "resolveOrNull", "other", "pathOrNull", "block", "Lkotlin/Function0;", "isExecutable", "", "list", "Lkotlin/sequences/Sequence;", "pluralize", "capitalized", "Lorg/jetbrains/annotations/Nls;", "numberSuffix", "number", "", "isPowerOfTwo", "", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\norg/rust/stdext/UtilsKt\n*L\n1#1,79:1\n47#1,5:80\n47#1,5:85\n*S KotlinDebug\n*F\n+ 1 Utils.kt\norg/rust/stdext/UtilsKt\n*L\n42#1:80,5\n44#1:85,5\n*E\n"})
public final class UtilsKt {
    @NotNull
    private static final Logger LOG;

    public static final <T> T getExhaustive(T $this$exhaustive) {
        boolean $i$f$getExhaustive = false;
        return $this$exhaustive;
    }

    @Nullable
    public static final <T> T applyWithSymlink(@NotNull VirtualFile $this$applyWithSymlink, @NotNull Function1<? super VirtualFile, ? extends T> f) {
        Intrinsics.checkNotNullParameter((Object)$this$applyWithSymlink, (String)"<this>");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        boolean $i$f$applyWithSymlink = false;
        Object object = f.invoke((Object)$this$applyWithSymlink);
        if (object == null) {
            VirtualFile virtualFile = $this$applyWithSymlink.getCanonicalFile();
            if (virtualFile == null) {
                return null;
            }
            object = f.invoke((Object)virtualFile);
        }
        return (T)object;
    }

    @NotNull
    public static final Path toPath(@NotNull String $this$toPath) {
        Intrinsics.checkNotNullParameter((Object)$this$toPath, (String)"<this>");
        Path path = Paths.get($this$toPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @Nullable
    public static final Path toPathOrNull(@NotNull String $this$toPathOrNull) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)$this$toPathOrNull, (String)"<this>");
        boolean $i$f$pathOrNull = false;
        try {
            boolean bl = false;
            path = UtilsKt.toPath($this$toPathOrNull);
        }
        catch (InvalidPathException e$iv) {
            LOG.warn((Throwable)e$iv);
            path = null;
        }
        return path;
    }

    @Nullable
    public static final Path resolveOrNull(@NotNull Path $this$resolveOrNull, @NotNull String other) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)$this$resolveOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$pathOrNull = false;
        try {
            boolean bl = false;
            Path path2 = $this$resolveOrNull.resolve(other);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            path = path2;
        }
        catch (InvalidPathException e$iv) {
            LOG.warn((Throwable)e$iv);
            path = null;
        }
        return path;
    }

    private static final Path pathOrNull(Function0<? extends Path> block) {
        Path path;
        boolean $i$f$pathOrNull = false;
        try {
            path = (Path)block.invoke();
        }
        catch (InvalidPathException e) {
            LOG.warn((Throwable)e);
            path = null;
        }
        return path;
    }

    public static final boolean isExecutable(@NotNull Path $this$isExecutable) {
        Intrinsics.checkNotNullParameter((Object)$this$isExecutable, (String)"<this>");
        return Files.isExecutable($this$isExecutable);
    }

    @NotNull
    public static final Sequence<Path> list(@NotNull Path $this$list) {
        Intrinsics.checkNotNullParameter((Object)$this$list, (String)"<this>");
        Stream<Path> stream = Files.list($this$list);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"list(...)");
        return StreamsKt.asSequence(stream);
    }

    @NotNull
    public static final String pluralize(@NotNull String $this$pluralize) {
        Intrinsics.checkNotNullParameter((Object)$this$pluralize, (String)"<this>");
        String string = StringUtil.pluralize((String)$this$pluralize);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluralize(...)");
        return string;
    }

    @NlsActions.ActionText
    @NotNull
    public static final String capitalized(@NotNull String $this$capitalized) {
        Intrinsics.checkNotNullParameter((Object)$this$capitalized, (String)"<this>");
        String string = StringUtil.capitalize((String)$this$capitalized);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"capitalize(...)");
        return string;
    }

    @NotNull
    public static final String numberSuffix(int number) {
        int n = number % 100;
        boolean bl = 11 <= n ? n < 14 : false;
        if (bl) {
            return "th";
        }
        return switch (number % 10) {
            case 1 -> "st";
            case 2 -> "nd";
            case 3 -> "rd";
            default -> "th";
        };
    }

    public static final boolean isPowerOfTwo(long $this$isPowerOfTwo) {
        return $this$isPowerOfTwo > 0L && ($this$isPowerOfTwo & $this$isPowerOfTwo - 1L) == 0L;
    }

    static {
        Logger logger = Logger.getInstance((String)"#org.rust.stdext");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

