/*
 * Decompiled with CFR 0.152.
 */
package org.rust.stdext;

import com.intellij.util.io.DigestUtil;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import kotlin.text.HexExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.stdext.IoKt;
import org.rust.stdext.RsResult;
import org.rust.stdext.ThreadLocalDelegate;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0096\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0006\u0010\u000e\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/rust/stdext/HashCode;", "Ljava/io/Serializable;", "hash", "", "<init>", "([B)V", "equals", "", "other", "", "hashCode", "", "toString", "", "toByteArray", "Companion", "intellij.rustrover.core"})
public final class HashCode
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] hash;
    public static final int ARRAY_LEN = 20;
    @NotNull
    private static final ThreadLocalDelegate<MessageDigest> SHA1$delegate = new ThreadLocalDelegate(HashCode::SHA1_delegate$lambda$0);

    private HashCode(byte[] hash) {
        this.hash = hash;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) return false;
        byte[] byArray = this.hash;
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.rust.stdext.HashCode");
        if (!Arrays.equals(byArray, ((HashCode)object2).hash)) return false;
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(this.hash);
    }

    @NotNull
    public String toString() {
        return HexExtensionsKt.toHexString$default((byte[])this.hash, null, (int)1, null);
    }

    @NotNull
    public final byte[] toByteArray() {
        return this.hash;
    }

    private static final MessageDigest SHA1_delegate$lambda$0() {
        return DigestUtil.sha1();
    }

    public /* synthetic */ HashCode(byte[] hash, DefaultConstructorMarker $constructor_marker) {
        this(hash);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001f\u0010\f\u001a\u00020\r2\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011\u00a2\u0006\u0002\b\u0014J\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\rJ\u000e\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\""}, d2={"Lorg/rust/stdext/HashCode$Companion;", "", "<init>", "()V", "ARRAY_LEN", "", "SHA1", "Ljava/security/MessageDigest;", "getSHA1", "()Ljava/security/MessageDigest;", "SHA1$delegate", "Lorg/rust/stdext/ThreadLocalDelegate;", "compute", "Lorg/rust/stdext/HashCode;", "input", "", "computation", "Lkotlin/Function1;", "Ljava/io/DataOutputStream;", "", "Lkotlin/ExtensionFunctionType;", "ofFile", "Lorg/rust/stdext/RsResult;", "Ljava/io/IOException;", "path", "Ljava/nio/file/Path;", "mix", "hash1", "hash2", "fromByteArray", "bytes", "", "fromHexString", "hex", "intellij.rustrover.core"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        private final MessageDigest getSHA1() {
            return (MessageDigest)SHA1$delegate.getValue(this, $$delegatedProperties[0]);
        }

        @NotNull
        public final HashCode compute(@NotNull String input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            MessageDigest messageDigest = this.getSHA1();
            String string = input;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] byArray2 = messageDigest.digest(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"digest(...)");
            return new HashCode(byArray2, null);
        }

        @NotNull
        public final HashCode compute(@NotNull Function1<? super DataOutputStream, Unit> computation) {
            Intrinsics.checkNotNullParameter(computation, (String)"computation");
            MessageDigest sha1 = this.getSHA1();
            computation.invoke((Object)new DataOutputStream(new DigestOutputStream(OutputStream.nullOutputStream(), sha1)));
            byte[] byArray = sha1.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
            return new HashCode(byArray, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final RsResult<HashCode, IOException> ofFile(@NotNull Path path) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            MessageDigest digest = this.getSHA1();
            try {
                object = new DigestInputStream(Files.newInputStream(path, new OpenOption[0]), digest);
                Throwable throwable = null;
                try {
                    DigestInputStream it2 = (DigestInputStream)object;
                    boolean bl = false;
                    OutputStream outputStream = OutputStream.nullOutputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"nullOutputStream(...)");
                    IoKt.writeStream(outputStream, it2);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                byte[] byArray = digest.digest();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
                object = new RsResult.Ok<HashCode>(new HashCode(byArray, null));
            }
            catch (IOException e) {
                object = new RsResult.Err<IOException>(e);
            }
            return object;
        }

        @NotNull
        public final HashCode mix(@NotNull HashCode hash1, @NotNull HashCode hash2) {
            Intrinsics.checkNotNullParameter((Object)hash1, (String)"hash1");
            Intrinsics.checkNotNullParameter((Object)hash2, (String)"hash2");
            MessageDigest md = this.getSHA1();
            md.update(hash1.toByteArray());
            md.update(hash2.toByteArray());
            byte[] byArray = md.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
            return new HashCode(byArray, null);
        }

        @NotNull
        public final HashCode fromByteArray(@NotNull byte[] bytes) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            if (!(bytes.length == 20)) {
                throw new IllegalStateException("Check failed.");
            }
            return new HashCode(bytes, null);
        }

        @NotNull
        public final HashCode fromHexString(@NotNull String hex) {
            Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
            byte[] bytes = HexExtensionsKt.hexToByteArray$default((String)hex, null, (int)1, null);
            if (!(bytes.length == 20)) {
                throw new IllegalStateException("Check failed.");
            }
            return new HashCode(bytes, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "SHA1", "getSHA1()Ljava/security/MessageDigest;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

