/*
 * Decompiled with CFR 0.152.
 */
package org.rust.profiler;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.ElevationService;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.profiler.clion.ProfilerEnvironmentHost;
import com.intellij.xdebugger.attach.WslAttachHost;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.runconfig.RsCapturingProcessHandler;
import org.rust.cargo.runconfig.RsProcessHandler;
import org.rust.cargo.toolchain.BacktraceMode;
import org.rust.cargo.toolchain.RsLocalToolchain;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.wsl.RsWslToolchain;
import org.rust.openapiext.CommandLineExtKt;
import org.rust.stdext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\f\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0016JS\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010\u001bJ(\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006)"}, d2={"Lorg/rust/profiler/RsProfilerEnvironmentHost;", "Lcom/intellij/profiler/clion/ProfilerEnvironmentHost;", "<init>", "()V", "shouldCheckFilePathExist", "", "project", "Lcom/intellij/openapi/project/Project;", "getPath", "Ljava/nio/file/Path;", "path", "", "getEnvPath", "getTempDirectory", "isRemote", "isWSL", "getWSLVersion", "", "createProcessHandler", "Lcom/intellij/execution/process/BaseProcessHandler;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "colored", "usePty", "captureProcessOutput", "splitLines", "withElevated", "(Lcom/intellij/execution/configurations/GeneralCommandLine;Lcom/intellij/openapi/project/Project;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;)Lcom/intellij/execution/process/BaseProcessHandler;", "runProcess", "Lcom/intellij/execution/process/ProcessOutput;", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "timeout", "getProcessList", "", "Lcom/intellij/execution/process/ProcessInfo;", "sendSignal", "pid", "signalName", "intellij.rustrover.profiler"})
public final class RsProfilerEnvironmentHost
implements ProfilerEnvironmentHost {
    public boolean shouldCheckFilePathExist(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RsToolchainBase rsToolchainBase = RustProjectSettingsServiceKt.getToolchain(project);
        if (rsToolchainBase == null) {
            return false;
        }
        RsToolchainBase toolchain2 = rsToolchainBase;
        return toolchain2 instanceof RsLocalToolchain;
    }

    @NotNull
    public Path getPath(@NotNull String path, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = RustProjectSettingsServiceKt.getToolchain(project);
        if (object == null || (object = ((RsToolchainBase)object).toLocalPath(path)) == null || (object = UtilsKt.toPathOrNull((String)object)) == null) {
            Path path2 = Path.of(path, new String[0]);
            object = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
        }
        return object;
    }

    @NotNull
    public String getEnvPath(@Nullable String path, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (path == null) {
            return "";
        }
        RsToolchainBase rsToolchainBase = RustProjectSettingsServiceKt.getToolchain(project);
        return String.valueOf(rsToolchainBase != null ? rsToolchainBase.toRemotePath(path) : null);
    }

    @NotNull
    public Path getTempDirectory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = FileUtil.getTempDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTempDirectory(...)");
        return UtilsKt.toPath(string);
    }

    public boolean isRemote(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RsToolchainBase rsToolchainBase = RustProjectSettingsServiceKt.getToolchain(project);
        if (rsToolchainBase == null) {
            return false;
        }
        RsToolchainBase toolchain2 = rsToolchainBase;
        return !(toolchain2 instanceof RsLocalToolchain);
    }

    public boolean isWSL(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return RustProjectSettingsServiceKt.getToolchain(project) instanceof RsWslToolchain;
    }

    public int getWSLVersion(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RsToolchainBase rsToolchainBase = RustProjectSettingsServiceKt.getToolchain(project);
        RsWslToolchain rsWslToolchain = rsToolchainBase instanceof RsWslToolchain ? (RsWslToolchain)rsToolchainBase : null;
        if (rsWslToolchain == null) {
            return -1;
        }
        RsWslToolchain toolchain2 = rsWslToolchain;
        return toolchain2.getWslPath().getDistribution().getVersion();
    }

    @NotNull
    public BaseProcessHandler<?> createProcessHandler(@NotNull GeneralCommandLine commandLine, @NotNull Project project, @Nullable Boolean colored, @Nullable Boolean usePty, @Nullable Boolean captureProcessOutput, @Nullable Boolean splitLines, @Nullable Boolean withElevated) {
        BaseProcessHandler baseProcessHandler;
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GeneralCommandLine tmpCommandLine = commandLine;
        if (Intrinsics.areEqual((Object)usePty, (Object)true)) {
            PtyCommandLine ptyCommandLine = new PtyCommandLine(commandLine).withInitialColumns(2500).withConsoleMode(false);
            Intrinsics.checkNotNullExpressionValue((Object)ptyCommandLine, (String)"withConsoleMode(...)");
            tmpCommandLine = (GeneralCommandLine)ptyCommandLine;
        }
        RsToolchainBase rsToolchainBase = RustProjectSettingsServiceKt.getToolchain(project);
        if (rsToolchainBase == null) {
            throw new ExecutionException(RsBundle.INSTANCE.message("dialog.message.rust.toolchain.is.not.set", new Object[0]));
        }
        RsToolchainBase toolchain2 = rsToolchainBase;
        Boolean bl = withElevated;
        tmpCommandLine = toolchain2.patchCommandLine(tmpCommandLine, bl != null ? bl : false);
        if (Intrinsics.areEqual((Object)withElevated, (Object)true)) {
            OSProcessHandler oSProcessHandler = ElevationService.getInstance().createProcessHandler(tmpCommandLine);
            Intrinsics.checkNotNullExpressionValue((Object)oSProcessHandler, (String)"createProcessHandler(...)");
            baseProcessHandler = (BaseProcessHandler)oSProcessHandler;
        } else {
            baseProcessHandler = Intrinsics.areEqual((Object)colored, (Object)true) ? (BaseProcessHandler)new RsProcessHandler(tmpCommandLine, colored) : (Intrinsics.areEqual((Object)captureProcessOutput, (Object)true) ? (BaseProcessHandler)RsCapturingProcessHandler.Companion.startProcess(tmpCommandLine).unwrap() : (BaseProcessHandler)new RsProcessHandler(tmpCommandLine, false));
        }
        return baseProcessHandler;
    }

    @NotNull
    public ProcessOutput runProcess(@NotNull ProcessHandler handler, @NotNull ProgressIndicator indicator, int timeout, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProcessOutput processOutput = new CapturingProcessRunner(handler).runProcess(indicator, timeout);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
        return processOutput;
    }

    @NotNull
    public List<ProcessInfo> getProcessList(@NotNull Project project) {
        List list;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RsToolchainBase toolchain2 = RustProjectSettingsServiceKt.getToolchain(project);
        if (toolchain2 instanceof RsLocalToolchain) {
            ProcessInfo[] processInfoArray = OSProcessUtil.getProcessList();
            Intrinsics.checkNotNullExpressionValue((Object)processInfoArray, (String)"getProcessList(...)");
            list = ArraysKt.toList((Object[])processInfoArray);
        } else if (toolchain2 instanceof RsWslToolchain) {
            List list2 = new WslAttachHost(((RsWslToolchain)toolchain2).getWslPath().getDistribution()).getProcessList();
            list = list2;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getProcessList(...)");
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public int sendSignal(int pid, @NotNull String signalName, @NotNull Project project) {
        int n;
        Intrinsics.checkNotNullParameter((Object)signalName, (String)"signalName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RsToolchainBase toolchain2 = RustProjectSettingsServiceKt.getToolchain(project);
        if (toolchain2 instanceof RsLocalToolchain) {
            if (SystemInfo.isWindows) {
                throw new UnsupportedOperationException("Not supported for Windows OS, use winbreak instead");
            }
            n = UnixProcessManager.sendSignal((int)pid, (String)signalName);
        } else if (toolchain2 instanceof RsWslToolchain) {
            Path path = Path.of("kill", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            Path path2 = Path.of(".", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
            EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"DEFAULT");
            Object[] objectArray = new String[]{"-s", signalName, String.valueOf(pid)};
            ProcessOutput processOutput = CommandLineExtKt.execute$default(RsToolchainBase.createGeneralCommandLine$default(toolchain2, project, path, path2, null, BacktraceMode.NO, environmentVariablesData, CollectionsKt.listOf((Object[])objectArray), false, false, true, null, 1024, null), 5000, null, 2, null);
            n = processOutput != null ? processOutput.getExitCode() : -1;
        } else {
            n = -1;
        }
        return n;
    }
}

