/*
 * Decompiled with CFR 0.152.
 */
package org.rust.openapiext;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelOsFamily;
import com.intellij.platform.eel.EelPlatform;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.platform.eel.provider.utils.EelPathUtils;
import com.intellij.platform.eel.provider.utils.EelUtilsKt;
import com.intellij.util.system.CpuArch;
import com.intellij.util.system.OS;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.eel.RsEelToolchain;
import org.rust.cargo.toolchain.impl.RustcVersion;
import org.rust.cargo.toolchain.wsl.RsWslToolchain;
import org.rust.openapiext.RsPathManagerKt;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\u0007J\b\u0010\n\u001a\u00020\u0007H\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\rH\u0007J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0006\u0010\u0015\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0019\u001a\u00020\u0007J\u000e\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u001b\u001a\u00020\u0007J\u0010\u0010\u001c\u001a\n \u001d*\u0004\u0018\u00010\u00070\u0007H\u0002J\u0016\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!J\u0018\u0010\"\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00072\b\u0010 \u001a\u0004\u0018\u00010!J\u000e\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/rust/openapiext/RsPathManager;", "", "<init>", "()V", "INTELLIJ_RUST_NATIVE_HELPER", "", "prettyPrintersDir", "Ljava/nio/file/Path;", "bundledCachesDir", "bundledCachesCorruptionMarker", "pluginDir", "nativeHelper", "isWslToolchain", "", "toolchain", "Lorg/rust/cargo/toolchain/RsToolchainBase;", "nativeHelperPath", "os", "Lcom/intellij/util/system/OS;", "arch", "Lcom/intellij/util/system/CpuArch;", "pluginDirInSystem", "eelDescriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "stdlibDependenciesDir", "tempPluginDirInSystem", "stdlibLocalCopy", "coverageTmpDir", "fakeBundledCaches", "kotlin.jvm.PlatformType", "stdlibVendorDir", "srcDir", "version", "Lorg/rust/cargo/toolchain/impl/RustcVersion;", "stdlibCopyDir", "sysrootStdlibDir", "sysroot", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsPathManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsPathManager.kt\norg/rust/openapiext/RsPathManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n1#2:183\n*E\n"})
public final class RsPathManager {
    @NotNull
    public static final RsPathManager INSTANCE = new RsPathManager();
    @NotNull
    public static final String INTELLIJ_RUST_NATIVE_HELPER = "intellij-rust-native-helper";

    private RsPathManager() {
    }

    @NotNull
    public final Path prettyPrintersDir() {
        Path path;
        if (PluginManagerCore.isRunningFromSources()) {
            Path path2 = Path.of(PathManager.getHomePath(), new String[0]).resolve("rustrover/debugger/src/prettyPrinters");
            Intrinsics.checkNotNull((Object)path2);
            path = path2;
        } else {
            Path path3 = this.pluginDir().resolve("prettyPrinters");
            Intrinsics.checkNotNull((Object)path3);
            path = path3;
        }
        return path;
    }

    @NotNull
    public final Path bundledCachesDir() {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(this.bundledCachesCorruptionMarker(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Path path = this.fakeBundledCaches();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"fakeBundledCaches(...)");
            return path;
        }
        Path path = this.pluginDir().resolve("caches");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final Path bundledCachesCorruptionMarker() {
        Path path = this.fakeBundledCaches().resolve("use-fake-bundled-caches.marker");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private final Path pluginDir() {
        Path path = UtilsKt.plugin().getPluginPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPluginPath(...)");
        return path;
    }

    @Deprecated(message="use RsPathManager.nativeHelper(org.rust.cargo.toolchain.RsToolchainBase) instead")
    @Nullable
    public final Path nativeHelper(boolean isWslToolchain) {
        return this.nativeHelper(null, isWslToolchain);
    }

    @Nullable
    public final Path nativeHelper(@Nullable RsToolchainBase toolchain2) {
        return this.nativeHelper(toolchain2, toolchain2 instanceof RsWslToolchain);
    }

    private final Path nativeHelper(RsToolchainBase toolchain2, boolean isWslToolchain) {
        Path path;
        Path bundledBinary;
        boolean isEelToolchain = toolchain2 instanceof RsEelToolchain;
        String bundledName = isWslToolchain ? "intellij-rust-native-helper-wsl" : (isEelToolchain && ((RsEelToolchain)toolchain2).getDescriptor().getOsFamily() == EelOsFamily.Windows || SystemInfo.isWindows ? "intellij-rust-native-helper.exe" : INTELLIJ_RUST_NATIVE_HELPER);
        Path path2 = bundledBinary = PathManager.findBinFile((String)("native-helper/" + bundledName));
        if (path2 != null) {
            return path2;
        }
        if (isEelToolchain) {
            EelApi eel = EelProviderUtil.toEelApiBlocking((EelDescriptor)((RsEelToolchain)toolchain2).getDescriptor());
            path = this.nativeHelperPath(EelUtilsKt.toOs((EelPlatform)eel.getPlatform()), EelUtilsKt.toCpuArch((EelPlatform.Arch)eel.getPlatform().getArch()));
        } else {
            OS oS = isWslToolchain ? OS.Linux : OS.CURRENT;
            Intrinsics.checkNotNull((Object)oS);
            CpuArch cpuArch = CpuArch.CURRENT;
            Intrinsics.checkNotNullExpressionValue((Object)cpuArch, (String)"CURRENT");
            path = this.nativeHelperPath(oS, cpuArch);
        }
        if (path == null) {
            return null;
        }
        Path nativeHelperPath = path;
        return Files.isExecutable(nativeHelperPath) || nativeHelperPath.toFile().setExecutable(true) ? (isEelToolchain ? EelPathUtils.transferLocalContentToRemote$default((Path)nativeHelperPath, (EelPathUtils.TransferTarget)((EelPathUtils.TransferTarget)new EelPathUtils.TransferTarget.Temporary(((RsEelToolchain)toolchain2).getDescriptor())), null, (int)4, null) : nativeHelperPath) : null;
    }

    private final Path nativeHelperPath(OS os, CpuArch arch) {
        Path path;
        String string;
        Pair pair = switch (WhenMappings.$EnumSwitchMapping$0[os.ordinal()]) {
            case 1 -> TuplesKt.to((Object)"win", (Object)"intellij-rust-native-helper.exe");
            case 2 -> TuplesKt.to((Object)"mac", (Object)INTELLIJ_RUST_NATIVE_HELPER);
            default -> TuplesKt.to((Object)"linux", (Object)INTELLIJ_RUST_NATIVE_HELPER);
        };
        String os2 = (String)pair.component1();
        String binaryName = (String)pair.component2();
        switch (WhenMappings.$EnumSwitchMapping$1[arch.ordinal()]) {
            case 1: {
                string = "x64";
                break;
            }
            case 2: {
                string = "aarch64";
                break;
            }
            default: {
                return null;
            }
        }
        String arch2 = string;
        if (PluginManagerCore.isRunningFromSources()) {
            Path path2;
            Path it2 = path2 = Path.of(PathManager.getHomePath(), new String[0]).resolve("out/rustrover-helper/" + os2 + "/" + arch2 + "/" + binaryName);
            boolean bl = false;
            path = Files.exists(it2, new LinkOption[0]) ? path2 : null;
        } else if (AppMode.isRunningFromDevBuild()) {
            Path path3;
            Path it3 = path3 = Path.of(PathManager.getHomePath(), new String[0]).getParent().getParent().resolve("rustrover-helper/" + os2 + "/" + arch2 + "/" + binaryName);
            boolean bl = false;
            path = Files.exists(it3, new LinkOption[0]) ? path3 : null;
        } else {
            Path path4;
            Path it4 = path4 = this.pluginDir().resolve("bin/" + os2 + "/" + arch2 + "/" + binaryName);
            boolean bl = false;
            path = Files.exists(it4, new LinkOption[0]) ? path4 : null;
            if (path == null) {
                it4 = path4 = this.pluginDir().resolve("bin/" + binaryName);
                boolean bl2 = false;
                path = Files.exists(it4, new LinkOption[0]) ? path4 : null;
            }
        }
        return path;
    }

    @NotNull
    public final Path pluginDirInSystem() {
        Path path = Paths.get(PathManager.getSystemPath(), new String[0]).resolve("intellij-rust");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final Path pluginDirInSystem(@NotNull EelDescriptor eelDescriptor) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)eelDescriptor, (String)"eelDescriptor");
        if (eelDescriptor instanceof LocalEelDescriptor) {
            path = this.pluginDirInSystem();
        } else {
            Path path2 = EelPathUtils.getSystemFolder((EelDescriptor)eelDescriptor).resolve("intellij-rust");
            Intrinsics.checkNotNull((Object)path2);
            path = path2;
        }
        return path;
    }

    @NotNull
    public final Path stdlibDependenciesDir(@NotNull EelDescriptor eelDescriptor) {
        Intrinsics.checkNotNullParameter((Object)eelDescriptor, (String)"eelDescriptor");
        Path path = this.pluginDirInSystem(eelDescriptor).resolve("stdlib");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final Path tempPluginDirInSystem() {
        Path path = Paths.get(PathManager.getTempPath(), new String[0]).resolve("intellij-rust");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final Path tempPluginDirInSystem(@NotNull EelDescriptor eelDescriptor) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)eelDescriptor, (String)"eelDescriptor");
        if (eelDescriptor instanceof LocalEelDescriptor) {
            path = this.tempPluginDirInSystem();
        } else {
            Path path2 = EelPathUtils.getSystemFolder((EelDescriptor)eelDescriptor).resolve("tmp").resolve("intellij-rust");
            Intrinsics.checkNotNull((Object)path2);
            path = path2;
        }
        return path;
    }

    @NotNull
    public final Path stdlibLocalCopy(@NotNull EelDescriptor eelDescriptor) {
        Intrinsics.checkNotNullParameter((Object)eelDescriptor, (String)"eelDescriptor");
        Path path = this.pluginDirInSystem(eelDescriptor).resolve("stdlib-local-copy");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final Path coverageTmpDir() {
        Path path = this.pluginDirInSystem().resolve("tmp-coverage");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private final Path fakeBundledCaches() {
        return this.pluginDirInSystem().resolve("fake-bundled-caches");
    }

    @NotNull
    public final Path stdlibVendorDir(@NotNull Path srcDir, @NotNull RustcVersion version) {
        Intrinsics.checkNotNullParameter((Object)srcDir, (String)"srcDir");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        String stdlibHash = RsPathManagerKt.access$createDirAndVersionHash(srcDir, version);
        Path path = this.stdlibDependenciesDir(EelProviderUtil.getEelDescriptor((Path)srcDir)).resolve(version.getSemver().getParsedVersion() + "-" + stdlibHash + "/vendor");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final Path stdlibCopyDir(@NotNull Path srcDir, @Nullable RustcVersion version) {
        Intrinsics.checkNotNullParameter((Object)srcDir, (String)"srcDir");
        String stdlibPathHash = RsPathManagerKt.access$createDirAndVersionHash(srcDir, version);
        String dir = version == null ? stdlibPathHash : version.getSemver().getParsedVersion() + "-" + stdlibPathHash;
        Path path = this.stdlibLocalCopy(EelProviderUtil.getEelDescriptor((Path)srcDir)).resolve(dir + "/");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final Path sysrootStdlibDir(@NotNull Path sysroot) {
        Intrinsics.checkNotNullParameter((Object)sysroot, (String)"sysroot");
        Path path = sysroot.resolve("lib/rustlib/src/rust");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.macOS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CpuArch.values().length];
            try {
                nArray[CpuArch.X86_64.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuArch.ARM64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

