/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.utils.evaluation;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.psi.RsConstParameter;
import org.rust.lang.core.psi.RsConstant;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsInferType;
import org.rust.lang.core.psi.RsPathType;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.ext.ArithmeticOp;
import org.rust.lang.core.psi.ext.LogicOp;
import org.rust.lang.core.psi.ext.RsConstantKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.UnaryOperator;
import org.rust.lang.core.resolve.ref.RsPathReference;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.consts.Const;
import org.rust.lang.core.types.consts.CtConstParameter;
import org.rust.lang.core.types.consts.CtPlaceholder;
import org.rust.lang.core.types.consts.CtUnevaluated;
import org.rust.lang.core.types.consts.CtUnknown;
import org.rust.lang.core.types.consts.CtValue;
import org.rust.lang.core.types.infer.FoldKt;
import org.rust.lang.core.types.infer.TypeFoldable;
import org.rust.lang.core.types.infer.TypeFolder;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyBool;
import org.rust.lang.core.types.ty.TyInteger;
import org.rust.lang.core.types.ty.TyUnknown;
import org.rust.lang.utils.evaluation.ConstExpr;
import org.rust.lang.utils.evaluation.ConstExprBuilderKt;
import org.rust.lang.utils.evaluation.ConstExprKt;
import org.rust.lang.utils.evaluation.PathExprResolver;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u001a\u001e\u0010\u0007\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u001a\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\b\b\u0000\u0010\n*\u00020\u0004*\b\u0012\u0004\u0012\u0002H\n0\tH\u0002\u001a\u001b\u0010\u000b\u001a\u0002H\n\"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\f\u00a2\u0006\u0002\u0010\r\u001a&\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\b\b\u0000\u0010\n*\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\n0\tH\u0002\u001a&\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\b\b\u0000\u0010\n*\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\n0\tH\u0002\u001a\u001b\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015\"\u0015\u0010\u0016\u001a\u00020\u0017*\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"evaluate", "Lorg/rust/lang/core/types/consts/Const;", "Lorg/rust/lang/core/psi/RsExpr;", "expectedTy", "Lorg/rust/lang/core/types/ty/Ty;", "resolver", "Lorg/rust/lang/utils/evaluation/PathExprResolver;", "toConst", "Lorg/rust/lang/core/psi/ext/RsElement;", "Lorg/rust/lang/utils/evaluation/ConstExpr;", "T", "tryEvaluate", "Lorg/rust/lang/core/types/infer/TypeFoldable;", "(Lorg/rust/lang/core/types/infer/TypeFoldable;)Ljava/lang/Object;", "simplifyToBool", "expr", "simplifyToInteger", "validValueOrNull", "", "ty", "Lorg/rust/lang/core/types/ty/TyInteger;", "(JLorg/rust/lang/core/types/ty/TyInteger;)Ljava/lang/Long;", "validValuesRange", "Lkotlin/ranges/LongRange;", "getValidValuesRange", "(Lorg/rust/lang/core/types/ty/TyInteger;)Lkotlin/ranges/LongRange;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nConstExprEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstExprEvaluator.kt\norg/rust/lang/utils/evaluation/ConstExprEvaluatorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,207:1\n1#2:208\n*E\n"})
public final class ConstExprEvaluatorKt {
    @NotNull
    public static final Const evaluate(@NotNull RsExpr $this$evaluate, @NotNull Ty expectedTy, @Nullable PathExprResolver resolver) {
        Intrinsics.checkNotNullParameter((Object)$this$evaluate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expectedTy, (String)"expectedTy");
        TypeFoldable typeFoldable = ConstExprBuilderKt.toConstExpr($this$evaluate, expectedTy, resolver);
        if (typeFoldable == null || (typeFoldable = ConstExprEvaluatorKt.evaluate(typeFoldable)) == null || (typeFoldable = ConstExprKt.toConst(typeFoldable)) == null) {
            typeFoldable = CtUnknown.INSTANCE;
        }
        return typeFoldable;
    }

    public static /* synthetic */ Const evaluate$default(RsExpr rsExpr, Ty ty2, PathExprResolver pathExprResolver, int n, Object object) {
        if ((n & 1) != 0) {
            ty2 = ExtensionsKt.getType(rsExpr);
        }
        if ((n & 2) != 0) {
            pathExprResolver = PathExprResolver.Companion.getDefault();
        }
        return ConstExprEvaluatorKt.evaluate(rsExpr, ty2, pathExprResolver);
    }

    @NotNull
    public static final Const toConst(@NotNull RsElement $this$toConst, @NotNull Ty expectedTy, @Nullable PathExprResolver resolver) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$toConst, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expectedTy, (String)"expectedTy");
        RsElement rsElement = $this$toConst;
        if (rsElement instanceof RsExpr) {
            object = ConstExprEvaluatorKt.evaluate((RsExpr)$this$toConst, expectedTy, resolver);
        } else if (rsElement instanceof RsPathType) {
            RsElement resolved;
            RsPathReference rsPathReference = ((RsPathType)$this$toConst).getPath().getReference();
            RsElement rsElement2 = resolved = rsPathReference != null ? rsPathReference.resolve() : null;
            if (resolved instanceof RsConstParameter) {
                object = new CtConstParameter((RsConstParameter)resolved);
            } else if (resolved instanceof RsConstant) {
                if (RsConstantKt.isConst((RsConstant)resolved)) {
                    Object type;
                    Object object2 = ((RsConstant)resolved).getTypeReference();
                    if (object2 == null || (object2 = ExtensionsKt.getNormType((RsTypeReference)object2)) == null) {
                        object2 = type = (Ty)TyUnknown.INSTANCE;
                    }
                    if ((object = ((RsConstant)resolved).getExpr()) == null || (object = ConstExprEvaluatorKt.evaluate((RsExpr)object, (Ty)type, resolver)) == null) {
                        object = CtUnknown.INSTANCE;
                    }
                } else {
                    object = CtUnknown.INSTANCE;
                }
            } else {
                object = CtUnknown.INSTANCE;
            }
        } else {
            object = rsElement instanceof RsInferType ? (Const)new CtPlaceholder() : (Const)CtUnknown.INSTANCE;
        }
        return object;
    }

    public static /* synthetic */ Const toConst$default(RsElement rsElement, Ty ty2, PathExprResolver pathExprResolver, int n, Object object) {
        if ((n & 2) != 0) {
            pathExprResolver = PathExprResolver.Companion.getDefault();
        }
        return ConstExprEvaluatorKt.toConst(rsElement, ty2, pathExprResolver);
    }

    private static final <T extends Ty> ConstExpr<T> evaluate(ConstExpr<T> $this$evaluate) {
        T t = $this$evaluate.getExpectedTy();
        return t instanceof TyBool ? ConstExprEvaluatorKt.simplifyToBool($this$evaluate) : (t instanceof TyInteger ? ConstExprEvaluatorKt.simplifyToInteger($this$evaluate) : $this$evaluate);
    }

    public static final <T> T tryEvaluate(@NotNull TypeFoldable<? extends T> $this$tryEvaluate) {
        Intrinsics.checkNotNullParameter($this$tryEvaluate, (String)"<this>");
        if (!FoldKt.getNeedsEval($this$tryEvaluate)) {
            return (T)$this$tryEvaluate;
        }
        return $this$tryEvaluate.foldWith(new TypeFolder(){

            public Ty foldTy(Ty ty2) {
                Intrinsics.checkNotNullParameter((Object)ty2, (String)"ty");
                return FoldKt.getNeedsEval(ty2) ? ty2.superFoldWith(this) : ty2;
            }

            public Const foldConst(Const const_) {
                Intrinsics.checkNotNullParameter((Object)const_, (String)"const");
                return const_ instanceof CtUnevaluated && FoldKt.getNeedsEval(const_) ? ConstExprKt.toConst(ConstExprEvaluatorKt.access$evaluate(((CtUnevaluated)const_).getExpr())) : const_;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final <T extends Ty> ConstExpr<T> simplifyToBool(ConstExpr<T> expr) {
        boolean bl;
        block21: {
            ConstExpr right;
            ConstExpr left;
            Object object;
            block25: {
                block26: {
                    block23: {
                        block24: {
                            ConstExpr<T> constExpr;
                            block22: {
                                ConstExpr.Value.Bool value;
                                CtValue ctValue;
                                constExpr = expr;
                                if (!(constExpr instanceof ConstExpr.Constant)) break block22;
                                Const const_ = ((ConstExpr.Constant)expr).getConst();
                                CtValue ctValue2 = ctValue = const_ instanceof CtValue ? (CtValue)const_ : null;
                                object = ctValue2 != null ? ctValue2.getExpr() : null;
                                ConstExpr.Value.Bool bool = value = object instanceof ConstExpr.Value.Bool ? (ConstExpr.Value.Bool)object : null;
                                if (bool == null) {
                                    return expr;
                                }
                                bl = bool.getValue();
                                break block21;
                            }
                            if (constExpr instanceof ConstExpr.Unary) {
                                if (((ConstExpr.Unary)expr).getOperator() != UnaryOperator.NOT) {
                                    return new ConstExpr.Error();
                                }
                                ConstExpr result2 = ConstExprEvaluatorKt.simplifyToBool(((ConstExpr.Unary)expr).getExpr());
                                if (result2 instanceof ConstExpr.Value.Bool) {
                                    bl = !((ConstExpr.Value.Bool)result2).getValue();
                                    break block21;
                                } else {
                                    if (result2 instanceof ConstExpr.Error) {
                                        return new ConstExpr.Error();
                                    }
                                    return ConstExpr.Unary.copy$default((ConstExpr.Unary)expr, null, result2, null, 5, null);
                                }
                            }
                            if (!(constExpr instanceof ConstExpr.Binary)) {
                                return expr;
                            }
                            left = ConstExprEvaluatorKt.simplifyToBool(((ConstExpr.Binary)expr).getLeft());
                            right = ConstExprEvaluatorKt.simplifyToBool(((ConstExpr.Binary)expr).getRight());
                            object = ((ConstExpr.Binary)expr).getOperator();
                            if (!Intrinsics.areEqual((Object)object, (Object)LogicOp.AND.INSTANCE)) break block23;
                            if (!(left instanceof ConstExpr.Value.Bool) || ((ConstExpr.Value.Bool)left).getValue()) break block24;
                            bl = false;
                            break block21;
                        }
                        if (right instanceof ConstExpr.Value.Bool && !((ConstExpr.Value.Bool)right).getValue()) {
                            bl = false;
                            break block21;
                        } else if (left instanceof ConstExpr.Value.Bool && right instanceof ConstExpr.Value.Bool) {
                            bl = ((ConstExpr.Value.Bool)left).getValue() && ((ConstExpr.Value.Bool)right).getValue();
                            break block21;
                        } else {
                            if (!(left instanceof ConstExpr.Error) && !(right instanceof ConstExpr.Error)) {
                                return ConstExpr.Binary.copy$default((ConstExpr.Binary)expr, left, null, right, null, 10, null);
                            }
                            return new ConstExpr.Error();
                        }
                    }
                    if (!Intrinsics.areEqual((Object)object, (Object)LogicOp.OR.INSTANCE)) break block25;
                    if (!(left instanceof ConstExpr.Value.Bool) || !((ConstExpr.Value.Bool)left).getValue()) break block26;
                    bl = true;
                    break block21;
                }
                if (right instanceof ConstExpr.Value.Bool && ((ConstExpr.Value.Bool)right).getValue()) {
                    bl = true;
                    break block21;
                } else if (left instanceof ConstExpr.Value.Bool && right instanceof ConstExpr.Value.Bool) {
                    bl = ((ConstExpr.Value.Bool)left).getValue() || ((ConstExpr.Value.Bool)right).getValue();
                    break block21;
                } else {
                    if (!(left instanceof ConstExpr.Error) && !(right instanceof ConstExpr.Error)) {
                        return ConstExpr.Binary.copy$default((ConstExpr.Binary)expr, left, null, right, null, 10, null);
                    }
                    return new ConstExpr.Error();
                }
            }
            if (!Intrinsics.areEqual((Object)object, (Object)ArithmeticOp.BIT_XOR.INSTANCE)) {
                return new ConstExpr.Error();
            }
            if (left instanceof ConstExpr.Value.Bool && right instanceof ConstExpr.Value.Bool) {
                bl = ((ConstExpr.Value.Bool)left).getValue() ^ ((ConstExpr.Value.Bool)right).getValue();
            } else {
                if (!(left instanceof ConstExpr.Error) && !(right instanceof ConstExpr.Error)) {
                    return ConstExpr.Binary.copy$default((ConstExpr.Binary)expr, left, null, right, null, 10, null);
                }
                return new ConstExpr.Error();
            }
        }
        boolean value = bl;
        return new ConstExpr.Value.Bool(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final <T extends Ty> ConstExpr<T> simplifyToInteger(ConstExpr<T> expr) {
        Long value;
        Long l;
        Long l2;
        T expectedTy = expr.getExpectedTy();
        if (!(expectedTy instanceof TyInteger)) {
            return new ConstExpr.Error();
        }
        ConstExpr<T> constExpr = expr;
        if (constExpr instanceof ConstExpr.Constant) {
            ConstExpr.Value.Integer value2;
            CtValue ctValue;
            Const const_ = ((ConstExpr.Constant)expr).getConst();
            CtValue ctValue2 = ctValue = const_ instanceof CtValue ? (CtValue)const_ : null;
            var6_6 = ctValue2 != null ? ctValue2.getExpr() : null;
            ConstExpr.Value.Integer integer = value2 = var6_6 instanceof ConstExpr.Value.Integer ? (ConstExpr.Value.Integer)var6_6 : null;
            if (integer == null) {
                return expr;
            }
            l2 = integer.getValue();
        } else if (constExpr instanceof ConstExpr.Unary) {
            if (((ConstExpr.Unary)expr).getOperator() != UnaryOperator.NEG) {
                return new ConstExpr.Error();
            }
            ConstExpr result2 = ConstExprEvaluatorKt.simplifyToInteger(((ConstExpr.Unary)expr).getExpr());
            if (!(result2 instanceof ConstExpr.Value.Integer)) {
                if (!(result2 instanceof ConstExpr.Error)) return ConstExpr.Unary.copy$default((ConstExpr.Unary)expr, null, result2, null, 5, null);
                return new ConstExpr.Error();
            }
            l2 = -((ConstExpr.Value.Integer)result2).getValue();
        } else {
            if (!(constExpr instanceof ConstExpr.Binary)) return expr;
            ConstExpr left = ConstExprEvaluatorKt.simplifyToInteger(((ConstExpr.Binary)expr).getLeft());
            ConstExpr right = ConstExprEvaluatorKt.simplifyToInteger(((ConstExpr.Binary)expr).getRight());
            if (left instanceof ConstExpr.Value.Integer && right instanceof ConstExpr.Value.Integer) {
                var6_6 = ((ConstExpr.Binary)expr).getOperator();
                if (Intrinsics.areEqual((Object)var6_6, (Object)ArithmeticOp.ADD.INSTANCE)) {
                    l2 = ((ConstExpr.Value.Integer)left).getValue() + ((ConstExpr.Value.Integer)right).getValue();
                } else if (Intrinsics.areEqual((Object)var6_6, (Object)ArithmeticOp.SUB.INSTANCE)) {
                    l2 = ((ConstExpr.Value.Integer)left).getValue() - ((ConstExpr.Value.Integer)right).getValue();
                } else if (Intrinsics.areEqual((Object)var6_6, (Object)ArithmeticOp.MUL.INSTANCE)) {
                    l2 = ((ConstExpr.Value.Integer)left).getValue() * ((ConstExpr.Value.Integer)right).getValue();
                } else if (Intrinsics.areEqual((Object)var6_6, (Object)ArithmeticOp.DIV.INSTANCE)) {
                    l2 = ((ConstExpr.Value.Integer)right).getValue() == 0L ? null : Long.valueOf(((ConstExpr.Value.Integer)left).getValue() / ((ConstExpr.Value.Integer)right).getValue());
                } else if (Intrinsics.areEqual((Object)var6_6, (Object)ArithmeticOp.REM.INSTANCE)) {
                    l2 = ((ConstExpr.Value.Integer)right).getValue() == 0L ? null : Long.valueOf(((ConstExpr.Value.Integer)left).getValue() % ((ConstExpr.Value.Integer)right).getValue());
                } else if (Intrinsics.areEqual((Object)var6_6, (Object)ArithmeticOp.BIT_AND.INSTANCE)) {
                    l2 = ((ConstExpr.Value.Integer)left).getValue() & ((ConstExpr.Value.Integer)right).getValue();
                } else if (Intrinsics.areEqual((Object)var6_6, (Object)ArithmeticOp.BIT_OR.INSTANCE)) {
                    l2 = ((ConstExpr.Value.Integer)left).getValue() | ((ConstExpr.Value.Integer)right).getValue();
                } else if (Intrinsics.areEqual((Object)var6_6, (Object)ArithmeticOp.BIT_XOR.INSTANCE)) {
                    l2 = ((ConstExpr.Value.Integer)left).getValue() ^ ((ConstExpr.Value.Integer)right).getValue();
                } else if (Intrinsics.areEqual((Object)var6_6, (Object)ArithmeticOp.SHL.INSTANCE)) {
                    l2 = ((ConstExpr.Value.Integer)right).getValue() >= 8L ? null : Long.valueOf(((ConstExpr.Value.Integer)left).getValue() << (int)((ConstExpr.Value.Integer)right).getValue());
                } else {
                    if (!Intrinsics.areEqual((Object)var6_6, (Object)ArithmeticOp.SHR.INSTANCE)) return new ConstExpr.Error();
                    l2 = ((ConstExpr.Value.Integer)right).getValue() >= 8L ? 0L : ((ConstExpr.Value.Integer)left).getValue() >> (int)((ConstExpr.Value.Integer)right).getValue();
                }
            } else {
                if (!(left instanceof ConstExpr.Error) && !(right instanceof ConstExpr.Error)) return ConstExpr.Binary.copy$default((ConstExpr.Binary)expr, left, null, right, null, 10, null);
                return new ConstExpr.Error();
            }
        }
        if ((l = (value = l2)) == null || (l = ConstExprEvaluatorKt.validValueOrNull(l, (TyInteger)expectedTy)) == null) {
            return new ConstExpr.Error();
        }
        long checkedValue = l;
        return new ConstExpr.Value.Integer(checkedValue, (TyInteger)expectedTy);
    }

    private static final Long validValueOrNull(long $this$validValueOrNull, TyInteger ty2) {
        Long l = $this$validValueOrNull;
        long it2 = ((Number)l).longValue();
        boolean bl = false;
        LongRange longRange = ConstExprEvaluatorKt.getValidValuesRange(ty2);
        long l2 = longRange.getFirst();
        return (it2 <= longRange.getLast() ? l2 <= it2 : false) ? l : null;
    }

    @NotNull
    public static final LongRange getValidValuesRange(@NotNull TyInteger $this$validValuesRange) {
        LongRange longRange;
        Intrinsics.checkNotNullParameter((Object)$this$validValuesRange, (String)"<this>");
        TyInteger tyInteger = $this$validValuesRange;
        if (tyInteger instanceof TyInteger.U8) {
            longRange = new LongRange(0L, 255L);
        } else if (tyInteger instanceof TyInteger.U16) {
            longRange = new LongRange(0L, 65535L);
        } else if (tyInteger instanceof TyInteger.U32) {
            longRange = new LongRange(0L, 0xFFFFFFFFL);
        } else if (tyInteger instanceof TyInteger.U64) {
            longRange = new LongRange(0L, Long.MAX_VALUE);
        } else if (tyInteger instanceof TyInteger.U128) {
            longRange = new LongRange(0L, Long.MAX_VALUE);
        } else if (tyInteger instanceof TyInteger.USize) {
            longRange = new LongRange(0L, Long.MAX_VALUE);
        } else if (tyInteger instanceof TyInteger.I8) {
            longRange = new LongRange(-128L, 127L);
        } else if (tyInteger instanceof TyInteger.I16) {
            longRange = new LongRange(-32768L, 32767L);
        } else if (tyInteger instanceof TyInteger.I32) {
            longRange = new LongRange(Integer.MIN_VALUE, Integer.MAX_VALUE);
        } else if (tyInteger instanceof TyInteger.I64) {
            longRange = new LongRange(Long.MIN_VALUE, Long.MAX_VALUE);
        } else if (tyInteger instanceof TyInteger.I128) {
            longRange = new LongRange(Long.MIN_VALUE, Long.MAX_VALUE);
        } else if (tyInteger instanceof TyInteger.ISize) {
            longRange = new LongRange(Long.MIN_VALUE, Long.MAX_VALUE);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return longRange;
    }

    public static final /* synthetic */ ConstExpr access$evaluate(ConstExpr $receiver) {
        return ConstExprEvaluatorKt.evaluate($receiver);
    }
}

