/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.utils.evaluation;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.rust.cargo.CfgOptions;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.project.workspace.FeatureState;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.lang.core.crate.Crate;
import org.rust.lang.core.psi.RsCfgSelectPredicate;
import org.rust.lang.core.psi.RsPsiManagerKt;
import org.rust.lang.core.stubs.common.RsMetaItemPsiOrStub;
import org.rust.lang.core.stubs.index.RsCfgNotTestIndex;
import org.rust.lang.utils.evaluation.CfgEvaluatorKt;
import org.rust.lang.utils.evaluation.CfgPredicate;
import org.rust.lang.utils.evaluation.CfgTestmarks;
import org.rust.lang.utils.evaluation.ThreeValuedLogic;
import org.rust.stdext.HashCode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0014\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0013J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006H\u0002J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J\u0006\u0010 \u001a\u00020!R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/rust/lang/utils/evaluation/CfgEvaluator;", "", "options", "Lorg/rust/cargo/CfgOptions;", "features", "", "", "Lorg/rust/cargo/project/workspace/FeatureState;", "origin", "Lorg/rust/cargo/project/workspace/PackageOrigin;", "evaluateUnknownCfgToFalse", "", "cfgTestValue", "Lorg/rust/lang/utils/evaluation/ThreeValuedLogic;", "<init>", "(Lorg/rust/cargo/CfgOptions;Ljava/util/Map;Lorg/rust/cargo/project/workspace/PackageOrigin;ZLorg/rust/lang/utils/evaluation/ThreeValuedLogic;)V", "evaluate", "cfgAttributes", "Lkotlin/sequences/Sequence;", "Lorg/rust/lang/core/stubs/common/RsMetaItemPsiOrStub;", "cfgSelectPredicate", "Lorg/rust/lang/core/psi/RsCfgSelectPredicate;", "evaluateCondition", "predicate", "cfgPredicate", "Lorg/rust/lang/utils/evaluation/CfgPredicate;", "evaluatePredicate", "evaluateName", "name", "evaluateNameValue", "value", "evaluateFeature", "hashCodeForMacroCache", "Lorg/rust/stdext/HashCode;", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCfgEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CfgEvaluator.kt\norg/rust/lang/utils/evaluation/CfgEvaluator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,331:1\n1803#2,3:332\n1803#2,3:335\n1056#2:338\n*S KotlinDebug\n*F\n+ 1 CfgEvaluator.kt\norg/rust/lang/utils/evaluation/CfgEvaluator\n*L\n110#1:332,3\n111#1:335,3\n174#1:338\n*E\n"})
public final class CfgEvaluator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CfgOptions options;
    @NotNull
    private final Map<String, FeatureState> features;
    @NotNull
    private final PackageOrigin origin;
    private final boolean evaluateUnknownCfgToFalse;
    @NotNull
    private final ThreeValuedLogic cfgTestValue;
    @NotNull
    private static final Set<String> SUPPORTED_NAME_OPTIONS;
    @NotNull
    private static final Set<String> SUPPORTED_NAME_VALUE_OPTIONS;
    @NotNull
    private static final Key<CachedValue<CfgEvaluator>> CRATE_CFG_EVALUATOR_KEY;

    public CfgEvaluator(@NotNull CfgOptions options, @NotNull Map<String, ? extends FeatureState> features, @NotNull PackageOrigin origin, boolean evaluateUnknownCfgToFalse, @NotNull ThreeValuedLogic cfgTestValue) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(features, (String)"features");
        Intrinsics.checkNotNullParameter((Object)((Object)origin), (String)"origin");
        Intrinsics.checkNotNullParameter((Object)((Object)cfgTestValue), (String)"cfgTestValue");
        this.options = options;
        this.features = features;
        this.origin = origin;
        this.evaluateUnknownCfgToFalse = evaluateUnknownCfgToFalse;
        this.cfgTestValue = cfgTestValue;
    }

    @NotNull
    public final ThreeValuedLogic evaluate(@NotNull Sequence<? extends RsMetaItemPsiOrStub> cfgAttributes) {
        Intrinsics.checkNotNullParameter(cfgAttributes, (String)"cfgAttributes");
        return this.evaluate(CfgPredicate.Companion.fromCfgAttributes(cfgAttributes));
    }

    @NotNull
    public final ThreeValuedLogic evaluate(@NotNull RsCfgSelectPredicate cfgSelectPredicate) {
        Intrinsics.checkNotNullParameter((Object)cfgSelectPredicate, (String)"cfgSelectPredicate");
        return this.evaluate(CfgPredicate.Companion.fromCfgSelectPredicate(cfgSelectPredicate));
    }

    @NotNull
    public final ThreeValuedLogic evaluateCondition(@NotNull RsMetaItemPsiOrStub predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        return this.evaluate(CfgPredicate.Companion.fromMetaItem(predicate));
    }

    private final ThreeValuedLogic evaluate(CfgPredicate cfgPredicate) {
        ThreeValuedLogic result2 = this.evaluatePredicate(cfgPredicate);
        switch (WhenMappings.$EnumSwitchMapping$0[result2.ordinal()]) {
            case 1: {
                CfgTestmarks.EvaluatesTrue.INSTANCE.hit();
                break;
            }
            case 2: {
                CfgTestmarks.EvaluatesFalse.INSTANCE.hit();
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final ThreeValuedLogic evaluatePredicate(CfgPredicate predicate) {
        ThreeValuedLogic threeValuedLogic;
        CfgPredicate cfgPredicate = predicate;
        if (cfgPredicate instanceof CfgPredicate.All) {
            void $this$fold$iv;
            Iterable iterable = ((CfgPredicate.All)predicate).getList();
            ThreeValuedLogic initial$iv = ThreeValuedLogic.True;
            boolean $i$f$fold = false;
            ThreeValuedLogic accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void pred;
                CfgPredicate cfgPredicate2 = (CfgPredicate)element$iv;
                ThreeValuedLogic acc = accumulator$iv;
                boolean bl = false;
                accumulator$iv = CfgEvaluatorKt.and(acc, this.evaluatePredicate((CfgPredicate)pred));
            }
            threeValuedLogic = accumulator$iv;
        } else if (cfgPredicate instanceof CfgPredicate.Any) {
            Iterable $this$fold$iv = ((CfgPredicate.Any)predicate).getList();
            ThreeValuedLogic initial$iv = ThreeValuedLogic.False;
            boolean $i$f$fold = false;
            ThreeValuedLogic accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                CfgPredicate pred = (CfgPredicate)element$iv;
                ThreeValuedLogic acc = accumulator$iv;
                boolean bl = false;
                accumulator$iv = CfgEvaluatorKt.or(acc, this.evaluatePredicate(pred));
            }
            threeValuedLogic = accumulator$iv;
        } else if (cfgPredicate instanceof CfgPredicate.Not) {
            threeValuedLogic = CfgEvaluatorKt.not(this.evaluatePredicate(((CfgPredicate.Not)predicate).getSingle()));
        } else if (cfgPredicate instanceof CfgPredicate.NameOption) {
            threeValuedLogic = this.evaluateName(((CfgPredicate.NameOption)predicate).getName());
        } else if (cfgPredicate instanceof CfgPredicate.NameValueOption) {
            threeValuedLogic = this.evaluateNameValue(((CfgPredicate.NameValueOption)predicate).getName(), ((CfgPredicate.NameValueOption)predicate).getValue());
        } else if (cfgPredicate instanceof CfgPredicate.True) {
            threeValuedLogic = ThreeValuedLogic.True;
        } else if (cfgPredicate instanceof CfgPredicate.False) {
            threeValuedLogic = ThreeValuedLogic.False;
        } else if (cfgPredicate instanceof CfgPredicate.Error) {
            threeValuedLogic = ThreeValuedLogic.Unknown;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return threeValuedLogic;
    }

    private final ThreeValuedLogic evaluateName(String name2) {
        String string;
        return Intrinsics.areEqual((Object)name2, (Object)"cfg_panic") ? ThreeValuedLogic.Unknown : (Intrinsics.areEqual((Object)name2, (Object)"test") ? this.cfgTestValue : (Intrinsics.areEqual((Object)name2, (Object)"rustdoc") && this.origin == PackageOrigin.STDLIB ? ThreeValuedLogic.Unknown : (this.evaluateUnknownCfgToFalse ? ThreeValuedLogic.Companion.fromBoolean(this.options.isNameEnabled(name2)) : (SUPPORTED_NAME_OPTIONS.contains(string = name2) ? ThreeValuedLogic.Companion.fromBoolean(this.options.isNameEnabled(name2)) : ThreeValuedLogic.Unknown))));
    }

    private final ThreeValuedLogic evaluateNameValue(String name2, String value) {
        String string;
        return Intrinsics.areEqual((Object)name2, (Object)"feature") ? this.evaluateFeature(value) : (this.evaluateUnknownCfgToFalse ? ThreeValuedLogic.Companion.fromBoolean(this.options.isNameValueEnabled(name2, value)) : (SUPPORTED_NAME_VALUE_OPTIONS.contains(string = name2) ? ThreeValuedLogic.Companion.fromBoolean(this.options.isNameValueEnabled(name2, value)) : ThreeValuedLogic.Unknown));
    }

    private final ThreeValuedLogic evaluateFeature(String name2) {
        if (this.origin == PackageOrigin.STDLIB) {
            return ThreeValuedLogic.Unknown;
        }
        FeatureState featureState = this.features.get(name2);
        return switch (featureState == null ? -1 : WhenMappings.$EnumSwitchMapping$1[featureState.ordinal()]) {
            case 1 -> ThreeValuedLogic.True;
            case 2 -> ThreeValuedLogic.False;
            case -1 -> {
                if (this.options.isNameValueEnabled("feature", name2)) {
                    yield ThreeValuedLogic.True;
                }
                if (this.evaluateUnknownCfgToFalse) {
                    yield ThreeValuedLogic.False;
                }
                yield ThreeValuedLogic.Unknown;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final HashCode hashCodeForMacroCache() {
        StringBuilder stringBuilder;
        StringBuilder $this$hashCodeForMacroCache_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$hashCodeForMacroCache_u24lambda_u240.append("[keyValueOptions]").append('\n');
        for (String key : CollectionsKt.sorted((Iterable)this.options.getKeyValueOptions().keySet())) {
            $this$hashCodeForMacroCache_u24lambda_u240.append(key + " = ");
            StringBuilder stringBuilder2 = $this$hashCodeForMacroCache_u24lambda_u240;
            Collection<String> collection = this.options.getKeyValueOptions().get(key);
            stringBuilder2.append(collection != null && (collection = CollectionsKt.sorted((Iterable)collection)) != null ? CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) : null).append('\n');
        }
        $this$hashCodeForMacroCache_u24lambda_u240.append("[namedOptions]").append('\n');
        $this$hashCodeForMacroCache_u24lambda_u240.append(CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)this.options.getNameOptions()), (CharSequence)",", null, null, (int)0, null, null, (int)62, null)).append('\n');
        $this$hashCodeForMacroCache_u24lambda_u240.append("[features]").append('\n');
        Iterable $this$sortedBy$iv = this.features.entrySet();
        boolean $i$f$sortedBy = false;
        for (Map.Entry entry2 : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it2 = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it2.getKey()));
                it2 = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it2.getKey()))));
            }
        })) {
            String feature = (String)entry2.getKey();
            FeatureState state = (FeatureState)((Object)entry2.getValue());
            $this$hashCodeForMacroCache_u24lambda_u240.append(feature + " = " + state).append('\n');
        }
        $this$hashCodeForMacroCache_u24lambda_u240.append("[origin]").append('\n');
        $this$hashCodeForMacroCache_u24lambda_u240.append(this.origin.toString()).append('\n');
        $this$hashCodeForMacroCache_u24lambda_u240.append("[evaluateUnknownCfgToFalse]").append('\n');
        $this$hashCodeForMacroCache_u24lambda_u240.append(String.valueOf(this.evaluateUnknownCfgToFalse)).append('\n');
        $this$hashCodeForMacroCache_u24lambda_u240.append("[cfgTestValue]").append('\n');
        $this$hashCodeForMacroCache_u24lambda_u240.append(this.cfgTestValue.toString()).append('\n');
        String serialized = stringBuilder.toString();
        return HashCode.Companion.compute(serialized);
    }

    static {
        Object[] objectArray = new String[]{"debug_assertions", "unix", "windows", "test", "doc"};
        SUPPORTED_NAME_OPTIONS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"target_arch", "target_endian", "target_env", "target_family", "target_feature", "target_os", "target_pointer_width", "target_vendor"};
        SUPPORTED_NAME_VALUE_OPTIONS = SetsKt.setOf((Object[])objectArray);
        Key key = Key.create((String)"CRATE_CFG_EVALUATOR_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        CRATE_CFG_EVALUATOR_KEY = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/rust/lang/utils/evaluation/CfgEvaluator$Companion;", "", "<init>", "()V", "SUPPORTED_NAME_OPTIONS", "", "", "SUPPORTED_NAME_VALUE_OPTIONS", "CRATE_CFG_EVALUATOR_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "Lorg/rust/lang/utils/evaluation/CfgEvaluator;", "forCrate", "crate", "Lorg/rust/lang/core/crate/Crate;", "forCrateInner", "evaluateUnknownCfgToFalse", "", "cfgTestValue", "Lorg/rust/lang/utils/evaluation/ThreeValuedLogic;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nCfgEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CfgEvaluator.kt\norg/rust/lang/utils/evaluation/CfgEvaluator$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,331:1\n1#2:332\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CfgEvaluator forCrate(@NotNull Crate crate) {
            Intrinsics.checkNotNullParameter((Object)crate, (String)"crate");
            Project project = crate.getProject();
            Object object = CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)crate, CRATE_CFG_EVALUATOR_KEY, () -> Companion.forCrate$lambda$0(crate), false);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
            return (CfgEvaluator)object;
        }

        private final CfgEvaluator forCrateInner(Crate crate) {
            ThreeValuedLogic cfgTest = switch (WhenMappings.$EnumSwitchMapping$0[crate.getOrigin().ordinal()]) {
                case 1, 2 -> ThreeValuedLogic.False;
                case 3 -> {
                    boolean v3;
                    ThreeValuedLogic.Companion v1 = ThreeValuedLogic.Companion;
                    Object v2 = crate.getCargoTarget();
                    if (v2 != null && (v2 = v2.getPkg()) != null) {
                        void it;
                        Object var3_2 = v2;
                        ThreeValuedLogic.Companion var5_3 = v1;
                        boolean $i$a$-let-CfgEvaluator$Companion$forCrateInner$cfgTest$1 = false;
                        boolean var6_5 = !RsCfgNotTestIndex.Helper.INSTANCE.hasCfgNotTest(crate.getProject(), (CargoWorkspace.Package)it);
                        v1 = var5_3;
                        v3 = var6_5;
                    } else {
                        v3 = false;
                    }
                    yield v1.fromBoolean(v3);
                }
                case 4 -> ThreeValuedLogic.Unknown;
                default -> throw new NoWhenBranchMatchedException();
            };
            return this.forCrate(crate, crate.getEvaluateUnknownCfgToFalse(), cfgTest);
        }

        @NotNull
        public final CfgEvaluator forCrate(@NotNull Crate crate, boolean evaluateUnknownCfgToFalse, @NotNull ThreeValuedLogic cfgTestValue) {
            Intrinsics.checkNotNullParameter((Object)crate, (String)"crate");
            Intrinsics.checkNotNullParameter((Object)((Object)cfgTestValue), (String)"cfgTestValue");
            return new CfgEvaluator(crate.getCfgOptions(), crate.getFeatures(), crate.getOrigin(), evaluateUnknownCfgToFalse, cfgTestValue);
        }

        private static final CachedValueProvider.Result forCrate$lambda$0(Crate $crate) {
            Object[] objectArray = new Object[]{RsPsiManagerKt.getRustStructureModificationTracker($crate)};
            return CachedValueProvider.Result.create((Object)Companion.forCrateInner($crate), (Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[PackageOrigin.values().length];
                try {
                    nArray[PackageOrigin.STDLIB.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PackageOrigin.STDLIB_DEPENDENCY.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PackageOrigin.DEPENDENCY.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PackageOrigin.WORKSPACE.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ThreeValuedLogic.values().length];
            try {
                nArray[ThreeValuedLogic.True.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeValuedLogic.False.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeValuedLogic.Unknown.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[FeatureState.values().length];
            try {
                nArray[FeatureState.Enabled.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureState.Disabled.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

