/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.utils;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.ide.fixes.RsQuickFixBase;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsRetType;
import org.rust.lang.core.psi.ext.PsiElementKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/rust/lang/utils/RsRemoveReturnTypeQuickFix;", "Lorg/rust/ide/fixes/RsQuickFixBase;", "Lcom/intellij/psi/PsiElement;", "element", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "getFamilyName", "", "getText", "findReturnType", "Lorg/rust/lang/core/psi/RsRetType;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.rustrover.core"})
public final class RsRemoveReturnTypeQuickFix
extends RsQuickFixBase<PsiElement> {
    public RsRemoveReturnTypeQuickFix(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(element);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return RsBundle.INSTANCE.message("intention.family.name.remove.return.type", new Object[0]);
    }

    @Override
    @NotNull
    public String getText() {
        RsRetType rsRetType = this.findReturnType();
        if (rsRetType == null) {
            return this.getFamilyName();
        }
        RsRetType returnType = rsRetType;
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)returnType.getText(), (String)"getText(...)");
        return RsBundle.INSTANCE.message("intention.name.remove", objectArray);
    }

    private final RsRetType findReturnType() {
        PsiElement psiElement2 = this.myStartElement.getElement();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement element = psiElement2;
        RsFunction rsFunction = PsiElementKt.getContainingFunction(element);
        return rsFunction != null ? rsFunction.getRetType() : null;
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiElement element) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            RsRetType rsRetType = this.findReturnType();
            if (rsRetType == null) break block0;
            rsRetType.delete();
        }
    }
}

