/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.utils;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.lexer.RsEscapesLexer;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a(\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a$\u0010\b\u001a\u0018\u0012\b\u0012\u00060\nj\u0002`\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00030\t2\u0006\u0010\r\u001a\u00020\u0001\u001a&\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\r\u001a\u00020\u00012\n\u0010\u000f\u001a\u00060\nj\u0002`\u000b\u001a$\u0010\b\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00012\n\u0010\u000f\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\u0010\u001a\u00020\fH\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0013\u001a\u00020\u0001*\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0003\u001a \u0010\u0013\u001a\u00020\u0016*\u00020\u00142\n\u0010\u0017\u001a\u00060\nj\u0002`\u000b2\b\b\u0002\u0010\u0015\u001a\u00020\u0003\u001a \u0010\u0018\u001a\u00020\u0016*\u00020\u00142\n\u0010\u0017\u001a\u00060\nj\u0002`\u000b2\b\b\u0002\u0010\u0015\u001a\u00020\u0003\u00a8\u0006\u0019"}, d2={"unescapeRust", "", "unicode", "", "eol", "extendedByte", "escapesLexer", "Lorg/rust/lang/core/lexer/RsEscapesLexer;", "parseRustStringCharacters", "Lkotlin/Triple;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "", "chars", "Lkotlin/Pair;", "outChars", "sourceOffsets", "decodeEscape", "esc", "escapeRust", "", "escapeNonPrintable", "", "out", "escapeRustRaw", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsEscapesUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsEscapesUtils.kt\norg/rust/lang/utils/RsEscapesUtilsKt\n+ 2 EscapeUtils.kt\norg/rust/lang/core/lexer/EscapeUtilsKt\n+ 3 utils.kt\norg/rust/openapiext/UtilsKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,113:1\n30#2,33:114\n318#3,10:147\n318#3,10:157\n434#4:167\n507#4,5:168\n*S KotlinDebug\n*F\n+ 1 RsEscapesUtils.kt\norg/rust/lang/utils/RsEscapesUtilsKt\n*L\n47#1:114,33\n60#1:147,10\n61#1:157,10\n64#1:167\n64#1:168,5\n*E\n"})
public final class RsEscapesUtilsKt {
    @NotNull
    public static final String unescapeRust(@NotNull String $this$unescapeRust, boolean unicode, boolean eol, boolean extendedByte) {
        Intrinsics.checkNotNullParameter((Object)$this$unescapeRust, (String)"<this>");
        return RsEscapesUtilsKt.unescapeRust($this$unescapeRust, RsEscapesLexer.Companion.dummy(unicode, eol, extendedByte));
    }

    public static /* synthetic */ String unescapeRust$default(String string, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        if ((n & 4) != 0) {
            bl3 = true;
        }
        return RsEscapesUtilsKt.unescapeRust(string, bl, bl2, bl3);
    }

    @NotNull
    public static final String unescapeRust(@NotNull String $this$unescapeRust, @NotNull RsEscapesLexer escapesLexer) {
        Intrinsics.checkNotNullParameter((Object)$this$unescapeRust, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)escapesLexer), (String)"escapesLexer");
        return SequencesKt.joinToString$default(org.rust.lang.core.lexer.UtilsKt.tokenize($this$unescapeRust, (Lexer)escapesLexer), (CharSequence)"", null, null, (int)0, null, RsEscapesUtilsKt::unescapeRust$lambda$0, (int)30, null);
    }

    @NotNull
    public static final Triple<StringBuilder, int[], Boolean> parseRustStringCharacters(@NotNull String chars) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        StringBuilder outChars = new StringBuilder();
        Pair<int[], Boolean> pair = RsEscapesUtilsKt.parseRustStringCharacters(chars, outChars);
        int[] offsets = (int[])pair.component1();
        boolean success = (Boolean)pair.component2();
        return new Triple((Object)outChars, (Object)offsets, (Object)success);
    }

    @NotNull
    public static final Pair<int[], Boolean> parseRustStringCharacters(@NotNull String chars, @NotNull StringBuilder outChars) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        Intrinsics.checkNotNullParameter((Object)outChars, (String)"outChars");
        int[] sourceOffsets = new int[chars.length() + 1];
        boolean result2 = RsEscapesUtilsKt.parseRustStringCharacters(chars, outChars, sourceOffsets);
        return TuplesKt.to((Object)sourceOffsets, (Object)result2);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean parseRustStringCharacters(String chars, StringBuilder outChars, int[] sourceOffsets) {
        boolean bl;
        block4: {
            void lexer$iv;
            void chars$iv;
            void outChars$iv;
            Lexer lexer = (Lexer)RsEscapesLexer.Companion.dummy$default(RsEscapesLexer.Companion, false, false, false, 7, null);
            String string = chars;
            StringBuilder stringBuilder = outChars;
            int[] sourceOffsets$iv = sourceOffsets;
            boolean $i$f$parseStringCharacters = false;
            int outOffset$iv = outChars$iv.length();
            int index$iv = 0;
            block0: for (Pair pair : org.rust.lang.core.lexer.UtilsKt.tokenize((CharSequence)chars$iv, (Lexer)lexer$iv)) {
                IElementType type$iv = (IElementType)pair.component1();
                String text$iv = (String)pair.component2();
                sourceOffsets$iv[outChars$iv.length() - outOffset$iv] = index$iv;
                sourceOffsets$iv[outChars$iv.length() - outOffset$iv + 1] = index$iv + 1;
                IElementType iElementType = type$iv;
                if (Intrinsics.areEqual((Object)iElementType, (Object)StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN)) {
                    void p0;
                    String string2 = text$iv;
                    void var18_19 = outChars$iv;
                    boolean bl2 = false;
                    var18_19.append(RsEscapesUtilsKt.decodeEscape((String)p0));
                    index$iv += text$iv.length();
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN) || Intrinsics.areEqual((Object)iElementType, (Object)StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN)) {
                    bl = false;
                    break block4;
                }
                int first$iv = outChars$iv.length() - outOffset$iv;
                outChars$iv.append(text$iv);
                int i$iv = first$iv;
                int last$iv = outChars$iv.length() - outOffset$iv - 1;
                if (i$iv > last$iv) continue;
                while (true) {
                    sourceOffsets$iv[i$iv] = index$iv++;
                    if (i$iv == last$iv) continue block0;
                    ++i$iv;
                }
            }
            sourceOffsets$iv[outChars$iv.length() - outOffset$iv] = index$iv;
            bl = true;
        }
        return bl;
    }

    private static final String decodeEscape(String esc) {
        return switch (esc) {
            case "\\n" -> "\n";
            case "\\r" -> "\r";
            case "\\t" -> "\t";
            case "\\0" -> "\u0000";
            case "\\\\" -> "\\";
            case "\\'" -> "'";
            case "\\\"" -> "\"";
            default -> {
                boolean $i$f$weakAssert = false;
                boolean $i$f$weakAssert = false;
                if (UtilsKt.isUnitTestMode() || UtilsKt.isInternal()) {
                    boolean $i$a$-weakAssert-RsEscapesUtilsKt$decodeEscape$1 = false;
                    if (!(esc.length() >= 2)) {
                        boolean $i$a$-weakAssert-UtilsKt$weakAssert$1$iv = false;
                        String message$iv$iv = "Assertion failed";
                        throw new AssertionError((Object)message$iv$iv);
                    }
                }
                $i$f$weakAssert = false;
                $i$f$weakAssert = false;
                if (UtilsKt.isUnitTestMode() || UtilsKt.isInternal()) {
                    boolean $i$a$-weakAssert-RsEscapesUtilsKt$decodeEscape$2 = false;
                    if (!(esc.charAt(0) == '\\')) {
                        boolean $i$a$-weakAssert-UtilsKt$weakAssert$1$iv = false;
                        String message$iv$iv = "Assertion failed";
                        throw new AssertionError((Object)message$iv$iv);
                    }
                }
                switch (esc.charAt(1)) {
                    case 'x': {
                        String v1 = esc.substring(2);
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"substring(...)");
                        yield String.valueOf((char)Integer.parseInt(v1, 16));
                    }
                    case 'u': {
                        void $this$filterTo$iv$iv;
                        String v2 = esc.substring(3, esc.length() - 1);
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"substring(...)");
                        String $this$filter$iv = v2;
                        boolean $i$f$filter = false;
                        CharSequence message$iv$iv = $this$filter$iv;
                        Appendable destination$iv$iv = new StringBuilder();
                        boolean $i$f$filterTo = false;
                        int var9_14 = $this$filterTo$iv$iv.length();
                        for (int index$iv$iv = 0; index$iv$iv < var9_14; ++index$iv$iv) {
                            char element$iv$iv;
                            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                            boolean $i$a$-filter-RsEscapesUtilsKt$decodeEscape$3 = false;
                            if (!(it != '_')) continue;
                            destination$iv$iv.append(element$iv$iv);
                        }
                        yield String.valueOf((char)Integer.parseInt(((StringBuilder)destination$iv$iv).toString(), 16));
                    }
                    case '\n': 
                    case '\r': {
                        yield "";
                    }
                }
                throw new IllegalStateException("unreachable".toString());
            }
        };
    }

    @NotNull
    public static final String escapeRust(@NotNull CharSequence $this$escapeRust, boolean escapeNonPrintable) {
        Intrinsics.checkNotNullParameter((Object)$this$escapeRust, (String)"<this>");
        StringBuilder sb = new StringBuilder($this$escapeRust.length());
        RsEscapesUtilsKt.escapeRust($this$escapeRust, sb, escapeNonPrintable);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String escapeRust$default(CharSequence charSequence, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return RsEscapesUtilsKt.escapeRust(charSequence, bl);
    }

    public static final void escapeRust(@NotNull CharSequence $this$escapeRust, @NotNull StringBuilder out, boolean escapeNonPrintable) {
        Intrinsics.checkNotNullParameter((Object)$this$escapeRust, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        for (int j = 0; j < $this$escapeRust.length(); ++j) {
            StringBuilder stringBuilder;
            char c = $this$escapeRust.charAt(j);
            if (c == '\n') {
                stringBuilder = out.append("\\n");
                continue;
            }
            if (c == '\r') {
                stringBuilder = out.append("\\r");
                continue;
            }
            if (c == '\t') {
                stringBuilder = out.append("\\t");
                continue;
            }
            if (c == '\u0000') {
                stringBuilder = out.append("\\0");
                continue;
            }
            if (c == '\'') {
                stringBuilder = out.append("\\'");
                continue;
            }
            if (c == '\"') {
                stringBuilder = out.append("\\\"");
                continue;
            }
            if (c == '\\') {
                stringBuilder = out.append("\\\\");
                continue;
            }
            if (escapeNonPrintable && !StringUtil.isPrintableUnicode((char)c)) {
                out.append("\\u{");
                out.append((int)c);
                stringBuilder = out.append("}");
                continue;
            }
            stringBuilder = out.append(c);
        }
    }

    public static /* synthetic */ void escapeRust$default(CharSequence charSequence, StringBuilder stringBuilder, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        RsEscapesUtilsKt.escapeRust(charSequence, stringBuilder, bl);
    }

    public static final void escapeRustRaw(@NotNull CharSequence $this$escapeRustRaw, @NotNull StringBuilder out, boolean escapeNonPrintable) {
        Intrinsics.checkNotNullParameter((Object)$this$escapeRustRaw, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        for (int j = 0; j < $this$escapeRustRaw.length(); ++j) {
            StringBuilder stringBuilder;
            char c = $this$escapeRustRaw.charAt(j);
            if (c == '\n') {
                stringBuilder = out.append("\n");
                continue;
            }
            if (c == '\r') {
                stringBuilder = out.append("\r");
                continue;
            }
            if (c == '\t') {
                stringBuilder = out.append("\t");
                continue;
            }
            if (c == '\u0000') {
                stringBuilder = out.append("\\0");
                continue;
            }
            if (escapeNonPrintable && !StringUtil.isPrintableUnicode((char)c)) {
                out.append("\\u{");
                out.append((int)c);
                stringBuilder = out.append("}");
                continue;
            }
            stringBuilder = out.append(c);
        }
    }

    public static /* synthetic */ void escapeRustRaw$default(CharSequence charSequence, StringBuilder stringBuilder, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        RsEscapesUtilsKt.escapeRustRaw(charSequence, stringBuilder, bl);
    }

    private static final CharSequence unescapeRust$lambda$0(Pair it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        IElementType type = (IElementType)it2.component1();
        String text = (String)it2.component2();
        return Intrinsics.areEqual((Object)type, (Object)StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN) ? (CharSequence)RsEscapesUtilsKt.decodeEscape(text) : (CharSequence)text;
    }
}

