/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.utils;

import com.intellij.util.containers.PeekableIterator;
import com.intellij.util.containers.PeekableIteratorWrapper;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.utils.RsDemanglerKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/rust/lang/utils/RsDemangler;", "", "<init>", "()V", "demangle", "Lorg/rust/lang/utils/RsDemangler$Demangle;", "name", "", "tryDemangle", "isRustHash", "", "text", "isSymbolLike", "isAsciiAlphanumeric", "ch", "", "isAsciiPunctuation", "RUST_HASH_RE", "Lkotlin/text/Regex;", "DOLLAR_TABLE", "", "Demangle", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsDemangler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsDemangler.kt\norg/rust/lang/utils/RsDemangler\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,301:1\n1069#2,2:302\n1069#2,2:306\n12980#3,2:304\n*S KotlinDebug\n*F\n+ 1 RsDemangler.kt\norg/rust/lang/utils/RsDemangler\n*L\n125#1:302,2\n216#1:306,2\n170#1:304,2\n*E\n"})
public final class RsDemangler {
    @NotNull
    public static final RsDemangler INSTANCE = new RsDemangler();
    @NotNull
    private static final Regex RUST_HASH_RE = new Regex("^h[0-9a-fA-F]*$");
    @NotNull
    private static final Map<String, String> DOLLAR_TABLE;

    private RsDemangler() {
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final Demangle demangle(@NotNull String name) {
        block20: {
            block21: {
                block19: {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    text = name;
                    llvm = ".llvm.";
                    llvmIndex = StringsKt.indexOf$default((CharSequence)text, (String)llvm, (int)0, (boolean)false, (int)6, null);
                    if (llvmIndex == -1) break block21;
                    candidate = StringsKt.drop((String)text, (int)(llvmIndex + llvm.length()));
                    $this$all$iv = candidate;
                    $i$f$all = false;
                    for (var9_11 = 0; var9_11 < $this$all$iv.length(); ++var9_11) {
                        ch = element$iv = $this$all$iv.charAt(var9_11);
                        $i$a$-all-RsDemangler$demangle$allHex$1 = false;
                        var13_18 = ch;
                        if (65 <= var13_18 ? var13_18 < 71 : false) ** GOTO lbl-1000
                        v0 = 48 <= var13_18 ? var13_18 < 58 : false;
                        if (v0 || var13_18 == 64) lbl-1000:
                        // 2 sources

                        {
                            v1 = true;
                        } else {
                            v1 = false;
                        }
                        if (v1) continue;
                        v2 = false;
                        break block19;
                    }
                    v2 = allHex = true;
                }
                if (allHex) {
                    text = StringsKt.take((String)text, (int)llvmIndex);
                }
            }
            suffix = "";
            eIndex = StringsKt.lastIndexOf$default((CharSequence)text, (String)"E.", (int)0, (boolean)false, (int)6, null);
            if (eIndex != -1) {
                head = StringsKt.take((String)text, (int)(eIndex + 1));
                tail = StringsKt.drop((String)text, (int)(eIndex + 1));
                if (this.isSymbolLike(tail)) {
                    text = head;
                    suffix = tail;
                }
            }
            isValid = true;
            inner = "";
            if (text.length() > 4 && StringsKt.startsWith$default((String)text, (String)"_ZN", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)text, (String)"E", (boolean)false, (int)2, null)) {
                inner = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)text, (CharSequence)"_ZN"), (CharSequence)"E");
            } else if (text.length() > 3 && StringsKt.startsWith$default((String)text, (String)"ZN", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)text, (String)"E", (boolean)false, (int)2, null)) {
                inner = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)text, (CharSequence)"ZN"), (CharSequence)"E");
            } else if (text.length() > 5 && StringsKt.startsWith$default((String)text, (String)"__ZN", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)text, (String)"E", (boolean)false, (int)2, null)) {
                inner = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)text, (CharSequence)"__ZN"), (CharSequence)"E");
            } else {
                isValid = false;
            }
            var9_12 = inner;
            v3 = var9_12.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getBytes(...)");
            $this$any$iv = v3;
            $i$f$any = false;
            var12_17 = $this$any$iv.length;
            for (ch = 0; ch < var12_17; ++ch) {
                byte = element$iv = $this$any$iv[ch];
                $i$a$-any-RsDemangler$demangle$1 = false;
                if (!((byte)(byte & -128) != 0)) continue;
                v4 = true;
                break block20;
            }
            v4 = false;
        }
        if (v4) {
            isValid = false;
        }
        elementsNum = 0;
        if (isValid) {
            charsIter = new PeekableIteratorWrapper((Iterator)StringsKt.iterator((CharSequence)inner));
            while (isValid) {
                count = RsDemanglerKt.access$parseInt((PeekableIterator)charsIter);
                if (count < 0) {
                    isValid = false;
                    break;
                }
                if (count == 0) {
                    isValid = charsIter.hasNext() == false;
                    break;
                }
                if (RsDemanglerKt.access$take((Iterator)charsIter, count).size() != count) {
                    isValid = false;
                    continue;
                }
                ++elementsNum;
            }
        }
        return new Demangle(text, inner, suffix, isValid, elementsNum);
    }

    @Nullable
    public final Demangle tryDemangle(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Demangle sym = this.demangle(name2);
        return sym.isValid() ? sym : null;
    }

    private final boolean isRustHash(String text) {
        CharSequence charSequence = text;
        return RUST_HASH_RE.matches(charSequence);
    }

    private final boolean isSymbolLike(String text) {
        boolean bl;
        block1: {
            CharSequence $this$all$iv = text;
            boolean $i$f$all = false;
            for (int j = 0; j < $this$all$iv.length(); ++j) {
                char element$iv;
                char it2 = element$iv = $this$all$iv.charAt(j);
                boolean bl2 = false;
                if (INSTANCE.isAsciiAlphanumeric(it2) || INSTANCE.isAsciiPunctuation(it2)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAsciiAlphanumeric(char ch) {
        boolean bl;
        boolean bl2;
        char c = ch;
        if ('A' <= c) {
            if (c < '[') {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        if ('a' <= c) {
            if (c < '{') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if ('0' > c) return false;
        if (c >= ':') return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAsciiPunctuation(char ch) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        char c = ch;
        if ('!' <= c) {
            if (c < '0') {
                return true;
            }
            bl3 = false;
        } else {
            bl3 = false;
        }
        if (bl3) return true;
        if (':' <= c) {
            if (c < 'A') {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        if ('[' <= c) {
            if (c < 'a') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if ('{' > c) return false;
        if (c >= '\u007f') return false;
        return true;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"$SP$", (Object)"@"), TuplesKt.to((Object)"$BP$", (Object)"*"), TuplesKt.to((Object)"$RF$", (Object)"&"), TuplesKt.to((Object)"$LT$", (Object)"<"), TuplesKt.to((Object)"$GT$", (Object)">"), TuplesKt.to((Object)"$LP$", (Object)"("), TuplesKt.to((Object)"$RP$", (Object)")"), TuplesKt.to((Object)"$C$", (Object)","), TuplesKt.to((Object)"$u7e$", (Object)"~"), TuplesKt.to((Object)"$u20$", (Object)" "), TuplesKt.to((Object)"$u27$", (Object)"'"), TuplesKt.to((Object)"$u3d$", (Object)"="), TuplesKt.to((Object)"$u5b$", (Object)"["), TuplesKt.to((Object)"$u5d$", (Object)"]"), TuplesKt.to((Object)"$u7b$", (Object)"{"), TuplesKt.to((Object)"$u7d$", (Object)"}"), TuplesKt.to((Object)"$u3b$", (Object)";"), TuplesKt.to((Object)"$u2b$", (Object)"+"), TuplesKt.to((Object)"$u21$", (Object)"!"), TuplesKt.to((Object)"$u22$", (Object)"\"")};
        DOLLAR_TABLE = MapsKt.hashMapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0016\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0013\u001a\u00020\u00032\b\b\u0002\u0010\u0014\u001a\u00020\u0007J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003J;\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\tH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lorg/rust/lang/utils/RsDemangler$Demangle;", "", "original", "", "inner", "suffix", "isValid", "", "elementsNum", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZI)V", "getOriginal", "()Ljava/lang/String;", "getInner", "getSuffix", "()Z", "getElementsNum", "()I", "format", "skipHash", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "toString", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nRsDemangler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsDemangler.kt\norg/rust/lang/utils/RsDemangler$Demangle\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,301:1\n158#2,6:302\n1#3:308\n*S KotlinDebug\n*F\n+ 1 RsDemangler.kt\norg/rust/lang/utils/RsDemangler$Demangle\n*L\n78#1:302,6\n*E\n"})
    public static final class Demangle {
        @NotNull
        private final String original;
        @NotNull
        private final String inner;
        @NotNull
        private final String suffix;
        private final boolean isValid;
        private final int elementsNum;

        public Demangle(@NotNull String original, @NotNull String inner, @NotNull String suffix, boolean isValid, int elementsNum) {
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            Intrinsics.checkNotNullParameter((Object)inner, (String)"inner");
            Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
            this.original = original;
            this.inner = inner;
            this.suffix = suffix;
            this.isValid = isValid;
            this.elementsNum = elementsNum;
        }

        @NotNull
        public final String getOriginal() {
            return this.original;
        }

        @NotNull
        public final String getInner() {
            return this.inner;
        }

        @NotNull
        public final String getSuffix() {
            return this.suffix;
        }

        public final boolean isValid() {
            return this.isValid;
        }

        public final int getElementsNum() {
            return this.elementsNum;
        }

        @NotNull
        public final String format(boolean skipHash) {
            StringBuilder stringBuilder;
            StringBuilder $this$format_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            if (!this.isValid) {
                return this.original;
            }
            String inner = this.inner;
            int n = this.elementsNum;
            block0: for (int elementIdx = 0; elementIdx < n; ++elementIdx) {
                PeekableIteratorWrapper innerIter = new PeekableIteratorWrapper((Iterator)StringsKt.iterator((CharSequence)inner));
                int i2 = RsDemanglerKt.access$parseInt((PeekableIterator)innerIter);
                String rest = null;
                rest = CollectionsKt.joinToString$default((Iterable)RsDemanglerKt.access$take((Iterator)innerIter, i2), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
                inner = CollectionsKt.joinToString$default((Iterable)RsDemanglerKt.access$toList((Iterator)innerIter), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
                if (skipHash && elementIdx + 1 == this.elementsNum && INSTANCE.isRustHash(rest)) break;
                if (elementIdx != 0) {
                    $this$format_u24lambda_u240.append("::");
                }
                if (StringsKt.startsWith$default((String)rest, (String)"_$", (boolean)false, (int)2, null)) {
                    rest = StringsKt.drop((String)rest, (int)1);
                }
                block1: while (((CharSequence)rest).length() > 0) {
                    int n2;
                    block11: {
                        if (StringsKt.startsWith$default((String)rest, (String)".", (boolean)false, (int)2, null)) {
                            String string;
                            if (StringsKt.startsWith$default((String)rest, (String)"", (boolean)false, (int)2, null)) {
                                $this$format_u24lambda_u240.append("::");
                                string = StringsKt.drop((String)rest, (int)2);
                            } else {
                                $this$format_u24lambda_u240.append(".");
                                string = StringsKt.drop((String)rest, (int)1);
                            }
                            rest = string;
                            continue;
                        }
                        if (StringsKt.startsWith$default((String)rest, (String)"$", (boolean)false, (int)2, null)) {
                            for (Map.Entry entry2 : DOLLAR_TABLE.entrySet()) {
                                String pat = (String)entry2.getKey();
                                String demangled = (String)entry2.getValue();
                                if (!StringsKt.startsWith$default((String)rest, (String)pat, (boolean)false, (int)2, null)) continue;
                                $this$format_u24lambda_u240.append(demangled);
                                rest = StringsKt.removePrefix((String)rest, (CharSequence)pat);
                                continue block1;
                            }
                            $this$format_u24lambda_u240.append(rest);
                            continue block0;
                        }
                        CharSequence $this$indexOfFirst$iv = rest;
                        boolean $i$f$indexOfFirst = false;
                        int n3 = $this$indexOfFirst$iv.length();
                        for (int index$iv = 0; index$iv < n3; ++index$iv) {
                            char ch = $this$indexOfFirst$iv.charAt(index$iv);
                            boolean bl2 = false;
                            if (!(ch == '$' || ch == '.')) continue;
                            n2 = index$iv;
                            break block11;
                        }
                        n2 = -1;
                    }
                    int it2 = n2;
                    boolean bl3 = false;
                    int idx = it2 == -1 ? rest.length() : it2;
                    $this$format_u24lambda_u240.append(StringsKt.take((String)rest, (int)idx));
                    rest = StringsKt.drop((String)rest, (int)idx);
                }
            }
            $this$format_u24lambda_u240.append(this.suffix);
            return stringBuilder.toString();
        }

        public static /* synthetic */ String format$default(Demangle demangle, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            return demangle.format(bl);
        }

        @NotNull
        public final String component1() {
            return this.original;
        }

        @NotNull
        public final String component2() {
            return this.inner;
        }

        @NotNull
        public final String component3() {
            return this.suffix;
        }

        public final boolean component4() {
            return this.isValid;
        }

        public final int component5() {
            return this.elementsNum;
        }

        @NotNull
        public final Demangle copy(@NotNull String original, @NotNull String inner, @NotNull String suffix, boolean isValid, int elementsNum) {
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            Intrinsics.checkNotNullParameter((Object)inner, (String)"inner");
            Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
            return new Demangle(original, inner, suffix, isValid, elementsNum);
        }

        public static /* synthetic */ Demangle copy$default(Demangle demangle, String string, String string2, String string3, boolean bl, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = demangle.original;
            }
            if ((n2 & 2) != 0) {
                string2 = demangle.inner;
            }
            if ((n2 & 4) != 0) {
                string3 = demangle.suffix;
            }
            if ((n2 & 8) != 0) {
                bl = demangle.isValid;
            }
            if ((n2 & 0x10) != 0) {
                n = demangle.elementsNum;
            }
            return demangle.copy(string, string2, string3, bl, n);
        }

        @NotNull
        public String toString() {
            return "Demangle(original=" + this.original + ", inner=" + this.inner + ", suffix=" + this.suffix + ", isValid=" + this.isValid + ", elementsNum=" + this.elementsNum + ")";
        }

        public int hashCode() {
            int result2 = this.original.hashCode();
            result2 = result2 * 31 + this.inner.hashCode();
            result2 = result2 * 31 + this.suffix.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isValid);
            result2 = result2 * 31 + Integer.hashCode(this.elementsNum);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Demangle)) {
                return false;
            }
            Demangle demangle = (Demangle)other;
            if (!Intrinsics.areEqual((Object)this.original, (Object)demangle.original)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.inner, (Object)demangle.inner)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.suffix, (Object)demangle.suffix)) {
                return false;
            }
            if (this.isValid != demangle.isValid) {
                return false;
            }
            return this.elementsNum == demangle.elementsNum;
        }
    }
}

