/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.utils.Direction;
import org.rust.lang.utils.Edge;
import org.rust.lang.utils.Node;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B?\u0012\u001a\b\u0002\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00060\u0005\u0012\u001a\b\u0002\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b0\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00062\u0006\u0010\u0014\u001a\u00020\fJ\u001f\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00062\u0006\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017JG\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00062\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00062\u0006\u0010\u0016\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001bJ/\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001eJ,\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b0 2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006J,\u0010!\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b0 2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006J6\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b0 2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00062\u0006\u0010$\u001a\u00020%H\u0002J&\u0010&\u001a\u00020'2\u001e\u0010(\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0004\u0012\u00020'0)J&\u0010*\u001a\u00020'2\u001e\u0010(\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0004\u0012\u00020'0)JX\u0010+\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00060 2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00062\b\b\u0002\u0010$\u001a\u00020%2 \b\u0002\u0010-\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0004\u0012\u00020.0)J6\u0010/\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006002\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00062\b\b\u0002\u0010$\u001a\u00020%R \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000e\u00a8\u00062"}, d2={"Lorg/rust/lang/utils/Graph;", "N", "E", "", "nodes", "", "Lorg/rust/lang/utils/Node;", "edges", "Lorg/rust/lang/utils/Edge;", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "nextNodeIndex", "", "getNextNodeIndex", "()I", "nextEdgeIndex", "getNextEdgeIndex", "nodesCount", "getNodesCount", "getNode", "index", "addNode", "data", "(Ljava/lang/Object;)Lorg/rust/lang/utils/Node;", "addEdge", "source", "target", "(Lorg/rust/lang/utils/Node;Lorg/rust/lang/utils/Node;Ljava/lang/Object;)Lorg/rust/lang/utils/Edge;", "sourceIndex", "targetIndex", "(IILjava/lang/Object;)Lorg/rust/lang/utils/Edge;", "outgoingEdges", "Lkotlin/sequences/Sequence;", "incomingEdges", "incidentEdges", "node", "direction", "Lorg/rust/lang/utils/Direction;", "forEachNode", "", "f", "Lkotlin/Function1;", "forEachEdge", "depthFirstTraversal", "startNode", "edgeFilter", "", "nodesInPostOrder", "", "entryNode", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Graph.kt\norg/rust/lang/utils/Graph\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,179:1\n1869#2,2:180\n1869#2,2:182\n1321#3,2:184\n*S KotlinDebug\n*F\n+ 1 Graph.kt\norg/rust/lang/utils/Graph\n*L\n66#1:180,2\n69#1:182,2\n87#1:184,2\n*E\n"})
public class Graph<N, E> {
    @NotNull
    private final List<Node<N, E>> nodes;
    @NotNull
    private final List<Edge<N, E>> edges;

    public Graph(@NotNull List<Node<N, E>> nodes, @NotNull List<Edge<N, E>> edges) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Intrinsics.checkNotNullParameter(edges, (String)"edges");
        this.nodes = nodes;
        this.edges = edges;
    }

    public /* synthetic */ Graph(List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = new ArrayList();
        }
        if ((n & 2) != 0) {
            list2 = new ArrayList();
        }
        this(list, list2);
    }

    private final int getNextNodeIndex() {
        return this.nodes.size();
    }

    private final int getNextEdgeIndex() {
        return this.edges.size();
    }

    public final int getNodesCount() {
        return this.nodes.size();
    }

    @NotNull
    public final Node<N, E> getNode(int index) {
        return this.nodes.get(index);
    }

    @NotNull
    public final Node<N, E> addNode(N data2) {
        Node newNode = new Node(data2, this.getNextNodeIndex(), null, null, 12, null);
        this.nodes.add(newNode);
        return newNode;
    }

    @NotNull
    public final Edge<N, E> addEdge(@NotNull Node<N, E> source, @NotNull Node<N, E> target, E data2) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Intrinsics.checkNotNullParameter(target, (String)"target");
        Edge<N, E> sourceFirst = source.getFirstOutEdge();
        Edge<N, E> targetFirst = target.getFirstInEdge();
        Edge<N, E> newEdge = new Edge<N, E>(source, target, data2, this.getNextEdgeIndex(), sourceFirst, targetFirst);
        this.edges.add(newEdge);
        source.setFirstOutEdge(newEdge);
        target.setFirstInEdge(newEdge);
        return newEdge;
    }

    @NotNull
    public final Edge<N, E> addEdge(int sourceIndex, int targetIndex, E data2) {
        Node<N, E> source = this.nodes.get(sourceIndex);
        Node<N, E> target = this.nodes.get(targetIndex);
        return this.addEdge(source, target, data2);
    }

    @NotNull
    public final Sequence<Edge<N, E>> outgoingEdges(@NotNull Node<N, E> source) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        return SequencesKt.generateSequence(source.getFirstOutEdge(), Graph::outgoingEdges$lambda$0);
    }

    @NotNull
    public final Sequence<Edge<N, E>> incomingEdges(@NotNull Node<N, E> target) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        return SequencesKt.generateSequence(target.getFirstInEdge(), Graph::incomingEdges$lambda$0);
    }

    private final Sequence<Edge<N, E>> incidentEdges(Node<N, E> node, Direction direction) {
        return switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> this.outgoingEdges(node);
            case 2 -> this.incomingEdges(node);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final void forEachNode(@NotNull Function1<? super Node<N, E>, Unit> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        Iterable $this$forEach$iv = this.nodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it2 = (Node)element$iv;
            boolean bl = false;
            f.invoke((Object)it2);
        }
    }

    public final void forEachEdge(@NotNull Function1<? super Edge<N, E>, Unit> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        Iterable $this$forEach$iv = this.edges;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Edge it2 = (Edge)element$iv;
            boolean bl = false;
            f.invoke((Object)it2);
        }
    }

    @NotNull
    public final Sequence<Node<N, E>> depthFirstTraversal(@NotNull Node<N, E> startNode, @NotNull Direction direction, @NotNull Function1<? super Edge<N, E>, Boolean> edgeFilter) {
        Intrinsics.checkNotNullParameter(startNode, (String)"startNode");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        Intrinsics.checkNotNullParameter(edgeFilter, (String)"edgeFilter");
        Object[] objectArray = new Node[]{startNode};
        Set visited = SetsKt.mutableSetOf((Object[])objectArray);
        ArrayDeque<Node<N, E>> stack = new ArrayDeque<Node<N, E>>();
        stack.push(startNode);
        Function1 visit = arg_0 -> Graph.depthFirstTraversal$lambda$1(visited, stack, arg_0);
        return SequencesKt.generateSequence(() -> Graph.depthFirstTraversal$lambda$2(stack, this, direction, edgeFilter, visit));
    }

    public static /* synthetic */ Sequence depthFirstTraversal$default(Graph graph, Node node, Direction direction, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: depthFirstTraversal");
        }
        if ((n & 2) != 0) {
            direction = Direction.OUTGOING;
        }
        if ((n & 4) != 0) {
            function1 = Graph::depthFirstTraversal$lambda$0;
        }
        return graph.depthFirstTraversal(node, direction, function1);
    }

    @NotNull
    public final List<Node<N, E>> nodesInPostOrder(@NotNull Node<N, E> entryNode, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter(entryNode, (String)"entryNode");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        Set visited = new LinkedHashSet();
        ArrayDeque<Pair> stack = new ArrayDeque<Pair>();
        List result2 = new ArrayList();
        Function1 pushNode = arg_0 -> Graph.nodesInPostOrder$lambda$0(visited, stack, this, direction, arg_0);
        List nodesWithEntry = CollectionsKt.plus((Collection)CollectionsKt.listOf(entryNode), (Iterable)this.nodes);
        for (Node nextNode : nodesWithEntry) {
            pushNode.invoke((Object)nextNode);
            while (!((Collection)stack).isEmpty()) {
                Pair pair = (Pair)stack.pop();
                Node node = (Node)pair.component1();
                Iterator iter = (Iterator)pair.component2();
                Edge child = (Edge)org.rust.stdext.CollectionsKt.nextOrNull(iter);
                if (child != null) {
                    Node incident = child.incidentNode(direction);
                    stack.push(new Pair((Object)node, (Object)iter));
                    pushNode.invoke(incident);
                    continue;
                }
                result2.add(node);
            }
        }
        return result2;
    }

    public static /* synthetic */ List nodesInPostOrder$default(Graph graph, Node node, Direction direction, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: nodesInPostOrder");
        }
        if ((n & 2) != 0) {
            direction = Direction.OUTGOING;
        }
        return graph.nodesInPostOrder(node, direction);
    }

    private static final Edge outgoingEdges$lambda$0(Edge it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2.getNextSourceEdge();
    }

    private static final Edge incomingEdges$lambda$0(Edge it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2.getNextTargetEdge();
    }

    private static final boolean depthFirstTraversal$lambda$0(Edge it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return true;
    }

    private static final Unit depthFirstTraversal$lambda$1(Set $visited, ArrayDeque $stack, Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if ($visited.add(node)) {
            $stack.push(node);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Node depthFirstTraversal$lambda$2(ArrayDeque $stack, Graph this$0, Direction $direction, Function1 $edgeFilter, Function1 $visit) {
        Node next = (Node)$stack.poll();
        if (next != null) {
            void $this$forEach$iv;
            Sequence sequence2 = SequencesKt.filter(this$0.incidentEdges(next, $direction), (Function1)$edgeFilter);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Edge edge = (Edge)element$iv;
                boolean bl = false;
                Node incident = edge.incidentNode($direction);
                $visit.invoke(incident);
            }
        }
        return next;
    }

    private static final Unit nodesInPostOrder$lambda$0(Set $visited, ArrayDeque $stack, Graph this$0, Direction $direction, Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if ($visited.add(node)) {
            $stack.push(new Pair((Object)node, (Object)this$0.incidentEdges(node, $direction).iterator()));
        }
        return Unit.INSTANCE;
    }

    public Graph() {
        this(null, null, 3, null);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.OUTGOING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.INCOMING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

