/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.doc.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.SimpleMultiLineTextEscaper;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;
import org.rust.lang.doc.psi.RsDocCodeFence;
import org.rust.lang.doc.psi.RsDocCodeFenceLang;
import org.rust.lang.doc.psi.RsDocCodeFenceStartEnd;
import org.rust.lang.doc.psi.RsDocKind;
import org.rust.lang.doc.psi.impl.RsDocElementImpl;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00000\u0018H\u0016R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lorg/rust/lang/doc/psi/impl/RsDocCodeFenceImpl;", "Lorg/rust/lang/doc/psi/impl/RsDocElementImpl;", "Lorg/rust/lang/doc/psi/RsDocCodeFence;", "type", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "isValidHost", "", "start", "Lorg/rust/lang/doc/psi/RsDocCodeFenceStartEnd;", "getStart", "()Lorg/rust/lang/doc/psi/RsDocCodeFenceStartEnd;", "end", "getEnd", "lang", "Lorg/rust/lang/doc/psi/RsDocCodeFenceLang;", "getLang", "()Lorg/rust/lang/doc/psi/RsDocCodeFenceLang;", "updateText", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "text", "", "createLiteralTextEscaper", "Lcom/intellij/psi/LiteralTextEscaper;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nPsi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Psi.kt\norg/rust/lang/doc/psi/impl/RsDocCodeFenceImpl\n+ 2 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n*L\n1#1,180:1\n28#2:181\n31#2:182\n28#2:183\n*S KotlinDebug\n*F\n+ 1 Psi.kt\norg/rust/lang/doc/psi/impl/RsDocCodeFenceImpl\n*L\n87#1:181\n90#1:182\n93#1:183\n*E\n"})
public final class RsDocCodeFenceImpl
extends RsDocElementImpl
implements RsDocCodeFence {
    public RsDocCodeFenceImpl(@NotNull IElementType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        super(type);
    }

    public boolean isValidHost() {
        return true;
    }

    @Override
    @NotNull
    public RsDocCodeFenceStartEnd getStart() {
        PsiElement $this$childOfType$iv = this;
        boolean $i$f$childOfType = false;
        return (RsDocCodeFenceStartEnd)this.notNullChild(PsiTreeUtil.getChildOfType((PsiElement)$this$childOfType$iv, RsDocCodeFenceStartEnd.class));
    }

    @Override
    @Nullable
    public RsDocCodeFenceStartEnd getEnd() {
        PsiElement $this$childrenOfType$iv = this;
        boolean $i$f$childrenOfType = false;
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, RsDocCodeFenceStartEnd.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenOfTypeAsList(...)");
        return (RsDocCodeFenceStartEnd)CollectionsKt.getOrNull((List)list, (int)1);
    }

    @Override
    @Nullable
    public RsDocCodeFenceLang getLang() {
        PsiElement $this$childOfType$iv = this;
        boolean $i$f$childOfType = false;
        return (RsDocCodeFenceLang)PsiTreeUtil.getChildOfType((PsiElement)$this$childOfType$iv, RsDocCodeFenceLang.class);
    }

    @NotNull
    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        RsDocKind docKind = RsDocKind.Companion.of(PsiElementExtensionsKt.getElementType(this.getContainingDoc()));
        String infix = docKind.getInfix();
        PsiElement prevSibling = PsiElementExtensionsKt.getPrevNonWhitespaceSibling(this);
        StringBuilder newText = new StringBuilder();
        if (prevSibling != null && !Intrinsics.areEqual((Object)prevSibling.getText(), (Object)docKind.getPrefix())) {
            newText.append(docKind.getPrefix());
            PsiElement prevPrevSibling = prevSibling.getPrevSibling();
            StringBuilder stringBuilder = prevPrevSibling instanceof PsiWhiteSpace ? newText.append(((PsiWhiteSpace)prevPrevSibling).getText()) : newText.append("\n");
        }
        newText.append(docKind.getInfix());
        if (prevSibling != null && !Intrinsics.areEqual((Object)prevSibling.getNextSibling(), (Object)this)) {
            newText.append(prevSibling.getNextSibling().getText());
        }
        String prevIndent = "";
        int index = 0;
        while (index < text.length()) {
            boolean isStartCorrect;
            int linebreakIndex = StringsKt.indexOf$default((CharSequence)text, (String)"\n", (int)index, (boolean)false, (int)4, null);
            if (linebreakIndex == -1) {
                newText.append(text, index, text.length());
                break;
            }
            int nextLineStart = linebreakIndex + 1;
            newText.append(text, index, nextLineStart);
            index = nextLineStart;
            int firstNonWhitespace = CharArrayUtil.shiftForward((CharSequence)text, (int)nextLineStart, (String)" \t");
            if (firstNonWhitespace == text.length()) continue;
            boolean bl = isStartCorrect = StringsKt.startsWith$default((String)text, (String)infix, (int)firstNonWhitespace, (boolean)false, (int)4, null) || docKind.isBlock() && StringsKt.startsWith$default((String)text, (String)"*/", (int)firstNonWhitespace, (boolean)false, (int)4, null);
            if (!isStartCorrect) {
                newText.append(prevIndent);
                newText.append(infix);
                newText.append(" ");
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)text.substring(nextLineStart, firstNonWhitespace), (String)"substring(...)");
        }
        if (docKind.isBlock() && !StringsKt.endsWith$default((CharSequence)newText, (CharSequence)"*/", (boolean)false, (int)2, null)) {
            newText.append("\n*/");
        }
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RsFile fromText = new RsPsiFactory(project, true, false, 4, null).createFile(newText);
        RsDocCodeFenceImpl rsDocCodeFenceImpl = (RsDocCodeFenceImpl)PsiTreeUtil.findChildOfType((PsiElement)fromText, this.getClass(), (boolean)false);
        if (rsDocCodeFenceImpl == null) {
            throw new IllegalStateException(((Object)newText).toString());
        }
        RsDocCodeFenceImpl newElement = rsDocCodeFenceImpl;
        PsiElement psiElement2 = this.replace(newElement);
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.rust.lang.doc.psi.impl.RsDocCodeFenceImpl");
        return (RsDocCodeFenceImpl)psiElement2;
    }

    @NotNull
    public LiteralTextEscaper<RsDocCodeFenceImpl> createLiteralTextEscaper() {
        return new SimpleMultiLineTextEscaper<PsiLanguageInjectionHost>(this);
    }
}

