/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.doc.psi;

import com.intellij.openapi.util.TextRange;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.doc.psi.Piece;
import org.rust.lang.doc.psi.PieceKind;
import org.rust.lang.doc.psi.RsDocCommentElementTypeKt;
import org.rust.lang.doc.psi.RsDocKind;
import org.rust.lang.doc.psi.RsDocLine;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J0\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00122\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00180\u001cH\u0086\b\u00f8\u0001\u0000J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0016\u001a\u00020\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001f"}, d2={"Lorg/rust/lang/doc/psi/RsDocTextMap;", "", "originalText", "", "mappedText", "", "offsetMap", "", "pieces", "", "Lorg/rust/lang/doc/psi/Piece;", "<init>", "(Ljava/lang/CharSequence;Ljava/lang/String;[ILjava/util/List;)V", "getOriginalText", "()Ljava/lang/CharSequence;", "getMappedText", "()Ljava/lang/String;", "mapOffsetFromMarkdownToRust", "", "offset", "mapTextRangeFromMarkdownToRust", "Lcom/intellij/openapi/util/TextRange;", "range", "processPiecesInRange", "", "startOffset", "endOffset", "processor", "Lkotlin/Function1;", "mapFully", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsDocCommentElementType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsDocCommentElementType.kt\norg/rust/lang/doc/psi/RsDocTextMap\n*L\n1#1,262:1\n156#1,9:263\n*S KotlinDebug\n*F\n+ 1 RsDocCommentElementType.kt\norg/rust/lang/doc/psi/RsDocTextMap\n*L\n167#1:263,9\n*E\n"})
final class RsDocTextMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CharSequence originalText;
    @NotNull
    private final String mappedText;
    @NotNull
    private final int[] offsetMap;
    @NotNull
    private final List<Piece> pieces;

    public RsDocTextMap(@NotNull CharSequence originalText, @NotNull String mappedText, @NotNull int[] offsetMap, @NotNull List<Piece> pieces) {
        Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
        Intrinsics.checkNotNullParameter((Object)mappedText, (String)"mappedText");
        Intrinsics.checkNotNullParameter((Object)offsetMap, (String)"offsetMap");
        Intrinsics.checkNotNullParameter(pieces, (String)"pieces");
        this.originalText = originalText;
        this.mappedText = mappedText;
        this.offsetMap = offsetMap;
        this.pieces = pieces;
    }

    @NotNull
    public final CharSequence getOriginalText() {
        return this.originalText;
    }

    @NotNull
    public final String getMappedText() {
        return this.mappedText;
    }

    public final int mapOffsetFromMarkdownToRust(int offset) {
        return this.offsetMap[offset];
    }

    @NotNull
    public final TextRange mapTextRangeFromMarkdownToRust(@NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return new TextRange(this.mapOffsetFromMarkdownToRust(range.getStartOffset()), this.mapOffsetFromMarkdownToRust(range.getEndOffset()));
    }

    public final void processPiecesInRange(int startOffset, int endOffset, @NotNull Function1<? super Piece, Unit> processor2) {
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        boolean $i$f$processPiecesInRange = false;
        int offset = 0;
        for (Piece p : this.pieces) {
            int pieceEndOffset = offset + p.getStr().length();
            if (startOffset < pieceEndOffset && endOffset - offset > 0) {
                processor2.invoke((Object)RsDocCommentElementTypeKt.access$cut(p, startOffset - offset, endOffset - offset));
            }
            offset += p.getStr().length();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final CharSequence mapFully(@NotNull TextRange range) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        RsDocTextMap rsDocTextMap = this;
        int n = range.getStartOffset();
        int endOffset$iv = range.getEndOffset();
        boolean $i$f$processPiecesInRange = false;
        int offset$iv = 0;
        for (Piece p$iv : ((RsDocTextMap)this_$iv).pieces) {
            void startOffset$iv;
            int pieceEndOffset$iv = offset$iv + p$iv.getStr().length();
            if (startOffset$iv < pieceEndOffset$iv && endOffset$iv - offset$iv > 0) {
                Piece it2 = RsDocCommentElementTypeKt.access$cut(p$iv, (int)(startOffset$iv - offset$iv), endOffset$iv - offset$iv);
                boolean bl = false;
                return it2.getKind() == PieceKind.TEXT && it2.getStr().length() == range.getLength() ? it2.getStr() : null;
            }
            offset$iv += p$iv.getStr().length();
        }
        return null;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\n\u001a\u00020\u000b*\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u001a\u0010\u000f\u001a\u00020\u000b*\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/rust/lang/doc/psi/RsDocTextMap$Companion;", "", "<init>", "()V", "new", "Lorg/rust/lang/doc/psi/RsDocTextMap;", "text", "", "kind", "Lorg/rust/lang/doc/psi/RsDocKind;", "mergeOrAddGapWithWS", "", "", "Lorg/rust/lang/doc/psi/Piece;", "str", "mergeOrAddWS", "gap", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nRsDocCommentElementType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsDocCommentElementType.kt\norg/rust/lang/doc/psi/RsDocTextMap$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,262:1\n1740#2,3:263\n*S KotlinDebug\n*F\n+ 1 RsDocCommentElementType.kt\norg/rust/lang/doc/psi/RsDocTextMap$Companion\n*L\n220#1:263,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RsDocTextMap new(@NotNull CharSequence text, @NotNull RsDocKind kind2) {
            boolean bl;
            int[] map2;
            StringBuilder mappedText;
            List pieces;
            block12: {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)((Object)kind2), (String)"kind");
                pieces = new ArrayList();
                mappedText = new StringBuilder();
                map2 = new int[text.length() + 1];
                int textPosition = 0;
                for (RsDocLine line : kind2.removeDecorationToLines(text)) {
                    boolean hasLineBreak;
                    if (line.getHasPrefix()) {
                        CharSequence prefix = line.getPrefix();
                        textPosition += prefix.length();
                        this.mergeOrAddGapWithWS(pieces, prefix);
                    }
                    if (line.getHasContent()) {
                        CharSequence content = line.getContent();
                        int n = content.length();
                        for (int i2 = 0; i2 < n; ++i2) {
                            map2[mappedText.length() + i2] = textPosition + i2;
                        }
                        map2[mappedText.length() + content.length()] = textPosition + content.length();
                        textPosition += content.length();
                        mappedText.append(content);
                        ((Collection)pieces).add(new Piece(content, PieceKind.TEXT));
                    }
                    boolean bl2 = hasLineBreak = !line.isLastLine() && !line.getHasSuffix();
                    if (hasLineBreak) {
                        if (!line.isRemoved()) {
                            map2[mappedText.length()] = textPosition;
                            map2[mappedText.length() + 1] = textPosition + 1;
                            mappedText.append("\n");
                        }
                        ++textPosition;
                        this.mergeOrAddWS(pieces, "\n");
                    }
                    if (!line.getHasSuffix()) continue;
                    CharSequence suffix = line.getSuffix();
                    textPosition += suffix.length();
                    this.mergeOrAddGapWithWS(pieces, suffix);
                }
                if (!(mappedText.length() <= text.length())) {
                    throw new IllegalStateException("Check failed.");
                }
                if (!(mappedText.length() < map2.length)) {
                    throw new IllegalStateException("Check failed.");
                }
                Iterable $this$all$iv = (Iterable)StringsKt.getIndices((CharSequence)mappedText);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator iterator2 = $this$all$iv.iterator();
                    while (iterator2.hasNext()) {
                        int element$iv;
                        int it2 = element$iv = ((IntIterator)iterator2).nextInt();
                        boolean bl3 = false;
                        if (map2[it2 + 1] > map2[it2]) continue;
                        bl = false;
                        break block12;
                    }
                    bl = true;
                }
            }
            if (!bl) {
                throw new IllegalStateException("Check failed.");
            }
            String string = mappedText.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return new RsDocTextMap(text, string, map2, pieces);
        }

        private final void mergeOrAddGapWithWS(List<Piece> $this$mergeOrAddGapWithWS, CharSequence str) {
            int gapStart = CharArrayUtil.shiftForward((CharSequence)str, (int)0, (String)"\n\t ");
            if (gapStart != 0) {
                this.mergeOrAddWS($this$mergeOrAddGapWithWS, str.subSequence(0, gapStart));
            }
            if (gapStart != str.length()) {
                int gapEnd = CharArrayUtil.shiftBackward((CharSequence)str, (int)gapStart, (int)StringsKt.getLastIndex((CharSequence)str), (String)"\n\t ") + 1;
                CharSequence gapText = str.subSequence(gapStart, gapEnd);
                if (!(gapText.length() > 0)) {
                    throw new IllegalStateException("Check failed.");
                }
                ((Collection)$this$mergeOrAddGapWithWS).add(new Piece(gapText, PieceKind.GAP));
                if (gapEnd != str.length()) {
                    this.mergeOrAddWS($this$mergeOrAddGapWithWS, str.subSequence(gapEnd, str.length()));
                }
            }
        }

        private final void mergeOrAddWS(List<Piece> $this$mergeOrAddWS, CharSequence gap) {
            Piece piece = (Piece)CollectionsKt.lastOrNull($this$mergeOrAddWS);
            if ((piece != null ? piece.getKind() : null) == PieceKind.WHITESPACE) {
                $this$mergeOrAddWS.set(CollectionsKt.getLastIndex($this$mergeOrAddWS), new Piece("" + $this$mergeOrAddWS.get(CollectionsKt.getLastIndex($this$mergeOrAddWS)).getStr() + gap, PieceKind.WHITESPACE));
            } else {
                ((Collection)$this$mergeOrAddWS).add(new Piece(gap, PieceKind.WHITESPACE));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

