/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.doc.psi;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.LeafASTNode;
import org.intellij.markdown.parser.LinkMap;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.doc.psi.Piece;
import org.rust.lang.doc.psi.PieceKind;
import org.rust.lang.doc.psi.RsDocCommentElementTypeKt;
import org.rust.lang.doc.psi.RsDocCompositeTokenType;
import org.rust.lang.doc.psi.RsDocElementTypes;
import org.rust.lang.doc.psi.RsDocLinkDestination;
import org.rust.lang.doc.psi.RsDocLinkDestinationParser;
import org.rust.lang.doc.psi.RsDocLinkReferenceShort;
import org.rust.lang.doc.psi.RsDocTextMap;
import org.rust.lang.doc.psi.impl.RsDocGapImpl;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J\u001c\u0010\u0019\u001a\u00020\r*\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u0014\u0010\u0019\u001a\u00020\r*\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/rust/lang/doc/psi/RsDocMarkdownAstBuilder;", "", "textMap", "Lorg/rust/lang/doc/psi/RsDocTextMap;", "charTable", "Lcom/intellij/util/CharTable;", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "<init>", "(Lorg/rust/lang/doc/psi/RsDocTextMap;Lcom/intellij/util/CharTable;Lorg/intellij/markdown/parser/LinkMap;)V", "prevNodeEnd", "", "buildTree", "", "root", "Lcom/intellij/psi/impl/source/tree/CompositeElement;", "markdownRoot", "Lorg/intellij/markdown/ast/ASTNode;", "visitNode", "parent", "markdownNode", "visitChildren", "node", "tryParseShortDocLinkAsRsPath", "", "insertLeaves", "startOffset", "endOffset", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsDocCommentElementType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsDocCommentElementType.kt\norg/rust/lang/doc/psi/RsDocMarkdownAstBuilder\n+ 2 RsDocCommentElementType.kt\norg/rust/lang/doc/psi/RsDocTextMap\n*L\n1#1,262:1\n156#2,9:263\n*S KotlinDebug\n*F\n+ 1 RsDocCommentElementType.kt\norg/rust/lang/doc/psi/RsDocMarkdownAstBuilder\n*L\n122#1:263,9\n*E\n"})
final class RsDocMarkdownAstBuilder {
    @NotNull
    private final RsDocTextMap textMap;
    @NotNull
    private final CharTable charTable;
    @NotNull
    private final LinkMap linkMap;
    private int prevNodeEnd;

    public RsDocMarkdownAstBuilder(@NotNull RsDocTextMap textMap, @NotNull CharTable charTable, @NotNull LinkMap linkMap) {
        Intrinsics.checkNotNullParameter((Object)textMap, (String)"textMap");
        Intrinsics.checkNotNullParameter((Object)charTable, (String)"charTable");
        Intrinsics.checkNotNullParameter((Object)linkMap, (String)"linkMap");
        this.textMap = textMap;
        this.charTable = charTable;
        this.linkMap = linkMap;
    }

    public final void buildTree(@NotNull CompositeElement root, @NotNull ASTNode markdownRoot) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)markdownRoot, (String)"markdownRoot");
        for (ASTNode markdownChild : markdownRoot.getChildren()) {
            this.visitNode(root, markdownChild);
        }
        if (this.prevNodeEnd < this.textMap.getOriginalText().length()) {
            this.insertLeaves(root, this.prevNodeEnd, this.textMap.getOriginalText().length());
        }
    }

    private final void visitNode(CompositeElement parent2, ASTNode markdownNode) {
        RsDocCompositeTokenType type = RsDocElementTypes.INSTANCE.mapMarkdownToRust(markdownNode.getType());
        if (type == null) {
            if (!(markdownNode instanceof LeafASTNode)) {
                this.visitChildren(parent2, markdownNode);
            }
            return;
        }
        this.insertLeaves(parent2, markdownNode.getStartOffset());
        CompositeElement node = type.createCompositeNode();
        parent2.rawAddChildrenWithoutNotifications((TreeElement)node);
        this.visitChildren(node, markdownNode);
        this.insertLeaves(node, markdownNode.getEndOffset());
    }

    private final void visitChildren(CompositeElement node, ASTNode markdownNode) {
        TextRange textRangeMapped;
        CharSequence mappedText;
        if (node instanceof RsDocLinkDestination && (mappedText = this.textMap.mapFully(textRangeMapped = this.textMap.mapTextRangeFromMarkdownToRust(RsDocCommentElementTypeKt.access$getTextRange(markdownNode)))) != null) {
            node.rawAddChildrenWithoutNotifications(RsDocLinkDestinationParser.INSTANCE.parse(mappedText, this.charTable));
            this.prevNodeEnd = textRangeMapped.getEndOffset();
            return;
        }
        if (node instanceof RsDocLinkReferenceShort && this.tryParseShortDocLinkAsRsPath(node, markdownNode)) {
            return;
        }
        for (ASTNode markdownChild : markdownNode.getChildren()) {
            this.visitNode(node, markdownChild);
        }
    }

    private final boolean tryParseShortDocLinkAsRsPath(CompositeElement node, ASTNode markdownNode) {
        TextRange textRangeMapped = this.textMap.mapTextRangeFromMarkdownToRust(RsDocCommentElementTypeKt.access$getTextRange(markdownNode));
        CharSequence charSequence = this.textMap.mapFully(textRangeMapped);
        if (charSequence == null) {
            return false;
        }
        CharSequence mappedText = charSequence;
        if (!StringsKt.startsWith$default((CharSequence)mappedText, (char)'[', (boolean)false, (int)2, null) || !StringsKt.endsWith$default((CharSequence)mappedText, (char)']', (boolean)false, (int)2, null)) {
            return false;
        }
        if (this.linkMap.getLinkInfo(mappedText) != null) {
            return false;
        }
        TreeElement treeElement = RsDocLinkDestinationParser.INSTANCE.parseShortLink(mappedText, this.charTable);
        if (treeElement == null) {
            return false;
        }
        TreeElement linkNode = treeElement;
        node.rawAddChildrenWithoutNotifications(linkNode);
        this.prevNodeEnd = textRangeMapped.getEndOffset();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void insertLeaves(CompositeElement $this$insertLeaves, int startOffset, int endOffset) {
        void this_$iv;
        RsDocTextMap rsDocTextMap = this.textMap;
        int n = startOffset;
        int endOffset$iv = endOffset;
        boolean $i$f$processPiecesInRange = false;
        int offset$iv = 0;
        for (Piece p$iv : RsDocTextMap.access$getPieces$p((RsDocTextMap)this_$iv)) {
            void startOffset$iv;
            int pieceEndOffset$iv = offset$iv + p$iv.getStr().length();
            if (startOffset$iv < pieceEndOffset$iv && endOffset$iv - offset$iv > 0) {
                Piece piece = RsDocCommentElementTypeKt.access$cut(p$iv, (int)(startOffset$iv - offset$iv), endOffset$iv - offset$iv);
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)this.charTable.intern(piece.getStr()), (String)"intern(...)");
                LeafPsiElement element = switch (WhenMappings.$EnumSwitchMapping$0[piece.getKind().ordinal()]) {
                    case 1 -> {
                        CharSequence internedText;
                        yield new LeafPsiElement((IElementType)RsDocElementTypes.INSTANCE.getDOC_DATA(), internedText);
                    }
                    case 2 -> {
                        CharSequence internedText;
                        yield new RsDocGapImpl(RsDocElementTypes.INSTANCE.getDOC_GAP(), internedText);
                    }
                    case 3 -> {
                        CharSequence internedText;
                        yield (LeafPsiElement)new PsiWhiteSpaceImpl(internedText);
                    }
                    default -> throw new NoWhenBranchMatchedException();
                };
                $this$insertLeaves.rawAddChildrenWithoutNotifications((TreeElement)element);
            }
            offset$iv += p$iv.getStr().length();
        }
    }

    private final void insertLeaves(CompositeElement $this$insertLeaves, int endOffset) {
        int endOffsetMapped = this.textMap.mapOffsetFromMarkdownToRust(endOffset);
        if (endOffsetMapped != this.prevNodeEnd) {
            this.insertLeaves($this$insertLeaves, this.prevNodeEnd, endOffsetMapped);
        }
        this.prevNodeEnd = endOffsetMapped;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PieceKind.values().length];
            try {
                nArray[PieceKind.TEXT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PieceKind.GAP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PieceKind.WHITESPACE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

