/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.doc.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.lexer.Lexer;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.CharTable;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.RsLanguage;
import org.rust.lang.core.lexer.RsLexer;
import org.rust.lang.core.parser.RustParser;
import org.rust.lang.doc.psi.LinkTextParts;
import org.rust.lang.doc.psi.RsDocElementTypes;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\"\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u000f*\u00020\u000fH\u0002J\f\u0010\u0011\u001a\u00020\u000f*\u00020\u000fH\u0002J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u000f*\u00020\u000fH\u0002J\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u000f*\u00020\u000fH\u0002J\"\u0010\u0014\u001a\u0004\u0018\u00010\u000f*\u00020\u000f2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\r0\u0016H\u0002J\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u000f*\u00020\u000fH\u0002J\u000e\u0010\u0019\u001a\u0004\u0018\u00010\u000f*\u00020\u000fH\u0002J\u0010\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\u0007H\u0002J\f\u0010\"\u001a\u00020\r*\u00020\u0017H\u0002J\"\u0010#\u001a\u0004\u0018\u00010\u00052\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010&\u001a\u0004\u0018\u00010\u00052\u0006\u0010'\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010(\u001a\u00020)2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001f\u00a8\u0006*"}, d2={"Lorg/rust/lang/doc/psi/RsDocLinkDestinationParser;", "", "<init>", "()V", "parse", "Lcom/intellij/psi/impl/source/tree/TreeElement;", "text", "", "charTable", "Lcom/intellij/util/CharTable;", "parseShortLink", "doParse", "isShortLink", "", "parseLink", "Lorg/rust/lang/doc/psi/LinkTextParts;", "preprocessShortLink", "trimBrackets", "trimBackticks", "trimWhitespaces", "trimChar", "filter", "Lkotlin/Function1;", "", "removeHashAnchor", "removeDisambiguator", "KNOWN_PREFIXES", "", "", "KNOWN_SUFFIXES", "", "[Ljava/lang/String;", "canBeCorrectLink", "link", "isAlphanumeric", "parsePathAndCreateNodes", "info", "path", "parseRsPath", "pathText", "docDataLeaf", "Lcom/intellij/psi/impl/source/tree/LeafPsiElement;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsDocLinkDestinationParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsDocLinkDestinationParser.kt\norg/rust/lang/doc/psi/RsDocLinkDestinationParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,204:1\n1#2:205\n1069#3,2:206\n*S KotlinDebug\n*F\n+ 1 RsDocLinkDestinationParser.kt\norg/rust/lang/doc/psi/RsDocLinkDestinationParser\n*L\n158#1:206,2\n*E\n"})
public final class RsDocLinkDestinationParser {
    @NotNull
    public static final RsDocLinkDestinationParser INSTANCE = new RsDocLinkDestinationParser();
    @NotNull
    private static final Set<String> KNOWN_PREFIXES;
    @NotNull
    private static final String[] KNOWN_SUFFIXES;

    private RsDocLinkDestinationParser() {
    }

    @NotNull
    public final TreeElement parse(@NotNull CharSequence text, @NotNull CharTable charTable) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)charTable, (String)"charTable");
        TreeElement treeElement = this.doParse(text, charTable, false);
        if (treeElement == null) {
            treeElement = (TreeElement)this.docDataLeaf(text, charTable);
        }
        return treeElement;
    }

    @Nullable
    public final TreeElement parseShortLink(@NotNull CharSequence text, @NotNull CharTable charTable) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)charTable, (String)"charTable");
        return this.doParse(text, charTable, true);
    }

    private final TreeElement doParse(CharSequence text, CharTable charTable, boolean isShortLink) {
        LinkTextParts linkTextParts = this.parseLink(text, isShortLink);
        if (linkTextParts == null) {
            return null;
        }
        LinkTextParts info = linkTextParts;
        TreeElement treeElement = this.parseRsPath(info.getContent(), charTable);
        if (treeElement == null) {
            return null;
        }
        TreeElement path = treeElement;
        return this.parsePathAndCreateNodes(info, path, charTable);
    }

    private final LinkTextParts parseLink(CharSequence text, boolean isShortLink) {
        LinkTextParts linkTextParts;
        LinkTextParts linkTextParts2;
        LinkTextParts linkTextParts3;
        LinkTextParts linkTextParts4;
        if (text.length() == 0 || StringsKt.contains$default((CharSequence)text, (CharSequence)"/", (boolean)false, (int)2, null)) {
            return null;
        }
        LinkTextParts $this$parseLink_u24lambda_u240 = new LinkTextParts(text);
        boolean bl = false;
        LinkTextParts linkTextParts5 = isShortLink ? INSTANCE.preprocessShortLink($this$parseLink_u24lambda_u240) : $this$parseLink_u24lambda_u240;
        if (linkTextParts5 != null && (linkTextParts4 = this.trimBackticks(linkTextParts5)) != null && (linkTextParts3 = this.removeHashAnchor(linkTextParts4)) != null && (linkTextParts2 = this.removeDisambiguator(linkTextParts3)) != null) {
            LinkTextParts linkTextParts6;
            LinkTextParts it2 = linkTextParts6 = linkTextParts2;
            boolean bl2 = false;
            linkTextParts = INSTANCE.canBeCorrectLink(it2.getContent()) ? linkTextParts6 : null;
        } else {
            linkTextParts = null;
        }
        return linkTextParts;
    }

    private final LinkTextParts preprocessShortLink(LinkTextParts $this$preprocessShortLink) {
        return this.trimWhitespaces(this.trimBrackets($this$preprocessShortLink));
    }

    private final LinkTextParts trimBrackets(LinkTextParts $this$trimBrackets) {
        CharSequence content = $this$trimBrackets.getContent();
        return StringsKt.startsWith$default((CharSequence)content, (char)'[', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)content, (char)']', (boolean)false, (int)2, null) ? $this$trimBrackets.subSequence(1, content.length() - 1) : $this$trimBrackets;
    }

    private final LinkTextParts trimBackticks(LinkTextParts $this$trimBackticks) {
        return this.trimChar($this$trimBackticks, (Function1<? super Character, Boolean>)((Function1)RsDocLinkDestinationParser::trimBackticks$lambda$0));
    }

    private final LinkTextParts trimWhitespaces(LinkTextParts $this$trimWhitespaces) {
        return this.trimChar($this$trimWhitespaces, (Function1<? super Character, Boolean>)((Function1)RsDocLinkDestinationParser::trimWhitespaces$lambda$0));
    }

    private final LinkTextParts trimChar(LinkTextParts $this$trimChar, Function1<? super Character, Boolean> filter2) {
        CharSequence content = $this$trimChar.getContent();
        if (content.length() == 0) {
            return null;
        }
        int start2 = 0;
        int end = content.length();
        while (((Boolean)filter2.invoke((Object)Character.valueOf(content.charAt(start2)))).booleanValue()) {
            ++start2;
        }
        if (start2 == end) {
            return null;
        }
        while (((Boolean)filter2.invoke((Object)Character.valueOf(content.charAt(end - 1)))).booleanValue()) {
            --end;
        }
        return $this$trimChar.subSequence(start2, end);
    }

    private final LinkTextParts removeHashAnchor(LinkTextParts $this$removeHashAnchor) {
        char[] cArray = new char[]{'#'};
        List parts = StringsKt.split$default((CharSequence)$this$removeHashAnchor.getContent(), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (parts.size() > 2) {
            return null;
        }
        if (parts.size() < 2) {
            return $this$removeHashAnchor;
        }
        String link = (String)parts.get(0);
        String hash = (String)parts.get(1);
        if (StringsKt.isBlank((CharSequence)link)) {
            return null;
        }
        return $this$removeHashAnchor.removeSuffix(1 + hash.length());
    }

    private final LinkTextParts removeDisambiguator(LinkTextParts $this$removeDisambiguator) {
        int index = StringsKt.indexOf$default((CharSequence)$this$removeDisambiguator.getContent(), (char)'@', (int)0, (boolean)false, (int)6, null);
        if (index != -1) {
            LinkTextParts linkTextParts;
            String prefix = ((Object)$this$removeDisambiguator.getContent().subSequence(0, index)).toString();
            if (!KNOWN_PREFIXES.contains(prefix)) {
                return null;
            }
            LinkTextParts it2 = linkTextParts = $this$removeDisambiguator.removePrefix(prefix.length() + 1);
            boolean bl = false;
            return !StringsKt.isBlank((CharSequence)it2.getContent()) ? linkTextParts : null;
        }
        for (String suffix : KNOWN_SUFFIXES) {
            if (!StringsKt.endsWith$default((CharSequence)$this$removeDisambiguator.getContent(), (CharSequence)suffix, (boolean)false, (int)2, null) || $this$removeDisambiguator.getContent().length() <= suffix.length()) continue;
            return $this$removeDisambiguator.removeSuffix(suffix.length());
        }
        return $this$removeDisambiguator;
    }

    private final boolean canBeCorrectLink(CharSequence link) {
        boolean bl;
        block1: {
            CharSequence $this$all$iv = link;
            boolean $i$f$all = false;
            for (int j = 0; j < $this$all$iv.length(); ++j) {
                char element$iv;
                char it2 = element$iv = $this$all$iv.charAt(j);
                boolean bl2 = false;
                if (INSTANCE.isAlphanumeric(it2) || StringsKt.contains$default((CharSequence)":_<>, !*&;", (char)it2, (boolean)false, (int)2, null)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    private final boolean isAlphanumeric(char $this$isAlphanumeric) {
        return Character.isAlphabetic($this$isAlphanumeric) || Character.isDigit($this$isAlphanumeric);
    }

    private final TreeElement parsePathAndCreateNodes(LinkTextParts info, TreeElement path, CharTable charTable) {
        CompositeElement root = RsDocElementTypes.INSTANCE.getDOC_LINK_DEFINITION().createCompositeNode();
        CharSequence prefix = info.getPrefix();
        CharSequence suffix = info.getSuffix();
        if (prefix.length() > 0) {
            root.rawAddChildrenWithoutNotifications((TreeElement)this.docDataLeaf(prefix, charTable));
        }
        root.rawAddChildrenWithoutNotifications(path);
        if (suffix.length() > 0) {
            root.rawAddChildrenWithoutNotifications((TreeElement)this.docDataLeaf(suffix, charTable));
        }
        return root.getFirstChildNode();
    }

    private final TreeElement parseRsPath(CharSequence pathText, CharTable charTable) {
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)RsLanguage.INSTANCE);
        if (parserDefinition == null) {
            throw new IllegalStateException(("No parser definition for language " + RsLanguage.INSTANCE).toString());
        }
        ParserDefinition parserDefinition2 = parserDefinition;
        PsiBuilderImpl plainBuilder = new PsiBuilderImpl(null, null, parserDefinition2, (Lexer)new RsLexer(), charTable, pathText, null, null);
        PsiBuilder builder = GeneratedParserUtilBase.adapt_builder_((IElementType)RsDocElementTypes.INSTANCE.getDOC_LINK_DEFINITION(), (PsiBuilder)((PsiBuilder)plainBuilder), (PsiParser)new RustParser(), (TokenSet[])RustParser.EXTENDS_SETS_);
        PsiBuilder.Marker rootMarker = GeneratedParserUtilBase.enter_section_((PsiBuilder)builder, (int)0, (int)0, null);
        if (!RustParser.TypePathGenericArgs(builder, 0)) {
            return null;
        }
        GeneratedParserUtilBase.exit_section_((PsiBuilder)builder, (int)0, (PsiBuilder.Marker)rootMarker, (IElementType)RsDocElementTypes.INSTANCE.getDOC_LINK_DEFINITION(), (boolean)true, (boolean)true, (GeneratedParserUtilBase.Parser)GeneratedParserUtilBase.TRUE_CONDITION);
        ASTNode aSTNode = builder.getTreeBuilt();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getTreeBuilt(...)");
        ASTNode treeBuilt = aSTNode;
        if (treeBuilt.findChildByType(TokenType.ERROR_ELEMENT) != null) {
            return null;
        }
        ASTNode aSTNode2 = treeBuilt.getFirstChildNode();
        Intrinsics.checkNotNull((Object)aSTNode2, (String)"null cannot be cast to non-null type com.intellij.psi.impl.source.tree.TreeElement");
        return (TreeElement)aSTNode2;
    }

    private final LeafPsiElement docDataLeaf(CharSequence text, CharTable charTable) {
        return new LeafPsiElement((IElementType)RsDocElementTypes.INSTANCE.getDOC_DATA(), charTable.intern(text));
    }

    private static final boolean trimBackticks$lambda$0(char it2) {
        return it2 == '`';
    }

    private static final boolean trimWhitespaces$lambda$0(char it2) {
        return CharsKt.isWhitespace((char)it2);
    }

    static {
        Object[] objectArray = new String[]{"struct", "enum", "trait", "union", "module", "mod", "const", "constant", "static", "function", "fn", "method", "derive", "type", "value", "macro", "prim", "primitive"};
        KNOWN_PREFIXES = SetsKt.hashSetOf((Object[])objectArray);
        objectArray = new String[]{"!()", "!{}", "![]", "()", "!"};
        KNOWN_SUFFIXES = objectArray;
    }
}

