/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.doc;

import com.intellij.psi.PsiElement;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.LeafASTNode;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMFlavourDescriptor;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.SimpleTagProvider;
import org.intellij.markdown.lexer.MarkdownLexer;
import org.intellij.markdown.parser.LinkMap;
import org.intellij.markdown.parser.MarkerProcessorFactory;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.doc.RsCodeFenceProvider;
import org.rust.lang.doc.RsDocRenderMode;
import org.rust.lang.doc.RsInlineLinkGeneratingProvider;
import org.rust.lang.doc.RsReferenceLinksGeneratingProvider;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0001\u00a2\u0006\u0004\b\t\u0010\nJ&\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J(\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0019H\u0002J\t\u0010\u001c\u001a\u00020\u001dH\u0096\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001e\u001a\u00020\u001fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0012\u0010\"\u001a\u00020#X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lorg/rust/lang/doc/RustDocMarkdownFlavourDescriptor;", "Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;", "context", "Lcom/intellij/psi/PsiElement;", "uri", "Ljava/net/URI;", "renderMode", "Lorg/rust/lang/doc/RsDocRenderMode;", "gfm", "<init>", "(Lcom/intellij/psi/PsiElement;Ljava/net/URI;Lorg/rust/lang/doc/RsDocRenderMode;Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;)V", "createHtmlGeneratingProviders", "", "Lorg/intellij/markdown/IElementType;", "Lorg/intellij/markdown/html/GeneratingProvider;", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "baseURI", "adjustOnlyQuotedBackslash", "Lorg/intellij/markdown/ast/ASTNode;", "node", "adjustWithTextQuotedBackslash", "splitIntoAdjustedCode", "base", "codeStart", "", "backslashStart", "end", "createInlinesLexer", "Lorg/intellij/markdown/lexer/MarkdownLexer;", "markerProcessorFactory", "Lorg/intellij/markdown/parser/MarkerProcessorFactory;", "getMarkerProcessorFactory", "()Lorg/intellij/markdown/parser/MarkerProcessorFactory;", "sequentialParserManager", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserManager;", "getSequentialParserManager", "()Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserManager;", "intellij.rustrover.core"})
final class RustDocMarkdownFlavourDescriptor
implements MarkdownFlavourDescriptor {
    @NotNull
    private final PsiElement context;
    @Nullable
    private final URI uri;
    @NotNull
    private final RsDocRenderMode renderMode;
    @NotNull
    private final MarkdownFlavourDescriptor gfm;

    public RustDocMarkdownFlavourDescriptor(@NotNull PsiElement context, @Nullable URI uri, @NotNull RsDocRenderMode renderMode, @NotNull MarkdownFlavourDescriptor gfm) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)renderMode), (String)"renderMode");
        Intrinsics.checkNotNullParameter((Object)gfm, (String)"gfm");
        this.context = context;
        this.uri = uri;
        this.renderMode = renderMode;
        this.gfm = gfm;
    }

    public /* synthetic */ RustDocMarkdownFlavourDescriptor(PsiElement psiElement2, URI uRI, RsDocRenderMode rsDocRenderMode, MarkdownFlavourDescriptor markdownFlavourDescriptor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            uRI = null;
        }
        if ((n & 8) != 0) {
            markdownFlavourDescriptor = (MarkdownFlavourDescriptor)new GFMFlavourDescriptor(false, true, false, 4, null);
        }
        this(psiElement2, uRI, rsDocRenderMode, markdownFlavourDescriptor);
    }

    @NotNull
    public Map<IElementType, GeneratingProvider> createHtmlGeneratingProviders(@NotNull LinkMap linkMap, @Nullable URI baseURI) {
        Intrinsics.checkNotNullParameter((Object)linkMap, (String)"linkMap");
        URI uRI = this.uri;
        if (uRI == null) {
            uRI = baseURI;
        }
        HashMap generatingProviders = new HashMap(this.gfm.createHtmlGeneratingProviders(linkMap, uRI));
        generatingProviders.remove(MarkdownElementTypes.MARKDOWN_FILE);
        ((Map)generatingProviders).put(MarkdownElementTypes.ATX_1, new SimpleTagProvider("h2"));
        ((Map)generatingProviders).put(MarkdownElementTypes.ATX_2, new SimpleTagProvider("h3"));
        ((Map)generatingProviders).put(MarkdownElementTypes.CODE_FENCE, new RsCodeFenceProvider(this.context, this.renderMode));
        Map map2 = generatingProviders;
        IElementType iElementType = MarkdownElementTypes.SHORT_REFERENCE_LINK;
        URI uRI2 = this.uri;
        if (uRI2 == null) {
            uRI2 = baseURI;
        }
        Object object = new RsReferenceLinksGeneratingProvider(linkMap, uRI2, true);
        map2.put(iElementType, object);
        map2 = generatingProviders;
        iElementType = MarkdownElementTypes.FULL_REFERENCE_LINK;
        URI uRI3 = this.uri;
        if (uRI3 == null) {
            uRI3 = baseURI;
        }
        object = new RsReferenceLinksGeneratingProvider(linkMap, uRI3, true);
        map2.put(iElementType, object);
        map2 = generatingProviders;
        iElementType = MarkdownElementTypes.INLINE_LINK;
        URI uRI4 = this.uri;
        if (uRI4 == null) {
            uRI4 = baseURI;
        }
        object = new RsInlineLinkGeneratingProvider(uRI4, true);
        map2.put(iElementType, object);
        GeneratingProvider codeSpanProvider = (GeneratingProvider)generatingProviders.get(MarkdownElementTypes.CODE_SPAN);
        ((Map)generatingProviders).put(MarkdownElementTypes.CODE_SPAN, new GeneratingProvider(codeSpanProvider, this){
            final /* synthetic */ GeneratingProvider $codeSpanProvider;
            final /* synthetic */ RustDocMarkdownFlavourDescriptor this$0;
            {
                this.$codeSpanProvider = $codeSpanProvider;
                this.this$0 = $receiver;
            }

            public void processNode(HtmlGenerator.HtmlGeneratingVisitor visitor2, String text, ASTNode node) {
                Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (this.$codeSpanProvider == null) {
                    return;
                }
                if (!Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownElementTypes.CODE_SPAN)) {
                    this.$codeSpanProvider.processNode(visitor2, text, node);
                    return;
                }
                ASTNode aSTNode = RustDocMarkdownFlavourDescriptor.access$adjustOnlyQuotedBackslash(this.this$0, node);
                if (aSTNode == null && (aSTNode = RustDocMarkdownFlavourDescriptor.access$adjustWithTextQuotedBackslash(this.this$0, node)) == null) {
                    aSTNode = node;
                }
                ASTNode adjustedNode = aSTNode;
                this.$codeSpanProvider.processNode(visitor2, text, adjustedNode);
            }
        });
        return generatingProviders;
    }

    private final ASTNode adjustOnlyQuotedBackslash(ASTNode node) {
        List children = node.getChildren();
        if (children.size() != 2 || !Intrinsics.areEqual((Object)((ASTNode)children.get(0)).getType(), (Object)MarkdownTokenTypes.BACKTICK) || !Intrinsics.areEqual((Object)((ASTNode)children.get(1)).getType(), (Object)MarkdownTokenTypes.ESCAPED_BACKTICKS) || ((ASTNode)children.get(1)).getEndOffset() - ((ASTNode)children.get(1)).getStartOffset() != 2) {
            return null;
        }
        ASTNode last = (ASTNode)node.getChildren().get(1);
        return this.splitIntoAdjustedCode(node, last.getStartOffset(), last.getStartOffset(), last.getEndOffset());
    }

    private final ASTNode adjustWithTextQuotedBackslash(ASTNode node) {
        List children = node.getChildren();
        if (!(children.size() == 3 && Intrinsics.areEqual((Object)((ASTNode)children.get(0)).getType(), (Object)MarkdownTokenTypes.BACKTICK) && Intrinsics.areEqual((Object)((ASTNode)children.get(1)).getType(), (Object)MarkdownTokenTypes.TEXT) && Intrinsics.areEqual((Object)((ASTNode)children.get(2)).getType(), (Object)MarkdownTokenTypes.ESCAPED_BACKTICKS) && ((ASTNode)children.get(2)).getEndOffset() - ((ASTNode)children.get(2)).getStartOffset() == 2)) {
            return null;
        }
        ASTNode code = (ASTNode)node.getChildren().get(1);
        ASTNode last = (ASTNode)node.getChildren().get(2);
        return this.splitIntoAdjustedCode(node, code.getStartOffset(), last.getStartOffset(), last.getEndOffset());
    }

    private final ASTNode splitIntoAdjustedCode(ASTNode base, int codeStart, int backslashStart, int end) {
        LeafASTNode adjustedCode = new LeafASTNode(MarkdownTokenTypes.TEXT, codeStart, backslashStart + 1);
        LeafASTNode backslash = new LeafASTNode(MarkdownTokenTypes.BACKTICK, backslashStart + 1, end);
        return new ASTNode(base, adjustedCode, backslash){
            private final /* synthetic */ ASTNode $$delegate_0;
            final /* synthetic */ ASTNode $base;
            final /* synthetic */ LeafASTNode $adjustedCode;
            final /* synthetic */ LeafASTNode $backslash;
            {
                this.$base = $base;
                this.$adjustedCode = $adjustedCode;
                this.$backslash = $backslash;
                this.$$delegate_0 = $base;
            }

            public List<ASTNode> getChildren() {
                Object[] objectArray = new ASTNode[]{this.$base.getChildren().get(0), this.$adjustedCode, this.$backslash};
                return CollectionsKt.listOf((Object[])objectArray);
            }

            public int getEndOffset() {
                return this.$$delegate_0.getEndOffset();
            }

            public ASTNode getParent() {
                return this.$$delegate_0.getParent();
            }

            public int getStartOffset() {
                return this.$$delegate_0.getStartOffset();
            }

            public IElementType getType() {
                return this.$$delegate_0.getType();
            }
        };
    }

    @NotNull
    public MarkdownLexer createInlinesLexer() {
        return this.gfm.createInlinesLexer();
    }

    @NotNull
    public MarkerProcessorFactory getMarkerProcessorFactory() {
        return this.gfm.getMarkerProcessorFactory();
    }

    @NotNull
    public SequentialParserManager getSequentialParserManager() {
        return this.gfm.getSequentialParserManager();
    }

    public static final /* synthetic */ ASTNode access$adjustOnlyQuotedBackslash(RustDocMarkdownFlavourDescriptor $this, ASTNode node) {
        return $this.adjustOnlyQuotedBackslash(node);
    }

    public static final /* synthetic */ ASTNode access$adjustWithTextQuotedBackslash(RustDocMarkdownFlavourDescriptor $this, ASTNode node) {
        return $this.adjustWithTextQuotedBackslash(node);
    }
}

