/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.doc;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.parser.MarkdownParser;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.macros.MacroExpansion;
import org.rust.lang.core.macros.RsExpandedElement;
import org.rust.lang.core.psi.RsBlock;
import org.rust.lang.core.psi.RsInnerAttr;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsMacroCall;
import org.rust.lang.core.psi.RsOuterAttr;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.RsTokenTypeKt;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsAttr;
import org.rust.lang.core.psi.ext.RsDocAndAttributeOwner;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsLitExprKt;
import org.rust.lang.core.psi.ext.RsMetaItemKt;
import org.rust.lang.core.psi.ext.RsPossibleMacroCall;
import org.rust.lang.core.psi.ext.RsPossibleMacroCallKt;
import org.rust.lang.core.psi.ext.RsQualifiedName;
import org.rust.lang.core.psi.ext.RsQualifiedNamedElement;
import org.rust.lang.core.types.ty.TyPrimitive;
import org.rust.lang.doc.RsDocRenderMode;
import org.rust.lang.doc.RustDocMarkdownFlavourDescriptor;
import org.rust.lang.doc.psi.RsDocComment;
import org.rust.lang.doc.psi.RsDocKind;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u001a \u0010\u0006\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n\u001a\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u0001*\u00020\u000b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u001a\"\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0003\u001a\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0001*\u00020\u0016H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\"\u0018\u0010\u0010\u001a\u00020\u0004*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012\u00a8\u0006\u001b"}, d2={"documentation", "", "Lorg/rust/lang/core/psi/ext/RsDocAndAttributeOwner;", "withInner", "", "withMacroExpansion", "documentationAsHtml", "originalElement", "Lcom/intellij/psi/PsiElement;", "renderMode", "Lorg/rust/lang/doc/RsDocRenderMode;", "Lorg/rust/lang/doc/psi/RsDocComment;", "rawDocumentationText", "context", "docElements", "Lkotlin/sequences/Sequence;", "isDocAttr", "Lorg/rust/lang/core/psi/ext/RsAttr;", "(Lorg/rust/lang/core/psi/ext/RsAttr;)Z", "getDocumentationFromAttr", "attr", "expandMacroForDocumentation", "Lorg/rust/lang/core/psi/ext/RsPossibleMacroCall;", "linkIsProbablyValidRustPath", "link", "", "markLinkAsLanguageItemIfItIsRustPath", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsDocPipeline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsDocPipeline.kt\norg/rust/lang/doc/RsDocPipelineKt\n+ 2 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,385:1\n28#2:386\n1855#3,2:387\n1#4:389\n*S KotlinDebug\n*F\n+ 1 RsDocPipeline.kt\norg/rust/lang/doc/RsDocPipelineKt\n*L\n126#1:386\n341#1:387,2\n*E\n"})
public final class RsDocPipelineKt {
    @NotNull
    public static final String documentation(@NotNull RsDocAndAttributeOwner $this$documentation, boolean withInner, boolean withMacroExpansion) {
        Intrinsics.checkNotNullParameter((Object)$this$documentation, (String)"<this>");
        return SequencesKt.joinToString$default((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.mapNotNull(RsDocPipelineKt.docElements($this$documentation, withInner), arg_0 -> RsDocPipelineKt.documentation$lambda$0(withMacroExpansion, arg_0)), RsDocPipelineKt::documentation$lambda$1), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    @Nullable
    public static final String documentationAsHtml(@NotNull RsDocAndAttributeOwner $this$documentationAsHtml, @NotNull PsiElement originalElement, @NotNull RsDocRenderMode renderMode) {
        Intrinsics.checkNotNullParameter((Object)$this$documentationAsHtml, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)originalElement, (String)"originalElement");
        Intrinsics.checkNotNullParameter((Object)((Object)renderMode), (String)"renderMode");
        return RsDocPipelineKt.documentationAsHtml(RsDocPipelineKt.documentation($this$documentationAsHtml, true, true), originalElement, renderMode);
    }

    public static /* synthetic */ String documentationAsHtml$default(RsDocAndAttributeOwner rsDocAndAttributeOwner, PsiElement psiElement2, RsDocRenderMode rsDocRenderMode, int n, Object object) {
        if ((n & 1) != 0) {
            psiElement2 = rsDocAndAttributeOwner;
        }
        if ((n & 2) != 0) {
            rsDocRenderMode = RsDocRenderMode.QUICK_DOC_POPUP;
        }
        return RsDocPipelineKt.documentationAsHtml(rsDocAndAttributeOwner, psiElement2, rsDocRenderMode);
    }

    @Nls
    @Nullable
    public static final String documentationAsHtml(@NotNull RsDocComment $this$documentationAsHtml, @NotNull RsDocRenderMode renderMode) {
        String string;
        RsDocAndAttributeOwner rsDocAndAttributeOwner;
        RsMacroCall macroCall;
        Intrinsics.checkNotNullParameter((Object)$this$documentationAsHtml, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)renderMode), (String)"renderMode");
        RsPossibleMacroCall rsPossibleMacroCall = RsPossibleMacroCallKt.getContextMacroCall($this$documentationAsHtml);
        RsMacroCall rsMacroCall = macroCall = rsPossibleMacroCall instanceof RsMacroCall ? (RsMacroCall)rsPossibleMacroCall : null;
        if (rsMacroCall != null) {
            rsDocAndAttributeOwner = rsMacroCall;
        } else {
            rsDocAndAttributeOwner = $this$documentationAsHtml.getOwner();
            if (rsDocAndAttributeOwner == null) {
                return null;
            }
        }
        RsDocAndAttributeOwner owner = rsDocAndAttributeOwner;
        IElementType iElementType = $this$documentationAsHtml.getTokenType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getTokenType(...)");
        RsDocKind rsDocKind = RsDocKind.Companion.of(iElementType);
        String string2 = $this$documentationAsHtml.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        String documentationText = SequencesKt.joinToString$default(rsDocKind.removeDecoration(string2), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        String string3 = RsDocPipelineKt.documentationAsHtml(documentationText, (PsiElement)owner, renderMode);
        if (string3 != null) {
            String it2 = string3;
            boolean bl = false;
            String result2 = it2;
            string = ((CharSequence)result2).length() == 0 ? "&nbsp;" : result2;
        } else {
            string = null;
        }
        return string;
    }

    public static /* synthetic */ String documentationAsHtml$default(RsDocComment rsDocComment, RsDocRenderMode rsDocRenderMode, int n, Object object) {
        if ((n & 1) != 0) {
            rsDocRenderMode = RsDocRenderMode.QUICK_DOC_POPUP;
        }
        return RsDocPipelineKt.documentationAsHtml(rsDocComment, rsDocRenderMode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NlsSafe
    private static final String documentationAsHtml(String rawDocumentationText, PsiElement context, RsDocRenderMode renderMode) {
        URI uRI;
        String path;
        String tmpUriPrefix = "psi://element/";
        if (context instanceof RsQualifiedNamedElement) {
            RsQualifiedName rsQualifiedName = RsQualifiedName.Companion.from((RsQualifiedNamedElement)context);
            v1 = rsQualifiedName != null ? rsQualifiedName.toUrlPath() : null;
        } else if (context instanceof RsPath) {
            if (TyPrimitive.Companion.fromPath$default(TyPrimitive.Companion, (RsPath)context, false, null, 6, null) == null) return null;
            v1 = "std/";
        } else {
            v1 = path = PsiElementKt.isKeywordLike(context) ? "std/" : null;
        }
        if (path != null) {
            URI uRI2;
            try {
                uRI2 = URI.create(tmpUriPrefix + path);
            }
            catch (Exception e) {
                uRI2 = null;
            }
            uRI = uRI2;
        } else {
            uRI = null;
        }
        URI baseURI = uRI;
        RustDocMarkdownFlavourDescriptor flavour = new RustDocMarkdownFlavourDescriptor(context, baseURI, renderMode, null, 8, null);
        ASTNode root = new MarkdownParser((MarkdownFlavourDescriptor)flavour).buildMarkdownTreeFromString(rawDocumentationText);
        return StringsKt.replace$default((String)HtmlGenerator.generateHtml$default((HtmlGenerator)new HtmlGenerator(rawDocumentationText, root, (MarkdownFlavourDescriptor)flavour, false, 8, null), null, (int)1, null), (String)tmpUriPrefix, (String)"psi_element://", (boolean)false, (int)4, null);
    }

    @NotNull
    public static final Sequence<PsiElement> docElements(@NotNull RsDocAndAttributeOwner $this$docElements, boolean withInner) {
        Sequence sequence2;
        Intrinsics.checkNotNullParameter((Object)$this$docElements, (String)"<this>");
        Sequence outerDocs = SequencesKt.filter((Sequence)SequencesKt.takeWhile(PsiElementKt.getChildrenWithLeaves($this$docElements), RsDocPipelineKt::docElements$lambda$0), RsDocPipelineKt::docElements$lambda$1);
        if (withInner) {
            PsiElement $this$childOfType$iv = $this$docElements;
            boolean $i$f$childOfType = false;
            RsBlock rsBlock = (RsBlock)PsiTreeUtil.getChildOfType((PsiElement)$this$childOfType$iv, RsBlock.class);
            RsElement childBlock = rsBlock != null ? (RsElement)rsBlock : (RsElement)$this$docElements;
            sequence2 = SequencesKt.filter(PsiElementKt.getChildrenWithLeaves(childBlock), RsDocPipelineKt::docElements$lambda$2);
        } else {
            sequence2 = SequencesKt.emptySequence();
        }
        Sequence innerDocs = sequence2;
        return SequencesKt.plus((Sequence)outerDocs, (Sequence)innerDocs);
    }

    public static /* synthetic */ Sequence docElements$default(RsDocAndAttributeOwner rsDocAndAttributeOwner, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return RsDocPipelineKt.docElements(rsDocAndAttributeOwner, bl);
    }

    private static final boolean isDocAttr(RsAttr $this$isDocAttr) {
        return Intrinsics.areEqual((Object)RsMetaItemKt.getName($this$isDocAttr.getMetaItem()), (Object)"doc");
    }

    private static final String getDocumentationFromAttr(RsAttr attr, boolean withMacroExpansion) {
        if (!RsDocPipelineKt.isDocAttr(attr)) {
            return null;
        }
        RsLitExpr litExpr = attr.getMetaItem().getLitExpr();
        if (litExpr != null) {
            return RsLitExprKt.getStringValue(litExpr);
        }
        if (!withMacroExpansion) {
            return null;
        }
        RsMacroCall rsMacroCall = attr.getMetaItem().getMacroCall();
        return rsMacroCall != null ? RsDocPipelineKt.expandMacroForDocumentation(rsMacroCall) : null;
    }

    private static final String expandMacroForDocumentation(RsPossibleMacroCall $this$expandMacroForDocumentation) {
        RsPossibleMacroCall element = $this$expandMacroForDocumentation;
        while (element instanceof RsPossibleMacroCall) {
            Object object = RsPossibleMacroCallKt.getExpansion(element);
            element = object != null && (object = ((MacroExpansion)object).getElements()) != null ? (RsExpandedElement)CollectionsKt.singleOrNull((List)object) : null;
        }
        RsPossibleMacroCall rsPossibleMacroCall = element;
        RsLitExpr rsLitExpr = rsPossibleMacroCall instanceof RsLitExpr ? (RsLitExpr)((Object)rsPossibleMacroCall) : null;
        return rsLitExpr != null ? RsLitExprKt.getStringValue(rsLitExpr) : null;
    }

    private static final boolean linkIsProbablyValidRustPath(CharSequence link) {
        boolean bl;
        block1: {
            CharSequence $this$none$iv = link;
            boolean $i$f$none = false;
            for (int j = 0; j < $this$none$iv.length(); ++j) {
                char element$iv;
                char it2 = element$iv = $this$none$iv.charAt(j);
                boolean bl2 = false;
                if (!(StringsKt.contains$default((CharSequence)"/.#", (char)it2, (boolean)false, (int)2, null) || CharsKt.isWhitespace((char)it2))) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    private static final CharSequence markLinkAsLanguageItemIfItIsRustPath(CharSequence link) {
        return RsDocPipelineKt.linkIsProbablyValidRustPath(link) ? (CharSequence)("psi_element://" + link) : link;
    }

    private static final Pair documentation$lambda$0(boolean $withMacroExpansion, PsiElement it2) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        PsiElement psiElement2 = it2;
        if (psiElement2 instanceof RsAttr) {
            String string = RsDocPipelineKt.getDocumentationFromAttr((RsAttr)it2, $withMacroExpansion);
            if (string != null) {
                String text = string;
                boolean bl = false;
                pair = TuplesKt.to((Object)((Object)RsDocKind.Attr), (Object)text);
            } else {
                pair = null;
            }
        } else if (psiElement2 instanceof RsDocComment) {
            IElementType iElementType = ((RsDocComment)it2).getTokenType();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getTokenType(...)");
            pair = TuplesKt.to((Object)((Object)RsDocKind.Companion.of(iElementType)), (Object)((RsDocComment)it2).getText());
        } else {
            pair = null;
        }
        return pair;
    }

    private static final Sequence documentation$lambda$1(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        RsDocKind kind2 = (RsDocKind)((Object)pair.component1());
        String text = (String)pair.component2();
        return kind2.removeDecoration(text);
    }

    private static final boolean docElements$lambda$0(PsiElement it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2 instanceof RsOuterAttr || it2 instanceof PsiComment || it2 instanceof PsiWhiteSpace;
    }

    private static final boolean docElements$lambda$1(PsiElement it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2 instanceof RsOuterAttr && RsDocPipelineKt.isDocAttr((RsAttr)it2) || it2 instanceof RsDocComment && RsTokenTypeKt.getRS_OUTER_DOC_COMMENTS().contains(((RsDocComment)it2).getTokenType());
    }

    private static final boolean docElements$lambda$2(PsiElement it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2 instanceof RsInnerAttr && RsDocPipelineKt.isDocAttr((RsAttr)it2) || it2 instanceof RsDocComment && RsTokenTypeKt.getRS_INNER_DOC_COMMENTS().contains(((RsDocComment)it2).getTokenType());
    }

    public static final /* synthetic */ CharSequence access$markLinkAsLanguageItemIfItIsRustPath(CharSequence link) {
        return RsDocPipelineKt.markLinkAsLanguageItemIfItIsRustPath(link);
    }

    public static final /* synthetic */ boolean access$linkIsProbablyValidRustPath(CharSequence link) {
        return RsDocPipelineKt.linkIsProbablyValidRustPath(link);
    }
}

