/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.doc;

import com.intellij.codeEditor.printing.HTMLTextPainter;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColorHexUtil;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.doc.RsDocRenderMode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bR\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0014\u0010\u0013\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/rust/lang/doc/RsCodeFenceProvider;", "Lorg/intellij/markdown/html/GeneratingProvider;", "context", "Lcom/intellij/psi/PsiElement;", "renderMode", "Lorg/rust/lang/doc/RsDocRenderMode;", "<init>", "(Lcom/intellij/psi/PsiElement;Lorg/rust/lang/doc/RsDocRenderMode;)V", "processNode", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "convertToHtmlWithHighlighting", "codeText", "dimColors", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "isColorSchemeDark", "", "Companion", "intellij.rustrover.core"})
final class RsCodeFenceProvider
implements GeneratingProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiElement context;
    @NotNull
    private final RsDocRenderMode renderMode;
    @NotNull
    private static final Regex COLOR_PATTERN = new Regex("color:\\s*#(\\p{XDigit}{3,})");
    private static final int CODE_SNIPPET_INDENT = 20;
    private static final double LIGHT_THEME_ALPHA = 0.6;
    private static final double DARK_THEME_ALPHA = 0.78;

    public RsCodeFenceProvider(@NotNull PsiElement context, @NotNull RsDocRenderMode renderMode) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)renderMode), (String)"renderMode");
        this.context = context;
        this.renderMode = renderMode;
    }

    public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor2, @NotNull String text, @NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        int indentBefore = StringsKt.commonPrefixWith$default((CharSequence)ASTUtilKt.getTextInNode((ASTNode)node, (CharSequence)text), (CharSequence)StringsKt.repeat((CharSequence)" ", (int)10), (boolean)false, (int)2, null).length();
        StringBuilder codeText = new StringBuilder();
        List childrenToConsider = node.getChildren();
        if (Intrinsics.areEqual((Object)((ASTNode)CollectionsKt.last((List)childrenToConsider)).getType(), (Object)MarkdownTokenTypes.CODE_FENCE_END)) {
            childrenToConsider = childrenToConsider.subList(0, childrenToConsider.size() - 1);
        }
        boolean isContentStarted = false;
        boolean skipNextEOL = false;
        boolean lastChildWasContent = false;
        for (ASTNode child : childrenToConsider) {
            Object[] objectArray;
            if (isContentStarted && CollectionsKt.listOf((Object[])(objectArray = new IElementType[]{MarkdownTokenTypes.CODE_FENCE_CONTENT, MarkdownTokenTypes.EOL})).contains(child.getType())) {
                if (skipNextEOL && Intrinsics.areEqual((Object)child.getType(), (Object)MarkdownTokenTypes.EOL)) {
                    skipNextEOL = false;
                    continue;
                }
                CharSequence rawLine = HtmlGenerator.Companion.trimIndents(ASTUtilKt.getTextInNode((ASTNode)child, (CharSequence)text), indentBefore);
                CharSequence trimmedLine = StringsKt.trimStart((CharSequence)rawLine);
                if (StringsKt.startsWith$default((CharSequence)trimmedLine, (CharSequence)"#", (boolean)false, (int)2, null)) {
                    Character c = StringsKt.getOrNull((CharSequence)trimmedLine, (int)1);
                    if (!(c != null ? !((Object)c).equals(Character.valueOf(' ')) : false)) {
                        skipNextEOL = true;
                        continue;
                    }
                }
                CharSequence codeLine = StringsKt.startsWith$default((CharSequence)trimmedLine, (CharSequence)"##", (boolean)false, (int)2, null) ? StringsKt.removePrefix((CharSequence)trimmedLine, (CharSequence)"#") : rawLine;
                codeText.append(codeLine);
                lastChildWasContent = Intrinsics.areEqual((Object)child.getType(), (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT);
            }
            if (isContentStarted || !Intrinsics.areEqual((Object)child.getType(), (Object)MarkdownTokenTypes.EOL)) continue;
            isContentStarted = true;
        }
        if (lastChildWasContent) {
            codeText.append('\n');
        }
        String string = codeText.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        visitor2.consumeHtml((CharSequence)this.convertToHtmlWithHighlighting(string));
    }

    private final String convertToHtmlWithHighlighting(String codeText) {
        String string = HTMLTextPainter.convertCodeFragmentToHTMLFragmentWithInlineStyles((PsiElement)this.context, (String)codeText);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertCodeFragmentToHTM\u2026mentWithInlineStyles(...)");
        String htmlCodeText = string;
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        EditorColorsScheme scheme = editorColorsScheme;
        htmlCodeText = StringsKt.replaceFirst$default((String)htmlCodeText, (String)"<pre>", (String)"<pre style=\"text-indent: 20px;\">", (boolean)false, (int)4, null);
        return WhenMappings.$EnumSwitchMapping$0[this.renderMode.ordinal()] == 1 ? this.dimColors(htmlCodeText, scheme) : htmlCodeText;
    }

    private final String dimColors(String $this$dimColors, EditorColorsScheme scheme) {
        double alpha = this.isColorSchemeDark(scheme) ? 0.78 : 0.6;
        CharSequence charSequence = $this$dimColors;
        Regex regex = COLOR_PATTERN;
        Function1 function1 = arg_0 -> RsCodeFenceProvider.dimColors$lambda$0(scheme, alpha, arg_0);
        return regex.replace(charSequence, function1);
    }

    private final boolean isColorSchemeDark(EditorColorsScheme scheme) {
        return ColorUtil.isDark((Color)scheme.getDefaultBackground());
    }

    private static final CharSequence dimColors$lambda$0(EditorColorsScheme $scheme, double $alpha, MatchResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        String colorHexValue = (String)result2.getGroupValues().get(1);
        Color color = ColorHexUtil.fromHexOrNull((String)colorHexValue);
        if (color == null) {
            return result2.getValue();
        }
        Color fgColor = color;
        Color color2 = $scheme.getDefaultBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getDefaultBackground(...)");
        Color bgColor = color2;
        Color color3 = ColorUtil.mix((Color)bgColor, (Color)fgColor, (double)$alpha);
        Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"mix(...)");
        Color finalColor = color3;
        return "color: #" + ColorUtil.toHex((Color)finalColor);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/rust/lang/doc/RsCodeFenceProvider$Companion;", "", "<init>", "()V", "COLOR_PATTERN", "Lkotlin/text/Regex;", "CODE_SNIPPET_INDENT", "", "LIGHT_THEME_ALPHA", "", "DARK_THEME_ALPHA", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RsDocRenderMode.values().length];
            try {
                nArray[RsDocRenderMode.INLINE_DOC_COMMENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

